/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.xml.zip;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import oracle.toplink.internal.databaseaccess.Accessor;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.xml.XMLDataStoreException;
import oracle.toplink.xml.XMLStreamPolicy;

public class XMLZipFileStreamPolicy
implements XMLStreamPolicy {
    private File file;
    private ZipFile zipFile;
    private String zipEntryName;
    private Enumeration zipEntryNames;

    protected XMLZipFileStreamPolicy() {
    }

    public XMLZipFileStreamPolicy(File file, String string) {
        this();
        this.file = file;
        this.zipEntryName = string;
    }

    public XMLZipFileStreamPolicy(String string, String string2) {
        this(new File(string), string2);
    }

    public XMLZipFileStreamPolicy(File file, Enumeration enumeration) {
        this();
        this.file = file;
        this.zipEntryNames = enumeration;
    }

    public XMLZipFileStreamPolicy(String string, Enumeration enumeration) {
        this(new File(string), enumeration);
    }

    protected Reader buildReadStream() throws XMLDataStoreException {
        return this.buildReadStream(this.getZipEntryName());
    }

    protected Reader buildReadStream(String string) throws XMLDataStoreException {
        try {
            ZipInputStream zipInputStream = this.buildZipInputStream();
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                if (string.equals(zipEntry.getName())) {
                    return new InputStreamReader(zipInputStream);
                }
                zipEntry = zipInputStream.getNextEntry();
            }
            zipInputStream.close();
        }
        catch (IOException iOException) {
            throw XMLDataStoreException.ioException(iOException);
        }
        return null;
    }

    protected Enumeration buildReadStreams() {
        return new Enumeration(){

            public boolean hasMoreElements() {
                return XMLZipFileStreamPolicy.this.getZipEntryNames().hasMoreElements();
            }

            public Object nextElement() throws XMLDataStoreException {
                return XMLZipFileStreamPolicy.this.buildReadStream((String)XMLZipFileStreamPolicy.this.getZipEntryNames().nextElement());
            }
        };
    }

    protected File buildTempFile() throws IOException {
        return this.buildTempFile(this.getFile());
    }

    protected File buildTempFile(File file) throws IOException {
        int n = file.getName().lastIndexOf(46);
        String string = n == -1 ? ".zip" : file.getName().substring(n);
        File file2 = File.createTempFile("temp", string, file.getParentFile());
        return file2;
    }

    protected Writer buildWriteStream(boolean bl) throws XMLDataStoreException {
        try {
            File file = this.buildTempFile();
            file.delete();
            boolean bl2 = this.getFile().renameTo(file);
            ZipInputStream zipInputStream = this.buildZipInputStream(file);
            ZipOutputStream zipOutputStream = this.buildZipOutputStream();
            boolean bl3 = false;
            byte[] byArray = new byte[32768];
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                boolean bl4 = true;
                if (this.getZipEntryName().equals(zipEntry.getName())) {
                    bl3 = true;
                    if (bl) {
                        bl4 = false;
                    }
                }
                if (bl4) {
                    int n;
                    zipOutputStream.putNextEntry(zipEntry);
                    while ((n = zipInputStream.read(byArray)) != -1) {
                        zipOutputStream.write(byArray, 0, n);
                    }
                    zipOutputStream.closeEntry();
                }
                zipEntry = zipInputStream.getNextEntry();
            }
            zipInputStream.close();
            file.delete();
            if (bl != bl3) {
                zipOutputStream.close();
                if (bl3) {
                    throw XMLDataStoreException.fileAlreadyExists(new File(this.getZipEntryName()));
                }
                throw XMLDataStoreException.fileNotFound(new File(this.getZipEntryName()), null);
            }
            zipOutputStream.putNextEntry(new ZipEntry(this.getZipEntryName()));
            return new OutputStreamWriter(zipOutputStream);
        }
        catch (IOException iOException) {
            throw XMLDataStoreException.ioException(iOException);
        }
    }

    protected ZipInputStream buildZipInputStream() throws FileNotFoundException {
        return this.buildZipInputStream(this.getFile());
    }

    protected ZipInputStream buildZipInputStream(File file) throws FileNotFoundException {
        return new ZipInputStream(new FileInputStream(file));
    }

    protected ZipOutputStream buildZipOutputStream() throws FileNotFoundException {
        return this.buildZipOutputStream(this.getFile());
    }

    protected ZipOutputStream buildZipOutputStream(File file) throws FileNotFoundException {
        return new ZipOutputStream(new FileOutputStream(file));
    }

    protected Integer deleteEntry() throws XMLDataStoreException {
        try {
            ZipInputStream zipInputStream = this.buildZipInputStream();
            File file = this.buildTempFile();
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
            byte[] byArray = new byte[32768];
            int n = 0;
            int n2 = 0;
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                ++n;
                if (!this.getZipEntryName().equals(zipEntry.getName())) {
                    int n3;
                    ++n2;
                    zipOutputStream.putNextEntry(zipEntry);
                    while ((n3 = zipInputStream.read(byArray)) != -1) {
                        zipOutputStream.write(byArray, 0, n3);
                    }
                    zipOutputStream.closeEntry();
                }
                zipEntry = zipInputStream.getNextEntry();
            }
            zipInputStream.close();
            if (n2 == 0) {
                zipOutputStream.putNextEntry(new ZipEntry("delete.txt"));
                zipOutputStream.write("This file is a place-holder. The containing ZIP file should be deleted.".getBytes());
                zipOutputStream.closeEntry();
            }
            zipOutputStream.close();
            if (n2 == n) {
                file.delete();
            } else {
                this.getFile().delete();
                if (n2 == 0) {
                    file.delete();
                } else {
                    file.renameTo(this.getFile());
                }
            }
            return new Integer(n - n2);
        }
        catch (IOException iOException) {
            throw XMLDataStoreException.ioException(iOException);
        }
    }

    public Integer deleteStream(String string, DatabaseRow databaseRow, Vector vector, Accessor accessor) throws XMLDataStoreException {
        return this.deleteEntry();
    }

    public Reader getExistenceCheckStream(String string, DatabaseRow databaseRow, Vector vector, Accessor accessor) throws XMLDataStoreException {
        return this.getReadStream(string, databaseRow, vector, accessor);
    }

    public Writer getExistingWriteStream(String string, DatabaseRow databaseRow, Vector vector, Accessor accessor) throws XMLDataStoreException {
        return this.buildWriteStream(true);
    }

    public Writer getNewWriteStream(String string, DatabaseRow databaseRow, Vector vector, Accessor accessor) throws XMLDataStoreException {
        return this.buildWriteStream(false);
    }

    public Reader getReadStream(String string, DatabaseRow databaseRow, Vector vector, Accessor accessor) throws XMLDataStoreException {
        return this.buildReadStream();
    }

    public Enumeration getReadStreams(String string, Vector vector, Vector vector2, Accessor accessor) throws XMLDataStoreException {
        return this.buildReadStreams();
    }

    public Enumeration getReadStreams(String string, Accessor accessor) throws XMLDataStoreException {
        return this.buildReadStreams();
    }

    protected File getFile() {
        return this.file;
    }

    protected String getZipEntryName() {
        return this.zipEntryName;
    }

    protected Enumeration getZipEntryNames() {
        return this.zipEntryNames;
    }

    protected ZipFile getZipFile() throws IOException {
        if (this.zipFile == null) {
            this.zipFile = new ZipFile(this.getFile());
        }
        return this.zipFile;
    }
}

