/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.xml.zip;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import oracle.toplink.xml.DefaultXMLFileAccessorFilePolicy;
import oracle.toplink.xml.XMLDataStoreException;

public class DefaultXMLZipFileAccessorFilePolicy
extends DefaultXMLFileAccessorFilePolicy {
    private String zipFileNameExtension;
    public static String DEFAULT_ZIP_FILE_NAME_EXTENSION = ".zip";

    protected String buildDefaultZipFileNameExtension() {
        return DEFAULT_ZIP_FILE_NAME_EXTENSION;
    }

    protected FileFilter buildExtensionFileFilter(String string) {
        return new ZipExtensionFileFilter(string);
    }

    protected void checkDocumentDirectory(File file) throws XMLDataStoreException {
        block7: {
            File file2 = this.convertToZipFile(file);
            super.checkDocumentDirectory(file2.getParentFile());
            if (file2.exists()) {
                if (!file2.isFile()) {
                    throw XMLDataStoreException.notADirectory(file2);
                }
            } else {
                if (this.createsDirectoriesAsNeeded()) {
                    try {
                        if (!file2.createNewFile()) {
                            throw XMLDataStoreException.directoryCouldNotBeCreated(file2);
                        }
                        break block7;
                    }
                    catch (IOException iOException) {
                        throw XMLDataStoreException.directoryCouldNotBeCreated(file2);
                    }
                }
                throw XMLDataStoreException.directoryNotFound(file2);
            }
        }
    }

    protected File convertToDirectory(File file) {
        File file2 = file.getParentFile();
        String string = file.getName();
        if (string.endsWith(this.getZipFileNameExtension())) {
            string = string.substring(0, string.length() - this.getZipFileNameExtension().length());
        }
        return this.buildFile(file2, string);
    }

    protected File convertToZipFile(File file) {
        File file2 = file.getParentFile();
        String string = file.getName() + this.getZipFileNameExtension();
        return this.buildFile(file2, string);
    }

    protected void createFileSource(File file) throws XMLDataStoreException {
        File file2 = this.convertToZipFile(file);
        super.createFileSource(file2.getParentFile());
        if (file2.exists()) {
            if (!file2.isFile()) {
                throw XMLDataStoreException.notADirectory(file2);
            }
        } else {
            try {
                if (!file2.createNewFile()) {
                    throw XMLDataStoreException.directoryCouldNotBeCreated(file2);
                }
            }
            catch (IOException iOException) {
                throw XMLDataStoreException.directoryCouldNotBeCreated(file2);
            }
        }
    }

    protected void dropFileSource(File file) throws XMLDataStoreException {
        File file2 = this.convertToZipFile(file);
        if (file2.exists()) {
            if (file2.isFile()) {
                file2.delete();
            } else {
                throw XMLDataStoreException.notADirectory(file2);
            }
        }
    }

    public String getZipFileNameExtension() {
        return this.zipFileNameExtension;
    }

    protected File[] listFiles(File file, FileFilter fileFilter) throws XMLDataStoreException {
        ArrayList<File> arrayList = new ArrayList<File>();
        try {
            ZipFile zipFile = new ZipFile(this.convertToZipFile(file));
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                File file2 = new File(file, zipEntry.getName());
                if (!fileFilter.accept(file2)) continue;
                arrayList.add(file2);
            }
            zipFile.close();
        }
        catch (IOException iOException) {
            throw XMLDataStoreException.ioException(iOException);
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    protected void initialize() {
        super.initialize();
        this.setZipFileNameExtension(this.buildDefaultZipFileNameExtension());
    }

    public void setZipFileNameExtension(String string) {
        this.zipFileNameExtension = string;
    }

    protected class ZipExtensionFileFilter
    extends DefaultXMLFileAccessorFilePolicy.ExtensionFileFilter {
        public ZipExtensionFileFilter(String string) {
            super(string);
        }

        protected boolean fileIsValid(File file) {
            return true;
        }
    }
}

