/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.xml.xerces;

import java.io.Writer;
import java.util.Enumeration;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.platform.xml.XMLPlatform;
import oracle.toplink.platform.xml.XMLPlatformException;
import oracle.toplink.platform.xml.XMLPlatformFactory;
import oracle.toplink.platform.xml.XMLTransformer;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.sdk.SDKFieldValue;
import oracle.toplink.xml.XMLDataStoreException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DatabaseRowToXMLTranslator
extends oracle.toplink.xml.DatabaseRowToXMLTranslator {
    public void write(Writer writer, DatabaseRow databaseRow) throws XMLDataStoreException {
        if (databaseRow.isEmpty()) {
            return;
        }
        try {
            XMLPlatform xMLPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
            Document document = xMLPlatform.createDocument();
            document.appendChild(this.buildRootElement(document, databaseRow));
            XMLTransformer xMLTransformer = xMLPlatform.newXMLTransformer();
            xMLTransformer.setVersion("1.0");
            xMLTransformer.setEncoding("UTF-8");
            xMLTransformer.transform((Node)document, writer);
        }
        catch (XMLPlatformException xMLPlatformException) {
            throw XMLDataStoreException.generalException(xMLPlatformException);
        }
    }

    protected Node buildRootElement(Document document, DatabaseRow databaseRow) throws XMLDataStoreException {
        String string = ((DatabaseField)databaseRow.getFields().firstElement()).getTableName();
        Element element = document.createElement(string);
        this.addFieldsToElementFromRow(document, element, databaseRow, string);
        return element;
    }

    protected Node buildNestedRowElement(Document document, Node node, DatabaseField databaseField, SDKFieldValue sDKFieldValue) throws XMLDataStoreException {
        String string = databaseField.getName();
        Element element = document.createElement(string);
        Enumeration enumeration = sDKFieldValue.getElements().elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e instanceof DatabaseRow) {
                Element element2;
                DatabaseRow databaseRow = (DatabaseRow)e;
                String string2 = sDKFieldValue.getElementDataTypeName();
                if (this.rowIsAllNulls(databaseRow)) {
                    element2 = document.createElement(string2);
                    element.appendChild(element2);
                    continue;
                }
                element2 = document.createElement(string2);
                this.addFieldsToElementFromRow(document, element2, databaseRow, string2);
                element.appendChild(element2);
                continue;
            }
            throw XMLDataStoreException.invalidFieldValue(string, e);
        }
        return element;
    }
}

