/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.tools.sessionconfiguration;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.InitialContext;
import oracle.toplink.Version;
import oracle.toplink.eis.EISConnectionSpec;
import oracle.toplink.eis.EISLogin;
import oracle.toplink.eis.adapters.xmlfile.XMLFileSequence;
import oracle.toplink.exceptions.ExceptionHandler;
import oracle.toplink.exceptions.SessionLoaderException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.databaseaccess.DatasourcePlatform;
import oracle.toplink.internal.helper.ConversionManager;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.jndi.JNDIConnector;
import oracle.toplink.logging.DefaultSessionLog;
import oracle.toplink.logging.SessionLog;
import oracle.toplink.ox.XMLLogin;
import oracle.toplink.platform.server.NoServerPlatform;
import oracle.toplink.platform.server.ServerPlatform;
import oracle.toplink.publicinterface.DatabaseSession;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.remote.AbstractClusteringService;
import oracle.toplink.remote.AbstractJNDIClusteringService;
import oracle.toplink.remote.CacheSynchronizationManager;
import oracle.toplink.remote.corba.sun.CORBAJNDIClusteringService;
import oracle.toplink.remote.jms.JMSClusteringService;
import oracle.toplink.remote.rmi.RMIClusteringService;
import oracle.toplink.remote.rmi.RMIJNDIClusteringService;
import oracle.toplink.remote.rmi.wls.WLSClusteringService;
import oracle.toplink.remotecommand.DiscoveryManager;
import oracle.toplink.remotecommand.RemoteCommandManager;
import oracle.toplink.remotecommand.TransportManager;
import oracle.toplink.remotecommand.corba.sun.SunCORBATransportManager;
import oracle.toplink.remotecommand.jms.JMSTopicTransportManager;
import oracle.toplink.remotecommand.rmi.RMITransportManager;
import oracle.toplink.sequencing.DefaultSequence;
import oracle.toplink.sequencing.NativeSequence;
import oracle.toplink.sequencing.Sequence;
import oracle.toplink.sequencing.TableSequence;
import oracle.toplink.sequencing.UnaryTableSequence;
import oracle.toplink.sessionbroker.SessionBroker;
import oracle.toplink.sessions.Connector;
import oracle.toplink.sessions.DatabaseLogin;
import oracle.toplink.sessions.DatasourceLogin;
import oracle.toplink.sessions.Login;
import oracle.toplink.sessions.Project;
import oracle.toplink.sessions.SessionEventListener;
import oracle.toplink.threetier.ConnectionPolicy;
import oracle.toplink.threetier.ConnectionPool;
import oracle.toplink.threetier.ReadConnectionPool;
import oracle.toplink.threetier.ServerSession;
import oracle.toplink.tools.profiler.DMSPerformanceProfiler;
import oracle.toplink.tools.profiler.PerformanceProfiler;
import oracle.toplink.tools.sessionconfiguration.SessionCustomizer;
import oracle.toplink.tools.sessionconfiguration.model.TopLinkSessions;
import oracle.toplink.tools.sessionconfiguration.model.clustering.ClusteringServiceConfig;
import oracle.toplink.tools.sessionconfiguration.model.clustering.JMSClusteringConfig;
import oracle.toplink.tools.sessionconfiguration.model.clustering.JNDIClusteringServiceConfig;
import oracle.toplink.tools.sessionconfiguration.model.clustering.RMIClusteringConfig;
import oracle.toplink.tools.sessionconfiguration.model.clustering.RMIIIOPJNDIClusteringConfig;
import oracle.toplink.tools.sessionconfiguration.model.clustering.RMIJNDIClusteringConfig;
import oracle.toplink.tools.sessionconfiguration.model.clustering.SunCORBAJNDIClusteringConfig;
import oracle.toplink.tools.sessionconfiguration.model.clustering.WLSClusteringConfig;
import oracle.toplink.tools.sessionconfiguration.model.csm.CacheSynchronizationManagerConfig;
import oracle.toplink.tools.sessionconfiguration.model.event.SessionEventManagerConfig;
import oracle.toplink.tools.sessionconfiguration.model.log.DefaultSessionLogConfig;
import oracle.toplink.tools.sessionconfiguration.model.log.JavaLogConfig;
import oracle.toplink.tools.sessionconfiguration.model.log.LogConfig;
import oracle.toplink.tools.sessionconfiguration.model.log.ServerLogConfig;
import oracle.toplink.tools.sessionconfiguration.model.login.DatabaseLoginConfig;
import oracle.toplink.tools.sessionconfiguration.model.login.EISLoginConfig;
import oracle.toplink.tools.sessionconfiguration.model.login.LoginConfig;
import oracle.toplink.tools.sessionconfiguration.model.login.XMLLoginConfig;
import oracle.toplink.tools.sessionconfiguration.model.platform.CustomServerPlatformConfig;
import oracle.toplink.tools.sessionconfiguration.model.platform.ServerPlatformConfig;
import oracle.toplink.tools.sessionconfiguration.model.pool.ConnectionPolicyConfig;
import oracle.toplink.tools.sessionconfiguration.model.pool.ConnectionPoolConfig;
import oracle.toplink.tools.sessionconfiguration.model.pool.PoolsConfig;
import oracle.toplink.tools.sessionconfiguration.model.pool.ReadConnectionPoolConfig;
import oracle.toplink.tools.sessionconfiguration.model.pool.WriteConnectionPoolConfig;
import oracle.toplink.tools.sessionconfiguration.model.project.ProjectConfig;
import oracle.toplink.tools.sessionconfiguration.model.property.PropertyConfig;
import oracle.toplink.tools.sessionconfiguration.model.rcm.RemoteCommandManagerConfig;
import oracle.toplink.tools.sessionconfiguration.model.rcm.command.CommandsConfig;
import oracle.toplink.tools.sessionconfiguration.model.sequencing.DefaultSequenceConfig;
import oracle.toplink.tools.sessionconfiguration.model.sequencing.NativeSequenceConfig;
import oracle.toplink.tools.sessionconfiguration.model.sequencing.SequenceConfig;
import oracle.toplink.tools.sessionconfiguration.model.sequencing.TableSequenceConfig;
import oracle.toplink.tools.sessionconfiguration.model.sequencing.UnaryTableSequenceConfig;
import oracle.toplink.tools.sessionconfiguration.model.sequencing.XMLFileSequenceConfig;
import oracle.toplink.tools.sessionconfiguration.model.session.DatabaseSessionConfig;
import oracle.toplink.tools.sessionconfiguration.model.session.ServerSessionConfig;
import oracle.toplink.tools.sessionconfiguration.model.session.SessionBrokerConfig;
import oracle.toplink.tools.sessionconfiguration.model.session.SessionConfig;
import oracle.toplink.tools.sessionconfiguration.model.transport.JMSTopicTransportManagerConfig;
import oracle.toplink.tools.sessionconfiguration.model.transport.RMIIIOPTransportManagerConfig;
import oracle.toplink.tools.sessionconfiguration.model.transport.RMITransportManagerConfig;
import oracle.toplink.tools.sessionconfiguration.model.transport.SunCORBATransportManagerConfig;
import oracle.toplink.tools.sessionconfiguration.model.transport.TransportManagerConfig;
import oracle.toplink.tools.sessionconfiguration.model.transport.UserDefinedTransportManagerConfig;
import oracle.toplink.tools.sessionconfiguration.model.transport.discovery.DiscoveryConfig;
import oracle.toplink.tools.sessionconfiguration.model.transport.naming.JNDINamingServiceConfig;
import oracle.toplink.tools.sessionconfiguration.model.transport.naming.RMIRegistryNamingServiceConfig;
import oracle.toplink.tools.workbench.XMLProjectReader;

public class TopLinkSessionsFactory {
    private Hashtable m_sessions;
    private Hashtable m_logLevels = new Hashtable();
    private ClassLoader m_classLoader;
    static TopLinkSessionsFactory m_factory;
    static /* synthetic */ Class class$oracle$toplink$sessions$DatabaseSession;
    static /* synthetic */ Class class$java$lang$Class;

    protected TopLinkSessionsFactory() {
        this.m_logLevels.put("off", new Integer(8));
        this.m_logLevels.put("severe", new Integer(7));
        this.m_logLevels.put("warning", new Integer(6));
        this.m_logLevels.put("info", new Integer(5));
        this.m_logLevels.put("config", new Integer(4));
        this.m_logLevels.put("fine", new Integer(3));
        this.m_logLevels.put("finer", new Integer(2));
        this.m_logLevels.put("finest", new Integer(1));
        this.m_logLevels.put("all", new Integer(1));
    }

    public static TopLinkSessionsFactory getFactory() {
        if (m_factory == null) {
            m_factory = new TopLinkSessionsFactory();
        }
        return m_factory;
    }

    public Hashtable buildTopLinkSessions(TopLinkSessions topLinkSessions, ClassLoader classLoader) {
        Object object;
        Object object2;
        this.m_sessions = new Hashtable();
        this.m_classLoader = classLoader;
        Vector<Object> vector = new Vector<Object>();
        Enumeration enumeration = topLinkSessions.getSessionConfigs().elements();
        while (enumeration.hasMoreElements()) {
            object2 = (SessionConfig)enumeration.nextElement();
            if (object2 instanceof SessionBrokerConfig) {
                vector.add(object2);
                continue;
            }
            object = this.buildSession((SessionConfig)object2);
            this.processSessionCustomizer((SessionConfig)object2, (Session)object);
            this.m_sessions.put(((Session)object).getName(), object);
            ((Session)object).getDatasourcePlatform().getConversionManager().setLoader(classLoader);
        }
        object2 = vector.elements();
        while (object2.hasMoreElements()) {
            object = (SessionBrokerConfig)object2.nextElement();
            SessionBroker sessionBroker = this.buildSessionBrokerConfig((SessionBrokerConfig)object);
            this.processSessionCustomizer((SessionConfig)object, sessionBroker);
            this.m_sessions.put(sessionBroker.getName(), sessionBroker);
        }
        return this.m_sessions;
    }

    private void processSessionCustomizer(SessionConfig sessionConfig, Session session) {
        String string = sessionConfig.getSessionCustomizerClass();
        if (string != null) {
            try {
                Class<?> clazz = this.m_classLoader.loadClass(string);
                ((SessionCustomizer)PrivilegedAccessController.newInstanceFromClass(clazz)).customize(session);
            }
            catch (Throwable throwable) {
                throw SessionLoaderException.failedToLoadTag("session-customizer-class", string, throwable);
            }
        }
    }

    private Session buildSession(SessionConfig sessionConfig) {
        if (sessionConfig instanceof ServerSessionConfig) {
            return this.buildServerSessionConfig((ServerSessionConfig)sessionConfig);
        }
        return this.buildDatabaseSessionConfig((DatabaseSessionConfig)sessionConfig);
    }

    private Session buildDatabaseSessionConfig(DatabaseSessionConfig databaseSessionConfig) {
        DatabaseSession databaseSession = this.createSession(databaseSessionConfig, null);
        Login login = this.buildLogin(databaseSessionConfig.getLoginConfig());
        if (login != null) {
            databaseSession.setLogin(login);
        }
        this.processDatabaseSessionConfig(databaseSessionConfig, databaseSession);
        this.processSessionConfig(databaseSessionConfig, databaseSession);
        return databaseSession;
    }

    private void processDatabaseSessionConfig(DatabaseSessionConfig databaseSessionConfig, Session session) {
    }

    private Session buildServerSessionConfig(ServerSessionConfig serverSessionConfig) {
        Login login = this.buildLogin(serverSessionConfig.getLoginConfig());
        ServerSession serverSession = (ServerSession)this.createSession(serverSessionConfig, login);
        this.processDatabaseSessionConfig(serverSessionConfig, serverSession);
        this.processPoolsConfig(serverSessionConfig.getPoolsConfig(), serverSession);
        this.processConnectionPolicyConfig(serverSessionConfig.getConnectionPolicyConfig(), serverSession);
        this.processSessionConfig(serverSessionConfig, serverSession);
        return serverSession;
    }

    private DatabaseSession createSession(DatabaseSessionConfig databaseSessionConfig, Login login) {
        Project project = databaseSessionConfig.getPrimaryProject() != null ? this.loadProjectConfig(databaseSessionConfig.getPrimaryProject()) : new Project();
        this.prepareProjectLogin(project, login);
        DatabaseSession databaseSession = this.getSession(databaseSessionConfig, project);
        if (databaseSessionConfig.getAdditionalProjects() != null) {
            Enumeration enumeration = databaseSessionConfig.getAdditionalProjects().elements();
            while (enumeration.hasMoreElements()) {
                Project project2 = this.loadProjectConfig((ProjectConfig)enumeration.nextElement());
                project.addDescriptors(project2, databaseSession);
            }
        }
        return databaseSession;
    }

    private void prepareProjectLogin(Project project, Login login) {
        if (login != null) {
            project.setLogin(login);
        } else if (project.getDatasourceLogin() == null) {
            project.setLogin(new DatabaseLogin());
        }
    }

    private DatabaseSession getSession(SessionConfig sessionConfig, Project project) {
        if (sessionConfig instanceof ServerSessionConfig) {
            return (ServerSession)project.createServerSession();
        }
        return (DatabaseSession)project.createDatabaseSession();
    }

    private Project loadProjectConfig(ProjectConfig projectConfig) {
        Project project = null;
        String string = projectConfig.getProjectString();
        if (projectConfig.isProjectClassConfig()) {
            try {
                project = (Project)PrivilegedAccessController.newInstanceFromClass(this.m_classLoader.loadClass(string));
            }
            catch (Throwable throwable) {
                throw SessionLoaderException.failedToLoadProjectClass(string, throwable);
            }
        }
        try {
            project = XMLProjectReader.read(string, this.m_classLoader);
        }
        catch (ValidationException validationException) {
            if (validationException.getErrorCode() == 7099) {
                try {
                    project = XMLProjectReader.read(string);
                }
                catch (Exception exception) {
                    throw SessionLoaderException.failedToLoadProjectXml(string, validationException);
                }
            }
            throw SessionLoaderException.failedToLoadProjectXml(string, validationException);
        }
        return project;
    }

    private Login buildLogin(LoginConfig loginConfig) {
        if (loginConfig instanceof EISLoginConfig) {
            return this.buildEISLoginConfig((EISLoginConfig)loginConfig);
        }
        if (loginConfig instanceof XMLLoginConfig) {
            return this.buildXMLLoginConfig((XMLLoginConfig)loginConfig);
        }
        if (loginConfig instanceof DatabaseLoginConfig) {
            return this.buildDatabaseLoginConfig((DatabaseLoginConfig)loginConfig);
        }
        return null;
    }

    private Login buildEISLoginConfig(EISLoginConfig eISLoginConfig) {
        EISLogin eISLogin = new EISLogin();
        String string = eISLoginConfig.getConnectionSpecClass();
        if (string != null) {
            try {
                Class<?> clazz = this.m_classLoader.loadClass(string);
                EISConnectionSpec eISConnectionSpec = (EISConnectionSpec)PrivilegedAccessController.newInstanceFromClass(clazz);
                eISLogin.setConnectionSpec(eISConnectionSpec);
            }
            catch (Exception exception) {
                throw SessionLoaderException.failedToLoadTag("connection-spec-class", string, exception);
            }
        }
        eISLogin.setConnectionFactoryURL(eISLoginConfig.getConnectionFactoryURL());
        this.processLoginConfig(eISLoginConfig, eISLogin);
        return eISLogin;
    }

    private Login buildXMLLoginConfig(XMLLoginConfig xMLLoginConfig) {
        XMLLogin xMLLogin = new XMLLogin();
        this.processLoginConfig(xMLLoginConfig, xMLLogin);
        return xMLLogin;
    }

    private Login buildDatabaseLoginConfig(DatabaseLoginConfig databaseLoginConfig) {
        Serializable serializable;
        String string;
        Object object;
        DatabaseLogin databaseLogin = new DatabaseLogin();
        String string2 = databaseLoginConfig.getDriverClass();
        if (string2 != null) {
            try {
                object = this.m_classLoader.loadClass(string2);
                databaseLogin.setDriverClass((Class)object);
            }
            catch (Exception exception) {
                throw SessionLoaderException.failedToLoadTag("driver-class", string2, exception);
            }
        }
        if ((object = databaseLoginConfig.getConnectionURL()) != null) {
            databaseLogin.setConnectionString((String)object);
        }
        if ((string = databaseLoginConfig.getDatasource()) != null) {
            try {
                serializable = new JNDIConnector(new InitialContext(), string);
                ((JNDIConnector)serializable).setLookupType(databaseLoginConfig.getLookupType());
                databaseLogin.setConnector((Connector)serializable);
            }
            catch (Exception exception) {
                throw SessionLoaderException.failedToLoadTag("datasource", string, exception);
            }
        }
        databaseLogin.setShouldBindAllParameters(databaseLoginConfig.getBindAllParameters());
        databaseLogin.setShouldCacheAllStatements(databaseLoginConfig.getCacheAllStatements());
        databaseLogin.setUsesByteArrayBinding(databaseLoginConfig.getByteArrayBinding());
        databaseLogin.setUsesStringBinding(databaseLoginConfig.getStringBinding());
        databaseLogin.setUsesStreamsForBinding(databaseLoginConfig.getStreamsForBinding());
        databaseLogin.setShouldForceFieldNamesToUpperCase(databaseLoginConfig.getForceFieldNamesToUppercase());
        databaseLogin.setShouldOptimizeDataConversion(databaseLoginConfig.getOptimizeDataConversion());
        databaseLogin.setShouldTrimStrings(databaseLoginConfig.getTrimStrings());
        databaseLogin.setUsesBatchWriting(databaseLoginConfig.getBatchWriting());
        databaseLogin.setUsesJDBCBatchWriting(databaseLoginConfig.getJdbcBatchWriting());
        serializable = databaseLoginConfig.getMaxBatchWritingSize();
        if (serializable != null) {
            databaseLogin.setMaxBatchWritingSize((Integer)serializable);
        }
        databaseLogin.setUsesNativeSQL(databaseLoginConfig.getNativeSQL());
        this.processLoginConfig(databaseLoginConfig, databaseLogin);
        return databaseLogin;
    }

    private void processLoginConfig(LoginConfig loginConfig, DatasourceLogin datasourceLogin) {
        Object object;
        Enumeration enumeration;
        Object object2;
        String string = loginConfig.getPlatformClass();
        if (string != null) {
            try {
                object2 = this.m_classLoader.loadClass(string);
                datasourceLogin.usePlatform((DatasourcePlatform)PrivilegedAccessController.newInstanceFromClass((Class)object2));
            }
            catch (Exception exception) {
                throw SessionLoaderException.failedToLoadTag("platform-class", string, exception);
            }
        }
        if ((object2 = loginConfig.getTableQualifier()) != null) {
            datasourceLogin.setTableQualifier((String)object2);
        }
        datasourceLogin.setUserName(loginConfig.getUsername());
        datasourceLogin.setEncryptionClassName(loginConfig.getEncryptionClass());
        datasourceLogin.setEncryptedPassword(loginConfig.getEncryptedPassword());
        datasourceLogin.setUsesExternalConnectionPooling(loginConfig.getExternalConnectionPooling());
        datasourceLogin.setUsesExternalTransactionController(loginConfig.getExternalTransactionController());
        if (loginConfig.getSequencingConfig() != null) {
            if (loginConfig.getSequencingConfig().getDefaultSequenceConfig() != null) {
                enumeration = this.buildSequence(loginConfig.getSequencingConfig().getDefaultSequenceConfig());
                datasourceLogin.setDefaultSequence((Sequence)((Object)enumeration));
            }
            if (loginConfig.getSequencingConfig().getSequenceConfigs() != null && !loginConfig.getSequencingConfig().getSequenceConfigs().isEmpty()) {
                enumeration = loginConfig.getSequencingConfig().getSequenceConfigs().elements();
                while (enumeration.hasMoreElements()) {
                    object = this.buildSequence((SequenceConfig)enumeration.nextElement());
                    datasourceLogin.addSequence((Sequence)object);
                }
            }
        }
        if (loginConfig.getPropertyConfigs() != null) {
            enumeration = loginConfig.getPropertyConfigs().elements();
            while (enumeration.hasMoreElements()) {
                object = (PropertyConfig)enumeration.nextElement();
                datasourceLogin.getProperties().put(((PropertyConfig)object).getName(), ((PropertyConfig)object).getValue());
            }
        }
    }

    private void processPoolsConfig(PoolsConfig poolsConfig, ServerSession serverSession) {
        if (poolsConfig != null) {
            ConnectionPoolConfig connectionPoolConfig;
            WriteConnectionPoolConfig writeConnectionPoolConfig;
            ReadConnectionPoolConfig readConnectionPoolConfig = poolsConfig.getReadConnectionPoolConfig();
            if (readConnectionPoolConfig != null) {
                serverSession.setReadConnectionPool(this.buildReadConnectionPoolConfig(readConnectionPoolConfig, serverSession));
            }
            if ((writeConnectionPoolConfig = poolsConfig.getWriteConnectionPoolConfig()) != null) {
                serverSession.addConnectionPool(this.buildConnectionPoolConfig(writeConnectionPoolConfig, serverSession));
            }
            if ((connectionPoolConfig = poolsConfig.getSequenceConnectionPoolConfig()) != null) {
                this.processSequenceConnectionPoolConfig(connectionPoolConfig, serverSession);
            }
            Enumeration enumeration = poolsConfig.getConnectionPoolConfigs().elements();
            while (enumeration.hasMoreElements()) {
                ConnectionPoolConfig connectionPoolConfig2 = (ConnectionPoolConfig)enumeration.nextElement();
                serverSession.addConnectionPool(this.buildConnectionPoolConfig(connectionPoolConfig2, serverSession));
            }
        }
    }

    private void processSequenceConnectionPoolConfig(ConnectionPoolConfig connectionPoolConfig, ServerSession serverSession) {
        Integer n;
        serverSession.getSequencingControl().setShouldUseSeparateConnection(true);
        Integer n2 = connectionPoolConfig.getMaxConnections();
        if (n2 != null) {
            serverSession.getSequencingControl().setMaxPoolSize(n2);
        }
        if ((n = connectionPoolConfig.getMinConnections()) != null) {
            serverSession.getSequencingControl().setMinPoolSize(n);
        }
    }

    private void processServerPlatformConfig(ServerPlatformConfig serverPlatformConfig, ServerPlatform serverPlatform) {
        if (!serverPlatformConfig.getEnableRuntimeServices()) {
            serverPlatform.disableRuntimeServices();
        }
        if (!serverPlatformConfig.getEnableJTA()) {
            serverPlatform.disableJTA();
        }
    }

    private ConnectionPool buildConnectionPoolConfig(ConnectionPoolConfig connectionPoolConfig, ServerSession serverSession) {
        ConnectionPool connectionPool = new ConnectionPool();
        this.processConnectionPoolConfig(connectionPoolConfig, connectionPool, serverSession);
        return connectionPool;
    }

    private ServerPlatform buildCustomServerPlatformConfig(CustomServerPlatformConfig customServerPlatformConfig, DatabaseSession databaseSession) {
        ServerPlatform serverPlatform;
        Object object;
        String string = customServerPlatformConfig.getServerClassName();
        try {
            object = this.m_classLoader.loadClass(string);
            Constructor constructor = PrivilegedAccessController.getConstructorFor(object, new Class[]{class$oracle$toplink$sessions$DatabaseSession == null ? (class$oracle$toplink$sessions$DatabaseSession = TopLinkSessionsFactory.class$("oracle.toplink.sessions.DatabaseSession")) : class$oracle$toplink$sessions$DatabaseSession}, false);
            serverPlatform = (ServerPlatform)PrivilegedAccessController.invokeConstructor(constructor, new Object[]{databaseSession});
        }
        catch (Throwable throwable) {
            throw SessionLoaderException.failedToLoadTag("server-class", string, throwable);
        }
        object = customServerPlatformConfig.getExternalTransactionControllerClass();
        if (object != null) {
            try {
                serverPlatform.setExternalTransactionControllerClass(this.m_classLoader.loadClass((String)object));
            }
            catch (Exception exception) {
                throw SessionLoaderException.failedToLoadTag("external-transaction-controller-class", (String)object, exception);
            }
        }
        return serverPlatform;
    }

    private ConnectionPool buildReadConnectionPoolConfig(ReadConnectionPoolConfig readConnectionPoolConfig, ServerSession serverSession) {
        ConnectionPool connectionPool = readConnectionPoolConfig.getExclusive() ? new ConnectionPool() : new ReadConnectionPool();
        this.processConnectionPoolConfig(readConnectionPoolConfig, connectionPool, serverSession);
        return connectionPool;
    }

    private void processConnectionPolicyConfig(ConnectionPolicyConfig connectionPolicyConfig, ServerSession serverSession) {
        if (connectionPolicyConfig != null) {
            ConnectionPolicy connectionPolicy = serverSession.getDefaultConnectionPolicy();
            connectionPolicy.setShouldUseExclusiveConnection(connectionPolicyConfig.getUseExclusiveConnection());
            connectionPolicy.setIsLazy(connectionPolicyConfig.getLazy());
        }
    }

    private void processConnectionPoolConfig(ConnectionPoolConfig connectionPoolConfig, ConnectionPool connectionPool, Session session) {
        Integer n;
        Login login = this.buildLogin(connectionPoolConfig.getLoginConfig());
        if (login != null) {
            connectionPool.setLogin(login);
        } else {
            connectionPool.setLogin(session.getDatasourceLogin());
        }
        connectionPool.setName(connectionPoolConfig.getName());
        Integer n2 = connectionPoolConfig.getMaxConnections();
        if (n2 != null) {
            connectionPool.setMaxNumberOfConnections(n2);
        }
        if ((n = connectionPoolConfig.getMinConnections()) != null) {
            connectionPool.setMinNumberOfConnections(n);
        }
    }

    private void processSessionConfig(SessionConfig sessionConfig, Session session) {
        String string;
        this.processSessionEventManagerConfig(sessionConfig.getSessionEventManagerConfig(), session);
        ((DatabaseSession)session).setServerPlatform(this.buildServerPlatformConfig(sessionConfig.getServerPlatformConfig(), (DatabaseSession)session));
        SessionLog sessionLog = this.buildSessionLog(sessionConfig.getLogConfig(), session);
        if (sessionLog != null) {
            session.setSessionLog(sessionLog);
        }
        session.setCacheSynchronizationManager(this.buildCacheSynchronizationManagerConfig(sessionConfig.getCacheSynchronizationManagerConfig(), session));
        this.buildRemoteCommandManagerConfig(sessionConfig.getRemoteCommandManagerConfig(), session);
        session.setName(sessionConfig.getName());
        if (sessionConfig.getProfiler() != null) {
            if (sessionConfig.getProfiler().equals("toplink")) {
                session.setProfiler(new PerformanceProfiler());
            } else if (sessionConfig.getProfiler().equals("dms")) {
                session.setProfiler(new DMSPerformanceProfiler(session));
            }
        }
        if ((string = sessionConfig.getExceptionHandlerClass()) != null) {
            try {
                Class<?> clazz = this.m_classLoader.loadClass(string);
                session.setExceptionHandler((ExceptionHandler)PrivilegedAccessController.newInstanceFromClass(clazz));
            }
            catch (Throwable throwable) {
                throw SessionLoaderException.failedToLoadTag("exception-handler-class", string, throwable);
            }
        }
    }

    private ServerPlatform buildServerPlatformConfig(ServerPlatformConfig serverPlatformConfig, DatabaseSession databaseSession) {
        ServerPlatform serverPlatform;
        if (serverPlatformConfig == null) {
            return new NoServerPlatform(databaseSession);
        }
        if (serverPlatformConfig instanceof CustomServerPlatformConfig) {
            serverPlatform = this.buildCustomServerPlatformConfig((CustomServerPlatformConfig)serverPlatformConfig, databaseSession);
        } else {
            String string = serverPlatformConfig.getServerClassName();
            try {
                Class<?> clazz = this.m_classLoader.loadClass(string);
                Constructor constructor = PrivilegedAccessController.getConstructorFor(clazz, new Class[]{class$oracle$toplink$sessions$DatabaseSession == null ? (class$oracle$toplink$sessions$DatabaseSession = TopLinkSessionsFactory.class$("oracle.toplink.sessions.DatabaseSession")) : class$oracle$toplink$sessions$DatabaseSession}, false);
                serverPlatform = (ServerPlatform)PrivilegedAccessController.invokeConstructor(constructor, new Object[]{databaseSession});
            }
            catch (Throwable throwable) {
                throw SessionLoaderException.failedToParseXML("Server platform class is invalid: " + string, throwable);
            }
        }
        this.processServerPlatformConfig(serverPlatformConfig, serverPlatform);
        return serverPlatform;
    }

    private void buildRemoteCommandManagerConfig(RemoteCommandManagerConfig remoteCommandManagerConfig, Session session) {
        if (remoteCommandManagerConfig != null) {
            RemoteCommandManager remoteCommandManager = new RemoteCommandManager(session);
            this.processCommandsConfig(remoteCommandManagerConfig.getCommandsConfig(), remoteCommandManager);
            this.buildTransportManager(remoteCommandManagerConfig.getTransportManagerConfig(), remoteCommandManager);
            remoteCommandManager.setChannel(remoteCommandManagerConfig.getChannel());
        }
    }

    private void buildTransportManager(TransportManagerConfig transportManagerConfig, RemoteCommandManager remoteCommandManager) {
        if (transportManagerConfig instanceof RMITransportManagerConfig) {
            this.buildRMITransportManagerConfig((RMITransportManagerConfig)transportManagerConfig, remoteCommandManager);
        } else if (transportManagerConfig instanceof RMIIIOPTransportManagerConfig) {
            this.buildRMIIIOPTransportManagerConfig((RMIIIOPTransportManagerConfig)transportManagerConfig, remoteCommandManager);
        } else if (transportManagerConfig instanceof JMSTopicTransportManagerConfig) {
            this.buildJMSTopicTransportManagerConfig((JMSTopicTransportManagerConfig)transportManagerConfig, remoteCommandManager);
        } else if (transportManagerConfig instanceof SunCORBATransportManagerConfig) {
            this.buildSunCORBATransportManagerConfig((SunCORBATransportManagerConfig)transportManagerConfig, remoteCommandManager);
        } else if (transportManagerConfig instanceof UserDefinedTransportManagerConfig) {
            this.buildUserDefinedTransportManagerConfig((UserDefinedTransportManagerConfig)transportManagerConfig, remoteCommandManager);
        }
    }

    private void buildRMITransportManagerConfig(RMITransportManagerConfig rMITransportManagerConfig, RemoteCommandManager remoteCommandManager) {
        RMITransportManager rMITransportManager = new RMITransportManager(remoteCommandManager);
        remoteCommandManager.setTransportManager(rMITransportManager);
        DiscoveryConfig discoveryConfig = rMITransportManagerConfig.getDiscoveryConfig();
        if (discoveryConfig != null) {
            this.processDiscoveryConfig(discoveryConfig, remoteCommandManager.getDiscoveryManager());
        }
        if (rMITransportManagerConfig.getJNDINamingServiceConfig() != null) {
            rMITransportManager.setNamingServiceType(0);
            this.processJNDINamingServiceConfig(rMITransportManagerConfig.getJNDINamingServiceConfig(), rMITransportManager);
        } else if (rMITransportManagerConfig.getRMIRegistryNamingServiceConfig() != null) {
            rMITransportManager.setNamingServiceType(1);
            this.processRMIRegistryNamingServiceConfig(rMITransportManagerConfig.getRMIRegistryNamingServiceConfig(), rMITransportManager);
        }
        rMITransportManager.setIsRMIOverIIOP(rMITransportManagerConfig instanceof RMIIIOPTransportManagerConfig);
        remoteCommandManager.setShouldPropagateAsynchronously(rMITransportManagerConfig.getSendMode().equals("Asynchronous"));
        this.processTransportManagerConfig(rMITransportManagerConfig, rMITransportManager);
    }

    private Sequence buildSequence(SequenceConfig sequenceConfig) {
        if (sequenceConfig == null) {
            return null;
        }
        String string = sequenceConfig.getName();
        int n = sequenceConfig.getPreallocationSize();
        if (sequenceConfig instanceof DefaultSequenceConfig) {
            return new DefaultSequence(string, n);
        }
        if (sequenceConfig instanceof NativeSequenceConfig) {
            return new NativeSequence(string, n);
        }
        if (sequenceConfig instanceof TableSequenceConfig) {
            TableSequenceConfig tableSequenceConfig = (TableSequenceConfig)sequenceConfig;
            return new TableSequence(string, n, tableSequenceConfig.getTable(), tableSequenceConfig.getNameField(), tableSequenceConfig.getCounterField());
        }
        if (sequenceConfig instanceof UnaryTableSequenceConfig) {
            UnaryTableSequenceConfig unaryTableSequenceConfig = (UnaryTableSequenceConfig)sequenceConfig;
            return new UnaryTableSequence(string, n, unaryTableSequenceConfig.getCounterField());
        }
        if (sequenceConfig instanceof XMLFileSequenceConfig) {
            return new XMLFileSequence(string, n);
        }
        return null;
    }

    private void buildRMIIIOPTransportManagerConfig(RMIIIOPTransportManagerConfig rMIIIOPTransportManagerConfig, RemoteCommandManager remoteCommandManager) {
        this.buildRMITransportManagerConfig(rMIIIOPTransportManagerConfig, remoteCommandManager);
    }

    private void buildJMSTopicTransportManagerConfig(JMSTopicTransportManagerConfig jMSTopicTransportManagerConfig, RemoteCommandManager remoteCommandManager) {
        String string;
        JMSTopicTransportManager jMSTopicTransportManager = new JMSTopicTransportManager(remoteCommandManager);
        remoteCommandManager.setTransportManager(jMSTopicTransportManager);
        if (jMSTopicTransportManagerConfig.getJNDINamingServiceConfig() != null) {
            jMSTopicTransportManager.setNamingServiceType(0);
            this.processJNDINamingServiceConfig(jMSTopicTransportManagerConfig.getJNDINamingServiceConfig(), jMSTopicTransportManager);
        }
        if ((string = jMSTopicTransportManagerConfig.getTopicHostURL()) != null) {
            jMSTopicTransportManager.setTopicHostUrl(string);
        }
        jMSTopicTransportManager.setTopicConnectionFactoryName(jMSTopicTransportManagerConfig.getTopicConnectionFactoryName());
        jMSTopicTransportManager.setTopicName(jMSTopicTransportManagerConfig.getTopicName());
        this.processTransportManagerConfig(jMSTopicTransportManagerConfig, jMSTopicTransportManager);
    }

    private void buildUserDefinedTransportManagerConfig(UserDefinedTransportManagerConfig userDefinedTransportManagerConfig, RemoteCommandManager remoteCommandManager) {
        TransportManager transportManager = null;
        String string = userDefinedTransportManagerConfig.getTransportClass();
        if (string != null) {
            try {
                Class<?> clazz = this.m_classLoader.loadClass(string);
                transportManager = (TransportManager)PrivilegedAccessController.newInstanceFromClass(clazz);
            }
            catch (Throwable throwable) {
                throw SessionLoaderException.failedToLoadTag("transport-class", string, throwable);
            }
            remoteCommandManager.setTransportManager(transportManager);
            this.processTransportManagerConfig(userDefinedTransportManagerConfig, transportManager);
        }
    }

    private void processJNDINamingServiceConfig(JNDINamingServiceConfig jNDINamingServiceConfig, TransportManager transportManager) {
        String string = jNDINamingServiceConfig.getURL();
        if (string != null) {
            transportManager.getRemoteCommandManager().setUrl(string);
        }
        transportManager.setUserName(jNDINamingServiceConfig.getUsername());
        transportManager.setEncryptionClassName(jNDINamingServiceConfig.getEncryptionClass());
        transportManager.setEncryptedPassword(jNDINamingServiceConfig.getEncryptedPassword());
        transportManager.setInitialContextFactoryName(jNDINamingServiceConfig.getInitialContextFactoryName());
        Enumeration enumeration = jNDINamingServiceConfig.getPropertyConfigs().elements();
        while (enumeration.hasMoreElements()) {
            PropertyConfig propertyConfig = (PropertyConfig)enumeration.nextElement();
            transportManager.getRemoteContextProperties().put(propertyConfig.getName(), propertyConfig.getValue());
        }
    }

    private void processRMIRegistryNamingServiceConfig(RMIRegistryNamingServiceConfig rMIRegistryNamingServiceConfig, TransportManager transportManager) {
        transportManager.getRemoteCommandManager().setUrl(rMIRegistryNamingServiceConfig.getURL());
    }

    private void processDiscoveryConfig(DiscoveryConfig discoveryConfig, DiscoveryManager discoveryManager) {
        discoveryManager.setMulticastGroupAddress(discoveryConfig.getMulticastGroupAddress());
        discoveryManager.setMulticastPort(discoveryConfig.getMulticastPort());
        discoveryManager.setAnnouncementDelay(discoveryConfig.getAnnouncementDelay());
        discoveryManager.setPacketTimeToLive(discoveryConfig.getPacketTimeToLive());
    }

    private void processTransportManagerConfig(TransportManagerConfig transportManagerConfig, TransportManager transportManager) {
        transportManager.setShouldRemoveConnectionOnError(transportManagerConfig.getOnConnectionError().equals("DiscardConnection"));
    }

    private void processSessionEventManagerConfig(SessionEventManagerConfig sessionEventManagerConfig, Session session) {
        if (sessionEventManagerConfig != null) {
            Enumeration enumeration = sessionEventManagerConfig.getSessionEventListeners().elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                try {
                    Class<?> clazz = this.m_classLoader.loadClass(string);
                    session.getEventManager().addListener((SessionEventListener)PrivilegedAccessController.newInstanceFromClass(clazz));
                }
                catch (Exception exception) {
                    throw SessionLoaderException.failedToLoadTag("event-listener-class", string, exception);
                }
            }
        }
    }

    private SessionLog buildSessionLog(LogConfig logConfig, Session session) {
        if (logConfig instanceof JavaLogConfig) {
            return this.buildJavaLogConfig((JavaLogConfig)logConfig, session);
        }
        if (logConfig instanceof DefaultSessionLogConfig) {
            return this.buildDefaultSessionLogConfig((DefaultSessionLogConfig)logConfig);
        }
        if (logConfig instanceof ServerLogConfig) {
            return this.buildServerLogConfig((ServerLogConfig)logConfig, session);
        }
        return null;
    }

    private SessionLog buildJavaLogConfig(JavaLogConfig javaLogConfig, Session session) {
        SessionLog sessionLog = null;
        if (!Version.isJDK13()) {
            try {
                sessionLog = (SessionLog)((Class)ConversionManager.getDefaultManager().convertObject("oracle.toplink.logging.JavaLog", class$java$lang$Class == null ? (class$java$lang$Class = TopLinkSessionsFactory.class$("java.lang.Class")) : class$java$lang$Class)).newInstance();
                sessionLog.setSession(session);
            }
            catch (Exception exception) {
                throw ValidationException.unableToLoadClass("oracle.toplink.logging.JavaLog", exception);
            }
        } else {
            throw ValidationException.featureIsNotAvailableInRunningJDKVersion("Java Log");
        }
        this.processLogConfig(javaLogConfig, sessionLog);
        return sessionLog;
    }

    private SessionLog buildDefaultSessionLogConfig(DefaultSessionLogConfig defaultSessionLogConfig) {
        DefaultSessionLog defaultSessionLog = new DefaultSessionLog();
        defaultSessionLog.setLevel((Integer)this.m_logLevels.get(defaultSessionLogConfig.getLogLevel()));
        defaultSessionLog.setWriter(defaultSessionLogConfig.getFilename());
        this.processLogConfig(defaultSessionLogConfig, defaultSessionLog);
        return defaultSessionLog;
    }

    private SessionLog buildServerLogConfig(ServerLogConfig serverLogConfig, Session session) {
        SessionLog sessionLog = ((DatabaseSession)session).getServerPlatform().getServerLog();
        return sessionLog;
    }

    private void processLogConfig(LogConfig logConfig, SessionLog sessionLog) {
        if (logConfig.getLoggingOptions() != null) {
            if (logConfig.getLoggingOptions().getShouldLogExceptionStackTrace() != null) {
                sessionLog.setShouldLogExceptionStackTrace(logConfig.getLoggingOptions().getShouldLogExceptionStackTrace());
            }
            if (logConfig.getLoggingOptions().getShouldPrintConnection() != null) {
                sessionLog.setShouldPrintConnection(logConfig.getLoggingOptions().getShouldPrintConnection());
            }
            if (logConfig.getLoggingOptions().getShouldPrintDate() != null) {
                sessionLog.setShouldPrintDate(logConfig.getLoggingOptions().getShouldPrintDate());
            }
            if (logConfig.getLoggingOptions().getShouldPrintSession() != null) {
                sessionLog.setShouldPrintSession(logConfig.getLoggingOptions().getShouldPrintSession());
            }
            if (logConfig.getLoggingOptions().getShouldPrintThread() != null) {
                sessionLog.setShouldPrintThread(logConfig.getLoggingOptions().getShouldPrintThread());
            }
        }
    }

    private CacheSynchronizationManager buildCacheSynchronizationManagerConfig(CacheSynchronizationManagerConfig cacheSynchronizationManagerConfig, Session session) {
        CacheSynchronizationManager cacheSynchronizationManager = null;
        if (cacheSynchronizationManagerConfig != null) {
            cacheSynchronizationManager = new CacheSynchronizationManager();
            cacheSynchronizationManager.setIsAsynchronous(cacheSynchronizationManagerConfig.getIsAsynchronous());
            cacheSynchronizationManager.setShouldRemoveConnectionOnError(cacheSynchronizationManagerConfig.getRemoveConnectionOnError());
            AbstractClusteringService abstractClusteringService = this.buildClusteringService(cacheSynchronizationManagerConfig.getClusteringServiceConfig(), session);
            if (abstractClusteringService != null) {
                cacheSynchronizationManager.setClusteringService(abstractClusteringService);
            }
        }
        return cacheSynchronizationManager;
    }

    private AbstractClusteringService buildClusteringService(ClusteringServiceConfig clusteringServiceConfig, Session session) {
        if (clusteringServiceConfig instanceof WLSClusteringConfig) {
            return this.buildWLSClusteringConfig((WLSClusteringConfig)clusteringServiceConfig, session);
        }
        if (clusteringServiceConfig instanceof RMIClusteringConfig) {
            return this.buildRMIClusteringConfig((RMIClusteringConfig)clusteringServiceConfig, session);
        }
        if (clusteringServiceConfig instanceof JMSClusteringConfig) {
            return this.buildJMSClusteringConfig((JMSClusteringConfig)clusteringServiceConfig, session);
        }
        if (clusteringServiceConfig instanceof RMIJNDIClusteringConfig) {
            return this.buildRMIJNDIClusteringConfig((RMIJNDIClusteringConfig)clusteringServiceConfig, session);
        }
        if (clusteringServiceConfig instanceof RMIIIOPJNDIClusteringConfig) {
            return this.buildRMIIIOPJNDIClusteringConfig((RMIIIOPJNDIClusteringConfig)clusteringServiceConfig, session);
        }
        if (clusteringServiceConfig instanceof SunCORBAJNDIClusteringConfig) {
            return this.buildSunCORBAJNDIClusteringConfig((SunCORBAJNDIClusteringConfig)clusteringServiceConfig, session);
        }
        return null;
    }

    private AbstractClusteringService buildWLSClusteringConfig(WLSClusteringConfig wLSClusteringConfig, Session session) {
        WLSClusteringService wLSClusteringService = new WLSClusteringService(session);
        this.processClusteringServiceConfig(wLSClusteringConfig, wLSClusteringService);
        return wLSClusteringService;
    }

    private AbstractClusteringService buildRMIClusteringConfig(RMIClusteringConfig rMIClusteringConfig, Session session) {
        RMIClusteringService rMIClusteringService = new RMIClusteringService(session);
        this.processClusteringServiceConfig(rMIClusteringConfig, rMIClusteringService);
        return rMIClusteringService;
    }

    private AbstractClusteringService buildJMSClusteringConfig(JMSClusteringConfig jMSClusteringConfig, Session session) {
        JMSClusteringService jMSClusteringService = new JMSClusteringService(session);
        jMSClusteringService.setTopicConnectionFactoryName(jMSClusteringConfig.getJMSTopicConnectionFactoryName());
        jMSClusteringService.setTopicName(jMSClusteringConfig.getJMSTopicName());
        this.processJNDIClusteringServiceConfig(jMSClusteringConfig, jMSClusteringService);
        return jMSClusteringService;
    }

    private AbstractClusteringService buildRMIJNDIClusteringConfig(RMIJNDIClusteringConfig rMIJNDIClusteringConfig, Session session) {
        RMIJNDIClusteringService rMIJNDIClusteringService = new RMIJNDIClusteringService(session);
        this.processJNDIClusteringServiceConfig(rMIJNDIClusteringConfig, rMIJNDIClusteringService);
        return rMIJNDIClusteringService;
    }

    private AbstractClusteringService buildRMIIIOPJNDIClusteringConfig(RMIIIOPJNDIClusteringConfig rMIIIOPJNDIClusteringConfig, Session session) {
        oracle.toplink.remote.rmi.iiop.RMIJNDIClusteringService rMIJNDIClusteringService = new oracle.toplink.remote.rmi.iiop.RMIJNDIClusteringService(session);
        this.processJNDIClusteringServiceConfig(rMIIIOPJNDIClusteringConfig, rMIJNDIClusteringService);
        return rMIJNDIClusteringService;
    }

    private AbstractClusteringService buildSunCORBAJNDIClusteringConfig(SunCORBAJNDIClusteringConfig sunCORBAJNDIClusteringConfig, Session session) {
        CORBAJNDIClusteringService cORBAJNDIClusteringService = new CORBAJNDIClusteringService(session);
        this.processJNDIClusteringServiceConfig(sunCORBAJNDIClusteringConfig, cORBAJNDIClusteringService);
        return cORBAJNDIClusteringService;
    }

    private void buildSunCORBATransportManagerConfig(SunCORBATransportManagerConfig sunCORBATransportManagerConfig, RemoteCommandManager remoteCommandManager) {
        SunCORBATransportManager sunCORBATransportManager = new SunCORBATransportManager(remoteCommandManager);
        remoteCommandManager.setTransportManager(sunCORBATransportManager);
        this.processTransportManagerConfig(sunCORBATransportManagerConfig, sunCORBATransportManager);
    }

    private void processClusteringServiceConfig(ClusteringServiceConfig clusteringServiceConfig, AbstractClusteringService abstractClusteringService) {
        String string;
        Integer n = clusteringServiceConfig.getMulticastPort();
        if (n != null) {
            abstractClusteringService.setMulticastPort(n);
        }
        abstractClusteringService.setMulticastGroupAddress(clusteringServiceConfig.getMulticastGroupAddress());
        Integer n2 = clusteringServiceConfig.getPacketTimeToLive();
        if (n2 != null) {
            abstractClusteringService.setTimeToLive(n2);
        }
        if ((string = clusteringServiceConfig.getNamingServiceURL()) != null) {
            abstractClusteringService.setLocalHostURL(string);
        }
    }

    private void processJNDIClusteringServiceConfig(JNDIClusteringServiceConfig jNDIClusteringServiceConfig, AbstractJNDIClusteringService abstractJNDIClusteringService) {
        String string;
        String string2;
        String string3 = jNDIClusteringServiceConfig.getJNDIUsername();
        if (string3 != null) {
            abstractJNDIClusteringService.setUserName(string3);
        }
        if ((string2 = jNDIClusteringServiceConfig.getJNDIPassword()) != null) {
            abstractJNDIClusteringService.setPassword(string2);
        }
        if ((string = jNDIClusteringServiceConfig.getNamingServiceInitialContextFactoryName()) != null) {
            abstractJNDIClusteringService.setInitialContextFactoryName(string);
        }
        this.processClusteringServiceConfig(jNDIClusteringServiceConfig, abstractJNDIClusteringService);
    }

    private void processCommandsConfig(CommandsConfig commandsConfig, RemoteCommandManager remoteCommandManager) {
        if (commandsConfig != null) {
            ((Session)remoteCommandManager.getCommandProcessor()).setShouldPropagateChanges(commandsConfig.getCacheSync());
        }
    }

    private SessionBroker buildSessionBrokerConfig(SessionBrokerConfig sessionBrokerConfig) {
        SessionBroker sessionBroker = new SessionBroker();
        Enumeration enumeration = sessionBrokerConfig.getSessionNames().elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            sessionBroker.registerSession(string, (Session)this.m_sessions.get(string));
        }
        this.processSessionConfig(sessionBrokerConfig, sessionBroker);
        return sessionBroker;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

