/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.tools.profiler;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.localization.ToStringLocalization;
import oracle.toplink.tools.profiler.PerformanceProfiler;

public class Profile
implements Serializable,
Cloneable {
    protected Class queryClass;
    protected Class domainClass;
    protected long numberOfInstancesEffected = 0L;
    protected Hashtable operationTimings = new Hashtable();
    protected long localTime = 0L;
    protected long profileTime = 0L;
    protected long totalTime = 0L;
    protected long shortestTime = -1L;
    protected long longestTime = 0L;

    public void addTiming(String string, long l) {
        this.getOperationTimings().put(string, new Long(l));
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public Class getDomainClass() {
        return this.domainClass;
    }

    public long getLocalTime() {
        return this.localTime;
    }

    public long getLongestTime() {
        return this.longestTime;
    }

    public long getNumberOfInstancesEffected() {
        return this.numberOfInstancesEffected;
    }

    public long getObjectsPerSecond() {
        if (this.getTotalTime() == 0L) {
            return 0L;
        }
        return this.getNumberOfInstancesEffected() * 1000L / this.getTotalTime();
    }

    public Hashtable getOperationTimings() {
        return this.operationTimings;
    }

    public long getProfileTime() {
        return this.profileTime;
    }

    public Class getQueryClass() {
        return this.queryClass;
    }

    public long getShortestTime() {
        return this.shortestTime;
    }

    public long getTimePerObject() {
        if (this.getNumberOfInstancesEffected() == 0L) {
            return 0L;
        }
        return this.getTotalTime() / this.getNumberOfInstancesEffected();
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public void setDomainClass(Class clazz) {
        this.domainClass = clazz;
    }

    public void setLocalTime(long l) {
        this.localTime = l;
    }

    public void setLongestTime(long l) {
        this.longestTime = l;
    }

    public void setNumberOfInstancesEffected(long l) {
        this.numberOfInstancesEffected = l;
    }

    public void setOperationTimings(Hashtable hashtable) {
        this.operationTimings = hashtable;
    }

    public void setProfileTime(long l) {
        this.profileTime = l;
    }

    public void setQueryClass(Class clazz) {
        this.queryClass = clazz;
    }

    public void setShortestTime(long l) {
        this.shortestTime = l;
    }

    public void setTotalTime(long l) {
        this.totalTime = l;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        this.write(stringWriter, new PerformanceProfiler());
        return stringWriter.toString();
    }

    public void write(Writer writer, PerformanceProfiler performanceProfiler) {
        String string = Helper.cr();
        try {
            writer.write(ToStringLocalization.buildMessage("profile", null) + "(");
            if (this.getQueryClass() != null) {
                writer.write(Helper.getShortClassName(this.getQueryClass()) + "," + string);
            } else {
                writer.write(string);
            }
            if (this.getDomainClass() != null) {
                performanceProfiler.writeNestingTabs(writer);
                writer.write("\t" + ToStringLocalization.buildMessage("class", null) + "=" + this.getDomainClass().getName() + "," + string);
            }
            if (this.getNumberOfInstancesEffected() != 0L) {
                performanceProfiler.writeNestingTabs(writer);
                writer.write("\t" + ToStringLocalization.buildMessage("number_of_objects", null) + "=" + this.getNumberOfInstancesEffected() + "," + string);
            }
            performanceProfiler.writeNestingTabs(writer);
            writer.write("\t" + ToStringLocalization.buildMessage("total_time", null) + "=" + this.getTotalTime() + "," + string);
            performanceProfiler.writeNestingTabs(writer);
            writer.write("\t" + ToStringLocalization.buildMessage("local_time", null) + "=" + this.getLocalTime() + "," + string);
            if (this.getProfileTime() != 0L) {
                performanceProfiler.writeNestingTabs(writer);
                writer.write("\t" + ToStringLocalization.buildMessage("profiling_time", null) + "=" + this.getProfileTime() + "," + string);
            }
            Enumeration enumeration = this.getOperationTimings().keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                long l = (Long)this.getOperationTimings().get(string2);
                if (l == 0L) continue;
                performanceProfiler.writeNestingTabs(writer);
                writer.write("\t" + string2 + "=" + l + "," + string);
            }
            if (this.getTimePerObject() != 0L) {
                performanceProfiler.writeNestingTabs(writer);
                writer.write("\t" + ToStringLocalization.buildMessage("time_object", null) + "=" + this.getTimePerObject() + "," + string);
            }
            if (this.getObjectsPerSecond() != 0L) {
                performanceProfiler.writeNestingTabs(writer);
                writer.write("\t" + ToStringLocalization.buildMessage("objects_second", null) + "=" + this.getObjectsPerSecond() + "," + string);
            }
            if (this.getShortestTime() != -1L) {
                performanceProfiler.writeNestingTabs(writer);
                writer.write("\t" + ToStringLocalization.buildMessage("shortestTime", null) + "=" + this.getShortestTime() + "," + string);
            }
            if (this.getLongestTime() != 0L) {
                performanceProfiler.writeNestingTabs(writer);
                writer.write("\t" + ToStringLocalization.buildMessage("longestTime", null) + "=" + this.getLongestTime() + "," + string);
            }
            performanceProfiler.writeNestingTabs(writer);
            writer.write(")");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

