/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.tools.ejbjar;

import java.io.File;
import java.io.FileNotFoundException;
import oracle.toplink.exceptions.EJBJarXMLException;
import oracle.toplink.tools.ejbjar.EjbJar;
import oracle.toplink.tools.ejbjar.XMLManager;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public class EjbJarXMLDocument {
    private Document document;
    private EjbJar ejbJar;
    private String xmlFileLocation;
    private long lastModifiedTime = -1L;

    public EjbJarXMLDocument() {
        this.ejbJar = new EjbJar();
    }

    public EjbJarXMLDocument(String string) throws FileNotFoundException, EJBJarXMLException {
        this(string, -2);
    }

    public EjbJarXMLDocument(String string, int n) throws FileNotFoundException, EJBJarXMLException {
        this.setXmlFileLocation(string);
        this.readAndLoad(n);
    }

    public EjbJar getEjbJar() {
        return this.ejbJar;
    }

    public boolean isSameXmlFile(String string) {
        if (this.xmlFileLocation != null && string != null) {
            return new File(this.xmlFileLocation).equals(new File(string));
        }
        return false;
    }

    public boolean isModified(String string) {
        if (string != null) {
            try {
                return this.isSameXmlFile(string) && this.lastModifiedTime != new File(string).lastModified();
            }
            catch (SecurityException securityException) {
                return true;
            }
        }
        return false;
    }

    public static void printAllNodes(Node node) {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        System.out.println("** length is  **" + n);
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (node2 instanceof DocumentType) {
                System.out.println(((DocumentType)node2).getName());
                System.out.println(((DocumentType)node2).getPublicId());
                System.out.println(((DocumentType)node2).getSystemId());
                System.out.println(((DocumentType)node2).getInternalSubset());
                System.out.println(((DocumentType)node2).getNodeValue());
                if (!node2.hasChildNodes()) continue;
                EjbJarXMLDocument.printAllNodes(node2);
                continue;
            }
            if (node2 instanceof Element) {
                EjbJarXMLDocument.printAllNodes(node2);
                continue;
            }
            if (node2 instanceof ProcessingInstruction) {
                ProcessingInstruction processingInstruction = (ProcessingInstruction)node2;
                System.out.println("** PI NODE STARTS **");
                System.out.println(processingInstruction.getData());
                System.out.println(processingInstruction.getNodeName());
                System.out.println(processingInstruction.getTarget());
                System.out.println("** PI NODE ENDS **");
                continue;
            }
            System.out.println("Don't know what to do...");
            EjbJarXMLDocument.printNodeType(node2);
        }
    }

    public static void printNodeType(Node node) {
        System.out.println(" Node " + node.getNodeName() + " ->");
        switch (node.getNodeType()) {
            case 2: {
                System.out.println("The node is an ATTRIBUTE_NODE ");
                break;
            }
            case 4: {
                System.out.println("The node is a CDATA_SECTION_NODE");
                break;
            }
            case 8: {
                System.out.println("The node is a COMMENT_NODE");
                break;
            }
            case 11: {
                System.out.println("The node is a DOCUMENT_FRAGMENT_NODE");
                break;
            }
            case 9: {
                System.out.println("The node is a DOCUMENT_NODE");
                break;
            }
            case 10: {
                System.out.println("The node is a DOCUMENT_TYPE_NODE");
                break;
            }
            case 1: {
                System.out.println("The node is an ELEMENT_NODE");
                break;
            }
            case 6: {
                System.out.println("The node is an ENTITY_NODE ");
                break;
            }
            case 5: {
                System.out.println("The node is an ENTITY_REFERENCE_NODE");
                break;
            }
            case 12: {
                System.out.println("The node is a Notation. ");
                break;
            }
            case 7: {
                System.out.println("The node is a PROCESSING_INSTRUCTION_NODE");
                break;
            }
            case 3: {
                System.out.println("The node is a TEXT_NODE");
            }
        }
    }

    public void readAndLoad() throws FileNotFoundException, EJBJarXMLException {
        this.readAndLoad(-2);
    }

    public void readAndLoad(int n) throws FileNotFoundException, EJBJarXMLException {
        this.document = XMLManager.readEjbXmlFile(this, this.xmlFileLocation, n);
        this.ejbJar = EjbJar.loadFromDocument(this.document);
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public void setXmlFileLocation(String string) {
        this.xmlFileLocation = string;
        try {
            this.lastModifiedTime = new File(string).lastModified();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

