/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.threetier;

import oracle.toplink.exceptions.ConcurrencyException;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.internal.databaseaccess.Accessor;
import oracle.toplink.sessions.Login;
import oracle.toplink.threetier.ConnectionPool;
import oracle.toplink.threetier.ServerSession;

public class ReadConnectionPool
extends ConnectionPool {
    public ReadConnectionPool() {
    }

    public ReadConnectionPool(String string, Login login, int n, int n2, ServerSession serverSession) {
        super(string, login, n, n2, serverSession);
    }

    public synchronized Accessor acquireConnection() throws ConcurrencyException {
        Accessor accessor = null;
        Object object = this.getConnectionsAvailable().elements();
        while (object.hasMoreElements()) {
            Accessor accessor2 = (Accessor)object.nextElement();
            if (accessor2.getCallCount() == 0) {
                accessor2.incrementCallCount(this.getOwner());
                return accessor2;
            }
            if (accessor != null && accessor.getCallCount() <= accessor2.getCallCount()) continue;
            accessor = accessor2;
        }
        if (this.getTotalNumberOfConnections() < this.getMaxNumberOfConnections()) {
            object = this.buildConnection();
            this.getConnectionsAvailable().addElement(object);
            object.incrementCallCount(this.getOwner());
            return object;
        }
        accessor.incrementCallCount(this.getOwner());
        return accessor;
    }

    public boolean hasConnectionAvailable() {
        return true;
    }

    public synchronized void releaseConnection(Accessor accessor) throws DatabaseException {
        accessor.decrementCallCount();
    }
}

