/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.sdk;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.internal.helper.DatabaseTable;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.DescriptorQueryManager;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.DeleteObjectQuery;
import oracle.toplink.queryframework.DoesExistQuery;
import oracle.toplink.queryframework.InsertObjectQuery;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.queryframework.ReadAllQuery;
import oracle.toplink.queryframework.ReadObjectQuery;
import oracle.toplink.queryframework.UpdateObjectQuery;
import oracle.toplink.sdk.InvalidSDKCall;
import oracle.toplink.sdk.SDKCall;
import oracle.toplink.sdk.SDKFieldValue;
import oracle.toplink.sdk.SDKQueryMechanism;
import oracle.toplink.sessions.DatabaseRecord;

public class SDKDescriptor
extends Descriptor {
    public SDKDescriptor() {
        this.initialize();
    }

    public void addReadAllCall(String string, SDKCall sDKCall) {
        this.addReadAllCall(string, sDKCall, new Vector());
    }

    public void addReadAllCall(String string, SDKCall sDKCall, String[] stringArray) {
        this.addReadAllCall(string, sDKCall, this.convertToVector(stringArray));
    }

    public void addReadAllCall(String string, SDKCall sDKCall, String string2) {
        Vector<String> vector = new Vector<String>(1);
        vector.addElement(string2);
        this.addReadAllCall(string, sDKCall, vector);
    }

    public void addReadAllCall(String string, SDKCall sDKCall, String string2, String string3) {
        Vector<String> vector = new Vector<String>(2);
        vector.addElement(string2);
        vector.addElement(string3);
        this.addReadAllCall(string, sDKCall, vector);
    }

    public void addReadAllCall(String string, SDKCall sDKCall, String string2, String string3, String string4) {
        Vector<String> vector = new Vector<String>(3);
        vector.addElement(string2);
        vector.addElement(string3);
        vector.addElement(string4);
        this.addReadAllCall(string, sDKCall, vector);
    }

    public void addReadAllCall(String string, SDKCall sDKCall, Vector vector) {
        this.addReadQuery(string, this.buildReadAllQuery(sDKCall), vector);
    }

    public void addReadObjectCall(String string, SDKCall sDKCall) {
        this.addReadObjectCall(string, sDKCall, new Vector(3));
    }

    public void addReadObjectCall(String string, SDKCall sDKCall, String[] stringArray) {
        this.addReadObjectCall(string, sDKCall, this.convertToVector(stringArray));
    }

    public void addReadObjectCall(String string, SDKCall sDKCall, String string2) {
        Vector<String> vector = new Vector<String>(1);
        vector.addElement(string2);
        this.addReadObjectCall(string, sDKCall, vector);
    }

    public void addReadObjectCall(String string, SDKCall sDKCall, String string2, String string3) {
        Vector<String> vector = new Vector<String>(2);
        vector.addElement(string2);
        vector.addElement(string3);
        this.addReadObjectCall(string, sDKCall, vector);
    }

    public void addReadObjectCall(String string, SDKCall sDKCall, String string2, String string3, String string4) {
        Vector<String> vector = new Vector<String>(3);
        vector.addElement(string2);
        vector.addElement(string3);
        vector.addElement(string4);
        this.addReadObjectCall(string, sDKCall, vector);
    }

    public void addReadObjectCall(String string, SDKCall sDKCall, Vector vector) {
        this.addReadQuery(string, this.buildReadObjectQuery(sDKCall), vector);
    }

    protected void addReadQuery(String string, ObjectLevelReadQuery objectLevelReadQuery, Vector vector) {
        objectLevelReadQuery.setReferenceClass(this.getJavaClass());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            objectLevelReadQuery.addArgument((String)enumeration.nextElement());
        }
        this.getQueryManager().addQuery(string, objectLevelReadQuery);
    }

    public void addReadTranslation(String string, String string2) {
        Enumeration enumeration = this.getCustomQueries().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseQuery databaseQuery = (DatabaseQuery)enumeration.nextElement();
            ((SDKQueryMechanism)databaseQuery.getQueryMechanism()).addReadTranslation(string, string2);
        }
    }

    public void addReadTranslations(String[] stringArray, String[] stringArray2) {
        Enumeration enumeration = this.getCustomQueries().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseQuery databaseQuery = (DatabaseQuery)enumeration.nextElement();
            ((SDKQueryMechanism)databaseQuery.getQueryMechanism()).addReadTranslations(stringArray, stringArray2);
        }
    }

    public void addReadTranslations(Vector vector) {
        Enumeration enumeration = this.getCustomQueries().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseQuery databaseQuery = (DatabaseQuery)enumeration.nextElement();
            ((SDKQueryMechanism)databaseQuery.getQueryMechanism()).addReadTranslations(vector);
        }
    }

    public void addWriteTranslation(String string, String string2) {
        Enumeration enumeration = this.getCustomQueries().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseQuery databaseQuery = (DatabaseQuery)enumeration.nextElement();
            ((SDKQueryMechanism)databaseQuery.getQueryMechanism()).addWriteTranslation(string, string2);
        }
    }

    public void addWriteTranslations(String[] stringArray, String[] stringArray2) {
        Enumeration enumeration = this.getCustomQueries().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseQuery databaseQuery = (DatabaseQuery)enumeration.nextElement();
            ((SDKQueryMechanism)databaseQuery.getQueryMechanism()).addWriteTranslations(stringArray, stringArray2);
        }
    }

    public void addWriteTranslations(Vector vector) {
        Enumeration enumeration = this.getCustomQueries().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseQuery databaseQuery = (DatabaseQuery)enumeration.nextElement();
            ((SDKQueryMechanism)databaseQuery.getQueryMechanism()).addWriteTranslations(vector);
        }
    }

    public Vector buildDirectValuesFromFieldValue(Object object) throws DatabaseException {
        return ((SDKFieldValue)object).getElements();
    }

    public Object buildFieldValueFromDirectValues(Vector vector, String string, Session session) throws DatabaseException {
        return SDKFieldValue.forDirectValues(vector, string);
    }

    public Object buildFieldValueFromForeignKeys(Vector vector, String string, Session session) throws DatabaseException {
        return SDKFieldValue.forDatabaseRows(vector, string);
    }

    public Object buildFieldValueFromNestedRow(DatabaseRow databaseRow, Session session) throws DatabaseException {
        Vector<DatabaseRow> vector = new Vector<DatabaseRow>(1);
        vector.addElement(databaseRow);
        return this.buildFieldValueFromNestedRows(vector, "", session);
    }

    public Object buildFieldValueFromNestedRows(Vector vector, String string, Session session) throws DatabaseException {
        return SDKFieldValue.forDatabaseRows(vector, this.getTableName());
    }

    public DatabaseRow buildNestedRowFromFieldValue(Object object) throws DatabaseException {
        if (!(object instanceof SDKFieldValue)) {
            return new DatabaseRecord(1);
        }
        Vector vector = ((SDKFieldValue)object).getElements();
        if (vector.isEmpty()) {
            return new DatabaseRecord(1);
        }
        if (!(vector.firstElement() instanceof DatabaseRow)) {
            return new DatabaseRecord(1);
        }
        return (DatabaseRow)vector.firstElement();
    }

    public Vector buildNestedRowsFromFieldValue(Object object, Session session) throws DatabaseException {
        if (!(object instanceof SDKFieldValue)) {
            return new Vector();
        }
        return ((SDKFieldValue)object).getElements();
    }

    protected ReadAllQuery buildReadAllQuery(SDKCall sDKCall) {
        ReadAllQuery readAllQuery = new ReadAllQuery();
        readAllQuery.setCall(sDKCall);
        return readAllQuery;
    }

    protected ReadObjectQuery buildReadObjectQuery(SDKCall sDKCall) {
        ReadObjectQuery readObjectQuery = new ReadObjectQuery();
        readObjectQuery.setCall(sDKCall);
        return readObjectQuery;
    }

    protected Vector convertToVector(Object[] objectArray) {
        return Helper.vectorFromArray(objectArray);
    }

    protected DatabaseTable extractDefaultTable() {
        if (this.isAggregateDescriptor()) {
            return new DatabaseTable();
        }
        return super.extractDefaultTable();
    }

    protected Vector getCustomQueries() {
        DescriptorQueryManager descriptorQueryManager = this.getQueryManager();
        Vector<DatabaseQuery> vector = new Vector<DatabaseQuery>();
        vector.addElement(descriptorQueryManager.getReadObjectQuery());
        vector.addElement(descriptorQueryManager.getReadAllQuery());
        vector.addElement(descriptorQueryManager.getInsertQuery());
        vector.addElement(descriptorQueryManager.getUpdateQuery());
        vector.addElement(descriptorQueryManager.getDeleteQuery());
        vector.addElement(descriptorQueryManager.getDoesExistQuery());
        Iterator iterator = descriptorQueryManager.getQueries().values().iterator();
        while (iterator.hasNext()) {
            vector.addElement((DatabaseQuery)iterator.next());
        }
        return vector;
    }

    public String getDataTypeName() throws DescriptorException {
        return this.getTableName();
    }

    protected void initialize() {
        this.initializeQueryManager();
    }

    protected void validateMappingType(DatabaseMapping databaseMapping) {
    }

    public void initializeAggregateInheritancePolicy(Session session) {
    }

    protected void initializeQueryManager() {
        if (this.getQueryManager().getReadObjectCall() == null) {
            this.getQueryManager().setReadObjectCall(InvalidSDKCall.getInstance());
        }
        if (this.getQueryManager().getReadAllCall() == null) {
            this.getQueryManager().setReadAllCall(InvalidSDKCall.getInstance());
        }
        if (this.getQueryManager().getInsertCall() == null) {
            this.getQueryManager().setInsertCall(InvalidSDKCall.getInstance());
        }
        if (this.getQueryManager().getDeleteCall() == null) {
            this.getQueryManager().setDeleteCall(InvalidSDKCall.getInstance());
        }
        if (this.getQueryManager().getUpdateCall() == null) {
            this.getQueryManager().setUpdateCall(InvalidSDKCall.getInstance());
        }
        if (this.getQueryManager().getDoesExistCall() == null) {
            this.getQueryManager().setDoesExistCall(InvalidSDKCall.getInstance());
        }
    }

    public boolean requiresInitialization() {
        return !this.isDescriptorForInterface();
    }

    public void setDataTypeName(String string) throws DescriptorException {
        this.setTableName(string);
    }

    public void setDeleteCall(SDKCall sDKCall) {
        DeleteObjectQuery deleteObjectQuery = new DeleteObjectQuery();
        deleteObjectQuery.setCall(sDKCall);
        this.getQueryManager().setDeleteQuery(deleteObjectQuery);
    }

    public void setDoesExistCall(SDKCall sDKCall) {
        DoesExistQuery doesExistQuery = new DoesExistQuery();
        doesExistQuery.setCall(sDKCall);
        this.getQueryManager().setDoesExistQuery(doesExistQuery);
    }

    public void setInsertCall(SDKCall sDKCall) {
        InsertObjectQuery insertObjectQuery = new InsertObjectQuery();
        insertObjectQuery.setCall(sDKCall);
        this.getQueryManager().setInsertQuery(insertObjectQuery);
    }

    public void setQueryManager(DescriptorQueryManager descriptorQueryManager) {
        super.setQueryManager(descriptorQueryManager);
        this.initializeQueryManager();
    }

    public void setReadAllCall(SDKCall sDKCall) {
        ReadAllQuery readAllQuery = new ReadAllQuery();
        readAllQuery.setCall(sDKCall);
        this.getQueryManager().setReadAllQuery(readAllQuery);
    }

    public void setReadObjectCall(SDKCall sDKCall) {
        ReadObjectQuery readObjectQuery = new ReadObjectQuery();
        readObjectQuery.setCall(sDKCall);
        this.getQueryManager().setReadObjectQuery(readObjectQuery);
    }

    public void setUpdateCall(SDKCall sDKCall) {
        UpdateObjectQuery updateObjectQuery = new UpdateObjectQuery();
        updateObjectQuery.setCall(sDKCall);
        this.getQueryManager().setUpdateQuery(updateObjectQuery);
    }
}

