/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.sdk;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.internal.databaseaccess.Accessor;
import oracle.toplink.internal.databaseaccess.DatasourceCall;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.queryframework.DatabaseQueryMechanism;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.sdk.DefaultFieldTranslator;
import oracle.toplink.sdk.FieldTranslator;
import oracle.toplink.sdk.SDKCall;
import oracle.toplink.sdk.SDKFieldValue;
import oracle.toplink.sdk.SDKQueryMechanism;
import oracle.toplink.sdk.SimpleFieldTranslator;
import oracle.toplink.sessions.DatabaseRecord;

public abstract class AbstractSDKCall
extends DatasourceCall
implements SDKCall {
    private FieldTranslator fieldTranslator;

    protected AbstractSDKCall() {
        this.initialize();
    }

    public void addReadTranslation(String string, String string2) {
        SimpleFieldTranslator simpleFieldTranslator = this.buildSimpleFieldTranslator();
        simpleFieldTranslator.addReadTranslation(string, string2);
        this.setFieldTranslator(simpleFieldTranslator);
    }

    public void addReadTranslations(String[] stringArray, String[] stringArray2) {
        SimpleFieldTranslator simpleFieldTranslator = this.buildSimpleFieldTranslator();
        simpleFieldTranslator.addReadTranslations(stringArray, stringArray2);
        this.setFieldTranslator(simpleFieldTranslator);
    }

    public void addReadTranslations(Vector vector) {
        SimpleFieldTranslator simpleFieldTranslator = this.buildSimpleFieldTranslator();
        simpleFieldTranslator.addReadTranslations(vector);
        this.setFieldTranslator(simpleFieldTranslator);
    }

    public void addWriteTranslation(String string, String string2) {
        SimpleFieldTranslator simpleFieldTranslator = this.buildSimpleFieldTranslator();
        simpleFieldTranslator.addWriteTranslation(string, string2);
        this.setFieldTranslator(simpleFieldTranslator);
    }

    public void addWriteTranslations(String[] stringArray, String[] stringArray2) {
        SimpleFieldTranslator simpleFieldTranslator = this.buildSimpleFieldTranslator();
        simpleFieldTranslator.addWriteTranslations(stringArray, stringArray2);
        this.setFieldTranslator(simpleFieldTranslator);
    }

    public void addWriteTranslations(Vector vector) {
        SimpleFieldTranslator simpleFieldTranslator = this.buildSimpleFieldTranslator();
        simpleFieldTranslator.addWriteTranslations(vector);
        this.setFieldTranslator(simpleFieldTranslator);
    }

    public FieldTranslator buildDefaultTranslator() {
        return new DefaultFieldTranslator();
    }

    public DatabaseQueryMechanism buildNewQueryMechanism(DatabaseQuery databaseQuery) {
        return new SDKQueryMechanism(databaseQuery, this);
    }

    public DatabaseQueryMechanism buildQueryMechanism(DatabaseQuery databaseQuery, DatabaseQueryMechanism databaseQueryMechanism) {
        if (databaseQueryMechanism instanceof SDKQueryMechanism) {
            ((SDKQueryMechanism)databaseQueryMechanism).addCall(this);
            return databaseQueryMechanism;
        }
        return this.buildNewQueryMechanism(databaseQuery);
    }

    protected SimpleFieldTranslator buildSimpleFieldTranslator() {
        FieldTranslator fieldTranslator = this.getFieldTranslator();
        if (fieldTranslator instanceof SimpleFieldTranslator) {
            return (SimpleFieldTranslator)fieldTranslator;
        }
        return new SimpleFieldTranslator(fieldTranslator);
    }

    protected DatabaseRow extractPrimaryKeyFrom(DatabaseRow databaseRow) {
        Vector vector = this.getOrderedPrimaryKeyFields();
        DatabaseRecord databaseRecord = new DatabaseRecord(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            databaseRecord.put(e, databaseRow.get(e));
        }
        return databaseRecord;
    }

    public FieldTranslator getFieldTranslator() {
        return this.fieldTranslator;
    }

    public String getLogString(Accessor accessor) {
        StringWriter stringWriter = new StringWriter(1000);
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.writeLogDescription(printWriter);
        printWriter.write(": ");
        printWriter.write(this.getLogTableName());
        this.writeLogData(printWriter);
        return stringWriter.toString();
    }

    protected void writeLogDescription(PrintWriter printWriter) {
        printWriter.write("SDK Call");
    }

    protected String getLogTableName() {
        return this.getTableName();
    }

    protected void writeLogData(PrintWriter printWriter) {
        printWriter.write(Helper.cr());
        printWriter.write("\t");
        this.write(this.getLogRow(), printWriter, 0);
    }

    protected DatabaseRow getLogRow() {
        return this.getTranslationRow();
    }

    protected void write(DatabaseRow databaseRow, PrintWriter printWriter, int n) {
        Object object;
        DatabaseField databaseField;
        boolean bl = true;
        Enumeration enumeration = databaseRow.keys();
        while (enumeration.hasMoreElements()) {
            databaseField = (DatabaseField)enumeration.nextElement();
            object = databaseRow.get(databaseField);
            if (object instanceof SDKFieldValue) continue;
            if (!bl) {
                bl = false;
                printWriter.write("; ");
            } else {
                bl = false;
            }
            printWriter.write(databaseField.getName());
            printWriter.write("=>");
            printWriter.print(object);
        }
        enumeration = databaseRow.keys();
        while (enumeration.hasMoreElements()) {
            databaseField = (DatabaseField)enumeration.nextElement();
            object = databaseRow.get(databaseField);
            if (!(object instanceof SDKFieldValue)) continue;
            if (!bl) {
                printWriter.write("; ");
            } else {
                bl = false;
            }
            printWriter.write(Helper.cr());
            for (int i = 0; i <= n; ++i) {
                printWriter.write("\t");
            }
            printWriter.write(databaseField.getName());
            printWriter.write("=>");
            printWriter.write("[");
            this.writeSDKFieldValue((SDKFieldValue)object, printWriter, n);
            printWriter.write("]");
        }
    }

    protected void writeSDKFieldValue(SDKFieldValue sDKFieldValue, PrintWriter printWriter, int n) {
        int n2 = n;
        if (sDKFieldValue.getElements().size() > 1) {
            ++n2;
        }
        Enumeration enumeration = sDKFieldValue.getElements().elements();
        while (enumeration.hasMoreElements()) {
            if (sDKFieldValue.isDirectCollection()) {
                printWriter.print(enumeration.nextElement());
                if (!enumeration.hasMoreElements()) continue;
                printWriter.write(", ");
                continue;
            }
            printWriter.write("(");
            if (sDKFieldValue.getElements().size() > 1) {
                printWriter.write(Helper.cr());
                for (int i = 0; i <= n2; ++i) {
                    printWriter.write("\t");
                }
            }
            this.write((DatabaseRow)enumeration.nextElement(), printWriter, n2 + 1);
            printWriter.write(")");
            if (!enumeration.hasMoreElements()) continue;
            printWriter.write(" ");
        }
    }

    protected Accessor getAccessor() {
        return this.getQuery().getAccessor();
    }

    protected Vector getOrderedPrimaryKeyFields() {
        return new Vector(this.getQuery().getDescriptor().getPrimaryKeyFields());
    }

    protected Session getSession() {
        return this.getQuery().getSession();
    }

    protected String getTableName() {
        return this.getQuery().getDescriptor().getTableName();
    }

    protected DatabaseRow getTranslationRow() {
        return this.getQuery().getTranslationRow();
    }

    protected void initialize() {
        this.fieldTranslator = this.buildDefaultTranslator();
    }

    public boolean isFinished() {
        return true;
    }

    public void setFieldTranslator(FieldTranslator fieldTranslator) {
        this.fieldTranslator = fieldTranslator;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.write(Helper.getShortClassName(this));
        printWriter.write("(");
        this.toString(printWriter);
        printWriter.write(")");
        return stringWriter.toString();
    }

    protected void toString(PrintWriter printWriter) {
        printWriter.print(this.getQuery());
    }
}

