/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.remotecommand;

import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.Vector;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.localization.ExceptionLocalization;
import oracle.toplink.internal.remotecommand.CommandProject;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.platform.xml.XMLParser;
import oracle.toplink.platform.xml.XMLPlatform;
import oracle.toplink.platform.xml.XMLPlatformFactory;
import oracle.toplink.platform.xml.XMLTransformer;
import oracle.toplink.remotecommand.Command;
import oracle.toplink.remotecommand.CommandConverter;
import oracle.toplink.remotecommand.MergeChangeSetCommand;
import oracle.toplink.transform.ObjectTransformer;
import oracle.toplink.transform.xml.XMLResult;
import oracle.toplink.transform.xml.XMLSource;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLCommandConverter
implements CommandConverter {
    protected static final String SCHEMA = "command_904.xsd";
    protected static final String USER_CMD_STYLE_SHEET = "user_command_904.xsl";
    protected static final String TL_CMD_STYLE_SHEET = "toplink_command_904.xsl";
    ObjectTransformer transformer;
    protected URL schemaDoc;
    protected URL userCmdStyleSheetDoc;
    protected URL tlCmdStyleSheetDoc;
    protected XMLParser nonValidatingParser;
    protected XMLParser validatingParser;
    static /* synthetic */ Class class$oracle$toplink$remotecommand$MergeChangeSetCommand;

    public XMLCommandConverter() {
        this.initialize();
    }

    protected void initialize() {
        this.transformer = new ObjectTransformer(new CommandProject());
        this.schemaDoc = PrivilegedAccessController.getClassLoaderForClass(this.getClass()).getResource(SCHEMA);
        this.userCmdStyleSheetDoc = PrivilegedAccessController.getClassLoaderForClass(this.getClass()).getResource(USER_CMD_STYLE_SHEET);
        this.tlCmdStyleSheetDoc = PrivilegedAccessController.getClassLoaderForClass(this.getClass()).getResource(TL_CMD_STYLE_SHEET);
        if (this.schemaDoc == null || this.userCmdStyleSheetDoc == null || this.tlCmdStyleSheetDoc == null) {
            Object[] objectArray = new Object[]{"command_904.xsd, user_command_904.xsl, toplink_command_904.xsl"};
            throw new RuntimeException(ExceptionLocalization.buildMessage("error_loading_resources", objectArray));
        }
    }

    public Command convertToTopLinkCommand(Object object) {
        Object object2;
        Document document;
        block11: {
            document = null;
            Reader reader = null;
            if (object instanceof Document) {
                document = (Document)object;
            } else if (object instanceof String) {
                reader = new StringReader((String)object);
            } else if (object instanceof Reader) {
                reader = (Reader)object;
            } else {
                Object[] objectArray = new Object[]{object};
                throw new RuntimeException(ExceptionLocalization.buildMessage("unexpect_argument", objectArray));
            }
            try {
                if (document == null) {
                    object2 = this.getValidatingDomParser();
                    document = object2.parse(reader);
                } else {
                    object2 = XMLPlatformFactory.getInstance().getXMLPlatform();
                    object2.validateDocument(document, this.schemaDoc, null);
                }
            }
            catch (Error error) {
                if (document != null) break block11;
                document = this.getNonValidatingDomParser().parse(reader);
            }
        }
        object2 = this.transform(document, this.tlCmdStyleSheetDoc);
        XMLSource xMLSource = new XMLSource();
        xMLSource.setSourceDocument((Document)object2);
        Vector vector = this.transformer.buildObjects(class$oracle$toplink$remotecommand$MergeChangeSetCommand == null ? (class$oracle$toplink$remotecommand$MergeChangeSetCommand = XMLCommandConverter.class$("oracle.toplink.remotecommand.MergeChangeSetCommand")) : class$oracle$toplink$remotecommand$MergeChangeSetCommand, xMLSource);
        if (vector.isEmpty()) {
            return null;
        }
        return (Command)vector.firstElement();
    }

    public Object convertToUserCommand(Command command) {
        if (command instanceof MergeChangeSetCommand) {
            Vector<Command> vector = new Vector<Command>();
            vector.add(command);
            XMLResult xMLResult = new XMLResult();
            this.transformer.storeObjects(vector, xMLResult);
            Document document = xMLResult.getResultDocument();
            return this.transform(document, this.userCmdStyleSheetDoc);
        }
        Object[] objectArray = new Object[]{command};
        throw new RuntimeException(ExceptionLocalization.buildMessage("unexpect_argument", objectArray));
    }

    protected Document transform(Document document, URL uRL) {
        try {
            XMLPlatform xMLPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
            XMLTransformer xMLTransformer = xMLPlatform.newXMLTransformer();
            Document document2 = xMLPlatform.createDocument();
            xMLTransformer.transform(document, document2, uRL);
            return document2;
        }
        catch (Exception exception) {
            throw new RuntimeException(ExceptionLocalization.buildMessage("parsing_error") + "\n" + Helper.printStackTraceToString(exception));
        }
    }

    protected XMLParser getNonValidatingDomParser() {
        if (this.nonValidatingParser == null) {
            XMLPlatform xMLPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
            this.nonValidatingParser = xMLPlatform.newXMLParser();
            this.nonValidatingParser.setNamespaceAware(false);
            this.nonValidatingParser.setWhitespacePreserving(true);
            this.nonValidatingParser.setErrorHandler(new TopLinkXMLErrorHanlder());
        }
        return this.nonValidatingParser;
    }

    protected XMLParser getValidatingDomParser() {
        if (this.validatingParser == null) {
            XMLPlatform xMLPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
            XMLParser xMLParser = xMLPlatform.newXMLParser();
            xMLParser.setNamespaceAware(false);
            xMLParser.setValidationMode(3);
            xMLParser.setWhitespacePreserving(true);
            xMLParser.setErrorHandler(new TopLinkXMLErrorHanlder());
            try {
                xMLParser.setXMLSchema(this.schemaDoc);
            }
            catch (Exception exception) {
                throw new RuntimeException(ExceptionLocalization.buildMessage("parsing_error") + "\n" + Helper.printStackTraceToString(exception));
            }
        }
        return this.validatingParser;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class TopLinkXMLErrorHanlder
    implements ErrorHandler {
        TopLinkXMLErrorHanlder() {
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            System.out.println(ExceptionLocalization.buildMessage("parsing_warning") + "\n" + Helper.printStackTraceToString(sAXParseException));
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            throw new SAXException(ExceptionLocalization.buildMessage("parsing_error"), sAXParseException);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw new SAXException(ExceptionLocalization.buildMessage("parsing_fatal_error"), sAXParseException);
        }
    }
}

