/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.remote.rmi;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import oracle.toplink.exceptions.SynchronizationException;
import oracle.toplink.internal.remote.RemoteConnection;
import oracle.toplink.remote.AbstractClusteringService;
import oracle.toplink.remote.rmi.RMIConnection;
import oracle.toplink.remote.rmi.RMIRemoteSessionController;
import oracle.toplink.remote.rmi.RMIRemoteSessionControllerDispatcher;
import oracle.toplink.sessions.Session;

public class RMIClusteringService
extends AbstractClusteringService {
    private static Class DEFAULT_DISPATCHER_CLASS = class$oracle$toplink$remote$rmi$RMIRemoteSessionControllerDispatcher == null ? (class$oracle$toplink$remote$rmi$RMIRemoteSessionControllerDispatcher = RMIClusteringService.class$("oracle.toplink.remote.rmi.RMIRemoteSessionControllerDispatcher")) : class$oracle$toplink$remote$rmi$RMIRemoteSessionControllerDispatcher;
    private static Class DEFAULT_CONNECTION_CLASS = class$oracle$toplink$remote$rmi$RMIConnection == null ? (class$oracle$toplink$remote$rmi$RMIConnection = RMIClusteringService.class$("oracle.toplink.remote.rmi.RMIConnection")) : class$oracle$toplink$remote$rmi$RMIConnection;
    static /* synthetic */ Class class$oracle$toplink$remote$rmi$RMIRemoteSessionControllerDispatcher;
    static /* synthetic */ Class class$oracle$toplink$remote$rmi$RMIConnection;

    public RMIClusteringService(String string, int n, Session session) {
        super(string, n, session);
    }

    public RMIClusteringService(Session session) {
        super(session);
    }

    public void registerDispatcher() {
        try {
            this.getRegistry(this.getLocalHostURL()).rebind(this.getSessionId(), (RMIRemoteSessionControllerDispatcher)this.getDispatcher());
        }
        catch (Exception exception) {
            this.getSession().handleException(SynchronizationException.errorBindingController(this.getSessionId(), exception));
        }
    }

    public void deregisterDispatcher() {
        try {
            this.getRegistry(this.getLocalHostURL()).unbind(this.getSessionId());
            RMIRemoteSessionControllerDispatcher rMIRemoteSessionControllerDispatcher = (RMIRemoteSessionControllerDispatcher)this.getDispatcher();
            if (rMIRemoteSessionControllerDispatcher != null) {
                RMIRemoteSessionControllerDispatcher.unexportObject(rMIRemoteSessionControllerDispatcher, true);
            }
        }
        catch (Exception exception) {
            this.getSession().handleException(SynchronizationException.errorBindingController(this.getSessionId(), exception));
        }
    }

    public RemoteConnection createRemoteConnection(String string, String string2) {
        try {
            RMIConnection rMIConnection = new RMIConnection((RMIRemoteSessionController)this.getRegistry(string2).lookup(string));
            rMIConnection.setServiceName(string);
            return rMIConnection;
        }
        catch (Exception exception) {
            this.getSession().handleException(SynchronizationException.errorLookingUpController(string, exception));
            return null;
        }
    }

    public MulticastSocket getCommunicationSocket() {
        if (this.communicationSocket == null) {
            try {
                this.communicationSocket = new MulticastSocket(this.getMulticastPort());
                this.communicationSocket.setTimeToLive(this.getTimeToLive());
                this.communicationSocket.joinGroup(InetAddress.getByName(this.getMulticastGroupAddress()));
            }
            catch (IOException iOException) {
                SynchronizationException synchronizationException = SynchronizationException.errorJoiningMulticastGroup(iOException);
                this.getSession().handleException(synchronizationException);
            }
        }
        return this.communicationSocket;
    }

    public Object getDispatcher() throws RemoteException {
        if (this.dispatcher == null) {
            this.dispatcher = new RMIRemoteSessionControllerDispatcher(this.getSession());
        }
        return this.dispatcher;
    }

    public RemoteConnection getLocalRemoteConnection() {
        try {
            RMIConnection rMIConnection = new RMIConnection((RMIRemoteSessionControllerDispatcher)this.getDispatcher());
            rMIConnection.setServiceName(this.getSessionId());
            return rMIConnection;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected Registry getRegistry(String string) throws RemoteException {
        int n = string.indexOf(":");
        String string2 = string.substring(0, n);
        int n2 = Integer.decode(string.substring(n + 1, string.length()));
        return LocateRegistry.getRegistry(string2, n2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

