/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.remote.jms;

import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import oracle.toplink.exceptions.JMSProcessingException;
import oracle.toplink.internal.remote.RemoteCommand;
import oracle.toplink.publicinterface.Session;

public class TopLinkMessageListener
implements MessageListener {
    protected Session session;

    public TopLinkMessageListener(oracle.toplink.sessions.Session session) {
        this.session = (Session)session;
    }

    public Session getSession() {
        return this.session;
    }

    public void onMessage(Message message) {
        ObjectMessage objectMessage = null;
        try {
            String string = ((Topic)message.getJMSDestination()).getTopicName();
            this.getSession().log(1, "propagation", "retreived_remote_message_from_JMS_topic", string);
            if (message instanceof ObjectMessage) {
                objectMessage = (ObjectMessage)message;
                Serializable serializable = objectMessage.getObject();
                if (serializable instanceof RemoteCommand) {
                    this.getSession().log(1, "propagation", "processing_topLink_remote_command");
                    ((RemoteCommand)serializable).execute(this.getSession(), null);
                } else if (serializable == null) {
                    this.getSession().log(6, "propagation", "retreived_null_message", string);
                } else {
                    this.getSession().log(6, "propagation", "retreived_unknown_message_type", serializable.getClass(), string);
                }
            } else {
                this.getSession().log(6, "propagation", "received_unexpected_message_type", message.getClass().getName(), string);
            }
        }
        catch (JMSException jMSException) {
            this.getSession().log(2, "propagation", "JMS_exception_thrown");
            this.getSession().handleException(JMSProcessingException.buildDefault(jMSException));
        }
        catch (Throwable throwable) {
            this.getSession().handleException(JMSProcessingException.buildDefault(throwable));
        }
    }
}

