/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.remote.jms;

import javax.jms.JMSException;
import javax.naming.NamingException;
import oracle.toplink.exceptions.SynchronizationException;
import oracle.toplink.internal.remote.RemoteConnection;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.remote.AbstractClusteringService;
import oracle.toplink.remote.DistributedSessionReconnectPolicy;
import oracle.toplink.remote.jms.JMSClusteringService;

public class JMSDistributedSessionReconnectPolicy
extends DistributedSessionReconnectPolicy {
    protected AbstractClusteringService clusteringService;

    public JMSDistributedSessionReconnectPolicy(AbstractClusteringService abstractClusteringService) {
        this.clusteringService = abstractClusteringService;
    }

    public RemoteConnection reconnect(RemoteConnection remoteConnection) {
        ((Session)this.clusteringService.getSession()).log(1, "propagation", "attempting_to_reconnect_to_JMS_service");
        try {
            return ((JMSClusteringService)this.clusteringService).createRemoteConnection();
        }
        catch (NamingException namingException) {
            throw SynchronizationException.errorLookingUpJMSService(remoteConnection.getServiceName(), namingException);
        }
        catch (JMSException jMSException) {
            throw SynchronizationException.errorLookingUpJMSService(remoteConnection.getServiceName(), (Exception)((Object)jMSException));
        }
    }
}

