/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.remote.corba.sun;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import oracle.toplink.exceptions.SynchronizationException;
import oracle.toplink.internal.remote.ConnectToJNDISessionCommand;
import oracle.toplink.internal.remote.RemoteConnection;
import oracle.toplink.remote.AbstractJNDIClusteringService;
import oracle.toplink.remote.corba.sun.CORBAConnection;
import oracle.toplink.remote.corba.sun.CORBARemoteSessionController;
import oracle.toplink.remote.corba.sun.CORBARemoteSessionControllerDispatcher;
import oracle.toplink.sessions.Session;

public class CORBAJNDIClusteringService
extends AbstractJNDIClusteringService {
    private static Class DEFAULT_DISPATCHER_CLASS = class$oracle$toplink$remote$corba$sun$CORBARemoteSessionControllerDispatcher == null ? (class$oracle$toplink$remote$corba$sun$CORBARemoteSessionControllerDispatcher = CORBAJNDIClusteringService.class$("oracle.toplink.remote.corba.sun.CORBARemoteSessionControllerDispatcher")) : class$oracle$toplink$remote$corba$sun$CORBARemoteSessionControllerDispatcher;
    private static Class DEFAULT_CONNECTION_CLASS = class$oracle$toplink$remote$corba$sun$CORBAConnection == null ? (class$oracle$toplink$remote$corba$sun$CORBAConnection = CORBAJNDIClusteringService.class$("oracle.toplink.remote.corba.sun.CORBAConnection")) : class$oracle$toplink$remote$corba$sun$CORBAConnection;
    static /* synthetic */ Class class$oracle$toplink$remote$corba$sun$CORBARemoteSessionControllerDispatcher;
    static /* synthetic */ Class class$oracle$toplink$remote$corba$sun$CORBAConnection;

    public CORBAJNDIClusteringService(String string, int n, Session session) {
        super(string, n, session);
    }

    public CORBAJNDIClusteringService(Session session) {
        super(session);
    }

    public void registerDispatcher() {
        try {
            this.getLocalContext().rebind(this.getSessionId(), this.getDispatcher());
        }
        catch (Exception exception) {
            this.getSession().handleException(SynchronizationException.errorBindingController(this.getSessionId(), exception));
        }
    }

    public void deregisterDispatcher() {
        try {
            this.getLocalContext().unbind(this.getSessionId());
        }
        catch (Exception exception) {
            this.getSession().handleException(SynchronizationException.errorBindingController(this.getSessionId(), exception));
        }
    }

    public void connectBackToRemote(RemoteConnection remoteConnection) throws Exception {
        ConnectToJNDISessionCommand connectToJNDISessionCommand = new ConnectToJNDISessionCommand();
        connectToJNDISessionCommand.setSessionId(this.getSessionId());
        connectToJNDISessionCommand.setJndiURL((String)this.getInitialContextProperties().get("java.naming.provider.url"));
        remoteConnection.processCommand(connectToJNDISessionCommand);
    }

    public RemoteConnection createRemoteConnection(String string, String string2) {
        try {
            Hashtable hashtable = (Hashtable)this.getInitialContextProperties().clone();
            hashtable.put("java.naming.provider.url", string2);
            return new CORBAConnection((CORBARemoteSessionController)this.getContext(hashtable).lookup(string));
        }
        catch (NamingException namingException) {
            this.getSession().handleException(SynchronizationException.errorLookingUpController(string, namingException));
            return null;
        }
    }

    public MulticastSocket getCommunicationSocket() {
        if (this.communicationSocket == null) {
            try {
                this.communicationSocket = new MulticastSocket(this.getMulticastPort());
                this.communicationSocket.setTimeToLive(this.getTimeToLive());
                this.communicationSocket.joinGroup(InetAddress.getByName(this.getMulticastGroupAddress()));
            }
            catch (IOException iOException) {
                SynchronizationException synchronizationException = SynchronizationException.errorJoiningMulticastGroup(iOException);
                this.getSession().handleException(synchronizationException);
            }
        }
        return this.communicationSocket;
    }

    public Context getContext(String string) {
        try {
            Hashtable<String, String> hashtable = new Hashtable<String, String>(2);
            hashtable.put("java.naming.provider.url", string);
            if (this.getUserName() != null) {
                hashtable.put("java.naming.security.principal", this.getUserName());
            }
            if (this.getPassword() != null) {
                hashtable.put("java.naming.security.credentials", this.getPassword());
            }
            return new InitialContext(hashtable);
        }
        catch (NamingException namingException) {
            this.getSession().handleException(SynchronizationException.errorLookingUpController(string, namingException));
            return null;
        }
    }

    public Object getDispatcher() throws RemoteException {
        if (this.dispatcher == null) {
            this.dispatcher = new CORBARemoteSessionControllerDispatcher(this.getSession());
        }
        return this.dispatcher;
    }

    public RemoteConnection getLocalRemoteConnection() {
        try {
            CORBAConnection cORBAConnection = new CORBAConnection((CORBARemoteSessionControllerDispatcher)this.getDispatcher());
            cORBAConnection.setServiceName(this.getSessionId());
            return cORBAConnection;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

