/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.queryframework;

import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.OptimisticLockException;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.DescriptorQueryManager;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.Call;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.WriteObjectQuery;

public class UpdateObjectQuery
extends WriteObjectQuery {
    public UpdateObjectQuery() {
    }

    public UpdateObjectQuery(Object object) {
        this();
        this.setObject(object);
    }

    public UpdateObjectQuery(Call call) {
        this();
        this.setCall(call);
    }

    public void executeCommit() throws DatabaseException, OptimisticLockException {
        if (this.getRedirector() != null) {
            this.redirectQuery(this, this.session, this.translationRow);
            return;
        }
        this.getQueryMechanism().updateObjectForWrite();
    }

    public void executeCommitWithChangeSet() throws DatabaseException, OptimisticLockException {
        if (this.getRedirector() != null) {
            this.redirectQuery(this, this.session, this.translationRow);
            return;
        }
        this.getQueryMechanism().updateObjectForWriteWithChangeSet();
    }

    protected void prepare() {
        super.prepare();
        this.getQueryMechanism().prepareUpdateObject();
    }

    protected DatabaseQuery checkForCustomQuery(Session session, DatabaseRow databaseRow) {
        this.checkDescriptor(session);
        DescriptorQueryManager descriptorQueryManager = this.getDescriptor().getQueryManager();
        if (!this.isCallQuery() && !this.isUserDefined() && descriptorQueryManager.hasUpdateQuery()) {
            return descriptorQueryManager.getUpdateQuery();
        }
        return null;
    }

    protected void prepareCustomQuery(DatabaseQuery databaseQuery) {
        UpdateObjectQuery updateObjectQuery = (UpdateObjectQuery)databaseQuery;
        updateObjectQuery.setObject(this.getObject());
        updateObjectQuery.setObjectChangeSet(this.getObjectChangeSet());
        updateObjectQuery.setCascadePolicy(this.getCascadePolicy());
        updateObjectQuery.setShouldMaintainCache(this.shouldMaintainCache());
        updateObjectQuery.setModifyRow(null);
    }

    public boolean isUpdateObjectQuery() {
        return true;
    }
}

