/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.queryframework;

import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.databaseaccess.DatabasePlatform;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.StoredProcedureCall;

public class StoredFunctionCall
extends StoredProcedureCall {
    public StoredFunctionCall() {
        this.addUnamedOutputArgument("");
    }

    public String getCallHeader(DatabasePlatform databasePlatform) {
        return databasePlatform.getFunctionCallHeader();
    }

    public int getFirstParameterIndexForCallString() {
        return 1;
    }

    public boolean isStoredFunctionCall() {
        return true;
    }

    public void prepareInternal(Session session) {
        if (!session.getPlatform().supportsStoredFunctions()) {
            throw ValidationException.platformDoesNotSupportStoredFunctions(Helper.getShortClassName(session.getPlatform()));
        }
        super.prepareInternal(session);
    }

    public void setResult(String string) {
        DatabaseField databaseField = (DatabaseField)this.getParameters().firstElement();
        databaseField.setName(string);
    }

    public void setResult(String string, Class clazz) {
        DatabaseField databaseField = (DatabaseField)this.getParameters().firstElement();
        databaseField.setName(string);
        databaseField.setType(clazz);
    }
}

