/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.queryframework;

import java.io.Serializable;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.queryframework.ReportItem;
import oracle.toplink.mappings.foundation.AbstractDirectMapping;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.queryframework.ReadObjectQuery;
import oracle.toplink.queryframework.ReportQuery;
import oracle.toplink.sessions.Session;

public class ReportQueryResult
implements Serializable,
Map {
    protected Vector names;
    protected Vector results;
    protected Vector primaryKeyValues;

    public ReportQueryResult(Vector vector, Vector vector2) {
        this.results = vector;
        this.primaryKeyValues = vector2;
    }

    public ReportQueryResult(ReportQuery reportQuery, DatabaseRow databaseRow) {
        this.names = reportQuery.getNames();
        this.buildResult(reportQuery, databaseRow);
    }

    protected void buildResult(ReportQuery reportQuery, DatabaseRow databaseRow) {
        int n = 0;
        Vector<Object> vector = new Vector<Object>(reportQuery.getItems().size());
        if (reportQuery.shouldRetrievePrimaryKeys()) {
            n = reportQuery.getDescriptor().getPrimaryKeyFields().size();
            this.setPrimaryKeyValues(reportQuery.getDescriptor().getObjectBuilder().extractPrimaryKeyFromRow(databaseRow, reportQuery.getSession()));
        } else if (reportQuery.shouldRetrieveFirstPrimaryKey()) {
            n = 1;
        }
        int n2 = 0;
        for (int i = 0; i < reportQuery.getItems().size(); ++i) {
            ReportItem reportItem = (ReportItem)reportQuery.getItems().elementAt(i);
            AbstractDirectMapping abstractDirectMapping = reportItem.getMapping();
            Object object = null;
            if (!reportItem.isPlaceHolder()) {
                if (n2 + n >= databaseRow.size()) {
                    throw QueryException.reportQueryResultSizeMismatch(n2 + n, databaseRow.size());
                }
                object = databaseRow.getValues().elementAt(n2 + n);
                ++n2;
            }
            if (abstractDirectMapping != null) {
                object = abstractDirectMapping.getAttributeValue(object, reportQuery.getSession());
            }
            vector.addElement(object);
        }
        this.setResults(vector);
    }

    public void clear() {
        this.names = new Vector();
        this.results = new Vector();
    }

    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    public boolean containsKey(Object object) {
        return this.getNames().contains(object);
    }

    public boolean containsValue(Object object) {
        return this.getResults().contains(object);
    }

    public Enumeration elements() {
        return this.getResults().elements();
    }

    public Set entrySet() {
        int n = this.size();
        HashMap hashMap = new HashMap(n);
        for (int i = 0; i < n; ++i) {
            hashMap.put(this.getNames().elementAt(i), this.getResults().elementAt(i));
        }
        return hashMap.entrySet();
    }

    public boolean equals(Object object) {
        if (object instanceof ReportQueryResult) {
            return this.equals((ReportQueryResult)object);
        }
        return false;
    }

    public boolean equals(ReportQueryResult reportQueryResult) {
        if (this == reportQueryResult) {
            return true;
        }
        if (!Helper.compareOrderedVectors(this.getResults(), reportQueryResult.getResults())) {
            return false;
        }
        if (this.getPrimaryKeyValues() != null) {
            if (reportQueryResult.getPrimaryKeyValues() == null) {
                return false;
            }
            return Helper.compareOrderedVectors(this.getPrimaryKeyValues(), reportQueryResult.getPrimaryKeyValues());
        }
        return true;
    }

    public Object get(Object object) {
        if (object instanceof String) {
            return this.get((String)object);
        }
        return null;
    }

    public Object get(String string) {
        int n = this.getNames().indexOf(string);
        if (n == -1) {
            return null;
        }
        return this.getResults().elementAt(n);
    }

    public Object getByIndex(int n) {
        return this.getResults().elementAt(n);
    }

    public Vector getNames() {
        return this.names;
    }

    public Vector getPrimaryKeyValues() {
        return this.primaryKeyValues;
    }

    public Vector getResults() {
        return this.results;
    }

    public boolean isEmpty() {
        return this.getNames().isEmpty();
    }

    public Enumeration keys() {
        return this.getNames().elements();
    }

    public Set keySet() {
        return new HashSet(this.getNames());
    }

    public Object put(Object object, Object object2) {
        int n = this.getNames().indexOf(object);
        if (n == -1) {
            this.getNames().addElement(object);
            this.getResults().addElement(object2);
            return null;
        }
        Object e = this.getResults().elementAt(n);
        this.getResults().setElementAt(object2, n);
        return e;
    }

    public void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object readObject(Class clazz, Session session) {
        if (this.getPrimaryKeyValues() == null) {
            throw QueryException.reportQueryResultWithoutPKs(this);
        }
        ReadObjectQuery readObjectQuery = new ReadObjectQuery(clazz);
        readObjectQuery.setSelectionKey(this.getPrimaryKeyValues());
        return session.executeQuery(readObjectQuery);
    }

    public Object remove(Object object) {
        int n = this.getNames().indexOf(object);
        if (n >= 0) {
            this.getNames().removeElementAt(n);
            Object e = this.getResults().elementAt(n);
            this.getResults().removeElementAt(n);
            return e;
        }
        return null;
    }

    protected void setNames(Vector vector) {
        this.names = vector;
    }

    protected void setPrimaryKeyValues(Vector vector) {
        this.primaryKeyValues = vector;
    }

    public void setResults(Vector vector) {
        this.results = vector;
    }

    public int size() {
        return this.getNames().size();
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("ReportQueryResult(");
        for (int i = 0; i < this.getResults().size(); ++i) {
            stringWriter.write(String.valueOf(this.getResults().elementAt(i)));
            if (i >= this.getResults().size() - 1) continue;
            stringWriter.write(", ");
        }
        stringWriter.write(")");
        return stringWriter.toString();
    }

    public Collection values() {
        return this.getResults();
    }
}

