/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.queryframework;

import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.expressions.ExpressionBuilder;
import oracle.toplink.internal.expressions.FunctionExpression;
import oracle.toplink.internal.expressions.QueryKeyExpression;
import oracle.toplink.internal.helper.IdentityHashtable;
import oracle.toplink.internal.helper.NonSynchronizedVector;
import oracle.toplink.internal.queryframework.ContainerPolicy;
import oracle.toplink.internal.queryframework.ExpressionQueryMechanism;
import oracle.toplink.internal.queryframework.ReportItem;
import oracle.toplink.internal.remote.RemoteSessionController;
import oracle.toplink.internal.remote.Transporter;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ReadAllQuery;
import oracle.toplink.queryframework.ReportQueryResult;

public class ReportQuery
extends ReadAllQuery {
    public static final int ShouldReturnSingleResult = 1;
    public static final int ShouldReturnSingleValue = 2;
    public static final int ShouldReturnSingleAttribute = 3;
    public static final int FULL_PRIMARY_KEY = 2;
    public static final int FIRST_PRIMARY_KEY = 1;
    public static final int NO_PRIMARY_KEY = 0;
    protected int shouldRetrievePrimaryKeys;
    protected Vector names;
    protected Vector items;
    protected Vector groupByExpressions;
    protected int returnChoice;

    public ReportQuery() {
        this.queryMechanism = new ExpressionQueryMechanism(this);
        this.items = NonSynchronizedVector.newInstance();
        this.shouldRetrievePrimaryKeys = 0;
        this.groupByExpressions = NonSynchronizedVector.newInstance(3);
        this.setLockMode((short)0);
    }

    public ReportQuery(Class clazz, Expression expression) {
        this();
        this.defaultBuilder = expression.getBuilder();
        this.setReferenceClass(clazz);
        this.setSelectionCriteria(expression);
    }

    public ReportQuery(Class clazz, ExpressionBuilder expressionBuilder) {
        this();
        this.defaultBuilder = expressionBuilder;
        this.setReferenceClass(clazz);
    }

    public ReportQuery(ExpressionBuilder expressionBuilder) {
        this();
        this.defaultBuilder = expressionBuilder;
    }

    public void addAttribute(String string) {
        this.addItem(string, this.getExpressionBuilder().get(string));
    }

    public void addAttribute(String string, Expression expression) {
        this.addItem(string, expression);
    }

    public void addAverage(String string) {
        this.addAverage(string, this.getExpressionBuilder().get(string));
    }

    public void addAverage(String string, Expression expression) {
        this.addItem(string, expression.average());
    }

    public void addCount() {
        this.addCount("COUNT", this.getExpressionBuilder());
    }

    public void addCount(String string) {
        this.addCount(string, this.getExpressionBuilder().get(string));
    }

    public void addCount(String string, Expression expression) {
        this.addItem(string, expression.count());
    }

    public void addFunctionItem(String string, Expression expression, String string2) {
        Expression expression2 = expression;
        expression2 = expression.getFunction(string2);
        ReportItem reportItem = new ReportItem(string, expression2);
        this.getItems().addElement(reportItem);
        this.setIsPrepared(false);
    }

    public void addGrouping(String string) {
        this.addGrouping(this.getExpressionBuilder().get(string));
    }

    public void addGrouping(Expression expression) {
        this.getGroupByExpressions().addElement(expression);
        this.setIsPrepared(false);
    }

    public void addItem(String string, Expression expression) {
        ReportItem reportItem = new ReportItem(string, expression);
        this.getItems().addElement(reportItem);
        this.setIsPrepared(false);
    }

    public void addMaximum(String string) {
        this.addMaximum(string, this.getExpressionBuilder().get(string));
    }

    public void addMaximum(String string, Expression expression) {
        this.addItem(string, expression.maximum());
    }

    public void addMinimum(String string) {
        this.addMinimum(string, this.getExpressionBuilder().get(string));
    }

    public void addMinimum(String string, Expression expression) {
        this.addItem(string, expression.minimum());
    }

    public void addStandardDeviation(String string) {
        this.addStandardDeviation(string, this.getExpressionBuilder().get(string));
    }

    public void addStandardDeviation(String string, Expression expression) {
        this.addItem(string, expression.standardDeviation());
    }

    public void addSum(String string) {
        this.addSum(string, this.getExpressionBuilder().get(string));
    }

    public void addSum(String string, Expression expression) {
        this.addItem(string, expression.sum());
    }

    public void addVariance(String string) {
        this.addVariance(string, this.getExpressionBuilder().get(string));
    }

    public void addVariance(String string, Expression expression) {
        this.addItem(string, expression.variance());
    }

    public Object buildObject(DatabaseRow databaseRow) {
        ReportQueryResult reportQueryResult = new ReportQueryResult(this, databaseRow);
        if (this.shouldReturnSingleAttribute()) {
            return reportQueryResult.getResults().firstElement();
        }
        return reportQueryResult;
    }

    public Object buildObjects(Vector vector) {
        if (this.shouldReturnSingleResult() || this.shouldReturnSingleValue()) {
            if (vector.isEmpty()) {
                return null;
            }
            ReportQueryResult reportQueryResult = (ReportQueryResult)this.buildObject((DatabaseRow)vector.firstElement());
            if (this.shouldReturnSingleValue()) {
                return reportQueryResult.elements().nextElement();
            }
            return reportQueryResult;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object = containerPolicy.containerInstance(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            containerPolicy.addInto(this.buildObject((DatabaseRow)enumeration.nextElement()), object, this.getSession());
        }
        if (this.shouldCacheQueryResults()) {
            this.setTemporaryCachedQueryResults(object);
        }
        return object;
    }

    protected Object checkEarlyReturnImpl(Session session, DatabaseRow databaseRow) {
        if (this.shouldCheckCacheOnly()) {
            throw QueryException.cannotSetShouldCheckCacheOnlyOnReportQuery();
        }
        return null;
    }

    public void copyReportItems(Dictionary dictionary) {
        Serializable serializable;
        int n;
        this.items = (Vector)this.items.clone();
        for (n = this.items.size() - 1; n >= 0; --n) {
            serializable = (ReportItem)this.items.elementAt(n);
            Expression expression = ((ReportItem)serializable).getAttributeExpression();
            if (expression != null && dictionary.get(expression.getBuilder()) != null) {
                expression = expression.copiedVersionFrom(dictionary);
            }
            this.items.set(n, new ReportItem(((ReportItem)serializable).getName(), expression));
        }
        if (this.groupByExpressions != null) {
            this.groupByExpressions = (Vector)this.groupByExpressions.clone();
            for (n = this.groupByExpressions.size() - 1; n >= 0; --n) {
                serializable = (Expression)this.groupByExpressions.elementAt(n);
                if (dictionary.get(((Expression)serializable).getBuilder()) == null) continue;
                this.groupByExpressions.set(n, ((Expression)serializable).copiedVersionFrom(dictionary));
            }
        }
        if (this.orderByExpressions != null) {
            for (n = this.orderByExpressions.size() - 1; n >= 0; --n) {
                serializable = (Expression)this.orderByExpressions.elementAt(n);
                if (dictionary.get(((Expression)serializable).getBuilder()) == null) continue;
                this.orderByExpressions.set(n, ((Expression)serializable).copiedVersionFrom(dictionary));
            }
        }
    }

    public void dontRetrievePrimaryKeys() {
        this.setShouldRetrievePrimaryKeys(false);
        this.setIsPrepared(false);
    }

    public void dontReturnSingleAttribute() {
        if (this.shouldReturnSingleAttribute()) {
            this.returnChoice = 0;
        }
    }

    public void dontReturnSingleResult() {
        if (this.shouldReturnSingleResult()) {
            this.returnChoice = 0;
        }
    }

    public void dontReturnSingleValue() {
        if (this.shouldReturnSingleValue()) {
            this.returnChoice = 0;
        }
    }

    public Object executeInUnitOfWork(UnitOfWork unitOfWork, DatabaseRow databaseRow) {
        return unitOfWork.getParent().executeQuery((DatabaseQuery)this, databaseRow);
    }

    public Object executeDatabaseQuery() throws DatabaseException {
        if (this.getContainerPolicy().overridesRead()) {
            return this.getContainerPolicy().execute();
        }
        if (this.getDescriptor().isDescriptorForInterface()) {
            return this.getDescriptor().getInterfacePolicy().selectAllObjectsUsingMultipleTableSubclassRead(this);
        }
        return this.buildObjects(this.getQueryMechanism().selectAllReportQueryRows());
    }

    public Object extractRemoteResult(Transporter transporter) {
        return transporter.getObject();
    }

    public Vector getGroupByExpressions() {
        return this.groupByExpressions;
    }

    public Vector getItemExpressions() {
        Vector vector = new Vector(this.getItems().size());
        if (this.shouldRetrieveFirstPrimaryKey() && !this.getDescriptor().getPrimaryKeyFields().isEmpty()) {
            vector.addElement(this.getDescriptor().getPrimaryKeyFields().get(0));
        }
        if (this.shouldRetrievePrimaryKeys()) {
            vector.addAll(this.getDescriptor().getPrimaryKeyFields());
        }
        Enumeration enumeration = this.getItems().elements();
        while (enumeration.hasMoreElements()) {
            ReportItem reportItem = (ReportItem)enumeration.nextElement();
            Expression expression = reportItem.getAttributeExpression();
            if (expression == null) continue;
            vector.addElement(expression);
        }
        return vector;
    }

    public Vector getItems() {
        return this.items;
    }

    public Vector getNames() {
        if (this.names == null) {
            this.names = NonSynchronizedVector.newInstance();
            Enumeration enumeration = this.getItems().elements();
            while (enumeration.hasMoreElements()) {
                this.names.addElement(((ReportItem)enumeration.nextElement()).getName());
            }
        }
        return this.names;
    }

    public boolean isReportQuery() {
        return true;
    }

    protected void prepare() throws QueryException {
        super.prepare();
        if (this.getItems().size() > 0) {
            try {
                Enumeration enumeration = this.getItems().elements();
                while (enumeration.hasMoreElements()) {
                    ((ReportItem)enumeration.nextElement()).initialize(this);
                }
            }
            catch (QueryException queryException) {
                queryException.setQuery(this);
                throw queryException;
            }
        } else if (!this.shouldRetrievePrimaryKeys() && !this.shouldRetrieveFirstPrimaryKey()) {
            throw QueryException.noAttributesForReportQuery(this);
        }
    }

    protected void prepareObjectAttributeCount(Dictionary dictionary) {
        FunctionExpression functionExpression;
        ReportItem reportItem;
        ReportItem reportItem2 = reportItem = this.getItems().isEmpty() ? null : (ReportItem)this.getItems().elementAt(0);
        if (reportItem != null && reportItem.getAttributeExpression() instanceof FunctionExpression && (functionExpression = (FunctionExpression)reportItem.getAttributeExpression()).getOperator().getSelector() == 19) {
            QueryKeyExpression queryKeyExpression;
            DatabaseMapping databaseMapping;
            Expression expression = functionExpression.getBaseExpression();
            boolean bl = false;
            if (expression.isFunctionExpression() && ((FunctionExpression)expression).getOperator().getSelector() == 87) {
                bl = true;
                expression = ((FunctionExpression)expression).getBaseExpression();
            }
            if (expression.isQueryKeyExpression() && (databaseMapping = this.getLeafMappingFor(queryKeyExpression = (QueryKeyExpression)expression, this.getDescriptor())) != null && !databaseMapping.isDirectToFieldMapping() && databaseMapping.getReferenceDescriptor() != null) {
                Descriptor descriptor = databaseMapping.getReferenceDescriptor();
                if (bl) {
                    if (dictionary != null) {
                        queryKeyExpression = dictionary.get(queryKeyExpression.getBuilder()) != null ? (QueryKeyExpression)queryKeyExpression.copiedVersionFrom(dictionary) : (QueryKeyExpression)queryKeyExpression.rebuildOn(this.getExpressionBuilder());
                    }
                    ExpressionBuilder expressionBuilder = queryKeyExpression.getBuilder();
                    ExpressionBuilder expressionBuilder2 = new ExpressionBuilder();
                    ReportQuery reportQuery = new ReportQuery(this.getReferenceClass(), expressionBuilder);
                    reportQuery.setShouldRetrieveFirstPrimaryKey(true);
                    if (this.getSelectionCriteria() != null) {
                        expressionBuilder2.setQueryClass(descriptor.getJavaClass());
                        reportQuery.setSelectionCriteria(this.getSelectionCriteria().and(expressionBuilder2.equal(queryKeyExpression)));
                    } else {
                        reportQuery.setSelectionCriteria(queryKeyExpression.equal(expressionBuilder2));
                    }
                    this.setSelectionCriteria(expressionBuilder2.exists(reportQuery));
                    this.getItems().setElementAt(new ReportItem(reportItem.getName(), expressionBuilder2.count()), 0);
                    this.setReferenceClass(descriptor.getJavaClass());
                    this.changeDescriptor(this.getSession());
                } else {
                    Expression expression2 = queryKeyExpression.prefixSQL("*").count();
                    this.getItems().setElementAt(new ReportItem(reportItem.getName(), expression2), 0);
                }
            }
        }
    }

    protected void prepareSelectAllRows() {
        this.prepareObjectAttributeCount(null);
        this.getQueryMechanism().prepareReportQuerySelectAllRows();
    }

    public synchronized void prepareSubSelect(Session session, DatabaseRow databaseRow, Dictionary dictionary) throws QueryException {
        if (this.isPrepared()) {
            return;
        }
        this.setIsPrepared(true);
        this.setSession(session);
        this.setTranslationRow(databaseRow);
        this.checkDescriptor(this.getSession());
        if (this.descriptor.isAggregateDescriptor()) {
            throw QueryException.aggregateObjectCannotBeDeletedOrWritten(this.descriptor, this);
        }
        try {
            Enumeration enumeration = this.getItems().elements();
            while (enumeration.hasMoreElements()) {
                ((ReportItem)enumeration.nextElement()).initialize(this);
            }
        }
        catch (QueryException queryException) {
            queryException.setQuery(this);
            throw queryException;
        }
        this.prepareObjectAttributeCount(dictionary);
        this.getQueryMechanism().prepareReportQuerySubSelect();
        this.setSession(null);
        this.setTranslationRow(null);
    }

    public void initializeFetchGroup() {
    }

    public IdentityHashtable replaceValueHoldersIn(Object object, RemoteSessionController remoteSessionController) {
        return null;
    }

    public void retrievePrimaryKeys() {
        this.setShouldRetrievePrimaryKeys(true);
        this.setIsPrepared(false);
    }

    public void returnSingleAttribute() {
        this.returnChoice = 3;
    }

    public void returnSingleResult() {
        this.returnChoice = 1;
    }

    public void returnSingleValue() {
        this.returnChoice = 2;
    }

    public void setShouldRetrievePrimaryKeys(boolean bl) {
        this.shouldRetrievePrimaryKeys = bl ? 2 : 0;
    }

    public void setShouldRetrieveFirstPrimaryKey(boolean bl) {
        this.shouldRetrievePrimaryKeys = bl ? 1 : 0;
    }

    public void setShouldReturnSingleAttribute(boolean bl) {
        if (bl) {
            this.returnSingleAttribute();
        } else {
            this.dontReturnSingleAttribute();
        }
    }

    public void setShouldReturnSingleResult(boolean bl) {
        if (bl) {
            this.returnSingleResult();
        } else {
            this.dontReturnSingleResult();
        }
    }

    public void setShouldReturnSingleValue(boolean bl) {
        if (bl) {
            this.returnSingleValue();
        } else {
            this.dontReturnSingleValue();
        }
    }

    public boolean shouldRetrievePrimaryKeys() {
        return this.shouldRetrievePrimaryKeys == 2;
    }

    public boolean shouldRetrieveFirstPrimaryKey() {
        return this.shouldRetrievePrimaryKeys == 1;
    }

    public boolean shouldReturnSingleAttribute() {
        return this.returnChoice == 3;
    }

    public boolean shouldReturnSingleResult() {
        return this.returnChoice == 1;
    }

    public boolean shouldReturnSingleValue() {
        return this.returnChoice == 2;
    }
}

