/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.queryframework;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.OptimisticLockException;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.expressions.ExpressionBuilder;
import oracle.toplink.history.AsOfClause;
import oracle.toplink.internal.descriptors.ObjectBuilder;
import oracle.toplink.internal.expressions.ForUpdateClause;
import oracle.toplink.internal.expressions.ForUpdateOfClause;
import oracle.toplink.internal.expressions.ObjectExpression;
import oracle.toplink.internal.expressions.QueryKeyExpression;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.helper.IdentityHashtable;
import oracle.toplink.internal.helper.InvalidObject;
import oracle.toplink.internal.helper.NonSynchronizedVector;
import oracle.toplink.internal.history.UniversalAsOfClause;
import oracle.toplink.internal.queryframework.DatabaseQueryMechanism;
import oracle.toplink.internal.queryframework.ExpressionQueryMechanism;
import oracle.toplink.internal.queryframework.QueryByExampleMechanism;
import oracle.toplink.mappings.AggregateObjectMapping;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.mappings.ForeignReferenceMapping;
import oracle.toplink.mappings.foundation.AbstractDirectMapping;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.FetchGroup;
import oracle.toplink.queryframework.InMemoryQueryIndirectionPolicy;
import oracle.toplink.queryframework.QueryByExamplePolicy;
import oracle.toplink.queryframework.ReadQuery;
import oracle.toplink.querykeys.ForeignReferenceQueryKey;
import oracle.toplink.querykeys.QueryKey;
import oracle.toplink.tools.workbench.expressions.ExpressionRepresentation;

public abstract class ObjectLevelReadQuery
extends ReadQuery {
    protected Class referenceClass;
    protected String referenceClassName;
    protected ExpressionBuilder defaultBuilder;
    protected boolean shouldRefreshIdentityMapResult = false;
    protected boolean shouldRefreshRemoteIdentityMapResult;
    protected int cacheUsage = -1;
    public static final int UseDescriptorSetting = -1;
    public static final int DoNotCheckCache = 0;
    public static final int CheckCacheByExactPrimaryKey = 1;
    public static final int CheckCacheByPrimaryKey = 2;
    public static final int CheckCacheThenDatabase = 3;
    public static final int CheckCacheOnly = 4;
    public static final int ConformResultsInUnitOfWork = 5;
    protected boolean shouldRegisterResultsInUnitOfWork = true;
    protected Vector additionalFields;
    protected boolean shouldIncludeData = false;
    protected boolean shouldProcessResultsInUnitOfWork = true;
    protected Vector joinedAttributeExpressions;
    protected Vector joinedMappingExpressions;
    protected Vector partialAttributeExpressions;
    protected ForUpdateClause lockingClause;
    public static final short NO_LOCK = 0;
    public static final short LOCK = 1;
    public static final short LOCK_NOWAIT = 2;
    public static final short DEFAULT_LOCK_MODE = -1;
    protected boolean isPrePrepared;
    protected short distinctState = 0;
    public static final short UNCOMPUTED_DISTINCT = 0;
    public static final short USE_DISTINCT = 1;
    public static final short DONT_USE_DISTINCT = 2;
    protected InMemoryQueryIndirectionPolicy inMemoryQueryIndirectionPolicy = new InMemoryQueryIndirectionPolicy();
    protected transient Map joinedMappingIndexes;
    protected transient Map joinedMappingQueries;
    protected transient Map joinedMappingQueryClones;
    protected long executionTime = 0L;
    protected boolean shouldUseExclusiveConnection = false;
    public static final String LOCK_RESULT_PROPERTY = "LOCK_RESULT";
    protected FetchGroup fetchGroup;
    protected String fetchGroupName;
    protected boolean shouldUseDefaultFetchGroup = true;
    protected boolean isOneToManyJoinQuery;
    protected List dataResults;
    protected boolean wasDefaultLockMode = false;
    protected List joinedAttributes;
    protected boolean isOuterJoinedAttributeQuery = true;
    protected Boolean isReferenceClassLocked;

    public boolean isOneToManyJoinQuery() {
        return this.isOneToManyJoinQuery;
    }

    protected void setIsOneToManyJoinQuery(boolean bl) {
        this.isOneToManyJoinQuery = bl;
    }

    public boolean isOuterJoinedAttributeQuery() {
        return this.isOuterJoinedAttributeQuery;
    }

    protected void setIsOuterJoinedAttributeQuery(boolean bl) {
        this.isOuterJoinedAttributeQuery = bl;
    }

    protected boolean wasDefaultLockMode() {
        return this.wasDefaultLockMode;
    }

    protected void setWasDefaultLockMode(boolean bl) {
        this.wasDefaultLockMode = bl;
    }

    public List getDataResults() {
        return this.dataResults;
    }

    protected void setDataResults(List list) {
        this.dataResults = list;
    }

    public Object clone() {
        ObjectLevelReadQuery objectLevelReadQuery = (ObjectLevelReadQuery)super.clone();
        if (this.hasJoinedAttributes()) {
            objectLevelReadQuery.joinedAttributeExpressions = (Vector)objectLevelReadQuery.getJoinedAttributeExpressions().clone();
            objectLevelReadQuery.joinedMappingExpressions = (Vector)objectLevelReadQuery.getJoinedMappingExpressions().clone();
        } else {
            objectLevelReadQuery.joinedAttributeExpressions = null;
            objectLevelReadQuery.joinedMappingExpressions = null;
        }
        return objectLevelReadQuery;
    }

    public Object deepClone() {
        ObjectLevelReadQuery objectLevelReadQuery = (ObjectLevelReadQuery)this.clone();
        if (this.getSelectionCriteria() != null) {
            objectLevelReadQuery.setSelectionCriteria((Expression)this.getSelectionCriteria().clone());
        } else if (this.defaultBuilder != null) {
            objectLevelReadQuery.defaultBuilder = (ExpressionBuilder)this.defaultBuilder.clone();
        }
        return objectLevelReadQuery;
    }

    public void acquireLocks() {
        this.setLockMode((short)1);
        this.setIsPrepared(false);
    }

    public void acquireLocksWithoutWaiting() {
        this.setLockMode((short)2);
        this.setIsPrepared(false);
    }

    public void addAdditionalField(DatabaseField databaseField) {
        this.getAdditionalFields().add(databaseField);
        this.setIsPrepared(false);
    }

    public void addAdditionalField(Expression expression) {
        this.getAdditionalFields().add(expression);
        this.setIsPrepared(false);
    }

    public void addJoinedAttribute(String string) {
        this.addJoinedAttribute(this.getExpressionBuilder().get(string));
    }

    public void addJoinedAttribute(Expression expression) {
        this.getJoinedAttributeExpressions().add(expression);
        this.setIsPrePrepared(false);
    }

    public void addJoinedMapping(String string) {
        this.addJoinedMapping(this.getExpressionBuilder().get(string));
    }

    public void addJoinedMapping(Expression expression) {
        this.getJoinedMappingExpressions().add(expression);
        this.setIsPrePrepared(false);
    }

    public void addPartialAttribute(String string) {
        this.addPartialAttribute(this.getExpressionBuilder().get(string));
    }

    protected void addSelectionFieldsForJoinedExpressions(Vector vector, Vector vector2) {
        for (int i = 0; i < vector2.size(); ++i) {
            ObjectExpression objectExpression = (ObjectExpression)vector2.get(i);
            objectExpression.getBuilder().setSession(this.getSession());
            objectExpression.getBuilder().setQueryClass(this.getReferenceClass());
            Descriptor descriptor = objectExpression.getMapping().getReferenceDescriptor();
            Helper.addAllToVector(vector, descriptor.getFields());
        }
    }

    public void setAsOfClause(AsOfClause asOfClause) {
        this.getExpressionBuilder().asOf(new UniversalAsOfClause(asOfClause));
        this.setIsPrepared(false);
    }

    public void addPartialAttribute(Expression expression) {
        this.getPartialAttributeExpressions().addElement(expression);
        this.setIsPrepared(false);
    }

    public Object buildObject(DatabaseRow databaseRow) {
        return this.getDescriptor().getObjectBuilder().buildObject(this, databaseRow);
    }

    public void checkCacheOnly() {
        this.setCacheUsage(4);
    }

    public void checkDescriptor(Session session) throws QueryException {
        if (this.getDescriptor() == null) {
            if (this.getReferenceClass() == null) {
                throw QueryException.referenceClassMissing(this);
            }
            Descriptor descriptor = session.getDescriptor(this.getReferenceClass());
            if (descriptor == null) {
                throw QueryException.descriptorIsMissing(this.getReferenceClass(), this);
            }
            this.setDescriptor(descriptor);
        }
    }

    protected abstract Object checkEarlyReturnImpl(Session var1, DatabaseRow var2);

    public Object checkEarlyReturn(Session session, DatabaseRow databaseRow) {
        Object object;
        this.checkPrePrepare(session);
        if (!session.isUnitOfWork()) {
            return this.checkEarlyReturnImpl(session, databaseRow);
        }
        UnitOfWork unitOfWork = (UnitOfWork)session;
        if ((this.shouldCheckCacheOnly() || this.shouldConformResultsInUnitOfWork() || this.getDescriptor().shouldAlwaysConformResultsInUnitOfWork() || this.getLockMode() != 0) && (object = this.checkEarlyReturnImpl(unitOfWork, databaseRow)) != null) {
            return object;
        }
        if (this.isReadObjectQuery() && this.isLockQuery()) {
            return null;
        }
        object = unitOfWork.getParentIdentityMapSession(this);
        Object object2 = this.checkEarlyReturn((Session)object, databaseRow);
        if (object2 != null) {
            if (object2 == InvalidObject.instance) {
                return object2;
            }
            return this.registerResultInUnitOfWork(object2, unitOfWork, databaseRow, false);
        }
        return null;
    }

    public void checkPrepare(Session session, DatabaseRow databaseRow, boolean bl) {
        this.checkPrePrepare(session);
        super.checkPrepare(session, databaseRow, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkPrePrepare(Session session) {
        if (this.getRedirector() != null) {
            return;
        }
        this.checkDescriptor(session);
        if (!this.isPrePrepared()) {
            ObjectLevelReadQuery objectLevelReadQuery = this;
            synchronized (objectLevelReadQuery) {
                if (!this.isPrePrepared()) {
                    Session session2 = this.getSession();
                    this.setSession(session);
                    this.prePrepare();
                    this.setSession(session2);
                    this.setIsPrePrepared(true);
                }
            }
        }
    }

    public void changeDescriptor(Session session) {
        this.setDescriptor(null);
        this.checkDescriptor(session);
    }

    protected Object conformIndividualResult(Object object, UnitOfWork unitOfWork, DatabaseRow databaseRow, Expression expression, IdentityHashtable identityHashtable, boolean bl) {
        Object object2 = null;
        object2 = bl ? this.buildObject((DatabaseRow)object) : this.registerIndividualResult(object, unitOfWork);
        if (this.getDescriptor().hasWrapperPolicy() && this.getDescriptor().getWrapperPolicy().isWrapped(object2)) {
            return object2;
        }
        if (unitOfWork.isObjectDeleted(object2)) {
            return null;
        }
        if (!this.isExpressionQuery() || expression == null) {
            if (identityHashtable != null) {
                identityHashtable.remove(object2);
            }
            return object2;
        }
        try {
            InMemoryQueryIndirectionPolicy inMemoryQueryIndirectionPolicy = this.getInMemoryQueryIndirectionPolicy();
            if (!inMemoryQueryIndirectionPolicy.shouldTriggerIndirection()) {
                inMemoryQueryIndirectionPolicy = new InMemoryQueryIndirectionPolicy(2);
            }
            if (expression.doesConform(object2, unitOfWork, databaseRow, inMemoryQueryIndirectionPolicy)) {
                if (identityHashtable != null) {
                    identityHashtable.remove(object2);
                }
                return object2;
            }
        }
        catch (QueryException queryException) {
            if (unitOfWork.getShouldThrowConformExceptions() == 1 && queryException.getErrorCode() != 6092) {
                throw queryException;
            }
            if (identityHashtable != null) {
                identityHashtable.remove(object2);
            }
            return object2;
        }
        return null;
    }

    public void conformResultsInUnitOfWork() {
        this.setCacheUsage(5);
    }

    public void dontAcquireLocks() {
        this.setLockMode((short)0);
        this.setIsPrepared(false);
    }

    public void dontCheckCache() {
        this.setCacheUsage(0);
    }

    public void dontRefreshIdentityMapResult() {
        this.setShouldRefreshIdentityMapResult(false);
    }

    public void dontRefreshRemoteIdentityMapResult() {
        this.setShouldRefreshRemoteIdentityMapResult(false);
    }

    public void dontUseDistinct() {
        this.setDistinctState((short)2);
        this.setIsPrepared(false);
    }

    public DatabaseQuery prepareOutsideUnitOfWork(Session session) {
        if (this.isLockQuery(session) && this.getLockingClause().isForUpdateOfClause()) {
            ObjectLevelReadQuery objectLevelReadQuery = (ObjectLevelReadQuery)this.clone();
            objectLevelReadQuery.setIsExecutionClone(true);
            objectLevelReadQuery.dontAcquireLocks();
            objectLevelReadQuery.setIsPrepared(false);
            objectLevelReadQuery.checkPrePrepare(session);
            return objectLevelReadQuery;
        }
        return this;
    }

    public Object execute(Session session, DatabaseRow databaseRow) throws DatabaseException, OptimisticLockException {
        if (this.shouldRefreshIdentityMapResult() && this.shouldCheckCacheOnly()) {
            throw QueryException.refreshNotPossibleWithCheckCacheOnly(this);
        }
        return super.execute(session, databaseRow);
    }

    public Object executeDatabaseQuery() throws DatabaseException {
        if (this.getSession().isUnitOfWork()) {
            UnitOfWork unitOfWork = (UnitOfWork)this.getSession();
            if (this.isLockQuery() && !unitOfWork.getCommitManager().isActive() && !unitOfWork.wasTransactionBegunPrematurely()) {
                unitOfWork.beginTransaction();
                unitOfWork.setWasTransactionBegunPrematurely(true);
            }
            if (unitOfWork.isNestedUnitOfWork()) {
                UnitOfWork unitOfWork2 = (UnitOfWork)this.getSession();
                this.setSession(unitOfWork2.getParent());
                Object object = this.executeDatabaseQuery();
                this.setSession(unitOfWork2);
                return this.registerResultInUnitOfWork(object, unitOfWork2, this.getTranslationRow(), false);
            }
        }
        this.session.validateQuery(this);
        if (this.getQueryId() == 0L) {
            this.setQueryId(this.getSession().getNextQueryId());
        }
        return this.executeObjectLevelReadQuery();
    }

    protected abstract Object executeObjectLevelReadQuery() throws DatabaseException;

    public Object executeInUnitOfWork(UnitOfWork unitOfWork, DatabaseRow databaseRow) throws DatabaseException, OptimisticLockException {
        if (!this.shouldMaintainCache()) {
            return unitOfWork.getParent().executeQuery((DatabaseQuery)this, databaseRow);
        }
        if (unitOfWork.isAfterWriteChangesButBeforeCommit()) {
            throw ValidationException.illegalOperationForUnitOfWorkLifecycle(unitOfWork.getLifecycle(), "executeQuery(ObjectLevelReadQuery)");
        }
        Object object = this.execute(unitOfWork, databaseRow);
        if (object == InvalidObject.instance) {
            return null;
        }
        return object;
    }

    public Vector getAdditionalFields() {
        if (this.additionalFields == null) {
            this.additionalFields = NonSynchronizedVector.newInstance();
        }
        return this.additionalFields;
    }

    public AsOfClause getAsOfClause() {
        return this.defaultBuilder != null ? this.defaultBuilder.getAsOfClause() : null;
    }

    public int getCacheUsage() {
        return this.cacheUsage;
    }

    public short getDistinctState() {
        return this.distinctState;
    }

    public Object getExampleObject() {
        if (this.getQueryMechanism().isQueryByExampleMechanism()) {
            return ((QueryByExampleMechanism)this.getQueryMechanism()).getExampleObject();
        }
        return null;
    }

    public ExpressionBuilder getExpressionBuilder() {
        if (this.defaultBuilder == null) {
            this.initializeDefaultBuilder();
        }
        return this.defaultBuilder;
    }

    public InMemoryQueryIndirectionPolicy getInMemoryQueryIndirectionPolicy() {
        return this.inMemoryQueryIndirectionPolicy;
    }

    public Vector getJoinedAttributeExpressions() {
        if (this.joinedAttributeExpressions == null) {
            this.joinedAttributeExpressions = NonSynchronizedVector.newInstance();
        }
        return this.joinedAttributeExpressions;
    }

    public Vector getJoinedMappingExpressions() {
        if (this.joinedMappingExpressions == null) {
            this.joinedMappingExpressions = NonSynchronizedVector.newInstance();
        }
        return this.joinedMappingExpressions;
    }

    public void setJoinedMappingExpressions(Vector vector) {
        this.joinedMappingExpressions = vector;
    }

    public DatabaseMapping getLeafMappingFor(Expression expression, Descriptor descriptor) throws QueryException {
        if (expression == null || expression.isFieldExpression()) {
            return null;
        }
        if (!expression.isQueryKeyExpression()) {
            return null;
        }
        QueryKeyExpression queryKeyExpression = (QueryKeyExpression)expression;
        Expression expression2 = queryKeyExpression.getBaseExpression();
        Descriptor descriptor2 = this.getLeafDescriptorFor(expression2, descriptor);
        return descriptor2.getMappingForAttributeName(queryKeyExpression.getName());
    }

    public Descriptor getLeafDescriptorFor(Expression expression, Descriptor descriptor) throws QueryException {
        if (expression.isExpressionBuilder()) {
            Class clazz = ((ExpressionBuilder)expression).getQueryClass();
            if (clazz != null && clazz != this.getReferenceClass()) {
                return this.getSession().getDescriptor(clazz);
            }
            return descriptor;
        }
        Expression expression2 = ((QueryKeyExpression)expression).getBaseExpression();
        Descriptor descriptor2 = this.getLeafDescriptorFor(expression2, descriptor);
        Descriptor descriptor3 = null;
        String string = expression.getName();
        DatabaseMapping databaseMapping = descriptor2.getMappingForAttributeName(string);
        if (databaseMapping == null) {
            QueryKey queryKey = descriptor2.getQueryKeyNamed(string);
            if (queryKey != null) {
                descriptor3 = queryKey.isForeignReferenceQueryKey() ? this.getSession().getDescriptor(((ForeignReferenceQueryKey)queryKey).getReferenceClass()) : queryKey.getDescriptor();
            }
            if (descriptor3 == null) {
                throw QueryException.invalidExpressionForQueryItem(expression, this);
            }
        } else if (databaseMapping.isAggregateObjectMapping()) {
            descriptor3 = ((AggregateObjectMapping)databaseMapping).getReferenceDescriptor();
        } else if (databaseMapping.isForeignReferenceMapping()) {
            descriptor3 = ((ForeignReferenceMapping)databaseMapping).getReferenceDescriptor();
        }
        return descriptor3;
    }

    public short getLockMode() {
        if (this.lockingClause == null) {
            return -1;
        }
        return this.lockingClause.getLockMode();
    }

    public ForUpdateClause getLockingClause() {
        return this.lockingClause;
    }

    public Vector getPartialAttributeExpressions() {
        if (this.partialAttributeExpressions == null) {
            this.partialAttributeExpressions = NonSynchronizedVector.newInstance();
        }
        return this.partialAttributeExpressions;
    }

    public Vector getPartialAttributeExpressionsWithoutKeyFields(Descriptor descriptor) {
        Vector<Expression> vector = new Vector<Expression>(this.getPartialAttributeExpressions().size());
        Enumeration enumeration = this.getPartialAttributeExpressions().elements();
        while (enumeration.hasMoreElements()) {
            Expression expression = (Expression)enumeration.nextElement();
            String string = expression.getName();
            DatabaseMapping databaseMapping = descriptor.getMappingForAttributeName(string);
            if (expression.isQueryKeyExpression()) {
                if (((QueryKeyExpression)expression).getBaseExpression() == ((QueryKeyExpression)expression).getBuilder()) {
                    if (databaseMapping == null) {
                        throw QueryException.specifiedPartialAttributeDoesNotExist(this, string, descriptor.getJavaClass().getName());
                    }
                    if (databaseMapping.isDirectToFieldMapping()) {
                        DatabaseField databaseField = ((AbstractDirectMapping)databaseMapping).getField();
                        if (descriptor.getPrimaryKeyFields().contains(databaseField)) continue;
                        vector.addElement(expression);
                        continue;
                    }
                    vector.addElement(expression);
                    continue;
                }
                vector.addElement(expression);
                continue;
            }
            vector.addElement(expression);
        }
        return vector;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public QueryByExamplePolicy getQueryByExamplePolicy() {
        if (this.getQueryMechanism().isQueryByExampleMechanism()) {
            return ((QueryByExampleMechanism)this.getQueryMechanism()).getQueryByExamplePolicy();
        }
        return null;
    }

    public Class getReferenceClass() {
        return this.referenceClass;
    }

    public String getReferenceClassName() {
        if (this.referenceClassName == null && this.referenceClass != null) {
            this.referenceClassName = this.referenceClass.getName();
        }
        return this.referenceClassName;
    }

    public ExpressionRepresentation getSelectionCriteriaForPersistence() {
        Expression expression = this.getSelectionCriteria();
        ExpressionRepresentation expressionRepresentation = null;
        if (expression != null) {
            expressionRepresentation = ExpressionRepresentation.convertFromRuntime(expression);
        }
        return expressionRepresentation;
    }

    public boolean hasAsOfClause() {
        return this.defaultBuilder != null && this.defaultBuilder.hasAsOfClause();
    }

    public boolean hasJoinedAttributes() {
        return this.joinedAttributeExpressions != null && !this.joinedAttributeExpressions.isEmpty() || this.joinedMappingExpressions != null && !this.joinedMappingExpressions.isEmpty();
    }

    public boolean hasPartialAttributeExpressions() {
        return this.partialAttributeExpressions != null && !this.partialAttributeExpressions.isEmpty();
    }

    public boolean hasAdditionalFields() {
        return this.additionalFields != null && !this.additionalFields.isEmpty();
    }

    public Vector getPartialAttributeSelectionFields() {
        Vector vector;
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(this.getPartialAttributeExpressions().size());
        ((Vector)nonSynchronizedVector).addAll(this.getDescriptor().getPrimaryKeyFields());
        if (this.getDescriptor().hasInheritance() && this.getDescriptor().getInheritancePolicy().getClassIndicatorField() != null) {
            ((Vector)nonSynchronizedVector).addElement(this.getDescriptor().getInheritancePolicy().getClassIndicatorField());
        }
        if ((vector = this.getPartialAttributeExpressionsWithoutKeyFields(this.getDescriptor())) != null) {
            Helper.addAllToVector(nonSynchronizedVector, vector);
        }
        return nonSynchronizedVector;
    }

    public Vector getFetchGroupSelectionFields() {
        Cloneable cloneable;
        Object object;
        Object object2;
        HashSet<Object> hashSet = new HashSet<Object>(this.getFetchGroup().getAttributes().size() + 2);
        hashSet.addAll(this.getDescriptor().getPrimaryKeyFields());
        if (this.getDescriptor().hasInheritance() && this.getDescriptor().getInheritancePolicy().getClassIndicatorField() != null) {
            hashSet.add(this.getDescriptor().getInheritancePolicy().getClassIndicatorField());
        }
        if (this.shouldMaintainCache() && this.getDescriptor().usesOptimisticLocking() && (object2 = this.getDescriptor().getOptimisticLockingPolicy().getWriteLockField()) != null) {
            hashSet.add(object2);
        }
        object2 = this.getFetchGroup().getAttributes().iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            cloneable = this.getDescriptor().getObjectBuilder().getMappingForAttributeName((String)object);
            if (cloneable == null) {
                throw QueryException.fetchGroupAttributeNotMapped((String)object);
            }
            hashSet.addAll(cloneable.getFields());
        }
        object2 = NonSynchronizedVector.newInstance(this.getFetchGroup().getAttributes().size() + 2);
        object = this.getDescriptor().getFields().iterator();
        while (object.hasNext()) {
            cloneable = (DatabaseField)object.next();
            if (hashSet.contains(cloneable)) {
                ((Vector)object2).add(cloneable);
                continue;
            }
            ((Vector)object2).add(null);
        }
        if (this.hasJoinedAttributes()) {
            Helper.addAllToVector((Vector)object2, this.getJoinedAttributeExpressions());
            Helper.addAllToVector((Vector)object2, this.getJoinedMappingExpressions());
        }
        if (this.hasAdditionalFields()) {
            Helper.addAllToVector((Vector)object2, this.getAdditionalFields());
        }
        return object2;
    }

    public Vector getSelectionFields() {
        if (this.hasPartialAttributeExpressions()) {
            return this.getPartialAttributeSelectionFields();
        }
        if (this.hasFetchGroup()) {
            return this.getFetchGroupSelectionFields();
        }
        if (this.hasJoinedAttributes()) {
            NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(this.getDescriptor().getAllFields().size() + this.getJoinedAttributeExpressions().size() + this.getJoinedMappingExpressions().size());
            Helper.addAllToVector(nonSynchronizedVector, this.getDescriptor().getAllFields());
            this.addSelectionFieldsForJoinedExpressions(nonSynchronizedVector, this.getJoinedAttributeExpressions());
            this.addSelectionFieldsForJoinedExpressions(nonSynchronizedVector, this.getJoinedMappingExpressions());
            return nonSynchronizedVector;
        }
        return this.getDescriptor().getAllFields();
    }

    protected int computeIndexesForJoinedExpressions(Vector vector, int n) {
        for (int i = 0; i < vector.size(); ++i) {
            ObjectExpression objectExpression = (ObjectExpression)vector.get(i);
            objectExpression.getBuilder().setSession(this.getSession());
            objectExpression.getBuilder().setQueryClass(this.getReferenceClass());
            if (objectExpression.getBaseExpression() == objectExpression.getBuilder() && objectExpression.getMapping().isForeignReferenceMapping()) {
                this.getJoinedMappingIndexes().put(objectExpression.getMapping(), new Integer(n));
            }
            Descriptor descriptor = objectExpression.getMapping().getReferenceDescriptor();
            n += descriptor.getFields().size();
        }
        return n;
    }

    protected void computeNestedQueriesForJoinedExpressions(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            ObjectExpression objectExpression = (ObjectExpression)vector.get(i);
            objectExpression.getBuilder().setSession(this.getSession());
            objectExpression.getBuilder().setQueryClass(this.getReferenceClass());
            ObjectExpression objectExpression2 = objectExpression;
            while (!objectExpression2.getBaseExpression().isExpressionBuilder()) {
                objectExpression2 = (ObjectExpression)((QueryKeyExpression)objectExpression2).getBaseExpression();
            }
            this.joinedAttributes.add(objectExpression2.getName());
            if (objectExpression.getBaseExpression() != objectExpression.getBuilder() || !objectExpression.getMapping().isForeignReferenceMapping()) continue;
            ForeignReferenceMapping foreignReferenceMapping = (ForeignReferenceMapping)objectExpression.getMapping();
            ObjectLevelReadQuery objectLevelReadQuery = foreignReferenceMapping.prepareNestedJoinQuery(this);
            this.getJoinedMappingQueries().put(foreignReferenceMapping, objectLevelReadQuery);
        }
    }

    public void computeJoiningMappingIndexes(boolean bl) {
        if (!this.hasJoinedAttributes() || this.hasPartialAttributeExpressions()) {
            return;
        }
        this.setJoinedMappingIndexes(new HashMap(this.getJoinedAttributeExpressions().size() + this.getJoinedMappingExpressions().size()));
        int n = 0;
        n = bl ? this.getDescriptor().getAllFields().size() : this.getDescriptor().getFields().size();
        n = this.computeIndexesForJoinedExpressions(this.getJoinedAttributeExpressions(), n);
        this.computeIndexesForJoinedExpressions(this.getJoinedMappingExpressions(), n);
    }

    public void computeJoiningMappingQueries() {
        if (this.hasJoinedAttributes() && !this.hasPartialAttributeExpressions()) {
            this.joinedAttributes = new ArrayList(this.getJoinedAttributeExpressions().size() + this.getJoinedMappingExpressions().size());
            this.setJoinedMappingQueries(new HashMap(this.getJoinedAttributeExpressions().size() + this.getJoinedMappingExpressions().size()));
            this.computeNestedQueriesForJoinedExpressions(this.getJoinedAttributeExpressions());
            this.computeNestedQueriesForJoinedExpressions(this.getJoinedMappingExpressions());
        }
    }

    protected void initializeDefaultBuilder() {
        DatabaseQueryMechanism databaseQueryMechanism = this.getQueryMechanism();
        if (databaseQueryMechanism.isExpressionQueryMechanism() && ((ExpressionQueryMechanism)databaseQueryMechanism).getExpressionBuilder() != null) {
            this.defaultBuilder = ((ExpressionQueryMechanism)databaseQueryMechanism).getExpressionBuilder();
            return;
        }
        this.defaultBuilder = new ExpressionBuilder();
    }

    protected boolean isAttributeNameInJoinedExpressionList(String string, Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            QueryKeyExpression queryKeyExpression = (QueryKeyExpression)enumeration.nextElement();
            while (!queryKeyExpression.getBaseExpression().isExpressionBuilder()) {
                queryKeyExpression = (QueryKeyExpression)queryKeyExpression.getBaseExpression();
            }
            if (!queryKeyExpression.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isAttributeJoined(Descriptor descriptor, String string) {
        if (!this.hasJoinedAttributes()) {
            return false;
        }
        if (descriptor.isAggregateDescriptor() && descriptor != this.getDescriptor()) {
            return false;
        }
        if (this.joinedAttributes != null) {
            return this.joinedAttributes.contains(string);
        }
        return this.isAttributeExpressionJoined(string) || this.isAttributeMappingJoined(string);
    }

    protected boolean isAttributeExpressionJoined(String string) {
        return this.isAttributeNameInJoinedExpressionList(string, this.getJoinedAttributeExpressions());
    }

    protected boolean isAttributeMappingJoined(String string) {
        return this.isAttributeNameInJoinedExpressionList(string, this.getJoinedMappingExpressions());
    }

    public boolean isDistinctComputed() {
        return this.getDistinctState() != 0;
    }

    public boolean isLockQuery() {
        return this.getLockMode() > 0;
    }

    public boolean isLockQuery(oracle.toplink.sessions.Session session) {
        this.checkPrePrepare((Session)session);
        return this.isLockQuery();
    }

    public boolean isObjectLevelReadQuery() {
        return true;
    }

    public boolean isPartialAttribute(String string) {
        if (!this.hasPartialAttributeExpressions()) {
            return false;
        }
        Vector vector = this.getPartialAttributeExpressions();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            QueryKeyExpression queryKeyExpression = (QueryKeyExpression)vector.get(i);
            while (!queryKeyExpression.getBaseExpression().isExpressionBuilder()) {
                queryKeyExpression = (QueryKeyExpression)queryKeyExpression.getBaseExpression();
            }
            if (!queryKeyExpression.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    protected boolean isPrePrepared() {
        return this.isPrePrepared;
    }

    protected boolean isRegisteringResults() {
        return this.shouldRegisterResultsInUnitOfWork() && this.getDescriptor().shouldRegisterResultsInUnitOfWork() || this.isLockQuery();
    }

    protected void setIsPrePrepared(boolean bl) {
        if (this.isPrePrepared && !bl) {
            this.setIsPrepared(false);
            this.joinedMappingExpressions = null;
        }
        this.isPrePrepared = bl;
    }

    public void setIsPrepared(boolean bl) {
        super.setIsPrepared(bl);
        this.isReferenceClassLocked = null;
    }

    protected void prepare() throws QueryException {
        super.prepare();
        this.prepareQuery();
        this.computeJoiningMappingQueries();
    }

    protected void prePrepare() throws QueryException {
        Cloneable cloneable;
        this.buildSelectionCriteria(this.session);
        this.checkDescriptor(this.session);
        if (this.getQueryMechanism().isExpressionQueryMechanism() && ((ObjectBuilder)(cloneable = this.getDescriptor().getObjectBuilder())).hasJoinedAttributes()) {
            Vector vector = ((ObjectBuilder)cloneable).getJoinedAttributes();
            if (!this.hasJoinedAttributes()) {
                for (int i = 0; i < vector.size(); ++i) {
                    this.addJoinedMapping((String)vector.get(i));
                }
            } else {
                for (int i = 0; i < vector.size(); ++i) {
                    String string = (String)vector.get(i);
                    if (this.isAttributeExpressionJoined(string)) continue;
                    this.addJoinedMapping(string);
                }
            }
        }
        if (this.isDefaultLock()) {
            this.setWasDefaultLockMode(true);
            cloneable = null;
            if (this.descriptor.hasPessimisticLockingPolicy()) {
                cloneable = new ForUpdateOfClause();
                ((ForUpdateOfClause)cloneable).setLockMode(this.descriptor.getCMPPolicy().getPessimisticLockingPolicy().getLockingMode());
                ((ForUpdateOfClause)cloneable).addLockedExpression(this.getExpressionBuilder());
            }
            if (this.hasJoinedAttributes()) {
                cloneable = this.setupLockingClauseForJoinedExpressions(this.getJoinedAttributeExpressions(), (ForUpdateOfClause)cloneable);
                cloneable = this.setupLockingClauseForJoinedExpressions(this.getJoinedMappingExpressions(), (ForUpdateOfClause)cloneable);
            }
            if (cloneable == null) {
                this.lockingClause = ForUpdateClause.newInstance((short)0);
            } else {
                this.lockingClause = cloneable;
                this.dontUseDistinct();
            }
        } else if (this.getLockMode() == 0 && !this.descriptor.hasPessimisticLockingPolicy()) {
            this.setWasDefaultLockMode(true);
        }
    }

    protected void prepareQuery() throws QueryException {
        Expression expression;
        int n;
        if (!this.shouldMaintainCache() && this.shouldRefreshIdentityMapResult() && !this.descriptor.isAggregateCollectionDescriptor()) {
            throw QueryException.refreshNotPossibleWithoutCache(this);
        }
        if (this.shouldMaintainCache() && this.hasPartialAttributeExpressions()) {
            throw QueryException.cannotCachePartialObjects(this);
        }
        if (this.descriptor.isAggregateDescriptor()) {
            throw QueryException.aggregateObjectCannotBeDeletedOrWritten(this.descriptor, this);
        }
        if (this.hasAsOfClause() && this.getSession().getAsOfClause() == null) {
            if (this.shouldMaintainCache()) {
                throw QueryException.historicalQueriesMustPreserveGlobalCache();
            }
            if (!this.getSession().getPlatform().isOracle() && !this.getSession().getProject().hasGenericHistorySupport()) {
                throw QueryException.historicalQueriesOnlySupportedOnOracle();
            }
        }
        if (!(this.getDescriptor().hasFetchGroupManager() || this.getFetchGroup() == null && this.getFetchGroupName() == null)) {
            throw QueryException.fetchGroupValidOnlyIfFetchGroupManagerInDescriptor(this.getDescriptor().getJavaClassName(), this.getName());
        }
        if (this.getDescriptor().hasFetchGroupManager()) {
            this.getDescriptor().getFetchGroupManager().prepareQueryWithFetchGroup(this);
        }
        if (this.hasJoinedAttributes()) {
            this.setIsOuterJoinedAttributeQuery(false);
            for (n = 0; n < this.getJoinedAttributeExpressions().size(); ++n) {
                expression = (Expression)this.getJoinedAttributeExpressions().get(n);
                this.prepareJoinExpression(expression);
            }
            for (n = 0; n < this.getJoinedMappingExpressions().size(); ++n) {
                expression = (Expression)this.getJoinedMappingExpressions().get(n);
                this.prepareJoinExpression(expression);
            }
        } else {
            this.setIsOuterJoinedAttributeQuery(true);
            this.joinedAttributes = null;
            this.joinedMappingIndexes = null;
            this.joinedMappingQueries = null;
        }
        if (this.hasPartialAttributeExpressions()) {
            for (n = 0; n < this.getPartialAttributeExpressions().size(); ++n) {
                expression = (Expression)this.getPartialAttributeExpressions().get(n);
                while (expression.isQueryKeyExpression() && !expression.isExpressionBuilder()) {
                    if (((QueryKeyExpression)expression).shouldQueryToManyRelationship()) {
                        this.setIsOneToManyJoinQuery(true);
                    }
                    expression = ((QueryKeyExpression)expression).getBaseExpression();
                }
            }
        }
    }

    protected void prepareJoinExpression(Expression expression) {
        if (!expression.isQueryKeyExpression()) {
            throw QueryException.mappingForExpressionDoesNotSupportJoining(expression);
        }
        QueryKeyExpression queryKeyExpression = (QueryKeyExpression)expression;
        queryKeyExpression.getBuilder().setSession(this.getSession());
        queryKeyExpression.getBuilder().setQueryClass(this.getReferenceClass());
        if (queryKeyExpression.getMapping() == null || !queryKeyExpression.getMapping().isJoiningSupported()) {
            throw QueryException.mappingForExpressionDoesNotSupportJoining(queryKeyExpression);
        }
        Descriptor descriptor = queryKeyExpression.getMapping().getReferenceDescriptor();
        if (descriptor != null && descriptor.hasInheritance() && descriptor.getInheritancePolicy().hasMultipleTableChild() && descriptor.getInheritancePolicy().shouldReadSubclasses()) {
            throw QueryException.joiningAcrossInheritanceClassWithMultipleTablesNotSupported(this, descriptor.getJavaClass());
        }
        ObjectExpression objectExpression = queryKeyExpression;
        while (!objectExpression.isExpressionBuilder()) {
            if (objectExpression.shouldQueryToManyRelationship()) {
                this.setIsOneToManyJoinQuery(true);
            }
            if (objectExpression.shouldUseOuterJoin()) {
                this.setIsOuterJoinedAttributeQuery(true);
            }
            objectExpression = (ObjectExpression)objectExpression.getBaseExpression();
        }
    }

    protected void prepareForRemoteExecution() throws QueryException {
        super.prepareForRemoteExecution();
        this.checkPrePrepare(this.getSession());
        this.prepareQuery();
    }

    public void refreshIdentityMapResult() {
        this.setShouldRefreshIdentityMapResult(true);
    }

    public void refreshRemoteIdentityMapResult() {
        this.setShouldRefreshRemoteIdentityMapResult(true);
    }

    public Object registerIndividualResult(Object object, UnitOfWork unitOfWork) {
        if (unitOfWork.isClassReadOnly(object.getClass())) {
            this.recordCloneForPessimisticLocking(object, unitOfWork);
            return object;
        }
        Object object2 = null;
        if (!this.isRegisteringResults()) {
            object2 = unitOfWork.getIdentityMapAccessorInstance().getIdentityMapManager().getFromIdentityMap(object);
            if (object2 == null) {
                object2 = object;
            }
        } else {
            object2 = unitOfWork.registerExistingObject(object);
        }
        if (this.shouldRefreshIdentityMapResult()) {
            if (unitOfWork.getParent().getIdentityMapAccessor().containsObjectInIdentityMap(object2)) {
                if (this.shouldCascadeAllParts()) {
                    unitOfWork.deepRevertObject(object2);
                } else if (this.shouldCascadePrivateParts()) {
                    unitOfWork.revertObject(object2);
                } else if (this.shouldCascadeByMapping()) {
                    unitOfWork.revertObject(object2, 4);
                } else if (!this.shouldCascadeParts()) {
                    unitOfWork.shallowRevertObject(object2);
                }
            } else if (this.shouldCascadeAllParts()) {
                unitOfWork.deepMergeClone(object);
            } else if (this.shouldCascadePrivateParts()) {
                unitOfWork.mergeClone(object);
            } else if (this.shouldCascadeByMapping()) {
                unitOfWork.mergeClone(object, 4);
            } else if (!this.shouldCascadeParts()) {
                unitOfWork.shallowMergeClone(object);
            }
        }
        return object2;
    }

    public abstract Object registerResultInUnitOfWork(Object var1, UnitOfWork var2, DatabaseRow var3, boolean var4);

    public void resetDistinct() {
        this.setDistinctState((short)0);
        this.setIsPrepared(false);
    }

    public void setAdditionalFields(Vector vector) {
        this.additionalFields = vector;
    }

    public void setCacheUsage(int n) {
        this.cacheUsage = n;
    }

    public void setDistinctState(short s) {
        this.distinctState = s;
    }

    public void setExecutionTime(long l) {
        this.executionTime = l;
    }

    public void setExampleObject(Object object) {
        if (!this.getQueryMechanism().isQueryByExampleMechanism()) {
            this.setQueryMechanism(new QueryByExampleMechanism((DatabaseQuery)this, this.getSelectionCriteria()));
            ((QueryByExampleMechanism)this.getQueryMechanism()).setExampleObject(object);
            this.setIsPrepared(false);
        } else {
            ((QueryByExampleMechanism)this.getQueryMechanism()).setExampleObject(object);
            if (this.isPrepared() || !this.shouldPrepare() && ((QueryByExampleMechanism)this.getQueryMechanism()).isParsed()) {
                ((QueryByExampleMechanism)this.getQueryMechanism()).setIsParsed(false);
                this.setSelectionCriteria(null);
            }
        }
        if (object != null) {
            this.setReferenceClass(object.getClass());
        }
    }

    public void setInMemoryQueryIndirectionPolicy(InMemoryQueryIndirectionPolicy inMemoryQueryIndirectionPolicy) {
        if (inMemoryQueryIndirectionPolicy != null) {
            this.inMemoryQueryIndirectionPolicy = inMemoryQueryIndirectionPolicy;
        }
    }

    public Map getJoinedMappingIndexes() {
        return this.joinedMappingIndexes;
    }

    public Map getJoinedMappingQueries() {
        return this.joinedMappingQueries;
    }

    public Map getJoinedMappingQueryClones() {
        return this.joinedMappingQueryClones;
    }

    protected void setJoinedMappingQueries(Map map) {
        this.joinedMappingQueries = map;
    }

    public void setJoinedMappingQueryClones(Map map) {
        this.joinedMappingQueryClones = map;
    }

    public void setJoinedMappingIndexes(Map map) {
        this.joinedMappingIndexes = map;
    }

    public void setJoinedAttributeExpressions(Vector vector) {
        this.joinedAttributeExpressions = vector;
        this.setIsPrePrepared(false);
    }

    public void setLockMode(short s) {
        if (s == 1 || s == 2) {
            this.lockingClause = ForUpdateClause.newInstance(s);
            this.setShouldRefreshIdentityMapResult(true);
        } else if (s == 0) {
            this.lockingClause = ForUpdateClause.newInstance(s);
        } else {
            this.lockingClause = null;
            this.setIsPrePrepared(false);
        }
        this.setIsPrepared(false);
    }

    public void setLockingClause(ForUpdateClause forUpdateClause) {
        if (forUpdateClause.isForUpdateOfClause()) {
            this.lockingClause = forUpdateClause;
            this.setIsPrePrepared(false);
        } else {
            this.setLockMode(forUpdateClause.getLockMode());
        }
    }

    public void setPartialAttributeExpressions(Vector vector) {
        this.partialAttributeExpressions = vector;
    }

    public void setEJBQLString(String string) {
        super.setEJBQLString(string);
        this.setIsPrePrepared(false);
    }

    public void setQueryByExamplePolicy(QueryByExamplePolicy queryByExamplePolicy) {
        if (!this.getQueryMechanism().isQueryByExampleMechanism()) {
            this.setQueryMechanism(new QueryByExampleMechanism((DatabaseQuery)this, this.getSelectionCriteria()));
            ((QueryByExampleMechanism)this.getQueryMechanism()).setQueryByExamplePolicy(queryByExamplePolicy);
            this.setIsPrepared(false);
        } else {
            ((QueryByExampleMechanism)this.getQueryMechanism()).setQueryByExamplePolicy(queryByExamplePolicy);
            if (this.isPrepared() || !this.shouldPrepare() && ((QueryByExampleMechanism)this.getQueryMechanism()).isParsed()) {
                ((QueryByExampleMechanism)this.getQueryMechanism()).setIsParsed(false);
                this.setSelectionCriteria(null);
            }
        }
        this.setIsPrePrepared(false);
    }

    public void setReferenceClass(Class clazz) {
        if (this.referenceClass != clazz) {
            this.setIsPrepared(false);
        }
        this.referenceClass = clazz;
    }

    public void setReferenceClassName(String string) {
        if (this.referenceClassName != string) {
            this.setIsPrepared(false);
        }
        this.referenceClassName = string;
    }

    public void setSelectionCriteriaFromPersistence(ExpressionRepresentation expressionRepresentation) {
        Expression expression = null;
        if (expressionRepresentation != null) {
            expression = expressionRepresentation.convertToRuntime(this.getExpressionBuilder());
            this.setSelectionCriteria(expression);
        }
    }

    public void setSelectionCriteria(Expression expression) {
        ExpressionBuilder expressionBuilder;
        super.setSelectionCriteria(expression);
        if (expression != null && this.defaultBuilder != null && (expressionBuilder = expression.getBuilder()) != this.defaultBuilder) {
            if (this.hasAsOfClause() && this.getAsOfClause().isUniversal()) {
                expressionBuilder.asOf(this.defaultBuilder.getAsOfClause());
            }
            this.defaultBuilder = expressionBuilder;
        }
    }

    public void setShouldIncludeData(boolean bl) {
        this.shouldIncludeData = bl;
    }

    public void setShouldRefreshIdentityMapResult(boolean bl) {
        this.shouldRefreshIdentityMapResult = bl;
        if (bl) {
            this.setShouldRefreshRemoteIdentityMapResult(true);
        }
    }

    public void setShouldRefreshRemoteIdentityMapResult(boolean bl) {
        this.shouldRefreshRemoteIdentityMapResult = bl;
    }

    public void setShouldRegisterResultsInUnitOfWork(boolean bl) {
        this.shouldRegisterResultsInUnitOfWork = bl;
    }

    public void setShouldUseExclusiveConnection(boolean bl) {
        this.shouldUseExclusiveConnection = bl;
    }

    private ForUpdateOfClause setupLockingClauseForJoinedExpressions(Vector vector, ForUpdateOfClause forUpdateOfClause) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Expression expression = (Expression)enumeration.nextElement();
            if (!expression.isObjectExpression()) continue;
            ObjectExpression objectExpression = (ObjectExpression)expression;
            objectExpression.getBuilder().setSession(this.getSession());
            objectExpression.getBuilder().setQueryClass(this.getReferenceClass());
            Descriptor descriptor = objectExpression.getDescriptor();
            if (descriptor == null) {
                return forUpdateOfClause;
            }
            if (!descriptor.hasPessimisticLockingPolicy()) continue;
            if (forUpdateOfClause == null) {
                forUpdateOfClause = new ForUpdateOfClause();
                forUpdateOfClause.setLockMode(descriptor.getCMPPolicy().getPessimisticLockingPolicy().getLockingMode());
            }
            forUpdateOfClause.addLockedExpression(objectExpression);
        }
        return forUpdateOfClause;
    }

    public boolean shouldCheckCacheOnly() {
        return this.getCacheUsage() == 4;
    }

    public boolean shouldCheckDescriptorForCacheUsage() {
        return this.getCacheUsage() == -1;
    }

    public boolean shouldConformResultsInUnitOfWork() {
        return this.getCacheUsage() == 5;
    }

    public boolean shouldDistinctBeUsed() {
        return this.getDistinctState() == 1;
    }

    public boolean shouldIncludeData() {
        return this.shouldIncludeData;
    }

    public boolean shouldRegisterResultsInUnitOfWork() {
        return this.shouldRegisterResultsInUnitOfWork;
    }

    public boolean shouldReadAllMappings() {
        return !this.hasPartialAttributeExpressions() && !this.hasFetchGroup();
    }

    public boolean shouldReadMapping(DatabaseMapping databaseMapping) {
        if (!this.hasPartialAttributeExpressions() && !this.hasFetchGroup()) {
            return true;
        }
        String string = databaseMapping.getAttributeName();
        if (this.hasFetchGroup()) {
            return this.isFetchGroupAttribute(string);
        }
        return this.isPartialAttribute(string);
    }

    public boolean shouldRefreshIdentityMapResult() {
        return this.shouldRefreshIdentityMapResult;
    }

    public boolean shouldRefreshRemoteIdentityMapResult() {
        return this.shouldRefreshRemoteIdentityMapResult;
    }

    public String toString() {
        if (this.getReferenceClass() == null) {
            return super.toString();
        }
        return Helper.getShortClassName(this.getClass()) + "(" + this.getReferenceClass().getName() + ")";
    }

    public boolean shouldUseExclusiveConnection() {
        return this.shouldUseExclusiveConnection;
    }

    public void setShouldProcessResultsInUnitOfWork(boolean bl) {
        this.shouldProcessResultsInUnitOfWork = bl;
    }

    public boolean shouldProcessResultsInUnitOfWork() {
        return this.shouldProcessResultsInUnitOfWork;
    }

    public void useDistinct() {
        this.setDistinctState((short)1);
        this.setIsPrepared(false);
    }

    public boolean isClonePessimisticLocked(Object object, UnitOfWork unitOfWork) {
        return this.getDescriptor().hasPessimisticLockingPolicy() && unitOfWork.isPessimisticLocked(object);
    }

    protected boolean isReferenceClassLocked() {
        if (this.isReferenceClassLocked == null) {
            this.isReferenceClassLocked = this.isLockQuery() && this.lockingClause.isReferenceClassLocked();
        }
        return this.isReferenceClassLocked;
    }

    public void recordCloneForPessimisticLocking(Object object, UnitOfWork unitOfWork) {
        if (this.isReferenceClassLocked()) {
            unitOfWork.addPessimisticLockedClone(object);
        }
    }

    public boolean isDefaultLock() {
        return this.lockingClause == null;
    }

    public boolean hasFetchGroup() {
        return this.fetchGroup != null;
    }

    public FetchGroup getFetchGroup() {
        return this.fetchGroup;
    }

    public void initializeFetchGroup() {
        if (this.fetchGroup != null) {
            return;
        }
        if (this.fetchGroupName != null) {
            this.fetchGroup = this.getDescriptor().getFetchGroupManager().getFetchGroup(this.fetchGroupName);
            if (this.fetchGroup == null) {
                throw QueryException.fetchGroupNotDefinedInDescriptor(this.fetchGroupName);
            }
        } else if (this.shouldUseDefaultFetchGroup()) {
            this.fetchGroup = this.getDescriptor().getDefaultFetchGroup();
        }
    }

    public void setFetchGroup(FetchGroup fetchGroup) {
        this.fetchGroup = fetchGroup;
    }

    public void setFetchGroupName(String string) {
        this.fetchGroup = null;
        this.fetchGroupName = string;
    }

    public String getFetchGroupName() {
        return this.fetchGroupName;
    }

    public boolean shouldUseDefaultFetchGroup() {
        return this.shouldUseDefaultFetchGroup;
    }

    public void setShouldUseDefaultFetchGroup(boolean bl) {
        this.shouldUseDefaultFetchGroup = bl;
    }

    public boolean isFetchGroupAttribute(String string) {
        if (this.getFetchGroup() == null) {
            return true;
        }
        return this.getFetchGroup().getAttributes().contains(string);
    }
}

