/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.queryframework;

import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.expressions.ExpressionBuilder;
import oracle.toplink.expressions.ExpressionOperator;
import oracle.toplink.internal.databaseaccess.DatabaseCall;
import oracle.toplink.internal.expressions.SQLSelectStatement;
import oracle.toplink.internal.expressions.SQLStatement;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.helper.IdentityHashtable;
import oracle.toplink.internal.queryframework.ExpressionQueryMechanism;
import oracle.toplink.queryframework.Cursor;
import oracle.toplink.queryframework.CursoredStreamPolicy;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ReadAllQuery;
import oracle.toplink.queryframework.ValueReadQuery;

public class CursoredStream
extends Cursor {
    protected int marker;

    public CursoredStream() {
    }

    public CursoredStream(DatabaseCall databaseCall, CursoredStreamPolicy cursoredStreamPolicy) {
        super(databaseCall, cursoredStreamPolicy);
        try {
            this.setLimits();
        }
        catch (RuntimeException runtimeException) {
            try {
                this.close();
            }
            catch (RuntimeException runtimeException2) {
                // empty catch block
            }
            throw runtimeException;
        }
    }

    public boolean atEnd() throws DatabaseException {
        if (this.getPosition() + 1 <= this.getObjectCollection().size()) {
            return false;
        }
        if (this.isClosed()) {
            return true;
        }
        int n = this.getObjectCollection().size();
        this.retrieveNextPage();
        return this.getObjectCollection().size() == n;
    }

    public int available() throws DatabaseException {
        return this.getObjectCollection().size() - this.getPosition();
    }

    public Expression buildCountDistinctExpression(List list, ExpressionBuilder expressionBuilder) {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setType(3);
        Vector<String> vector = new Vector<String>();
        vector.addElement("COUNT(DISTINCT ");
        vector.addElement(")");
        expressionOperator.printsAs(vector);
        expressionOperator.bePrefix();
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        Expression expression = expressionBuilder.getField(((DatabaseField)list.get(0)).getQualifiedName());
        return expressionOperator.expressionForArguments(expression, new Vector(0));
    }

    protected Vector copy(int n, int n2) throws QueryException {
        while (this.getObjectCollection().size() < n2) {
            if (this.retrieveNextObject() != null) continue;
            throw QueryException.readBeyondStream(this.getQuery());
        }
        return Helper.copyVector(this.getObjectCollection(), n, n2);
    }

    protected int getCursorSize() throws DatabaseException, QueryException {
        ValueReadQuery valueReadQuery;
        Serializable serializable;
        if (!((CursoredStreamPolicy)this.getPolicy()).hasSizeQuery()) {
            if (!this.getQuery().isExpressionQuery()) {
                throw QueryException.sizeOnlySupportedOnExpressionQueries(this.getQuery());
            }
            serializable = new SQLSelectStatement();
            IdentityHashtable identityHashtable = new IdentityHashtable();
            ((SQLStatement)serializable).setWhereClause(((ExpressionQueryMechanism)this.getQuery().getQueryMechanism()).buildBaseSelectionCriteria(false, identityHashtable));
            if (this.getQuery().getDescriptor().hasInheritance() && this.getQuery().getDescriptor().getInheritancePolicy().getWithAllSubclassesExpression() != null) {
                Expression expression = this.getQuery().getDescriptor().getInheritancePolicy().getWithAllSubclassesExpression();
                if (expression != null && ((SQLStatement)serializable).getWhereClause() != null) {
                    ((SQLStatement)serializable).setWhereClause(((SQLStatement)serializable).getWhereClause().and(expression));
                } else if (expression != null) {
                    ((SQLStatement)serializable).setWhereClause((Expression)expression.clone());
                }
            }
            ((SQLSelectStatement)serializable).setTables((Vector)this.getQuery().getDescriptor().getTables().clone());
            if (((ReadAllQuery)this.getQuery()).shouldDistinctBeUsed() && this.getQuery().getCall().getFields().size() == 1) {
                ((SQLSelectStatement)serializable).addField(this.buildCountDistinctExpression(this.getQuery().getCall().getFields(), ((ReadAllQuery)this.getQuery()).getExpressionBuilder()));
            } else {
                ((SQLSelectStatement)serializable).computeDistinct();
                if (((SQLSelectStatement)serializable).shouldDistinctBeUsed() && this.getQuery().getDescriptor().getPrimaryKeyFields().size() == 1) {
                    ((SQLSelectStatement)serializable).addField(this.buildCountDistinctExpression(this.getQuery().getDescriptor().getPrimaryKeyFields(), ((ReadAllQuery)this.getQuery()).getExpressionBuilder()));
                } else {
                    ((SQLSelectStatement)serializable).addField(((ReadAllQuery)this.getQuery()).getExpressionBuilder().count());
                }
                ((SQLSelectStatement)serializable).dontUseDistinct();
            }
            ((SQLSelectStatement)serializable).normalize(this.getSession(), this.getQuery().getDescriptor(), identityHashtable);
            valueReadQuery = new ValueReadQuery();
            valueReadQuery.setSQLStatement((SQLStatement)serializable);
        } else {
            valueReadQuery = ((CursoredStreamPolicy)this.getPolicy()).getSizeQuery();
        }
        serializable = (Number)this.getSession().executeQuery((DatabaseQuery)valueReadQuery, this.getQuery().getTranslationRow());
        if (serializable == null) {
            throw QueryException.incorrectSizeQueryForCursorStream(this.getQuery());
        }
        return ((Number)serializable).intValue();
    }

    protected int getInitialReadSize() {
        return ((CursoredStreamPolicy)this.getPolicy()).getInitialReadSize();
    }

    protected int getMarker() {
        return this.marker;
    }

    public int getPageSize() {
        return ((CursoredStreamPolicy)this.getPolicy()).getPageSize();
    }

    public int getPosition() {
        return this.position;
    }

    public boolean hasMoreElements() {
        return !this.atEnd();
    }

    public void mark(int n) {
        this.setMarker(this.getPosition());
    }

    public boolean markSupported() {
        return true;
    }

    public Object nextElement() {
        return this.read();
    }

    public Vector nextElements(int n) {
        Vector<Object> vector = new Vector<Object>(n);
        while (vector.size() < n) {
            if (this.atEnd()) {
                return vector;
            }
            vector.add(this.nextElement());
        }
        return vector;
    }

    public Object peek() throws DatabaseException {
        Object object = this.read();
        this.setPosition(this.getPosition() - 1);
        return object;
    }

    public Object read() throws DatabaseException, QueryException {
        if (this.getObjectCollection().size() == this.getPosition()) {
            this.retrieveNextPage();
        }
        if (this.atEnd()) {
            throw QueryException.readBeyondStream(this.getQuery());
        }
        Object e = this.getObjectCollection().elementAt(this.getPosition());
        this.setPosition(this.getPosition() + 1);
        return e;
    }

    public Vector read(int n) throws DatabaseException {
        Vector vector = this.copy(this.getPosition(), this.getPosition() + n);
        this.setPosition(this.getPosition() + vector.size());
        return vector;
    }

    public void releasePrevious() {
        if (this.getPosition() == 0) {
            return;
        }
        this.setObjectCollection(Helper.copyVector(this.getObjectCollection(), this.getPosition(), this.getObjectCollection().size()));
        this.setPosition(0);
    }

    public void reset() {
        this.setPosition(this.getMarker());
    }

    protected Object retrieveNextObject() throws DatabaseException {
        Object object = super.retrieveNextObject();
        if (object != null) {
            this.getObjectCollection().addElement(object);
        }
        return object;
    }

    protected Object retrieveNextPage() throws DatabaseException {
        Object object = null;
        for (int i = 0; i < this.getPageSize(); ++i) {
            object = this.retrieveNextObject();
            if (object != null) continue;
            return null;
        }
        return object;
    }

    protected void setLimits() {
        this.setPosition(0);
        this.setMarker(0);
        for (int i = 0; i < this.getInitialReadSize(); ++i) {
            this.retrieveNextObject();
        }
    }

    protected void setMarker(int n) {
        this.marker = n;
    }
}

