/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.publicinterface;

import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.descriptors.ClassDescriptor;
import oracle.toplink.exceptions.ConcurrencyException;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.ExceptionHandler;
import oracle.toplink.exceptions.IntegrityChecker;
import oracle.toplink.exceptions.OptimisticLockException;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.exceptions.TopLinkException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.history.AsOfClause;
import oracle.toplink.internal.databaseaccess.Accessor;
import oracle.toplink.internal.databaseaccess.DatabasePlatform;
import oracle.toplink.internal.databaseaccess.Platform;
import oracle.toplink.internal.descriptors.ObjectBuilder;
import oracle.toplink.internal.helper.ConcurrencyManager;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.helper.IdentityHashtable;
import oracle.toplink.internal.helper.NonSynchronizedVector;
import oracle.toplink.internal.helper.QueryCounter;
import oracle.toplink.internal.history.HistoricalSession;
import oracle.toplink.internal.identitymaps.IdentityMapManager;
import oracle.toplink.internal.indirection.ProxyIndirectionPolicy;
import oracle.toplink.internal.sequencing.Sequencing;
import oracle.toplink.internal.sessions.CommitManager;
import oracle.toplink.internal.sessions.IdentityMapAccessor;
import oracle.toplink.internal.sessions.UnitOfWorkChangeSet;
import oracle.toplink.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.logging.AbstractSessionLog;
import oracle.toplink.logging.DefaultSessionLog;
import oracle.toplink.logging.SessionLog;
import oracle.toplink.logging.SessionLogEntry;
import oracle.toplink.platform.server.ServerPlatform;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.Call;
import oracle.toplink.queryframework.DataModifyQuery;
import oracle.toplink.queryframework.DataReadQuery;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.DeleteObjectQuery;
import oracle.toplink.queryframework.DoesExistQuery;
import oracle.toplink.queryframework.InMemoryQueryIndirectionPolicy;
import oracle.toplink.queryframework.InsertObjectQuery;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.queryframework.ReadAllQuery;
import oracle.toplink.queryframework.ReadObjectQuery;
import oracle.toplink.queryframework.SQLCall;
import oracle.toplink.queryframework.UpdateObjectQuery;
import oracle.toplink.queryframework.WriteObjectQuery;
import oracle.toplink.remote.CacheSynchronizationManager;
import oracle.toplink.remotecommand.Command;
import oracle.toplink.remotecommand.CommandManager;
import oracle.toplink.remotecommand.CommandProcessor;
import oracle.toplink.sessions.DatabaseLogin;
import oracle.toplink.sessions.ExternalTransactionController;
import oracle.toplink.sessions.Login;
import oracle.toplink.sessions.ObjectCopyingPolicy;
import oracle.toplink.sessions.Project;
import oracle.toplink.sessions.SessionEventManager;
import oracle.toplink.sessions.SessionProfiler;
import oracle.toplink.threetier.ClientSession;

public abstract class Session
implements oracle.toplink.sessions.Session,
CommandProcessor,
Serializable,
Cloneable {
    protected transient ExceptionHandler exceptionHandler;
    protected transient IntegrityChecker integrityChecker;
    protected transient Project project;
    protected transient ConcurrencyManager transactionMutex;
    protected IdentityMapAccessor identityMapAccessor;
    protected boolean wasJTSTransactionInternallyStarted;
    protected transient Accessor accessor;
    protected transient Platform platform;
    protected transient Map queries;
    protected transient CommitManager commitManager;
    protected transient SessionProfiler profiler;
    protected transient Session broker;
    protected String name;
    protected transient int numberOfActiveUnitsOfWork;
    protected transient SessionLog sessionLog;
    protected transient String logSessionString;
    protected transient SessionEventManager eventManager;
    protected Map properties;
    protected transient ExternalTransactionController externalTransactionController;
    protected transient Descriptor lastDescriptorAccessed;
    protected transient CacheSynchronizationManager cacheSynchronizationManager;
    protected boolean isInBroker;
    protected boolean usesOldCommit;
    protected transient CommandManager commandManager;
    protected boolean shouldPropagateChanges;
    protected boolean isInProfile;
    protected boolean isFinalizersEnabled = true;
    static /* synthetic */ Class class$oracle$toplink$descriptors$ClassDescriptor;

    protected Session() {
        this.name = "";
        this.initializeIdentityMapAccessor();
        this.numberOfActiveUnitsOfWork = 0;
        this.isInBroker = false;
        this.usesOldCommit = false;
    }

    protected Session(int n) {
    }

    public Session(Login login) {
        this(new Project(login));
    }

    public Session(Project project) {
        this();
        this.project = project;
        if (project.getDatasourceLogin() == null) {
            throw ValidationException.projectLoginIsNull(this);
        }
    }

    public long getNextQueryId() {
        return QueryCounter.getCount();
    }

    public UnitOfWork acquireNonSynchronizedUnitOfWork() {
        this.setNumberOfActiveUnitsOfWork(this.getNumberOfActiveUnitsOfWork() + 1);
        UnitOfWorkImpl unitOfWorkImpl = new UnitOfWorkImpl(this);
        unitOfWorkImpl.setUseOldCommit(this.usesOldCommit());
        if (this.shouldLog(2, "transaction")) {
            this.log(2, "transaction", "acquire_unit_of_work_with_argument", String.valueOf(System.identityHashCode(unitOfWorkImpl)));
        }
        return unitOfWorkImpl;
    }

    public oracle.toplink.sessions.Session acquireHistoricalSession(AsOfClause asOfClause) throws ValidationException {
        if (asOfClause == null || asOfClause.getValue() == null) {
            throw ValidationException.cannotAcquireHistoricalSession();
        }
        if (!(this.getProject().hasGenericHistorySupport() || this.hasBroker() || this.getPlatform() != null && this.getPlatform().isOracle())) {
            throw ValidationException.historicalSessionOnlySupportedOnOracle();
        }
        return new HistoricalSession(this, asOfClause);
    }

    public UnitOfWork acquireUnitOfWork() {
        UnitOfWork unitOfWork = this.acquireNonSynchronizedUnitOfWork();
        unitOfWork.registerWithTransactionIfRequired();
        return unitOfWork;
    }

    public void addAlias(String string, Descriptor descriptor) {
        this.project.addAlias(string, descriptor);
    }

    public void addQuery(String string, DatabaseQuery databaseQuery) {
        databaseQuery.setName(string);
        this.addQuery(databaseQuery);
    }

    protected void addQuery(DatabaseQuery databaseQuery) {
        Vector vector = (Vector)this.getQueries().get(databaseQuery.getName());
        if (vector == null) {
            vector = NonSynchronizedVector.newInstance();
            this.getQueries().put(databaseQuery.getName(), vector);
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            DatabaseQuery databaseQuery2 = (DatabaseQuery)enumeration.nextElement();
            if (!Helper.areTypesAssignable(databaseQuery.getArgumentTypes(), databaseQuery2.getArgumentTypes())) continue;
            throw ValidationException.existingQueryTypeConflict(databaseQuery, databaseQuery2);
        }
        vector.add(databaseQuery);
    }

    protected void basicBeginTransaction() throws DatabaseException {
        try {
            this.getAccessor().beginTransaction(this);
        }
        catch (RuntimeException runtimeException) {
            this.handleException(runtimeException);
        }
    }

    public void afterTransaction(boolean bl, boolean bl2) {
    }

    protected void basicCommitTransaction() throws DatabaseException {
        try {
            this.getAccessor().commitTransaction(this);
        }
        catch (RuntimeException runtimeException) {
            this.handleException(runtimeException);
        }
    }

    protected void basicRollbackTransaction() throws DatabaseException {
        try {
            this.getAccessor().rollbackTransaction(this);
        }
        catch (RuntimeException runtimeException) {
            this.handleException(runtimeException);
        }
    }

    public boolean beginExternalTransaction() {
        boolean bl = false;
        if (this.hasExternalTransactionController() && !this.wasJTSTransactionInternallyStarted()) {
            try {
                this.getExternalTransactionController().beginTransaction(this);
            }
            catch (RuntimeException runtimeException) {
                this.handleException(runtimeException);
            }
            if (this.wasJTSTransactionInternallyStarted()) {
                bl = true;
                this.log(2, "transaction", "external_transaction_has_begun_internally");
            }
        }
        return bl;
    }

    public void beginTransaction() throws DatabaseException, ConcurrencyException {
        if (!this.isInTransaction()) {
            this.beginExternalTransaction();
        }
        if (this.isUnitOfWork() || this.isClientSession()) {
            this.getTransactionMutex().setActiveThread(Thread.currentThread());
        }
        this.getTransactionMutex().acquire();
        if (!this.getTransactionMutex().isNested()) {
            this.getEventManager().preBeginTransaction();
            this.basicBeginTransaction();
            this.getEventManager().postBeginTransaction();
        }
    }

    public void clearIntegrityChecker() {
        this.setIntegrityChecker(null);
    }

    public void clearLastDescriptorAccessed() {
        this.lastDescriptorAccessed = null;
    }

    public void clearProfile() {
        this.setProfiler(null);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected boolean commitExternalTransaction() {
        boolean bl = false;
        if (this.hasExternalTransactionController() && this.wasJTSTransactionInternallyStarted()) {
            try {
                this.getExternalTransactionController().commitTransaction(this);
            }
            catch (RuntimeException runtimeException) {
                this.handleException(runtimeException);
            }
            if (!this.wasJTSTransactionInternallyStarted()) {
                bl = true;
                this.log(2, "transaction", "external_transaction_has_committed_internally");
            }
        }
        return bl;
    }

    public void commitTransaction() throws DatabaseException, ConcurrencyException {
        if (!this.getTransactionMutex().isNested()) {
            this.getEventManager().preCommitTransaction();
            this.basicCommitTransaction();
            this.getEventManager().postCommitTransaction();
        }
        this.getTransactionMutex().release();
        if (!this.isInTransaction()) {
            this.commitExternalTransaction();
        }
    }

    public boolean compareObjects(Object object, Object object2) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (!object.getClass().equals(object2.getClass())) {
            return false;
        }
        ObjectBuilder objectBuilder = this.getDescriptor(object.getClass()).getObjectBuilder();
        return objectBuilder.compareObjects(objectBuilder.unwrapObject(object, this), objectBuilder.unwrapObject(object2, this), this);
    }

    public boolean compareObjectsDontMatch(Object object, Object object2) {
        return !this.compareObjects(object, object2);
    }

    public boolean containsObjectInIdentityMap(Object object) {
        return this.getIdentityMapAccessorInstance().containsObjectInIdentityMap(object);
    }

    public boolean containsObjectInIdentityMap(Vector vector, Class clazz) {
        return this.getIdentityMapAccessorInstance().containsObjectInIdentityMap(vector, clazz);
    }

    public boolean containsQuery(String string) {
        return this.getQueries().containsKey(string);
    }

    public Object copyObject(Object object) {
        return this.copyObject(object, new ObjectCopyingPolicy());
    }

    public Object copyObject(Object object, ObjectCopyingPolicy objectCopyingPolicy) {
        if (object == null) {
            return null;
        }
        Descriptor descriptor = this.getDescriptor(object);
        if (descriptor == null) {
            return object;
        }
        objectCopyingPolicy.setSession(this);
        return descriptor.getObjectBuilder().copyObject(object, objectCopyingPolicy);
    }

    public Vector copyReadOnlyClasses() {
        return this.getDefaultReadOnlyClasses();
    }

    public void deleteAllObjects(Collection collection) throws DatabaseException, OptimisticLockException {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.deleteObject(iterator.next());
        }
    }

    public void deleteAllObjects(Vector vector) throws DatabaseException, OptimisticLockException {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.deleteObject(enumeration.nextElement());
        }
    }

    public Object deleteObject(Object object) throws DatabaseException, OptimisticLockException {
        DeleteObjectQuery deleteObjectQuery = new DeleteObjectQuery();
        deleteObjectQuery.setObject(object);
        deleteObjectQuery.setIsExecutionClone(true);
        return this.executeQuery(deleteObjectQuery);
    }

    public boolean doesObjectExist(Object object) throws DatabaseException {
        DoesExistQuery doesExistQuery = new DoesExistQuery();
        doesExistQuery.setObject(object);
        doesExistQuery.checkDatabaseForDoesExist();
        doesExistQuery.setIsExecutionClone(true);
        return (Boolean)this.executeQuery(doesExistQuery);
    }

    public void dontLogMessages() {
        this.setLogLevel(8);
    }

    public void endOperationProfile(String string) {
        if (this.isInProfile()) {
            this.getProfiler().endOperationProfile(string);
        }
    }

    public void updateProfile(String string, Object object) {
        if (this.isInProfile()) {
            this.getProfiler().update(string, object);
        }
    }

    public void incrementProfile(String string) {
        if (this.isInProfile()) {
            this.getProfiler().occurred(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeCall(Call call, DatabaseRow databaseRow, DatabaseQuery databaseQuery) throws DatabaseException {
        if (databaseQuery.getAccessor() == null) {
            databaseQuery.setAccessor(this.getAccessor());
        }
        try {
            Object object = databaseQuery.getAccessor().executeCall(call, databaseRow, this);
            return object;
        }
        finally {
            if (call.isFinished()) {
                databaseQuery.setAccessor(null);
            }
        }
    }

    public int executeNonSelectingCall(Call call) throws DatabaseException {
        DataModifyQuery dataModifyQuery = new DataModifyQuery();
        dataModifyQuery.setIsExecutionClone(true);
        dataModifyQuery.setCall(call);
        Integer n = (Integer)this.executeQuery(dataModifyQuery);
        if (n == null) {
            return 0;
        }
        return n;
    }

    public void executeNonSelectingSQL(String string) throws DatabaseException {
        this.executeNonSelectingCall(new SQLCall(string));
    }

    public Object executeQuery(String string) throws DatabaseException {
        DatabaseQuery databaseQuery = this.getQuery(string);
        if (databaseQuery == null) {
            throw QueryException.queryNotDefined(string);
        }
        return this.executeQuery(databaseQuery);
    }

    public Object executeQuery(String string, Class clazz) throws DatabaseException {
        Descriptor descriptor = this.getDescriptor(clazz);
        if (descriptor == null) {
            throw QueryException.descriptorIsMissingForNamedQuery(clazz, string);
        }
        DatabaseQuery databaseQuery = descriptor.getQueryManager().getQuery(string);
        if (databaseQuery == null) {
            throw QueryException.queryNotDefined(string, clazz);
        }
        return this.executeQuery(databaseQuery);
    }

    public Object executeQuery(String string, Class clazz, Object object) throws DatabaseException {
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(object);
        return this.executeQuery(string, clazz, vector);
    }

    public Object executeQuery(String string, Class clazz, Object object, Object object2) throws DatabaseException {
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(object);
        vector.addElement(object2);
        return this.executeQuery(string, clazz, vector);
    }

    public Object executeQuery(String string, Class clazz, Object object, Object object2, Object object3) throws DatabaseException {
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(object);
        vector.addElement(object2);
        vector.addElement(object3);
        return this.executeQuery(string, clazz, vector);
    }

    public Object executeQuery(String string, Class clazz, Vector vector) throws DatabaseException {
        Descriptor descriptor = this.getDescriptor(clazz);
        if (descriptor == null) {
            throw QueryException.descriptorIsMissingForNamedQuery(clazz, string);
        }
        DatabaseQuery databaseQuery = descriptor.getQueryManager().getQuery(string, vector);
        if (databaseQuery == null) {
            throw QueryException.queryNotDefined(string, clazz);
        }
        return this.executeQuery(databaseQuery, vector);
    }

    public Object executeQuery(String string, Object object) throws DatabaseException {
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(object);
        return this.executeQuery(string, vector);
    }

    public Object executeQuery(String string, Object object, Object object2) throws DatabaseException {
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(object);
        vector.addElement(object2);
        return this.executeQuery(string, vector);
    }

    public Object executeQuery(String string, Object object, Object object2, Object object3) throws DatabaseException {
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(object);
        vector.addElement(object2);
        vector.addElement(object3);
        return this.executeQuery(string, vector);
    }

    public Object executeQuery(String string, Vector vector) throws DatabaseException {
        DatabaseQuery databaseQuery = this.getQuery(string, vector);
        if (databaseQuery == null) {
            throw QueryException.queryNotDefined(string);
        }
        return this.executeQuery(databaseQuery, vector);
    }

    public Object executeQuery(DatabaseQuery databaseQuery) throws DatabaseException {
        return this.executeQuery(databaseQuery, (DatabaseRow)null);
    }

    public Object executeQuery(DatabaseQuery databaseQuery, Vector vector) throws DatabaseException {
        if (databaseQuery == null) {
            throw QueryException.queryNotDefined();
        }
        DatabaseRow databaseRow = databaseQuery.rowFromArguments(vector);
        return this.executeQuery(databaseQuery, databaseRow);
    }

    public Object executeQuery(DatabaseQuery databaseQuery, DatabaseRow databaseRow) throws DatabaseException {
        if (this.hasBroker() && (!databaseQuery.isDataModifyQuery() && !databaseQuery.isDataReadQuery() || databaseQuery.getSessionName() != null)) {
            return this.getBroker().executeQuery(databaseQuery, databaseRow);
        }
        if (databaseQuery == null) {
            throw QueryException.queryNotDefined();
        }
        this.log(1, "query", "execute_query", databaseQuery);
        try {
            this.getEventManager().preExecuteQuery(databaseQuery);
            Object object = this.isInProfile() ? this.getProfiler().profileExecutionOfQuery(databaseQuery, databaseRow, this) : this.internalExecuteQuery(databaseQuery, databaseRow);
            this.getEventManager().postExecuteQuery(databaseQuery, object);
            return object;
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException instanceof QueryException) {
                QueryException queryException = (QueryException)runtimeException;
                if (queryException.getQuery() == null) {
                    queryException.setQuery(databaseQuery);
                }
                if (queryException.getQueryArguments() == null) {
                    queryException.setQueryArguments(databaseRow);
                }
                if (queryException.getSession() == null) {
                    queryException.setSession(this);
                }
            } else if (runtimeException instanceof DatabaseException) {
                DatabaseException databaseException = (DatabaseException)runtimeException;
                if (databaseException.getQuery() == null) {
                    databaseException.setQuery(databaseQuery);
                }
                if (databaseException.getQueryArguments() == null) {
                    databaseException.setQueryArguments(databaseRow);
                }
                if (databaseException.getSession() == null) {
                    databaseException.setSession(this);
                }
            }
            return this.handleException(runtimeException);
        }
    }

    public Vector executeSelectingCall(Call call) throws DatabaseException {
        DataReadQuery dataReadQuery = new DataReadQuery();
        dataReadQuery.setCall(call);
        dataReadQuery.setIsExecutionClone(true);
        return (Vector)this.executeQuery(dataReadQuery);
    }

    public Vector executeSQL(String string) throws DatabaseException {
        return this.executeSelectingCall(new SQLCall(string));
    }

    public synchronized Accessor getAccessor() {
        if (this.accessor == null && this.project != null && this.project.getDatasourceLogin() != null) {
            this.accessor = this.project.getDatasourceLogin().buildAccessor();
        }
        return this.accessor;
    }

    public Accessor getAccessor(Class clazz) {
        return this.getAccessor();
    }

    public Accessor getAccessor(String string) {
        return this.getAccessor();
    }

    public oracle.toplink.sessions.Session getActiveSession() {
        oracle.toplink.sessions.Session session = this.getActiveUnitOfWork();
        if (session == null) {
            session = this;
        }
        return session;
    }

    public oracle.toplink.sessions.UnitOfWork getActiveUnitOfWork() {
        if (this.hasExternalTransactionController()) {
            return this.getExternalTransactionController().getActiveUnitOfWork();
        }
        if (this.isClientSession()) {
            return ((ClientSession)this).getParent().getActiveUnitOfWork();
        }
        return null;
    }

    public Map getAliasDescriptors() {
        return this.project.getAliasDescriptors();
    }

    public Vector getAllFromIdentityMap(Expression expression, Class clazz, DatabaseRow databaseRow) throws QueryException {
        return this.getAllFromIdentityMap(expression, clazz, databaseRow, new InMemoryQueryIndirectionPolicy());
    }

    public Vector getAllFromIdentityMap(Expression expression, Class clazz, DatabaseRow databaseRow, InMemoryQueryIndirectionPolicy inMemoryQueryIndirectionPolicy, boolean bl) throws QueryException {
        return this.getIdentityMapAccessorInstance().getAllFromIdentityMap(expression, clazz, databaseRow, inMemoryQueryIndirectionPolicy, bl);
    }

    public Vector getAllFromIdentityMap(Expression expression, Class clazz, DatabaseRow databaseRow, InMemoryQueryIndirectionPolicy inMemoryQueryIndirectionPolicy) throws QueryException {
        return this.getIdentityMapAccessorInstance().getAllFromIdentityMap(expression, clazz, databaseRow, inMemoryQueryIndirectionPolicy);
    }

    public AsOfClause getAsOfClause() {
        return null;
    }

    public Session getBroker() {
        return this.broker;
    }

    public Session getRootSession(DatabaseQuery databaseQuery) {
        return this.getParentIdentityMapSession(databaseQuery, false, true);
    }

    public Session getParentIdentityMapSession(DatabaseQuery databaseQuery) {
        return this.getParentIdentityMapSession(databaseQuery, false, false);
    }

    public Session getParentIdentityMapSession(DatabaseQuery databaseQuery, boolean bl, boolean bl2) {
        return this;
    }

    public Session getExecutionSession(DatabaseQuery databaseQuery) {
        return this;
    }

    public CacheSynchronizationManager getCacheSynchronizationManager() {
        return this.cacheSynchronizationManager;
    }

    public CommitManager getCommitManager() {
        if (this.hasBroker()) {
            return this.getBroker().getCommitManager();
        }
        if (this.commitManager == null) {
            this.commitManager = new CommitManager(this);
        }
        return this.commitManager;
    }

    public Vector getDefaultReadOnlyClasses() {
        if (this.hasBroker()) {
            return this.getBroker().getDefaultReadOnlyClasses();
        }
        return this.getProject().getDefaultReadOnlyClasses();
    }

    public ClassDescriptor getClassDescriptor(Class clazz) {
        Descriptor descriptor = this.getDescriptor(clazz);
        if (descriptor instanceof ClassDescriptor) {
            return (ClassDescriptor)descriptor;
        }
        throw ValidationException.cannotCastToClass(descriptor, descriptor.getClass(), class$oracle$toplink$descriptors$ClassDescriptor == null ? (class$oracle$toplink$descriptors$ClassDescriptor = Session.class$("oracle.toplink.descriptors.ClassDescriptor")) : class$oracle$toplink$descriptors$ClassDescriptor);
    }

    public ClassDescriptor getClassDescriptor(Object object) {
        Descriptor descriptor = this.getDescriptor(object);
        if (descriptor instanceof ClassDescriptor) {
            return (ClassDescriptor)descriptor;
        }
        throw ValidationException.cannotCastToClass(descriptor, descriptor.getClass(), class$oracle$toplink$descriptors$ClassDescriptor == null ? (class$oracle$toplink$descriptors$ClassDescriptor = Session.class$("oracle.toplink.descriptors.ClassDescriptor")) : class$oracle$toplink$descriptors$ClassDescriptor);
    }

    public ClassDescriptor getClassDescriptorForAlias(String string) {
        return this.project.getClassDescriptorForAlias(string);
    }

    public Descriptor getDescriptor(Class clazz) {
        if (clazz == null) {
            return null;
        }
        Descriptor descriptor = this.lastDescriptorAccessed;
        if (descriptor != null && descriptor.getJavaClass().equals(clazz)) {
            return descriptor;
        }
        Descriptor descriptor2 = (Descriptor)this.getDescriptors().get(clazz);
        if (descriptor2 == null && this.hasBroker()) {
            descriptor2 = this.getBroker().getDescriptor(clazz);
        }
        if (descriptor2 == null) {
            this.getEventManager().missingDescriptor(clazz);
            descriptor2 = (Descriptor)this.getDescriptors().get(clazz);
        }
        if (descriptor2 == null && !clazz.isInterface()) {
            Class<?>[] classArray = clazz.getInterfaces();
            for (int i = 0; i < classArray.length; ++i) {
                Class<?> clazz2 = classArray[i];
                descriptor2 = this.getDescriptor(clazz2);
                if (descriptor2 == null) continue;
                this.getDescriptors().put(clazz2, descriptor2);
                break;
            }
            if (descriptor2 == null) {
                descriptor2 = this.getDescriptor(clazz.getSuperclass());
            }
        }
        this.lastDescriptorAccessed = descriptor2;
        return descriptor2;
    }

    public Descriptor getDescriptor(Object object) {
        if (this.getProject().hasProxyIndirection()) {
            return this.getDescriptor(ProxyIndirectionPolicy.getValueFromProxy(object).getClass());
        }
        return this.getDescriptor(object.getClass());
    }

    public Descriptor getDescriptorForAlias(String string) {
        return this.project.getDescriptorForAlias(string);
    }

    public Map getDescriptors() {
        return this.getProject().getDescriptors();
    }

    public synchronized SessionEventManager getEventManager() {
        if (this.eventManager == null) {
            this.eventManager = new SessionEventManager(this);
        }
        return this.eventManager;
    }

    public String getExceptionHandlerClass() {
        String string = null;
        try {
            string = this.getExceptionHandler().getClass().getName();
        }
        catch (Exception exception) {
            return null;
        }
        return string;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public ExternalTransactionController getExternalTransactionController() {
        return this.externalTransactionController;
    }

    public Object getFromIdentityMap(Object object) {
        return this.getIdentityMapAccessorInstance().getFromIdentityMap(object);
    }

    public Object getFromIdentityMap(Vector vector, Class clazz) {
        return this.getIdentityMapAccessorInstance().getFromIdentityMap(vector, clazz);
    }

    public Object getFromIdentityMap(Vector vector, Class clazz, boolean bl) {
        return this.getIdentityMapAccessorInstance().getFromIdentityMap(vector, clazz, bl);
    }

    public Object getFromIdentityMap(Expression expression, Class clazz, DatabaseRow databaseRow) throws QueryException {
        return this.getFromIdentityMap(expression, clazz, databaseRow, new InMemoryQueryIndirectionPolicy());
    }

    public Object getFromIdentityMap(Expression expression, Class clazz, DatabaseRow databaseRow, InMemoryQueryIndirectionPolicy inMemoryQueryIndirectionPolicy) throws QueryException {
        return this.getIdentityMapAccessorInstance().getFromIdentityMap(expression, clazz, databaseRow, inMemoryQueryIndirectionPolicy);
    }

    public oracle.toplink.sessions.IdentityMapAccessor getIdentityMapAccessor() {
        return this.identityMapAccessor;
    }

    public IdentityMapAccessor getIdentityMapAccessorInstance() {
        return this.identityMapAccessor;
    }

    public IdentityMapManager getIdentityMapManager() {
        return this.getIdentityMapAccessorInstance().getIdentityMapManager();
    }

    public IntegrityChecker getIntegrityChecker() {
        if (this.integrityChecker == null) {
            this.integrityChecker = new IntegrityChecker();
        }
        return this.integrityChecker;
    }

    public Writer getLog() {
        return this.getSessionLog().getWriter();
    }

    public String getLogSessionString() {
        if (this.logSessionString == null) {
            StringWriter stringWriter = new StringWriter();
            stringWriter.write(this.getSessionTypeString());
            stringWriter.write("(");
            stringWriter.write(String.valueOf(System.identityHashCode(this)));
            stringWriter.write(")");
            this.logSessionString = stringWriter.toString();
        }
        return this.logSessionString;
    }

    public String getSessionTypeString() {
        return Helper.getShortClassName(this.getClass());
    }

    public DatabaseLogin getLogin() {
        try {
            return (DatabaseLogin)this.getDatasourceLogin();
        }
        catch (ClassCastException classCastException) {
            throw ValidationException.notSupportedForDatasource();
        }
    }

    public Login getDatasourceLogin() {
        return this.getProject().getDatasourceLogin();
    }

    public String getName() {
        return this.name;
    }

    public Number getNextSequenceNumberValue(Class clazz) {
        return (Number)this.getSequencing().getNextValue(clazz);
    }

    public int getNumberOfActiveUnitsOfWork() {
        return this.numberOfActiveUnitsOfWork;
    }

    public DatabasePlatform getPlatform() {
        if (this.platform == null) {
            this.platform = this.getDatasourceLogin().getPlatform();
        }
        return (DatabasePlatform)this.platform;
    }

    public Platform getDatasourcePlatform() {
        if (this.platform == null) {
            this.platform = this.getDatasourceLogin().getDatasourcePlatform();
        }
        return this.platform;
    }

    public ServerPlatform getServerPlatform() {
        return null;
    }

    public Platform getPlatform(Class clazz) {
        if (this.platform == null) {
            this.platform = this.getDatasourcePlatform();
        }
        return this.platform;
    }

    public SessionProfiler getProfiler() {
        return this.profiler;
    }

    public Project getProject() {
        return this.project;
    }

    public Map getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap(5);
        }
        return this.properties;
    }

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public Object getProperty(String string) {
        return this.getProperties().get(string);
    }

    public Map getQueries() {
        if (this.queries == null) {
            this.queries = new HashMap(5);
        }
        return this.queries;
    }

    public Vector getAllQueries() {
        Vector vector = new Vector();
        Iterator iterator = this.getQueries().values().iterator();
        while (iterator.hasNext()) {
            vector.addAll((Vector)iterator.next());
        }
        return vector;
    }

    public DatabaseQuery getQuery(String string) {
        return this.getQuery(string, null);
    }

    public DatabaseQuery getQuery(String string, Vector vector) {
        Vector vector2 = (Vector)this.getQueries().get(string);
        if (vector2 == null || vector2.isEmpty()) {
            return null;
        }
        if (vector2.size() == 1) {
            return (DatabaseQuery)vector2.firstElement();
        }
        int n = 0;
        if (vector != null) {
            n = vector.size();
        }
        Vector vector3 = new Vector(n);
        for (int i = 0; i < n; ++i) {
            vector3.addElement(vector.elementAt(i).getClass());
        }
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            DatabaseQuery databaseQuery = (DatabaseQuery)enumeration.nextElement();
            if (!Helper.areTypesAssignable(vector3, databaseQuery.getArgumentTypes())) continue;
            return databaseQuery;
        }
        return null;
    }

    public Sequencing getSequencing() {
        return null;
    }

    public Session getSessionForClass(Class clazz) {
        if (this.hasBroker()) {
            return this.getBroker().getSessionForClass(clazz);
        }
        return this;
    }

    public SessionLog getSessionLog() {
        if (this.sessionLog == null) {
            this.setSessionLog(new DefaultSessionLog());
        }
        return this.sessionLog;
    }

    public synchronized ConcurrencyManager getTransactionMutex() {
        if (this.transactionMutex == null) {
            this.transactionMutex = new ConcurrencyManager();
        }
        return this.transactionMutex;
    }

    public Object getWriteLockValue(Object object) {
        return this.getIdentityMapAccessorInstance().getWriteLockValue(object);
    }

    public Object getWriteLockValue(Vector vector, Class clazz) {
        return this.getIdentityMapAccessorInstance().getWriteLockValue(vector, clazz);
    }

    public Object handleException(RuntimeException runtimeException) throws RuntimeException {
        if (runtimeException instanceof TopLinkException) {
            TopLinkException topLinkException = (TopLinkException)runtimeException;
            if (topLinkException.getSession() == null) {
                topLinkException.setSession(this);
            }
            if (!topLinkException.hasBeenLogged()) {
                this.logThrowable(6, null, runtimeException);
                topLinkException.setHasBeenLogged(true);
            }
        } else {
            this.logThrowable(6, null, runtimeException);
        }
        if (this.hasExceptionHandler()) {
            return this.getExceptionHandler().handleException(runtimeException);
        }
        throw runtimeException;
    }

    public boolean hasBroker() {
        return this.broker != null;
    }

    public boolean hasCacheSynchronizationManager() {
        return this.cacheSynchronizationManager != null;
    }

    public boolean hasDescriptor(Class clazz) {
        if (clazz == null) {
            return false;
        }
        return this.getDescriptors().get(clazz) != null;
    }

    public boolean hasExceptionHandler() {
        return this.exceptionHandler != null;
    }

    public boolean hasExternalTransactionController() {
        return this.externalTransactionController != null;
    }

    public void initializeAllIdentityMaps() {
        this.getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void initializeIdentityMap(Class clazz) {
        this.getIdentityMapAccessorInstance().initializeIdentityMap(clazz);
    }

    public void initializeIdentityMapAccessor() {
        this.identityMapAccessor = new IdentityMapAccessor(this, new IdentityMapManager(this));
    }

    public void initializeIdentityMaps() {
        this.getIdentityMapAccessorInstance().initializeIdentityMaps();
    }

    public Object insertObject(Object object) throws DatabaseException {
        InsertObjectQuery insertObjectQuery = new InsertObjectQuery();
        insertObjectQuery.setObject(object);
        insertObjectQuery.setIsExecutionClone(true);
        return this.executeQuery(insertObjectQuery);
    }

    public Object internalExecuteQuery(DatabaseQuery databaseQuery, DatabaseRow databaseRow) throws DatabaseException {
        return databaseQuery.execute(this, databaseRow);
    }

    public boolean isBroker() {
        return false;
    }

    public boolean isInBroker() {
        return this.isInBroker;
    }

    public boolean isClassReadOnly(Class clazz) {
        Descriptor descriptor = this.getDescriptor(clazz);
        return this.isClassReadOnly(clazz, descriptor);
    }

    public boolean isClassReadOnly(Class clazz, Descriptor descriptor) {
        if (descriptor != null && descriptor.shouldBeReadOnly()) {
            return true;
        }
        if (clazz != null) {
            return this.getDefaultReadOnlyClasses().contains(clazz);
        }
        return false;
    }

    public boolean isClientSession() {
        return false;
    }

    public boolean isConnected() {
        if (this.getAccessor() == null) {
            return false;
        }
        return this.getAccessor().isConnected();
    }

    public boolean isDatabaseSession() {
        return false;
    }

    public boolean isDistributedSession() {
        return false;
    }

    public boolean isInProfile() {
        return this.isInProfile;
    }

    public void setIsInProfile(boolean bl) {
        this.isInProfile = bl;
    }

    public void setIsInBroker(boolean bl) {
        this.isInBroker = bl;
    }

    public boolean isFinalizersEnabled() {
        return this.isFinalizersEnabled;
    }

    public void setIsFinalizersEnabled(boolean bl) {
        this.isFinalizersEnabled = bl;
    }

    public boolean isInTransaction() {
        return this.getTransactionMutex().isAcquired();
    }

    public boolean isRemoteSession() {
        return false;
    }

    public boolean isRemoteUnitOfWork() {
        return false;
    }

    public boolean isServerSession() {
        return false;
    }

    public boolean isSessionBroker() {
        return false;
    }

    public boolean isUnitOfWork() {
        return false;
    }

    public Vector keyFromObject(Object object) throws ValidationException {
        Descriptor descriptor = this.getDescriptor(object);
        if (descriptor == null) {
            throw ValidationException.missingDescriptor(object.getClass().getName());
        }
        Object object2 = descriptor.getObjectBuilder().unwrapObject(object, this);
        if (object2 == null) {
            return null;
        }
        return descriptor.getObjectBuilder().extractPrimaryKeyFromObject(object2, this);
    }

    public void log(SessionLogEntry sessionLogEntry) {
        if (this.shouldLog(sessionLogEntry.getLevel(), sessionLogEntry.getNameSpace())) {
            if (sessionLogEntry.getSession() == null) {
                sessionLogEntry.setSession(this);
            }
            this.getSessionLog().log(sessionLogEntry);
        }
    }

    public void log(oracle.toplink.sessions.SessionLogEntry sessionLogEntry) {
        if (this.shouldLog(sessionLogEntry.getLevel(), sessionLogEntry.getNameSpace())) {
            if (sessionLogEntry.getSession() == null) {
                sessionLogEntry.setSession(this);
            }
            this.getSessionLog().log(sessionLogEntry);
        }
    }

    public void logDebug(String string, Object[] objectArray) {
        this.log(1, (String)null, string, objectArray);
    }

    public void logDebug(String string) {
        this.log(1, string, (Object[])null, null, false);
    }

    public void logException(Exception exception) {
        this.logThrowable(7, null, exception);
    }

    public void logMessage(String string, Object[] objectArray) {
        this.log(2, (String)null, string, objectArray);
    }

    public void logMessage(String string) {
        this.log(2, string, (Object[])null, null, false);
    }

    public void logMessage(String string, Object[] objectArray, Accessor accessor) {
        this.log(2, string, objectArray, accessor);
    }

    public void logMessage(String string, Accessor accessor) {
        this.log(2, string, (Object[])null, accessor, false);
    }

    public void logMessages() {
        this.setShouldLogMessages(true);
    }

    public DatabaseQuery prepareDatabaseQuery(DatabaseQuery databaseQuery) {
        if (!this.isUnitOfWork() && databaseQuery.isObjectLevelReadQuery()) {
            return ((ObjectLevelReadQuery)databaseQuery).prepareOutsideUnitOfWork(this);
        }
        return databaseQuery;
    }

    public void printIdentityMap(Class clazz) {
        this.getIdentityMapAccessorInstance().printIdentityMap(clazz);
    }

    public void printIdentityMaps() {
        this.getIdentityMapAccessorInstance().printIdentityMaps();
    }

    public Object putInIdentityMap(Object object) {
        return this.getIdentityMapAccessorInstance().putInIdentityMap(object);
    }

    public Object putInIdentityMap(Object object, Vector vector) {
        return this.getIdentityMapAccessorInstance().putInIdentityMap(object, vector);
    }

    public Object putInIdentityMap(Object object, Vector vector, Object object2) {
        return this.getIdentityMapAccessorInstance().putInIdentityMap(object, vector, object2);
    }

    public Object putInIdentityMap(Object object, Vector vector, Object object2, long l) {
        return this.getIdentityMapAccessorInstance().putInIdentityMap(object, vector, object2, l);
    }

    public Vector readAllObjects(Class clazz) throws DatabaseException {
        ReadAllQuery readAllQuery = new ReadAllQuery();
        readAllQuery.setIsExecutionClone(true);
        readAllQuery.setReferenceClass(clazz);
        return (Vector)this.executeQuery(readAllQuery);
    }

    public Vector readAllObjects(Class clazz, String string) throws DatabaseException {
        ReadAllQuery readAllQuery = new ReadAllQuery();
        readAllQuery.setReferenceClass(clazz);
        readAllQuery.setSQLString(string);
        readAllQuery.setIsExecutionClone(true);
        return (Vector)this.executeQuery(readAllQuery);
    }

    public Vector readAllObjects(Class clazz, Call call) throws DatabaseException {
        ReadAllQuery readAllQuery = new ReadAllQuery();
        readAllQuery.setReferenceClass(clazz);
        readAllQuery.setCall(call);
        readAllQuery.setIsExecutionClone(true);
        return (Vector)this.executeQuery(readAllQuery);
    }

    public Vector readAllObjects(Class clazz, Expression expression) throws DatabaseException {
        ReadAllQuery readAllQuery = new ReadAllQuery();
        readAllQuery.setReferenceClass(clazz);
        readAllQuery.setSelectionCriteria(expression);
        readAllQuery.setIsExecutionClone(true);
        return (Vector)this.executeQuery(readAllQuery);
    }

    public Object readObject(Class clazz) throws DatabaseException {
        ReadObjectQuery readObjectQuery = new ReadObjectQuery();
        readObjectQuery.setReferenceClass(clazz);
        readObjectQuery.setIsExecutionClone(true);
        return this.executeQuery(readObjectQuery);
    }

    public Object readObject(Class clazz, String string) throws DatabaseException {
        ReadObjectQuery readObjectQuery = new ReadObjectQuery();
        readObjectQuery.setReferenceClass(clazz);
        readObjectQuery.setSQLString(string);
        readObjectQuery.setIsExecutionClone(true);
        return this.executeQuery(readObjectQuery);
    }

    public Object readObject(Class clazz, Call call) throws DatabaseException {
        ReadObjectQuery readObjectQuery = new ReadObjectQuery();
        readObjectQuery.setReferenceClass(clazz);
        readObjectQuery.setCall(call);
        readObjectQuery.setIsExecutionClone(true);
        return this.executeQuery(readObjectQuery);
    }

    public Object readObject(Class clazz, Expression expression) throws DatabaseException {
        ReadObjectQuery readObjectQuery = new ReadObjectQuery();
        readObjectQuery.setReferenceClass(clazz);
        readObjectQuery.setSelectionCriteria(expression);
        readObjectQuery.setIsExecutionClone(true);
        return this.executeQuery(readObjectQuery);
    }

    public Object readObject(Object object) throws DatabaseException {
        ReadObjectQuery readObjectQuery = new ReadObjectQuery();
        readObjectQuery.setSelectionObject(object);
        readObjectQuery.setIsExecutionClone(true);
        return this.executeQuery(readObjectQuery);
    }

    public Object refreshAndLockObject(Object object) throws DatabaseException {
        return this.refreshAndLockObject(object, (short)1);
    }

    public Object refreshAndLockObject(Object object, short s) throws DatabaseException {
        ReadObjectQuery readObjectQuery = new ReadObjectQuery();
        readObjectQuery.setSelectionObject(object);
        readObjectQuery.refreshIdentityMapResult();
        readObjectQuery.cascadePrivateParts();
        readObjectQuery.setLockMode(s);
        readObjectQuery.setIsExecutionClone(true);
        return this.executeQuery(readObjectQuery);
    }

    public Object refreshObject(Object object) throws DatabaseException {
        return this.refreshAndLockObject(object, (short)0);
    }

    public void release() {
    }

    public void releaseUnitOfWork(UnitOfWork unitOfWork) {
        this.setNumberOfActiveUnitsOfWork(this.getNumberOfActiveUnitsOfWork() - 1);
    }

    public void removeFromIdentityMap(Object object) {
        this.getIdentityMapAccessorInstance().removeFromIdentityMap(object);
    }

    public void removeFromIdentityMap(Vector vector, Class clazz) {
        this.getIdentityMapAccessorInstance().removeFromIdentityMap(vector, clazz);
    }

    public void removeProperty(String string) {
        this.getProperties().remove(string);
    }

    public void removeQuery(String string) {
        this.getQueries().remove(string);
    }

    public void removeQuery(String string, Vector vector) {
        Vector vector2 = (Vector)this.getQueries().get(string);
        if (vector2 == null) {
            return;
        }
        DatabaseQuery databaseQuery = null;
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements() && !Helper.areTypesAssignable(vector, (databaseQuery = (DatabaseQuery)enumeration.nextElement()).getArgumentTypes())) {
        }
        if (databaseQuery != null) {
            vector2.remove(databaseQuery);
        }
    }

    protected boolean rollbackExternalTransaction() {
        boolean bl = false;
        if (this.hasExternalTransactionController() && this.wasJTSTransactionInternallyStarted()) {
            try {
                this.getExternalTransactionController().rollbackTransaction(this);
            }
            catch (RuntimeException runtimeException) {
                this.handleException(runtimeException);
            }
            if (!this.wasJTSTransactionInternallyStarted()) {
                bl = true;
                this.log(2, "transaction", "external_transaction_has_rolled_back_internally");
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackTransaction() throws DatabaseException, ConcurrencyException {
        try {
            if (!this.getTransactionMutex().isNested()) {
                this.getEventManager().preRollbackTransaction();
                this.basicRollbackTransaction();
                this.getEventManager().postRollbackTransaction();
            }
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.getTransactionMutex().release();
            if (!this.isInTransaction()) {
                this.rollbackExternalTransaction();
            }
            throw throwable;
        }
        this.getTransactionMutex().release();
        if (!this.isInTransaction()) {
            this.rollbackExternalTransaction();
        }
    }

    public void setAccessor(Accessor accessor) {
        this.accessor = accessor;
    }

    public void setBroker(Session session) {
        this.broker = session;
    }

    public void setCacheSynchronizationManager(CacheSynchronizationManager cacheSynchronizationManager) {
        this.cacheSynchronizationManager = cacheSynchronizationManager;
        if (cacheSynchronizationManager != null) {
            cacheSynchronizationManager.setSession(this);
        }
    }

    public void setCommitManager(CommitManager commitManager) {
        this.commitManager = commitManager;
    }

    public void setEventManager(SessionEventManager sessionEventManager) {
        this.eventManager = sessionEventManager != null ? sessionEventManager : new SessionEventManager();
        this.eventManager.setSession(this);
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void setExternalTransactionController(ExternalTransactionController externalTransactionController) {
        this.externalTransactionController = externalTransactionController;
        if (externalTransactionController == null) {
            return;
        }
        externalTransactionController.setSession(this);
    }

    public void setIntegrityChecker(IntegrityChecker integrityChecker) {
        this.integrityChecker = integrityChecker;
    }

    public void setLog(Writer writer) {
        this.getSessionLog().setWriter(writer);
    }

    public void setLogin(DatabaseLogin databaseLogin) {
        this.setDatasourceLogin(databaseLogin);
    }

    public void setLogin(Login login) {
        this.setDatasourceLogin(login);
    }

    public void setDatasourceLogin(Login login) {
        this.getProject().setDatasourceLogin(login);
        this.platform = null;
    }

    public void setName(String string) {
        this.name = string;
    }

    protected void setNumberOfActiveUnitsOfWork(int n) {
        this.numberOfActiveUnitsOfWork = n;
    }

    public void setProfiler(SessionProfiler sessionProfiler) {
        this.profiler = sessionProfiler;
        if (sessionProfiler != null) {
            sessionProfiler.setSession(this);
            this.setIsInProfile(this.getProfiler().getProfileWeight() != 0);
            this.getIdentityMapAccessorInstance().getIdentityMapManager().clearCacheAccessPreCheck();
        } else {
            this.setIsInProfile(false);
        }
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public void setProperties(Hashtable hashtable) {
        this.properties = hashtable;
    }

    public void setProperty(String string, Object object) {
        this.getProperties().put(string, object);
    }

    protected void setQueries(Hashtable hashtable) {
        this.queries = hashtable;
    }

    public void setSessionLog(SessionLog sessionLog) {
        this.sessionLog = (SessionLog)((AbstractSessionLog)sessionLog).clone();
        if (this.sessionLog != null) {
            this.sessionLog.setSession(this);
        }
    }

    public void setSessionLog(oracle.toplink.sessions.SessionLog sessionLog) {
        this.sessionLog = (SessionLog)sessionLog;
        this.sessionLog.setSession(this);
    }

    public void setShouldLogMessages(boolean bl) {
        if (bl && this.getLogLevel(null) > 2) {
            this.setLogLevel(2);
        } else if (!bl) {
            this.setLogLevel(8);
        }
    }

    public void setUseOldCommit(boolean bl) {
        this.usesOldCommit = bl;
    }

    protected void setTransactionMutex(ConcurrencyManager concurrencyManager) {
        this.transactionMutex = concurrencyManager;
    }

    public void setWasJTSTransactionInternallyStarted(boolean bl) {
        this.wasJTSTransactionInternallyStarted = bl;
    }

    public boolean shouldLogMessages() {
        return this.getLogLevel(null) != 8;
    }

    public void startOperationProfile(String string) {
        if (this.isInProfile()) {
            this.getProfiler().startOperationProfile(string);
        }
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write(this.getSessionTypeString() + "(" + Helper.cr() + "\t" + this.getAccessor() + Helper.cr() + "\t" + this.getDatasourcePlatform() + ")");
        return stringWriter.toString();
    }

    public Object unwrapObject(Object object) {
        return this.getDescriptor(object).getObjectBuilder().unwrapObject(object, this);
    }

    public Object updateObject(Object object) throws DatabaseException, OptimisticLockException {
        UpdateObjectQuery updateObjectQuery = new UpdateObjectQuery();
        updateObjectQuery.setObject(object);
        updateObjectQuery.setIsExecutionClone(true);
        return this.executeQuery(updateObjectQuery);
    }

    public void updateWriteLockValue(Object object, Object object2) {
        this.getIdentityMapAccessorInstance().updateWriteLockValue(object, object2);
    }

    public void updateWriteLockValue(Vector vector, Class clazz, Object object) {
        this.getIdentityMapAccessorInstance().updateWriteLockValue(vector, clazz, object);
    }

    public boolean usesExternalTransactionController() {
        return this.accessor.usesExternalTransactionController();
    }

    public boolean usesOldCommit() {
        return this.usesOldCommit;
    }

    public void validateCache() {
        this.getIdentityMapAccessorInstance().validateCache();
    }

    public void validateQuery(DatabaseQuery databaseQuery) {
    }

    public boolean verifyDelete(Object object) {
        ObjectBuilder objectBuilder = this.getDescriptor(object).getObjectBuilder();
        Object object2 = objectBuilder.unwrapObject(object, this);
        return objectBuilder.verifyDelete(object2, this);
    }

    public boolean wasJTSTransactionInternallyStarted() {
        return this.wasJTSTransactionInternallyStarted;
    }

    public Object wrapObject(Object object) {
        return this.getDescriptor(object).getObjectBuilder().wrapObject(object, this);
    }

    protected void writeAllObjects(IdentityHashtable identityHashtable) throws DatabaseException, OptimisticLockException {
        this.getCommitManager().commitAllObjects(identityHashtable);
    }

    protected void writeAllObjectsWithChangeSet(UnitOfWorkChangeSet unitOfWorkChangeSet) throws DatabaseException, OptimisticLockException {
        this.getCommitManager().commitAllObjectsWithChangeSet(unitOfWorkChangeSet);
    }

    public Object writeObject(Object object) throws DatabaseException, OptimisticLockException {
        WriteObjectQuery writeObjectQuery = new WriteObjectQuery();
        writeObjectQuery.setObject(object);
        writeObjectQuery.setIsExecutionClone(true);
        return this.executeQuery(writeObjectQuery);
    }

    public void writesCompleted() {
        this.getAccessor().writesCompleted(this);
    }

    public void processCommand(Object object) {
        ((Command)object).executeWithSession(this);
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    public void setCommandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
    }

    public boolean shouldPropagateChanges() {
        return this.shouldPropagateChanges;
    }

    public void setShouldPropagateChanges(boolean bl) {
        this.shouldPropagateChanges = bl;
    }

    public boolean shouldLogMessages(int n) {
        if (1 == n) {
            return this.getLogLevel("propagation") <= 7;
        }
        if (2 == n) {
            return this.getLogLevel("propagation") <= 6;
        }
        if (3 == n) {
            return this.getLogLevel("propagation") <= 2;
        }
        if (4 == n) {
            return this.getLogLevel("propagation") <= 1;
        }
        return false;
    }

    public void logMessage(int n, String string) {
        if (this.shouldLogMessages(n)) {
            int n2;
            switch (n) {
                case 1: {
                    n2 = 7;
                    break;
                }
                case 2: {
                    n2 = 6;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
                case 4: {
                    n2 = 1;
                    break;
                }
                default: {
                    n2 = 0;
                }
            }
            this.log(n2, string, null, null, false);
        }
    }

    public int getLogLevel(String string) {
        return this.getSessionLog().getLevel(string);
    }

    public int getLogLevel() {
        return this.getSessionLog().getLevel();
    }

    public void setLogLevel(int n) {
        this.getSessionLog().setLevel(n);
    }

    public boolean shouldLog(int n, String string) {
        return this.getSessionLog().shouldLog(n, string);
    }

    public void log(int n, String string, String string2) {
        if (!this.shouldLog(n, string)) {
            return;
        }
        this.log(n, string, string2, (Object[])null);
    }

    public void log(int n, String string, String string2, Object object) {
        if (!this.shouldLog(n, string)) {
            return;
        }
        this.log(n, string, string2, new Object[]{object});
    }

    public void log(int n, String string, String string2, Object object, Object object2) {
        if (!this.shouldLog(n, string)) {
            return;
        }
        this.log(n, string, string2, new Object[]{object, object2});
    }

    public void log(int n, String string, String string2, Object object, Object object2, Object object3) {
        if (!this.shouldLog(n, string)) {
            return;
        }
        this.log(n, string, string2, new Object[]{object, object2, object3});
    }

    public void log(int n, String string, String string2, Object[] objectArray) {
        this.log(n, string, string2, objectArray, null);
    }

    public void log(int n, String string, String string2, Object[] objectArray, Accessor accessor) {
        this.log(n, string, string2, objectArray, accessor, true);
    }

    public void log(int n, String string, String string2, Object[] objectArray, Accessor accessor, boolean bl) {
        if (this.shouldLog(n, string)) {
            this.startOperationProfile("logging");
            this.log(new SessionLogEntry(n, string, this, string2, objectArray, accessor, bl));
            this.endOperationProfile("logging");
        }
    }

    public void log(int n, String string, Object[] objectArray, Accessor accessor) {
        this.log(n, string, objectArray, accessor, true);
    }

    public void log(int n, String string, Object[] objectArray, Accessor accessor, boolean bl) {
        if (this.shouldLog(n, null)) {
            this.startOperationProfile("logging");
            this.log(new SessionLogEntry(n, this, string, objectArray, accessor, bl));
            this.endOperationProfile("logging");
        }
    }

    public void logThrowable(int n, String string, Throwable throwable) {
        if (this.shouldLog(n, string)) {
            this.startOperationProfile("logging");
            this.log(new SessionLogEntry(this, n, string, throwable));
            this.endOperationProfile("logging");
        }
    }

    public void severe(String string, String string2) {
        this.log(7, string2, string);
    }

    public void warning(String string, String string2) {
        this.log(6, string2, string);
    }

    public void info(String string, String string2) {
        this.log(5, string2, string);
    }

    public void config(String string, String string2) {
        this.log(4, string2, string);
    }

    public void fine(String string, String string2) {
        this.log(3, string2, string);
    }

    public void finer(String string, String string2) {
        this.log(2, string2, string);
    }

    public void finest(String string, String string2) {
        this.log(1, string2, string);
    }

    public Object handleSevere(RuntimeException runtimeException) throws RuntimeException {
        this.logThrowable(7, null, runtimeException);
        if (this.hasExceptionHandler()) {
            return this.getExceptionHandler().handleException(runtimeException);
        }
        throw runtimeException;
    }

    public void releaseReadConnection(Accessor accessor) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

