/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.publicinterface;

import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.IntegrityException;
import oracle.toplink.exceptions.OptimisticLockException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.sequencing.Sequencing;
import oracle.toplink.internal.sequencing.SequencingCallback;
import oracle.toplink.internal.sequencing.SequencingFactory;
import oracle.toplink.internal.sequencing.SequencingHome;
import oracle.toplink.internal.sessions.AbstractSession;
import oracle.toplink.platform.server.NoServerPlatform;
import oracle.toplink.platform.server.ServerPlatform;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.sequencing.SequencingControl;
import oracle.toplink.sessions.DatasourceLogin;
import oracle.toplink.sessions.Login;
import oracle.toplink.sessions.Project;

public class DatabaseSession
extends AbstractSession
implements oracle.toplink.sessions.DatabaseSession {
    private SequencingHome sequencingHome;
    private ServerPlatform serverPlatform;
    private long connectedTime;
    protected boolean isLoggedIn;

    protected void setSequencingHome(SequencingHome sequencingHome) {
        this.sequencingHome = sequencingHome;
    }

    protected SequencingHome getSequencingHome() {
        if (this.sequencingHome == null) {
            this.setSequencingHome(SequencingFactory.createSequencingHome(this));
        }
        return this.sequencingHome;
    }

    public SequencingControl getSequencingControl() {
        return this.getSequencingHome().getSequencingControl();
    }

    public Sequencing getSequencing() {
        return this.getSequencingHome().getSequencing();
    }

    public void initializeSequencing() {
        this.getSequencingHome().onDisconnect();
        this.getSequencingHome().onConnect();
    }

    public void afterTransaction(boolean bl, boolean bl2) {
        SequencingCallback sequencingCallback = this.getSequencingHome().getSequencingCallback();
        if (sequencingCallback != null) {
            sequencingCallback.afterTransaction(this.getAccessor(), bl);
        }
    }

    public DatabaseSession() {
        this.setServerPlatform(new NoServerPlatform(this));
    }

    public DatabaseSession(Login login) {
        this(new Project(login));
    }

    public DatabaseSession(Project project) {
        super(project);
        this.setServerPlatform(new NoServerPlatform(this));
    }

    public void addDescriptor(Descriptor descriptor) {
        this.lastDescriptorAccessed = null;
        this.getProject().addDescriptor(descriptor, this);
    }

    public void addDescriptors(Vector vector) {
        this.lastDescriptorAccessed = null;
        this.getProject().addDescriptors(vector, this);
    }

    public void addDescriptors(Project project) {
        this.lastDescriptorAccessed = null;
        this.getProject().addDescriptors(project, this);
    }

    public void connect() throws DatabaseException {
        this.getAccessor().connect(this.getDatasourceLogin(), this);
    }

    public void disconnect() throws DatabaseException {
        this.getSequencingHome().onDisconnect();
        this.getAccessor().disconnect(this);
    }

    public ServerPlatform getServerPlatform() {
        return this.serverPlatform;
    }

    public void setServerPlatform(ServerPlatform serverPlatform) {
        if (this.isConnected()) {
            throw ValidationException.serverPlatformIsReadOnlyAfterLogin(serverPlatform.getClass().getName());
        }
        this.serverPlatform = serverPlatform;
    }

    protected void finalize() throws DatabaseException {
        if (this.isConnected()) {
            this.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeDescriptorIfSessionAlive(Descriptor descriptor) {
        if (this.isConnected() && descriptor.requiresInitialization()) {
            try {
                try {
                    descriptor.preInitialize(this);
                    descriptor.initialize(this);
                    descriptor.postInitialize(this);
                    this.getCommitManager().initializeCommitOrder();
                }
                catch (RuntimeException runtimeException) {
                    this.getIntegrityChecker().handleError(runtimeException);
                }
                if (this.getIntegrityChecker().hasErrors()) {
                    this.handleException(new IntegrityException(this.getIntegrityChecker()));
                }
            }
            finally {
                this.clearIntegrityChecker();
            }
        }
    }

    public void initializeDescriptors() {
        this.getProject().setIsPureCMP2Project(true);
        this.initializeDescriptors((Map)((HashMap)this.getDescriptors()).clone());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeDescriptors(Map map) {
        this.initializeSequencing();
        try {
            Session session;
            Descriptor descriptor;
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                descriptor = (Descriptor)iterator.next();
                try {
                    session = this.getSessionForClass(descriptor.getJavaClass());
                    if (descriptor.requiresInitialization()) {
                        descriptor.preInitialize(session);
                    }
                    if (!descriptor.isAggregateDescriptor() || !descriptor.isChildDescriptor()) continue;
                    descriptor.initializeAggregateInheritancePolicy(session);
                }
                catch (RuntimeException runtimeException) {
                    this.getIntegrityChecker().handleError(runtimeException);
                }
            }
            iterator = map.values().iterator();
            while (iterator.hasNext()) {
                descriptor = (Descriptor)iterator.next();
                try {
                    session = this.getSessionForClass(descriptor.getJavaClass());
                    if (!descriptor.requiresInitialization()) continue;
                    descriptor.initialize(session);
                }
                catch (RuntimeException runtimeException) {
                    this.getIntegrityChecker().handleError(runtimeException);
                }
            }
            iterator = map.values().iterator();
            while (iterator.hasNext()) {
                descriptor = (Descriptor)iterator.next();
                try {
                    session = this.getSessionForClass(descriptor.getJavaClass());
                    if (!descriptor.requiresInitialization()) continue;
                    descriptor.postInitialize(session);
                }
                catch (RuntimeException runtimeException) {
                    this.getIntegrityChecker().handleError(runtimeException);
                }
            }
            try {
                this.getCommitManager().initializeCommitOrder();
            }
            catch (RuntimeException runtimeException) {
                this.getIntegrityChecker().handleError(runtimeException);
            }
            if (this.getIntegrityChecker().hasErrors()) {
                this.handleSevere(new IntegrityException(this.getIntegrityChecker()));
            }
        }
        finally {
            this.clearIntegrityChecker();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeDescriptors(Vector vector) {
        this.initializeSequencing();
        try {
            Session session;
            Descriptor descriptor;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                try {
                    descriptor = (Descriptor)enumeration.nextElement();
                    session = this.getSessionForClass(descriptor.getJavaClass());
                    if (descriptor.requiresInitialization()) {
                        descriptor.preInitialize(session);
                    }
                    if (!descriptor.isAggregateDescriptor() || !descriptor.isChildDescriptor()) continue;
                    descriptor.initializeAggregateInheritancePolicy(session);
                }
                catch (RuntimeException runtimeException) {
                    this.getIntegrityChecker().handleError(runtimeException);
                }
            }
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                try {
                    descriptor = (Descriptor)enumeration.nextElement();
                    session = this.getSessionForClass(descriptor.getJavaClass());
                    if (!descriptor.requiresInitialization()) continue;
                    descriptor.initialize(session);
                }
                catch (RuntimeException runtimeException) {
                    this.getIntegrityChecker().handleError(runtimeException);
                }
            }
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                try {
                    descriptor = (Descriptor)enumeration.nextElement();
                    session = this.getSessionForClass(descriptor.getJavaClass());
                    if (!descriptor.requiresInitialization()) continue;
                    descriptor.postInitialize(session);
                }
                catch (RuntimeException runtimeException) {
                    this.getIntegrityChecker().handleError(runtimeException);
                }
            }
            try {
                this.getCommitManager().initializeCommitOrder();
            }
            catch (RuntimeException runtimeException) {
                this.getIntegrityChecker().handleError(runtimeException);
            }
            if (this.getIntegrityChecker().hasErrors()) {
                this.handleException(new IntegrityException(this.getIntegrityChecker()));
            }
        }
        finally {
            this.clearIntegrityChecker();
        }
    }

    public boolean isDatabaseSession() {
        return true;
    }

    public void login() throws DatabaseException {
        if (this.isLoggedIn) {
            throw ValidationException.alreadyLoggedIn(this.getName());
        }
        this.platform = null;
        if (this.isInProfile()) {
            this.getProfiler().initialize();
        }
        this.updateProfile("loginTime", new Date(System.currentTimeMillis()));
        this.getEventManager().preLogin(this);
        this.getServerPlatform().initializeExternalTransactionController();
        this.log(5, null, "topLink_version", DatasourceLogin.getVersion());
        if (this.getServerPlatform().getServerNameAndVersion() != null) {
            this.log(5, null, "application_server_name_and_version", this.getServerPlatform().getServerNameAndVersion());
        }
        this.connect();
        this.initializeDescriptors();
        if (this.getCacheSynchronizationManager() != null) {
            this.getCacheSynchronizationManager().initialize();
        }
        if (this.getCommandManager() != null) {
            this.getCommandManager().initialize();
        }
        this.log(5, null, "login_successful", this.getName());
        this.getEventManager().postLogin(this);
        this.initializeConnectedTime();
        this.isLoggedIn = true;
        this.platform = null;
        this.getServerPlatform().registerMBean();
    }

    public void login(String string, String string2) throws DatabaseException {
        this.getDatasourceLogin().setUserName(string);
        this.getDatasourceLogin().setPassword(string2);
        this.login();
    }

    public void login(Login login) throws DatabaseException {
        this.setLogin(login);
        this.login();
    }

    public void logout() throws DatabaseException {
        this.lastDescriptorAccessed = null;
        if (this.isInTransaction()) {
            throw DatabaseException.logoutWhileTransactionInProgress();
        }
        if (this.getAccessor() == null) {
            return;
        }
        try {
            if (this.getCacheSynchronizationManager() != null) {
                this.getCacheSynchronizationManager().stopListening();
            }
        }
        catch (Throwable throwable) {
            this.log(6, "connection", "exception_thrown_when_attempting_to_shutdown_cache_synch", throwable);
        }
        if (this.getCommandManager() != null) {
            this.getCommandManager().shutdown();
        }
        this.disconnect();
        this.getIdentityMapAccessor().initializeIdentityMaps();
        this.isLoggedIn = false;
        this.log(5, null, "logout_successful", this.getName());
        this.getServerPlatform().unregisterMBean();
    }

    public void initializeConnectedTime() {
        this.connectedTime = System.currentTimeMillis();
    }

    public long getConnectedTime() {
        return this.connectedTime;
    }

    public void writeAllObjects(Collection collection) throws DatabaseException, OptimisticLockException {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.writeObject(iterator.next());
        }
    }

    public void writeAllObjects(Vector vector) throws DatabaseException, OptimisticLockException {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.writeObject(enumeration.nextElement());
        }
    }
}

