/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.mappings.converters;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import oracle.toplink.exceptions.ConversionException;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.CustomObjectInputStream;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.mappings.converters.Converter;
import oracle.toplink.mappings.foundation.AbstractDirectMapping;
import oracle.toplink.publicinterface.Session;

public class SerializedObjectConverter
implements Converter {
    protected DatabaseMapping mapping;

    public SerializedObjectConverter() {
    }

    public SerializedObjectConverter(DatabaseMapping databaseMapping) {
        this.mapping = databaseMapping;
    }

    public Object convertDataValueToObjectValue(Object object, oracle.toplink.sessions.Session session) throws DescriptorException {
        byte[] byArray;
        try {
            byArray = (byte[])((Session)session).getDatasourcePlatform().convertObject(object, ClassConstants.APBYTE);
        }
        catch (ConversionException conversionException) {
            throw ConversionException.couldNotBeConverted((Object)this.mapping, this.mapping.getDescriptor(), conversionException);
        }
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Object object2 = null;
        try {
            CustomObjectInputStream customObjectInputStream = new CustomObjectInputStream(byteArrayInputStream, session);
            object2 = customObjectInputStream.readObject();
        }
        catch (Exception exception) {
            throw DescriptorException.notDeserializable(this.getMapping(), exception);
        }
        return object2;
    }

    public Object convertObjectValueToDataValue(Object object, oracle.toplink.sessions.Session session) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
        }
        catch (IOException iOException) {
            throw DescriptorException.notSerializable(this.getMapping(), iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void initialize(DatabaseMapping databaseMapping, oracle.toplink.sessions.Session session) {
        AbstractDirectMapping abstractDirectMapping;
        this.mapping = databaseMapping;
        if (this.getMapping().isDirectToFieldMapping() && (abstractDirectMapping = (AbstractDirectMapping)this.getMapping()).getFieldClassification() == null) {
            abstractDirectMapping.setFieldClassification(ClassConstants.APBYTE);
        }
    }

    protected DatabaseMapping getMapping() {
        return this.mapping;
    }

    public boolean isMutable() {
        return true;
    }
}

