/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.mappings.converters;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.exceptions.ConversionException;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.internal.descriptors.TypeMapping;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.mappings.Association;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.mappings.converters.Converter;
import oracle.toplink.mappings.foundation.AbstractDirectMapping;
import oracle.toplink.publicinterface.Session;

public class ObjectTypeConverter
implements Converter {
    protected DatabaseMapping mapping;
    protected transient Map fieldToAttributeValues;
    protected Map attributeToFieldValues = new HashMap(10);
    protected transient Object defaultAttributeValue;
    protected transient Class fieldClassification;
    protected transient String fieldClassificationName;

    public ObjectTypeConverter() {
        this.fieldToAttributeValues = new HashMap(10);
    }

    public ObjectTypeConverter(DatabaseMapping databaseMapping) {
        this();
        this.mapping = databaseMapping;
    }

    public void addConversionValue(Object object, Object object2) {
        if (object == null) {
            object = Helper.getNullWrapper();
        }
        if (object2 == null) {
            object2 = Helper.getNullWrapper();
        }
        this.getFieldToAttributeValues().put(object, object2);
        this.getAttributeToFieldValues().put(object2, object);
    }

    public void addToAttributeOnlyConversionValue(Object object, Object object2) {
        if (object == null) {
            object = Helper.getNullWrapper();
        }
        if (object2 == null) {
            object2 = Helper.getNullWrapper();
        }
        this.getFieldToAttributeValues().put(object, object2);
    }

    public Map getAttributeToFieldValues() {
        return this.attributeToFieldValues;
    }

    public Object convertDataValueToObjectValue(Object object, oracle.toplink.sessions.Session session) {
        Object object2 = null;
        if (object == null) {
            object2 = this.getFieldToAttributeValues().get(Helper.getNullWrapper());
        } else {
            try {
                object = ((Session)session).getDatasourcePlatform().getConversionManager().convertObject(object, this.getFieldClassification());
            }
            catch (ConversionException conversionException) {
                throw ConversionException.couldNotBeConverted((Object)this.mapping, this.mapping.getDescriptor(), conversionException);
            }
            object2 = this.getFieldToAttributeValues().get(object);
            if (object2 == null) {
                if (this.getDefaultAttributeValue() != null) {
                    object2 = this.getDefaultAttributeValue();
                } else {
                    throw DescriptorException.noFieldValueConversionToAttributeValueProvided(object, this.getMapping().getField(), this.getMapping());
                }
            }
        }
        return object2;
    }

    public Object getDefaultAttributeValue() {
        return this.defaultAttributeValue;
    }

    protected DatabaseMapping getMapping() {
        return this.mapping;
    }

    protected void setMapping(DatabaseMapping databaseMapping) {
        this.mapping = databaseMapping;
    }

    public Class getFieldClassification() {
        return this.fieldClassification;
    }

    public String getFieldClassificationName() {
        if (this.fieldClassificationName == null && this.fieldClassification != null) {
            this.fieldClassificationName = this.fieldClassification.getName();
        }
        return this.fieldClassificationName;
    }

    public Class getFieldClassification(DatabaseField databaseField) {
        return this.getFieldClassification();
    }

    public Vector getFieldToAttributeValueAssociations() {
        Vector<TypeMapping> vector = new Vector<TypeMapping>(this.getFieldToAttributeValues().size());
        Iterator iterator = this.getFieldToAttributeValues().keySet().iterator();
        Iterator iterator2 = this.getFieldToAttributeValues().values().iterator();
        while (iterator.hasNext()) {
            Object v;
            Object k = iterator.next();
            if (k == Helper.getNullWrapper()) {
                k = null;
            }
            if ((v = iterator2.next()) == Helper.getNullWrapper()) {
                v = null;
            }
            vector.addElement(new TypeMapping(k, v));
        }
        return vector;
    }

    public Map getFieldToAttributeValues() {
        return this.fieldToAttributeValues;
    }

    public Object convertObjectValueToDataValue(Object object, oracle.toplink.sessions.Session session) {
        Object v;
        if (object == null) {
            v = this.getAttributeToFieldValues().get(Helper.getNullWrapper());
        } else {
            v = this.getAttributeToFieldValues().get(object);
            if (v == null) {
                throw DescriptorException.noAttributeValueConversionToFieldValueProvided(object, this.getMapping());
            }
        }
        return v;
    }

    public boolean isObjectTypeMapping() {
        return true;
    }

    public void mapBooleans() {
        this.addConversionValue("F", new Boolean(false));
        this.addConversionValue("T", new Boolean(true));
    }

    public void mapGenders() {
        this.addConversionValue("F", "Female");
        this.addConversionValue("M", "Male");
    }

    public void mapResponses() {
        this.addConversionValue("Y", "Yes");
        this.addConversionValue("N", "No");
    }

    public void initializeFieldClassification(oracle.toplink.sessions.Session session) throws DescriptorException {
        Object object;
        if (this.getFieldToAttributeValues().isEmpty()) {
            return;
        }
        Class<?> clazz = null;
        Iterator iterator = this.getFieldToAttributeValues().keySet().iterator();
        while (iterator.hasNext() && clazz == null) {
            object = iterator.next();
            if (object == Helper.getNullWrapper()) continue;
            clazz = object.getClass();
        }
        this.setFieldClassification(clazz);
        if (this.getMapping().isDirectToFieldMapping() && ((AbstractDirectMapping)(object = (AbstractDirectMapping)this.getMapping())).getFieldClassification() == null) {
            ((AbstractDirectMapping)object).setFieldClassification(clazz);
        }
    }

    public void initialize(DatabaseMapping databaseMapping, oracle.toplink.sessions.Session session) {
        this.mapping = databaseMapping;
        this.initializeFieldClassification(session);
    }

    public void setAttributeToFieldValues(Map map) {
        this.attributeToFieldValues = map;
    }

    public void setDefaultAttributeValue(Object object) {
        this.defaultAttributeValue = object;
    }

    public void setFieldClassification(Class clazz) {
        this.fieldClassification = clazz;
    }

    public void setFieldClassificationName(String string) {
        this.fieldClassificationName = string;
    }

    public void setFieldToAttributeValueAssociations(Vector vector) {
        this.setFieldToAttributeValues(new Hashtable(vector.size() + 1));
        this.setAttributeToFieldValues(new Hashtable(vector.size() + 1));
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Association association = (Association)enumeration.nextElement();
            this.addConversionValue(association.getKey(), association.getValue());
        }
    }

    public void setFieldToAttributeValues(Map map) {
        this.fieldToAttributeValues = map;
    }

    public boolean isMutable() {
        return false;
    }
}

