/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.mappings;

import java.util.Enumeration;
import oracle.toplink.descriptors.DescriptorEvent;
import oracle.toplink.descriptors.changetracking.ChangeTracker;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.exceptions.OptimisticLockException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.internal.descriptors.DescriptorIterator;
import oracle.toplink.internal.descriptors.ObjectBuilder;
import oracle.toplink.internal.descriptors.changetracking.AggregateAttributeChangeListener;
import oracle.toplink.internal.descriptors.changetracking.AttributeChangeListener;
import oracle.toplink.internal.helper.IdentityHashtable;
import oracle.toplink.internal.sessions.AggregateChangeRecord;
import oracle.toplink.internal.sessions.ChangeRecord;
import oracle.toplink.internal.sessions.MergeManager;
import oracle.toplink.internal.sessions.ObjectChangeSet;
import oracle.toplink.internal.sessions.UnitOfWorkChangeSet;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.DescriptorQueryManager;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.DeleteObjectQuery;
import oracle.toplink.queryframework.ObjectLevelModifyQuery;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.queryframework.QueryByExamplePolicy;
import oracle.toplink.queryframework.WriteObjectQuery;
import oracle.toplink.remote.DistributedSession;
import oracle.toplink.remote.RemoteSession;
import oracle.toplink.sessions.ObjectCopyingPolicy;

public abstract class AggregateMapping
extends DatabaseMapping {
    protected Class referenceClass;
    protected String referenceClassName;
    protected Descriptor referenceDescriptor;

    protected DeleteObjectQuery buildAggregateDeleteQuery(DeleteObjectQuery deleteObjectQuery, Object object) {
        DeleteObjectQuery deleteObjectQuery2 = new DeleteObjectQuery();
        this.buildAggregateModifyQuery(deleteObjectQuery, deleteObjectQuery2, object);
        return deleteObjectQuery2;
    }

    protected void buildAggregateModifyQuery(ObjectLevelModifyQuery objectLevelModifyQuery, ObjectLevelModifyQuery objectLevelModifyQuery2, Object object) {
        if (objectLevelModifyQuery.getSession().isUnitOfWork()) {
            Object object2 = this.getAttributeValueFromBackupClone(objectLevelModifyQuery.getBackupClone());
            if (object2 == null) {
                object2 = this.getObjectBuilder(object, objectLevelModifyQuery.getSession()).buildNewInstance();
            }
            objectLevelModifyQuery2.setBackupClone(object2);
        }
        objectLevelModifyQuery2.setCascadePolicy(objectLevelModifyQuery.getCascadePolicy());
        objectLevelModifyQuery2.setObject(object);
        objectLevelModifyQuery2.setTranslationRow(objectLevelModifyQuery.getTranslationRow());
        objectLevelModifyQuery2.setSession(objectLevelModifyQuery.getSession());
        objectLevelModifyQuery2.setProperties(objectLevelModifyQuery.getProperties());
    }

    protected WriteObjectQuery buildAggregateWriteQuery(WriteObjectQuery writeObjectQuery, Object object) {
        WriteObjectQuery writeObjectQuery2 = new WriteObjectQuery();
        this.buildAggregateModifyQuery(writeObjectQuery, writeObjectQuery2, object);
        return writeObjectQuery2;
    }

    public void buildBackupClone(Object object, Object object2, UnitOfWork unitOfWork) {
        Object object3 = this.getAttributeValueFromObject(object);
        this.setAttributeValueInObject(object2, this.buildBackupClonePart(object3, unitOfWork));
    }

    protected Object buildBackupClonePart(Object object, UnitOfWork unitOfWork) {
        if (object == null) {
            return null;
        }
        return this.getObjectBuilder(object, unitOfWork).buildBackupClone(object, unitOfWork);
    }

    public void buildClone(Object object, Object object2, UnitOfWork unitOfWork) {
        Object object3 = this.getAttributeValueFromObject(object);
        this.setAttributeValueInObject(object2, this.buildClonePart(object, object3, unitOfWork));
    }

    public void buildCloneFromRow(DatabaseRow databaseRow, Object object, ObjectLevelReadQuery objectLevelReadQuery, UnitOfWork unitOfWork, Session session) {
        Object object2 = this.valueFromRow(databaseRow, objectLevelReadQuery, session);
        this.setAttributeValueInObject(object, object2);
    }

    protected Object buildClonePart(Object object, Object object2, UnitOfWork unitOfWork) {
        if (object2 == null) {
            return null;
        }
        if (unitOfWork.isOriginalNewObject(object)) {
            unitOfWork.addNewAggregate(object2);
        }
        if (unitOfWork.isClassReadOnly(object2.getClass())) {
            return object2;
        }
        ObjectBuilder objectBuilder = this.getObjectBuilder(object2, unitOfWork);
        Object object3 = objectBuilder.instantiateWorkingCopyClone(object2, unitOfWork);
        objectBuilder.populateAttributesForClone(object2, object3, unitOfWork);
        return object3;
    }

    public void buildCopy(Object object, Object object2, ObjectCopyingPolicy objectCopyingPolicy) {
        Object object3 = this.getAttributeValueFromObject(object2);
        this.setAttributeValueInObject(object, this.buildCopyOfAttributeValue(object3, objectCopyingPolicy));
    }

    protected Object buildCopyOfAttributeValue(Object object, ObjectCopyingPolicy objectCopyingPolicy) {
        if (object == null) {
            return null;
        }
        return this.getObjectBuilder(object, objectCopyingPolicy.getSession()).copyObject(object, objectCopyingPolicy);
    }

    public Expression buildExpression(Object object, QueryByExamplePolicy queryByExamplePolicy, Expression expression, IdentityHashtable identityHashtable, Session session) {
        String string = this.getAttributeName();
        Object object2 = this.getRealAttributeValueFromObject(object, session);
        if (!queryByExamplePolicy.shouldIncludeInQuery(object.getClass(), string, object2)) {
            return null;
        }
        if (object2 == null) {
            Expression expression2 = expression.get(string);
            return queryByExamplePolicy.completeExpressionForNull(expression2);
        }
        ObjectBuilder objectBuilder = this.getReferenceDescriptor().getObjectBuilder();
        return objectBuilder.buildExpressionFromExample(object2, queryByExamplePolicy, expression.get(string), identityHashtable, session);
    }

    protected Object buildNewMergeInstanceOf(Object object, Session session) {
        return this.getObjectBuilder(object, session).buildNewInstance();
    }

    protected boolean compareAttributeValues(Object object, Object object2, Session session) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (object.getClass() != object2.getClass()) {
            return false;
        }
        return this.getObjectBuilder(object, session).compareObjects(object, object2, session);
    }

    public ChangeRecord compareForChange(Object object, Object object2, ObjectChangeSet objectChangeSet, Session session) {
        Object object3 = this.getAttributeValueFromObject(object);
        Object object4 = null;
        if (!objectChangeSet.isNew()) {
            object4 = this.getAttributeValueFromObject(object2);
            if (object3 == null && object4 == null) {
                return null;
            }
            if (object3 != null && object4 != null && !object3.getClass().equals(object4.getClass())) {
                object4 = null;
            }
        }
        AggregateChangeRecord aggregateChangeRecord = new AggregateChangeRecord(objectChangeSet);
        aggregateChangeRecord.setAttribute(this.getAttributeName());
        aggregateChangeRecord.setMapping(this);
        if (object3 == null) {
            aggregateChangeRecord.setChangedObject(null);
            return aggregateChangeRecord;
        }
        ObjectBuilder objectBuilder = this.getObjectBuilder(object3, session);
        ObjectChangeSet objectChangeSet2 = objectBuilder.createObjectChangeSet(object3, (UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet(), object4 == null, session);
        ObjectChangeSet objectChangeSet3 = objectBuilder.compareForChange(object3, object4, (UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet(), session);
        if (objectChangeSet3 == null) {
            if (objectChangeSet2.isNew()) {
                objectChangeSet3 = objectChangeSet2;
            } else {
                return null;
            }
        }
        aggregateChangeRecord.setChangedObject(objectChangeSet3);
        return aggregateChangeRecord;
    }

    public boolean compareObjects(Object object, Object object2, Session session) {
        return this.compareAttributeValues(this.getAttributeValueFromObject(object), this.getAttributeValueFromObject(object2), session);
    }

    protected void executeEvent(int n, ObjectLevelModifyQuery objectLevelModifyQuery) {
        Descriptor descriptor = this.getReferenceDescriptor(objectLevelModifyQuery.getObject(), objectLevelModifyQuery.getSession());
        if (descriptor.getEventManager().hasAnyEventListeners()) {
            descriptor.getEventManager().executeEvent(new DescriptorEvent(n, objectLevelModifyQuery));
        }
    }

    protected void fixAttributeValue(Object object, IdentityHashtable identityHashtable, IdentityHashtable identityHashtable2, ObjectLevelReadQuery objectLevelReadQuery, RemoteSession remoteSession) {
        if (object == null) {
            return;
        }
        this.getObjectBuilder(object, objectLevelReadQuery.getSession()).fixObjectReferences(object, identityHashtable, identityHashtable2, objectLevelReadQuery, remoteSession);
    }

    public void fixObjectReferences(Object object, IdentityHashtable identityHashtable, IdentityHashtable identityHashtable2, ObjectLevelReadQuery objectLevelReadQuery, RemoteSession remoteSession) {
        Object object2 = this.getAttributeValueFromObject(object);
        this.fixAttributeValue(object2, identityHashtable, identityHashtable2, objectLevelReadQuery, remoteSession);
    }

    protected Object getAttributeValueFromBackupClone(Object object) {
        return this.getAttributeValueFromObject(object);
    }

    protected ObjectBuilder getObjectBuilderForClass(Class clazz, Session session) {
        return this.getReferenceDescriptor(clazz, session).getObjectBuilder();
    }

    protected ObjectBuilder getObjectBuilder(Object object, Session session) {
        return this.getReferenceDescriptor(object, session).getObjectBuilder();
    }

    protected DescriptorQueryManager getQueryManager(Object object, Session session) {
        return this.getReferenceDescriptor(object, session).getQueryManager();
    }

    public Class getReferenceClass() {
        return this.referenceClass;
    }

    public String getReferenceClassName() {
        if (this.referenceClassName == null && this.referenceClass != null) {
            this.referenceClassName = this.referenceClass.getName();
        }
        return this.referenceClassName;
    }

    public Descriptor getReferenceDescriptor() {
        return this.referenceDescriptor;
    }

    protected Descriptor getReferenceDescriptor(Class clazz, Session session) {
        if (this.getReferenceDescriptor().getJavaClass().equals(clazz)) {
            return this.getReferenceDescriptor();
        }
        Descriptor descriptor = session.getDescriptor(clazz);
        if (descriptor == null) {
            throw DescriptorException.noSubClassMatch(clazz, this);
        }
        return descriptor;
    }

    protected Descriptor getReferenceDescriptor(Object object, Session session) {
        if (object == null) {
            return this.getReferenceDescriptor();
        }
        return this.getReferenceDescriptor(object.getClass(), session);
    }

    public void initialize(Session session) throws DescriptorException {
        super.initialize(session);
        if (this.getReferenceClass() == null) {
            throw DescriptorException.referenceClassNotSpecified(this);
        }
        this.setReferenceDescriptor(session.getDescriptor(this.getReferenceClass()));
        Descriptor descriptor = this.getReferenceDescriptor();
        if (descriptor == null) {
            session.getIntegrityChecker().handleError(DescriptorException.descriptorIsMissing(this.getReferenceClass().getName(), this));
        }
        if (descriptor.isAggregateDescriptor()) {
            descriptor.checkInheritanceTreeAggregateSettings(session, this);
        } else {
            session.getIntegrityChecker().handleError(DescriptorException.referenceDescriptorIsNotAggregate(this.getReferenceClass().getName(), this));
        }
    }

    public boolean isAggregateMapping() {
        return true;
    }

    public void iterate(DescriptorIterator descriptorIterator) {
        this.iterateOnAttributeValue(descriptorIterator, this.getAttributeValueFromObject(descriptorIterator.getVisitedParent()));
    }

    protected void iterateOnAttributeValue(DescriptorIterator descriptorIterator, Object object) {
        descriptorIterator.iterateForAggregateMapping(object, this, this.getReferenceDescriptor(object, descriptorIterator.getSession()));
    }

    protected void mergeAttributeValue(Object object, boolean bl, Object object2, MergeManager mergeManager) {
        if (mergeManager.getSession().isClassReadOnly(object2.getClass())) {
            return;
        }
        if (mergeManager.getSession().isClassReadOnly(object.getClass())) {
            return;
        }
        this.getObjectBuilder(object2, mergeManager.getSession()).mergeIntoObject(object, bl, object2, mergeManager);
    }

    public void mergeChangesIntoObject(Object object, ChangeRecord changeRecord, Object object2, MergeManager mergeManager) {
        ObjectChangeSet objectChangeSet = (ObjectChangeSet)((AggregateChangeRecord)changeRecord).getChangedObject();
        if (objectChangeSet == null) {
            this.setAttributeValueInObject(object, null);
            return;
        }
        Object object3 = null;
        if (object2 != null) {
            object3 = this.getAttributeValueFromObject(object2);
        }
        ObjectBuilder objectBuilder = this.getObjectBuilderForClass(objectChangeSet.getClassType(mergeManager.getSession()), mergeManager.getSession());
        Object object4 = this.getAttributeValueFromObject(object);
        if (object4 == null) {
            object4 = objectBuilder.buildNewInstance();
        } else if (object3 != null && object3.getClass() != object4.getClass()) {
            object4 = objectBuilder.buildNewInstance();
        }
        objectBuilder.mergeChangesIntoObject(object4, objectChangeSet, object3, mergeManager);
        this.setAttributeValueInObject(object, object4);
    }

    public void mergeIntoObject(Object object, boolean bl, Object object2, MergeManager mergeManager) {
        Object object3 = this.getAttributeValueFromObject(object2);
        if (object3 == null) {
            this.setAttributeValueInObject(object, null);
            return;
        }
        Object object4 = this.getAttributeValueFromObject(object);
        if (object4 == null) {
            object4 = this.buildNewMergeInstanceOf(object3, mergeManager.getSession());
            this.mergeAttributeValue(object4, true, object3, mergeManager);
            this.getDescriptor().getObjectChangePolicy().raiseInternalPropertyChangeEvent(object, this.getAttributeName(), this.getAttributeValueFromObject(object), object4);
        } else {
            this.mergeAttributeValue(object4, bl, object3, mergeManager);
        }
        this.setAttributeValueInObject(object, object4);
    }

    public void postDelete(DeleteObjectQuery deleteObjectQuery) throws DatabaseException, OptimisticLockException {
        if (!this.isReadOnly()) {
            this.postDeleteAttributeValue(deleteObjectQuery, this.getAttributeValueFromObject(deleteObjectQuery.getObject()));
        }
    }

    protected void postDeleteAttributeValue(DeleteObjectQuery deleteObjectQuery, Object object) throws DatabaseException, OptimisticLockException {
        if (object == null) {
            return;
        }
        DeleteObjectQuery deleteObjectQuery2 = this.buildAggregateDeleteQuery(deleteObjectQuery, object);
        this.getQueryManager(object, deleteObjectQuery.getSession()).postDelete(deleteObjectQuery2);
        this.executeEvent(3, deleteObjectQuery2);
    }

    public void postInsert(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        if (!this.isReadOnly()) {
            this.postInsertAttributeValue(writeObjectQuery, this.getAttributeValueFromObject(writeObjectQuery.getObject()));
        }
    }

    protected void postInsertAttributeValue(WriteObjectQuery writeObjectQuery, Object object) throws DatabaseException, OptimisticLockException {
        if (object == null) {
            return;
        }
        WriteObjectQuery writeObjectQuery2 = this.buildAggregateWriteQuery(writeObjectQuery, object);
        this.getQueryManager(object, writeObjectQuery.getSession()).postInsert(writeObjectQuery2);
        this.executeEvent(5, writeObjectQuery2);
        this.executeEvent(1, writeObjectQuery2);
    }

    public void postUpdate(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        if (!this.isReadOnly()) {
            this.postUpdateAttributeValue(writeObjectQuery, this.getAttributeValueFromObject(writeObjectQuery.getObject()));
        }
    }

    protected void postUpdateAttributeValue(WriteObjectQuery writeObjectQuery, Object object) throws DatabaseException, OptimisticLockException {
        if (object == null) {
            return;
        }
        ObjectChangeSet objectChangeSet = null;
        UnitOfWorkChangeSet unitOfWorkChangeSet = null;
        if (writeObjectQuery.getSession().isUnitOfWork() && ((UnitOfWork)writeObjectQuery.getSession()).getUnitOfWorkChangeSet() != null) {
            unitOfWorkChangeSet = (UnitOfWorkChangeSet)((UnitOfWork)writeObjectQuery.getSession()).getUnitOfWorkChangeSet();
            objectChangeSet = (ObjectChangeSet)unitOfWorkChangeSet.getObjectChangeSetForClone(object);
        }
        WriteObjectQuery writeObjectQuery2 = this.buildAggregateWriteQuery(writeObjectQuery, object);
        writeObjectQuery2.setObjectChangeSet(objectChangeSet);
        this.getQueryManager(object, writeObjectQuery.getSession()).postUpdate(writeObjectQuery2);
        this.executeEvent(7, writeObjectQuery2);
        this.executeEvent(1, writeObjectQuery2);
    }

    public void preDelete(DeleteObjectQuery deleteObjectQuery) throws DatabaseException, OptimisticLockException {
        if (!this.isReadOnly()) {
            this.preDeleteAttributeValue(deleteObjectQuery, this.getAttributeValueFromObject(deleteObjectQuery.getObject()));
        }
    }

    protected void preDeleteAttributeValue(DeleteObjectQuery deleteObjectQuery, Object object) throws DatabaseException, OptimisticLockException {
        if (object == null) {
            return;
        }
        DeleteObjectQuery deleteObjectQuery2 = this.buildAggregateDeleteQuery(deleteObjectQuery, object);
        this.executeEvent(2, deleteObjectQuery2);
        this.getQueryManager(object, deleteObjectQuery.getSession()).preDelete(deleteObjectQuery2);
    }

    public void preInsert(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        if (!this.isReadOnly()) {
            this.preInsertAttributeValue(writeObjectQuery, this.getAttributeValueFromObject(writeObjectQuery.getObject()));
        }
    }

    protected void preInsertAttributeValue(WriteObjectQuery writeObjectQuery, Object object) throws DatabaseException, OptimisticLockException {
        if (object == null) {
            return;
        }
        WriteObjectQuery writeObjectQuery2 = this.buildAggregateWriteQuery(writeObjectQuery, object);
        if (writeObjectQuery.getSession().usesOldCommit()) {
            this.executeEvent(0, writeObjectQuery2);
            this.executeEvent(4, writeObjectQuery2);
        }
        this.getQueryManager(object, writeObjectQuery.getSession()).preInsert(writeObjectQuery2);
    }

    public void preUpdate(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        if (!this.isReadOnly()) {
            this.preUpdateAttributeValue(writeObjectQuery, this.getAttributeValueFromObject(writeObjectQuery.getObject()));
        }
    }

    protected void preUpdateAttributeValue(WriteObjectQuery writeObjectQuery, Object object) throws DatabaseException, OptimisticLockException {
        if (object == null) {
            return;
        }
        WriteObjectQuery writeObjectQuery2 = this.buildAggregateWriteQuery(writeObjectQuery, object);
        ObjectChangeSet objectChangeSet = null;
        UnitOfWorkChangeSet unitOfWorkChangeSet = null;
        if (writeObjectQuery.getSession().isUnitOfWork() && ((UnitOfWork)writeObjectQuery.getSession()).getUnitOfWorkChangeSet() != null) {
            unitOfWorkChangeSet = (UnitOfWorkChangeSet)((UnitOfWork)writeObjectQuery.getSession()).getUnitOfWorkChangeSet();
            objectChangeSet = (ObjectChangeSet)unitOfWorkChangeSet.getObjectChangeSetForClone(writeObjectQuery2.getObject());
        }
        writeObjectQuery2.setObjectChangeSet(objectChangeSet);
        if (objectChangeSet == null) {
            this.executeEvent(0, writeObjectQuery2);
            this.executeEvent(6, writeObjectQuery2);
        }
        this.getQueryManager(object, writeObjectQuery.getSession()).preUpdate(writeObjectQuery2);
    }

    public void remoteInitialization(DistributedSession distributedSession) {
        super.remoteInitialization(distributedSession);
        Descriptor descriptor = this.getReferenceDescriptor();
        if (distributedSession.hasCorrespondingDescriptor(descriptor)) {
            Descriptor descriptor2 = distributedSession.getDescriptorCorrespondingTo(descriptor);
            this.setReferenceDescriptor(descriptor2);
        } else {
            distributedSession.privilegedAddDescriptor(descriptor);
            descriptor.remoteInitialization(distributedSession);
        }
    }

    public void setReferenceClass(Class clazz) {
        this.referenceClass = clazz;
    }

    public void setReferenceClassName(String string) {
        this.referenceClassName = string;
    }

    protected void setReferenceDescriptor(Descriptor descriptor) {
        this.referenceDescriptor = descriptor;
    }

    public void updateChangeRecord(Object object, Object object2, Object object3, ObjectChangeSet objectChangeSet, UnitOfWork unitOfWork) throws DescriptorException {
        AggregateChangeRecord aggregateChangeRecord = (AggregateChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (aggregateChangeRecord == null) {
            aggregateChangeRecord = new AggregateChangeRecord(objectChangeSet);
            aggregateChangeRecord.setAttribute(this.getAttributeName());
            aggregateChangeRecord.setMapping(this);
            objectChangeSet.addChange(aggregateChangeRecord);
        }
        if (object.getClass().equals(objectChangeSet.getClassType(unitOfWork))) {
            Descriptor descriptor = this.getReferenceDescriptor(object2, (Session)unitOfWork);
            if (object2 == null) {
                aggregateChangeRecord.setChangedObject(null);
                if (descriptor.getObjectChangePolicy().isAttributeChangeTrackingPolicy()) {
                    ((AggregateAttributeChangeListener)((ChangeTracker)object3).getTopLinkPropertyChangeListener()).setParentListener(null);
                }
                return;
            }
            UnitOfWorkChangeSet unitOfWorkChangeSet = (UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet();
            ObjectChangeSet objectChangeSet2 = (ObjectChangeSet)unitOfWorkChangeSet.getObjectChangeSetForClone(object2);
            if (objectChangeSet2 != null) {
                objectChangeSet2.clear();
            }
            if (descriptor.getObjectChangePolicy().isAttributeChangeTrackingPolicy()) {
                ((AggregateAttributeChangeListener)((ChangeTracker)object3).getTopLinkPropertyChangeListener()).setParentListener(null);
                AggregateAttributeChangeListener aggregateAttributeChangeListener = (AggregateAttributeChangeListener)((ChangeTracker)object2).getTopLinkPropertyChangeListener();
                if (aggregateAttributeChangeListener == null) {
                    aggregateAttributeChangeListener = new AggregateAttributeChangeListener(descriptor, unitOfWork, (AttributeChangeListener)((ChangeTracker)object).getTopLinkPropertyChangeListener(), this.getAttributeName(), object2);
                    ((ChangeTracker)object2).setTopLinkPropertyChangeListener(aggregateAttributeChangeListener);
                }
                aggregateAttributeChangeListener.setParentListener((AttributeChangeListener)((ChangeTracker)object).getTopLinkPropertyChangeListener());
            }
            aggregateChangeRecord.setChangedObject(descriptor.getObjectChangePolicy().createObjectChangeSetThroughComparison(object2, object3, unitOfWorkChangeSet, object3 == null, unitOfWork, descriptor));
            descriptor.getObjectChangePolicy().setChangeSetOnListener((ObjectChangeSet)aggregateChangeRecord.getChangedObject(), object2);
        } else if (this.referenceDescriptor.getObjectChangePolicy().isAttributeChangeTrackingPolicy()) {
            aggregateChangeRecord.setChangedObject(((AggregateAttributeChangeListener)((ChangeTracker)object).getTopLinkPropertyChangeListener()).getObjectChangeSet());
        } else {
            aggregateChangeRecord.setChangedObject(this.referenceDescriptor.getObjectChangePolicy().createObjectChangeSetThroughComparison(object, null, (UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet(), true, unitOfWork, this.referenceDescriptor));
        }
    }

    public boolean verifyDelete(Object object, Session session) throws DatabaseException {
        return this.verifyDeleteOfAttributeValue(this.getAttributeValueFromObject(object), session);
    }

    protected boolean verifyDeleteOfAttributeValue(Object object, Session session) throws DatabaseException {
        if (object == null) {
            return true;
        }
        Enumeration enumeration = this.getReferenceDescriptor(object, session).getMappings().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseMapping databaseMapping = (DatabaseMapping)enumeration.nextElement();
            if (databaseMapping.verifyDelete(object, session)) continue;
            return false;
        }
        return true;
    }
}

