/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.logging.AbstractSessionLog;
import oracle.toplink.logging.TopLinkLogRecord;

public class TopLinkSimpleFormatter
extends SimpleFormatter {
    Date dat = new Date();
    private static final String format = "{0,date} {0,time}";
    private MessageFormat formatter;
    private Object[] args = new Object[1];
    private String lineSeparator = PrivilegedAccessController.getLineSeparator();

    public synchronized String format(LogRecord logRecord) {
        CharSequence charSequence;
        if (!(logRecord instanceof TopLinkLogRecord)) {
            return super.format(logRecord);
        }
        TopLinkLogRecord topLinkLogRecord = (TopLinkLogRecord)logRecord;
        StringBuffer stringBuffer = new StringBuffer();
        if (topLinkLogRecord.shouldPrintDate()) {
            this.dat.setTime(topLinkLogRecord.getMillis());
            this.args[0] = this.dat;
            charSequence = new StringBuffer();
            if (this.formatter == null) {
                this.formatter = new MessageFormat(format);
            }
            this.formatter.format(this.args, (StringBuffer)charSequence, (FieldPosition)null);
            stringBuffer.append((StringBuffer)charSequence);
            stringBuffer.append(" ");
        }
        if (topLinkLogRecord.getSourceClassName() != null) {
            stringBuffer.append(topLinkLogRecord.getSourceClassName());
        } else {
            stringBuffer.append(topLinkLogRecord.getLoggerName());
        }
        if (topLinkLogRecord.getSourceMethodName() != null) {
            stringBuffer.append(" ");
            stringBuffer.append(topLinkLogRecord.getSourceMethodName());
        }
        if (topLinkLogRecord.getSessionString() != null) {
            stringBuffer.append(" ");
            stringBuffer.append(topLinkLogRecord.getSessionString());
        }
        if (topLinkLogRecord.getConnection() != null) {
            stringBuffer.append(" ");
            stringBuffer.append(AbstractSessionLog.CONNECTION_STRING + "(" + String.valueOf(System.identityHashCode(topLinkLogRecord.getConnection())) + ")");
        }
        if (topLinkLogRecord.shouldPrintThread()) {
            stringBuffer.append(" ");
            stringBuffer.append(AbstractSessionLog.THREAD_STRING + "(" + String.valueOf(topLinkLogRecord.getThreadID()) + ")");
        }
        stringBuffer.append(this.lineSeparator);
        charSequence = this.formatMessage(topLinkLogRecord);
        stringBuffer.append(topLinkLogRecord.getLevel().getLocalizedName());
        stringBuffer.append(": ");
        stringBuffer.append((String)charSequence);
        stringBuffer.append(this.lineSeparator);
        if (topLinkLogRecord.getThrown() != null) {
            try {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                if (topLinkLogRecord.getLevel().intValue() == Level.SEVERE.intValue()) {
                    topLinkLogRecord.getThrown().printStackTrace(printWriter);
                } else if (topLinkLogRecord.getLevel().intValue() <= Level.WARNING.intValue()) {
                    if (topLinkLogRecord.shouldLogExceptionStackTrace()) {
                        topLinkLogRecord.getThrown().printStackTrace(printWriter);
                    } else {
                        printWriter.write(topLinkLogRecord.getThrown().toString());
                        printWriter.write(this.lineSeparator);
                    }
                }
                printWriter.close();
                stringBuffer.append(stringWriter.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stringBuffer.toString();
    }
}

