/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.sessions;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import oracle.toplink.descriptors.TimestampLockingPolicy;
import oracle.toplink.descriptors.VersionLockingPolicy;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.ConversionManager;
import oracle.toplink.internal.identitymaps.CacheKey;
import oracle.toplink.internal.sessions.ChangeRecord;
import oracle.toplink.internal.sessions.DirectToFieldChangeRecord;
import oracle.toplink.internal.sessions.UnitOfWorkChangeSet;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.ReadObjectQuery;

public class ObjectChangeSet
implements Serializable,
oracle.toplink.changesets.ObjectChangeSet {
    protected Vector changes;
    protected Hashtable attributesToChanges;
    protected boolean shouldBeDeleted;
    protected CacheKey cacheKey;
    protected transient Class classType;
    protected String className;
    protected boolean isNew;
    protected boolean isAggregate;
    protected Object oldKey;
    protected Object newKey;
    protected UnitOfWorkChangeSet unitOfWorkChangeSet;
    protected Object writeLockValue;
    protected transient Object cloneObject;
    protected boolean hasVersionChange;
    protected Boolean shouldModifyVersionField;
    protected boolean hasCmpPolicyForcedUpdate;
    protected boolean hasChangesFromCascadeLocking;
    protected transient HashSet deferredSet;
    protected int cacheSynchronizationType = 0;
    protected int id = -1;

    public ObjectChangeSet() {
    }

    public ObjectChangeSet(Object object, UnitOfWorkChangeSet unitOfWorkChangeSet, boolean bl) {
        this.cloneObject = object;
        this.shouldBeDeleted = false;
        this.classType = object.getClass();
        this.className = this.classType.getName();
        this.unitOfWorkChangeSet = unitOfWorkChangeSet;
        this.isNew = bl;
    }

    public ObjectChangeSet(Vector vector, Object object, UnitOfWorkChangeSet unitOfWorkChangeSet, boolean bl) {
        this.cloneObject = object;
        this.isNew = bl;
        this.shouldBeDeleted = false;
        if (vector != null) {
            this.cacheKey = new CacheKey(vector);
        }
        this.classType = object.getClass();
        this.className = this.classType.getName();
        this.unitOfWorkChangeSet = unitOfWorkChangeSet;
        this.isAggregate = false;
    }

    public void clear() {
        this.shouldBeDeleted = false;
        this.setOldKey(null);
        this.setNewKey(null);
        this.changes = null;
        this.attributesToChanges = null;
    }

    public void addChange(ChangeRecord changeRecord) {
        if (changeRecord == null) {
            return;
        }
        String string = changeRecord.getAttribute();
        Hashtable hashtable = this.getAttributesToChanges();
        Vector vector = this.getChanges();
        ChangeRecord changeRecord2 = (ChangeRecord)hashtable.get(string);
        if (changeRecord2 != null) {
            vector.remove(changeRecord2);
        }
        vector.add(changeRecord);
        hashtable.put(string, changeRecord);
        this.dirtyUOWChangeSet();
    }

    public void deferredDetectionRequiredOn(String string) {
        this.getDeferredSet().add(string);
    }

    public boolean containsChangesFromSynchronization() {
        return this.cacheSynchronizationType == 3 || this.cacheSynchronizationType == 1;
    }

    public boolean equals(Object object) {
        if (object instanceof ObjectChangeSet) {
            return this.equals((ObjectChangeSet)object);
        }
        return false;
    }

    public boolean equals(oracle.toplink.changesets.ObjectChangeSet objectChangeSet) {
        if (this == objectChangeSet) {
            return true;
        }
        if (this.getCacheKey() == null) {
            return false;
        }
        return this.getCacheKey().equals(((ObjectChangeSet)objectChangeSet).getCacheKey());
    }

    public Hashtable getAttributesToChanges() {
        if (this.attributesToChanges == null) {
            this.attributesToChanges = new Hashtable(10);
        }
        return this.attributesToChanges;
    }

    public oracle.toplink.changesets.ChangeRecord getChangesForAttributeNamed(String string) {
        return (ChangeRecord)this.getAttributesToChanges().get(string);
    }

    public CacheKey getCacheKey() {
        return this.cacheKey;
    }

    public Vector getChangedAttributeNames() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.getChanges().elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(((ChangeRecord)enumeration.nextElement()).getAttribute());
        }
        return vector;
    }

    public Vector getChanges() {
        if (this.changes == null) {
            this.changes = new Vector();
        }
        return this.changes;
    }

    public Class getClassType(oracle.toplink.sessions.Session session) {
        if (this.classType == null) {
            this.classType = (Class)((Session)session).getDatasourcePlatform().getConversionManager().convertObject(this.getClassName(), ClassConstants.CLASS);
        }
        return this.classType;
    }

    public String getClassName() {
        return this.className;
    }

    public Object getOldKey() {
        return this.oldKey;
    }

    public Object getNewKey() {
        return this.newKey;
    }

    public Vector getPrimaryKeys() {
        if (this.getCacheKey() == null) {
            return null;
        }
        return this.getCacheKey().getKey();
    }

    public int getSynchronizationType() {
        return this.cacheSynchronizationType;
    }

    public Object getTargetVersionOfSourceObject(Session session) {
        return this.getTargetVersionOfSourceObject(session, false);
    }

    public Object getTargetVersionOfSourceObject(Session session, boolean bl) {
        Object object = null;
        Descriptor descriptor = session.getDescriptor(this.getClassType(session));
        if (session.getCommandManager() != null && session.getCommandManager().getCommandConverter() != null) {
            this.rebuildPKFromUserFormat(descriptor, session);
        }
        object = session.isUnitOfWork() ? (((UnitOfWork)session).getLifecycle() == 4 ? ((UnitOfWork)session).getOriginalVersionOfObjectOrNull(((UnitOfWorkChangeSet)this.getUOWChangeSet()).getObjectChangeSetToUOWClone().get(this)) : ((UnitOfWorkChangeSet)this.getUOWChangeSet()).getObjectChangeSetToUOWClone().get(this)) : session.getIdentityMapAccessorInstance().getIdentityMapManager().getFromIdentityMap(this.getPrimaryKeys(), this.getClassType(session), descriptor);
        if (object == null && bl) {
            ReadObjectQuery readObjectQuery = new ReadObjectQuery();
            readObjectQuery.setShouldUseWrapperPolicy(false);
            readObjectQuery.setReferenceClass(this.getClassType(session));
            readObjectQuery.setSelectionKey(this.getPrimaryKeys());
            object = session.executeQuery(readObjectQuery);
        }
        return object;
    }

    public Object getUnitOfWorkClone() {
        return this.cloneObject;
    }

    public oracle.toplink.changesets.UnitOfWorkChangeSet getUOWChangeSet() {
        return this.unitOfWorkChangeSet;
    }

    public Object getWriteLockValue() {
        return this.writeLockValue;
    }

    public boolean hasChangeFor(String string) {
        Enumeration enumeration = this.getChanges().elements();
        while (enumeration.hasMoreElements()) {
            if (!((ChangeRecord)enumeration.nextElement()).getAttribute().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean hasChanges() {
        return this.hasVersionChange || this.changes != null && !this.changes.isEmpty();
    }

    public boolean hasForcedChanges() {
        return this.shouldModifyVersionField != null || this.hasCmpPolicyForcedUpdate;
    }

    public void setShouldModifyVersionField(Boolean bl) {
        this.shouldModifyVersionField = bl;
        if (bl != null && bl.booleanValue()) {
            this.hasVersionChange = true;
        }
    }

    public Boolean shouldModifyVersionField() {
        return this.shouldModifyVersionField;
    }

    public void setHasCmpPolicyForcedUpdate(boolean bl) {
        this.hasCmpPolicyForcedUpdate = bl;
    }

    public boolean hasCmpPolicyForcedUpdate() {
        return this.hasCmpPolicyForcedUpdate;
    }

    public boolean hasForcedChangesFromCascadeLocking() {
        return this.hasChangesFromCascadeLocking;
    }

    public void setHasForcedChangesFromCascadeLocking(boolean bl) {
        this.setShouldModifyVersionField(Boolean.TRUE);
        this.hasChangesFromCascadeLocking = bl;
    }

    public int hashCode() {
        if (this.getCacheKey() == null) {
            return System.identityHashCode(this);
        }
        return this.getCacheKey().hashCode();
    }

    public boolean hasKeys() {
        return this.newKey != null || this.oldKey != null;
    }

    public boolean isAggregate() {
        return this.isAggregate;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void mergeObjectChanges(ObjectChangeSet objectChangeSet, UnitOfWorkChangeSet unitOfWorkChangeSet, UnitOfWorkChangeSet unitOfWorkChangeSet2) {
        if (this == objectChangeSet) {
            return;
        }
        Vector vector = objectChangeSet.getChanges();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ChangeRecord changeRecord = (ChangeRecord)vector.get(i);
            ChangeRecord changeRecord2 = (ChangeRecord)this.getChangesForAttributeNamed(changeRecord.getAttribute());
            if (changeRecord2 == null) {
                changeRecord.updateReferences(unitOfWorkChangeSet, unitOfWorkChangeSet2);
                this.addChange(changeRecord);
                continue;
            }
            changeRecord2.mergeRecord(changeRecord, unitOfWorkChangeSet, unitOfWorkChangeSet2);
        }
        this.shouldBeDeleted = objectChangeSet.shouldBeDeleted;
        this.setOldKey(objectChangeSet.oldKey);
        this.setNewKey(objectChangeSet.newKey);
        this.writeLockValue = objectChangeSet.writeLockValue;
        this.hasVersionChange = objectChangeSet.hasVersionChange;
        this.shouldModifyVersionField = objectChangeSet.shouldModifyVersionField;
        this.hasCmpPolicyForcedUpdate = objectChangeSet.hasCmpPolicyForcedUpdate;
        this.hasChangesFromCascadeLocking = objectChangeSet.hasChangesFromCascadeLocking;
        this.id = objectChangeSet.id;
    }

    public void prepareChangeRecordsForSynchronization(Session session) {
        Enumeration enumeration = this.getChanges().elements();
        while (enumeration.hasMoreElements()) {
            ((ChangeRecord)enumeration.nextElement()).prepareForSynchronization(session);
        }
    }

    public void readCompleteChangeSet(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.readIdentityInformation(objectInputStream);
        this.changes = (Vector)objectInputStream.readObject();
        this.setOldKey(objectInputStream.readObject());
        this.newKey = objectInputStream.readObject();
    }

    public void readIdentityInformation(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.cacheKey = (CacheKey)objectInputStream.readObject();
        this.className = (String)objectInputStream.readObject();
        this.writeLockValue = objectInputStream.readObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.read();
        this.setSynchronizationType(n);
        this.setShouldBeDeleted(objectInputStream.readBoolean());
        this.setIsNew(objectInputStream.readBoolean());
        this.setIsAggregate(objectInputStream.readBoolean());
        this.setId(objectInputStream.readInt());
        if (this.shouldBeDeleted || this.cacheSynchronizationType == 4 || this.cacheSynchronizationType == 2) {
            this.readIdentityInformation(objectInputStream);
        } else {
            this.readCompleteChangeSet(objectInputStream);
        }
        this.updateUOWChangeSet();
    }

    public void setCacheKey(CacheKey cacheKey) {
        this.cacheKey = cacheKey;
    }

    public void setChanges(Vector vector) {
        this.changes = vector;
        this.updateUOWChangeSet();
    }

    public void setClassType(Class clazz) {
        this.classType = clazz;
    }

    public void setClassName(String string) {
        this.className = string;
    }

    public void setIsAggregate(boolean bl) {
        this.isAggregate = bl;
    }

    protected void setIsNew(boolean bl) {
        this.isNew = bl;
    }

    public void setOldKey(Object object) {
        if (object == null || this.oldKey == null) {
            this.oldKey = object;
        }
    }

    public void setNewKey(Object object) {
        this.newKey = object;
    }

    public void setShouldBeDeleted(boolean bl) {
        this.shouldBeDeleted = bl;
    }

    public void setSynchronizationType(int n) {
        this.cacheSynchronizationType = n;
    }

    public void setUOWChangeSet(UnitOfWorkChangeSet unitOfWorkChangeSet) {
        this.unitOfWorkChangeSet = unitOfWorkChangeSet;
    }

    public void setInitialWriteLockValue(Object object) {
        this.writeLockValue = object;
    }

    public void setWriteLockValue(Object object) {
        this.setInitialWriteLockValue(object);
        this.hasVersionChange = true;
        this.updateUOWChangeSet();
    }

    public boolean shouldBeDeleted() {
        return this.shouldBeDeleted;
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.getClassName() + ")" + this.getChanges().toString();
    }

    public void updateChangeRecordForAttribute(String string, Object object) {
        ChangeRecord changeRecord = (ChangeRecord)this.getChangesForAttributeNamed(string);
        if (changeRecord != null) {
            changeRecord.updateChangeRecordWithNewValue(object);
        }
    }

    public void updateChangeRecordForAttributeWithMappedObject(String string, Object object, Session session) {
        Descriptor descriptor;
        ObjectChangeSet objectChangeSet = (ObjectChangeSet)this.getUOWChangeSet().getObjectChangeSetForClone(object);
        if (objectChangeSet == null && (descriptor = session.getDescriptor(object.getClass())) != null) {
            objectChangeSet = descriptor.getObjectBuilder().createObjectChangeSet(object, (UnitOfWorkChangeSet)this.getUOWChangeSet(), false, session);
        }
        this.updateChangeRecordForAttribute(string, (Object)objectChangeSet);
    }

    public void updateChangeRecordForAttribute(DatabaseMapping databaseMapping, Object object) {
        String string = databaseMapping.getAttributeName();
        ChangeRecord changeRecord = (ChangeRecord)this.getChangesForAttributeNamed(string);
        object = ConversionManager.getDefaultManager().convertObject(object, databaseMapping.getAttributeClassification());
        if (changeRecord != null) {
            changeRecord.updateChangeRecordWithNewValue(object);
        } else if (databaseMapping.isDirectToFieldMapping()) {
            changeRecord = new DirectToFieldChangeRecord(this);
            changeRecord.setAttribute(string);
            changeRecord.setMapping(databaseMapping);
            ((DirectToFieldChangeRecord)changeRecord).setNewValue(object);
            this.addChange(changeRecord);
        }
    }

    public void updateReferences(UnitOfWorkChangeSet unitOfWorkChangeSet, UnitOfWorkChangeSet unitOfWorkChangeSet2) {
        for (int i = 0; i < this.getChanges().size(); ++i) {
            ((ChangeRecord)this.getChanges().get(i)).updateReferences(unitOfWorkChangeSet, unitOfWorkChangeSet2);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.write(this.cacheSynchronizationType);
        objectOutputStream.writeBoolean(this.shouldBeDeleted);
        objectOutputStream.writeBoolean(this.isNew);
        objectOutputStream.writeBoolean(this.isAggregate);
        objectOutputStream.writeInt(this.id);
        if (this.shouldBeDeleted || this.cacheSynchronizationType == 4 || this.cacheSynchronizationType == 2) {
            this.writeIdentityInformation(objectOutputStream);
        } else {
            this.writeCompleteChangeSet(objectOutputStream);
        }
    }

    public void writeIdentityInformation(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.cacheKey);
        objectOutputStream.writeObject(this.className);
        objectOutputStream.writeObject(this.writeLockValue);
    }

    public void writeCompleteChangeSet(ObjectOutputStream objectOutputStream) throws IOException {
        this.writeIdentityInformation(objectOutputStream);
        objectOutputStream.writeObject(this.changes);
        objectOutputStream.writeObject(this.oldKey);
        objectOutputStream.writeObject(this.newKey);
    }

    public void setPrimaryKeys(Vector vector) {
        if (vector == null) {
            return;
        }
        if (this.getCacheKey() == null) {
            this.setCacheKey(new CacheKey(vector));
        } else {
            this.getCacheKey().setKey(vector);
        }
    }

    public HashSet getDeferredSet() {
        if (this.deferredSet == null) {
            this.deferredSet = new HashSet();
        }
        return this.deferredSet;
    }

    public boolean hasDeferredAttributes() {
        return this.deferredSet != null && !this.deferredSet.isEmpty();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    public Vector getSDKChanges() {
        return this.getChanges();
    }

    public void setSDKChanges(Vector vector) {
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                ((ChangeRecord)enumeration.nextElement()).setOwner(this);
            }
            this.setChanges(vector);
        }
    }

    protected void dirtyUOWChangeSet() {
        UnitOfWorkChangeSet unitOfWorkChangeSet = (UnitOfWorkChangeSet)this.getUOWChangeSet();
        if (unitOfWorkChangeSet != null) {
            unitOfWorkChangeSet.setHasChanges(true);
        }
    }

    protected void updateUOWChangeSet() {
        if (this.getUOWChangeSet() != null) {
            ((UnitOfWorkChangeSet)this.getUOWChangeSet()).setHasChanges(this.hasChanges());
        }
    }

    public void rebuildPKFromUserFormat(Descriptor descriptor, Session session) {
        Vector<Object> vector = new Vector<Object>();
        Vector vector2 = this.getPrimaryKeys();
        Vector vector3 = descriptor.getObjectBuilder().getPrimaryKeyClassifications();
        for (int i = 0; i < vector2.size(); ++i) {
            Object object = session.getPlatform(descriptor.getJavaClass()).getConversionManager().convertObject(vector2.elementAt(i), (Class)vector3.elementAt(i));
            vector.add(i, object);
        }
        if (vector.size() > 0) {
            this.setPrimaryKeys(vector);
        }
    }

    protected void rebuildWriteLockValueFromUserFormat(Descriptor descriptor, Session session) {
        if (descriptor.getOptimisticLockingPolicy() instanceof TimestampLockingPolicy) {
            this.writeLockValue = session.getPlatform(descriptor.getJavaClass()).getConversionManager().convertObject(this.writeLockValue, ClassConstants.JavaSqlTimestamp_Class);
        } else if (descriptor.getOptimisticLockingPolicy() instanceof VersionLockingPolicy) {
            this.writeLockValue = session.getPlatform(descriptor.getJavaClass()).getConversionManager().convertObject(this.writeLockValue, ClassConstants.BIGDECIMAL);
        }
    }

    public void removeChange(String string) {
        oracle.toplink.changesets.ChangeRecord changeRecord = this.getChangesForAttributeNamed(string);
        if (changeRecord != null) {
            this.getChanges().removeElement(changeRecord);
        }
    }

    protected void removeFromIdentityMap(Session session) {
        if (session.getCommandManager() != null && session.getCommandManager().getCommandConverter() != null) {
            this.rebuildPKFromUserFormat(session.getDescriptor(this.getClassType(session)), session);
        }
        session.getIdentityMapAccessor().removeFromIdentityMap(this.getPrimaryKeys(), this.getClassType(session));
    }
}

