/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.sessions;

import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.internal.identitymaps.IdentityMapManager;
import oracle.toplink.internal.sessions.FinalizedClientSession;
import oracle.toplink.internal.sessions.IsolatedClientSessionIdentityMapAccessor;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.Call;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.threetier.ConnectionPolicy;
import oracle.toplink.threetier.ServerSession;

public class IsolatedClientSession
extends FinalizedClientSession {
    public IsolatedClientSession(ServerSession serverSession, ConnectionPolicy connectionPolicy) {
        super(serverSession, connectionPolicy);
    }

    public void initializeIdentityMapAccessor() {
        this.identityMapAccessor = new IsolatedClientSessionIdentityMapAccessor(this, new IdentityMapManager(this));
    }

    protected boolean shouldExecuteLocally(DatabaseQuery databaseQuery) {
        if (this.isIsolatedQuery(databaseQuery)) {
            return true;
        }
        return this.isInTransaction();
    }

    protected boolean isIsolatedQuery(DatabaseQuery databaseQuery) {
        databaseQuery.checkDescriptor(this);
        return databaseQuery.isDataModifyQuery() || databaseQuery.isDataReadQuery() || databaseQuery.getDescriptor() != null && databaseQuery.getDescriptor().isIsolated() || databaseQuery.isObjectLevelReadQuery() && ((ObjectLevelReadQuery)databaseQuery).shouldUseExclusiveConnection();
    }

    public Session getParentIdentityMapSession(DatabaseQuery databaseQuery, boolean bl, boolean bl2) {
        if (databaseQuery != null && this.isIsolatedQuery(databaseQuery)) {
            return this;
        }
        return this.getParent().getParentIdentityMapSession(databaseQuery, bl, bl2);
    }

    public Session getExecutionSession(DatabaseQuery databaseQuery) {
        if (this.shouldExecuteLocally(databaseQuery)) {
            return this;
        }
        return this.getParent().getExecutionSession(databaseQuery);
    }

    public Object executeCall(Call call, DatabaseRow databaseRow, DatabaseQuery databaseQuery) throws DatabaseException {
        if (this.isInTransaction()) {
            return super.executeCall(call, databaseRow, databaseQuery);
        }
        return this.getParent().executeCall(call, databaseRow, databaseQuery);
    }
}

