/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.sessions;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import oracle.toplink.internal.helper.IdentityHashtable;
import oracle.toplink.internal.sessions.ChangeRecord;
import oracle.toplink.internal.sessions.ObjectChangeSet;
import oracle.toplink.internal.sessions.UnitOfWorkChangeSet;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;

public class CollectionChangeRecord
extends ChangeRecord
implements oracle.toplink.changesets.CollectionChangeRecord {
    protected IdentityHashtable addObjectList;
    protected transient List addOverFlow;
    protected IdentityHashtable removeObjectList;
    protected transient Vector sdkAddObjects;
    protected transient Vector sdkRemoveObjects;
    protected transient Object originalCollection;
    protected transient Object latestCollection;

    public CollectionChangeRecord() {
    }

    public CollectionChangeRecord(ObjectChangeSet objectChangeSet) {
        this.owner = objectChangeSet;
    }

    public void addAdditionChange(IdentityHashtable identityHashtable, UnitOfWorkChangeSet unitOfWorkChangeSet, Session session) {
        Enumeration enumeration = identityHashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            ObjectChangeSet objectChangeSet = session.getDescriptor(e.getClass()).getObjectBuilder().createObjectChangeSet(e, unitOfWorkChangeSet, session);
            if (objectChangeSet.hasKeys()) {
                this.getAddObjectList().put(objectChangeSet, objectChangeSet);
                continue;
            }
            if (this.getRemoveObjectList().contains(objectChangeSet)) {
                this.getRemoveObjectList().remove(objectChangeSet);
                continue;
            }
            this.getAddObjectList().put(objectChangeSet, objectChangeSet);
        }
    }

    public void addRemoveChange(IdentityHashtable identityHashtable, UnitOfWorkChangeSet unitOfWorkChangeSet, Session session) {
        Enumeration enumeration = identityHashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            Descriptor descriptor = session.getDescriptor(e.getClass());
            ObjectChangeSet objectChangeSet = descriptor.getObjectBuilder().createObjectChangeSet(e, unitOfWorkChangeSet, session);
            if (objectChangeSet.hasKeys()) {
                this.getRemoveObjectList().put(objectChangeSet, objectChangeSet);
                continue;
            }
            if (this.getAddObjectList().contains(objectChangeSet)) {
                this.getAddObjectList().remove(objectChangeSet);
                continue;
            }
            this.getRemoveObjectList().put(objectChangeSet, objectChangeSet);
        }
    }

    public IdentityHashtable getAddObjectList() {
        if (this.addObjectList == null) {
            this.addObjectList = new IdentityHashtable();
        }
        return this.addObjectList;
    }

    public List getAddOverFlow() {
        if (this.addOverFlow == null) {
            this.addOverFlow = new ArrayList();
        }
        return this.addOverFlow;
    }

    public IdentityHashtable getRemoveObjectList() {
        if (this.removeObjectList == null) {
            this.removeObjectList = new IdentityHashtable();
        }
        return this.removeObjectList;
    }

    public boolean hasChanges() {
        return !this.getAddObjectList().isEmpty() || !this.getRemoveObjectList().isEmpty() || this.getOwner().isNew();
    }

    public void mergeRecord(ChangeRecord changeRecord, UnitOfWorkChangeSet unitOfWorkChangeSet, UnitOfWorkChangeSet unitOfWorkChangeSet2) {
        ObjectChangeSet objectChangeSet;
        Object object;
        Enumeration enumeration = ((CollectionChangeRecord)changeRecord).getAddObjectList().keys();
        while (enumeration.hasMoreElements()) {
            object = (ObjectChangeSet)enumeration.nextElement();
            objectChangeSet = unitOfWorkChangeSet.findOrIntegrateObjectChangeSet((ObjectChangeSet)object, unitOfWorkChangeSet2);
            if (this.getRemoveObjectList().containsKey(objectChangeSet)) {
                this.getRemoveObjectList().remove(objectChangeSet);
                continue;
            }
            this.getAddObjectList().put(objectChangeSet, objectChangeSet);
        }
        object = ((CollectionChangeRecord)changeRecord).getRemoveObjectList().keys();
        while (object.hasMoreElements()) {
            objectChangeSet = (ObjectChangeSet)object.nextElement();
            ObjectChangeSet objectChangeSet2 = unitOfWorkChangeSet.findOrIntegrateObjectChangeSet(objectChangeSet, unitOfWorkChangeSet2);
            if (this.getAddObjectList().containsKey(objectChangeSet2)) {
                this.getAddObjectList().remove(objectChangeSet2);
                continue;
            }
            this.getRemoveObjectList().put(objectChangeSet2, objectChangeSet2);
        }
    }

    public void prepareForSynchronization(Session session) {
        int n;
        Descriptor descriptor;
        ObjectChangeSet objectChangeSet;
        Enumeration enumeration = this.getAddObjectList().elements();
        while (enumeration.hasMoreElements()) {
            objectChangeSet = (ObjectChangeSet)enumeration.nextElement();
            if (objectChangeSet.getSynchronizationType() != 0) continue;
            descriptor = session.getDescriptor(objectChangeSet.getClassType(session));
            n = descriptor.getCacheSynchronizationType();
            objectChangeSet.setSynchronizationType(n);
            objectChangeSet.prepareChangeRecordsForSynchronization(session);
        }
        enumeration = this.getRemoveObjectList().elements();
        while (enumeration.hasMoreElements()) {
            objectChangeSet = (ObjectChangeSet)enumeration.nextElement();
            if (objectChangeSet.getSynchronizationType() != 0) continue;
            descriptor = session.getDescriptor(objectChangeSet.getClassType(session));
            n = descriptor.getCacheSynchronizationType();
            objectChangeSet.setSynchronizationType(n);
            objectChangeSet.prepareChangeRecordsForSynchronization(session);
        }
    }

    public void setAddObjectList(IdentityHashtable identityHashtable) {
        this.addObjectList = identityHashtable;
    }

    public void setRemoveObjectList(IdentityHashtable identityHashtable) {
        this.removeObjectList = identityHashtable;
    }

    public void updateReferences(UnitOfWorkChangeSet unitOfWorkChangeSet, UnitOfWorkChangeSet unitOfWorkChangeSet2) {
        ObjectChangeSet objectChangeSet;
        IdentityHashtable identityHashtable = new IdentityHashtable(this.getAddObjectList().size() + 1);
        IdentityHashtable identityHashtable2 = new IdentityHashtable(this.getRemoveObjectList().size() + 1);
        Enumeration enumeration = this.getAddObjectList().elements();
        while (enumeration.hasMoreElements()) {
            objectChangeSet = unitOfWorkChangeSet.findOrIntegrateObjectChangeSet((ObjectChangeSet)enumeration.nextElement(), unitOfWorkChangeSet2);
            identityHashtable.put(objectChangeSet, objectChangeSet);
        }
        enumeration = this.getRemoveObjectList().elements();
        while (enumeration.hasMoreElements()) {
            objectChangeSet = unitOfWorkChangeSet.findOrIntegrateObjectChangeSet((ObjectChangeSet)enumeration.nextElement(), unitOfWorkChangeSet2);
            identityHashtable2.put(objectChangeSet, objectChangeSet);
        }
        this.setAddObjectList(identityHashtable);
        this.setRemoveObjectList(identityHashtable2);
    }

    public Vector getAddObjectsForSDK() {
        if (this.sdkAddObjects == null) {
            this.sdkAddObjects = new Vector();
            Enumeration enumeration = this.getAddObjectList().keys();
            while (enumeration.hasMoreElements()) {
                this.sdkAddObjects.add(enumeration.nextElement());
            }
        }
        return this.sdkAddObjects;
    }

    public void setAddObjectsForSDK(Vector vector) {
        this.sdkAddObjects = vector;
        IdentityHashtable identityHashtable = new IdentityHashtable();
        for (int i = 0; i < this.sdkAddObjects.size(); ++i) {
            Object e = this.sdkAddObjects.elementAt(i);
            identityHashtable.put(e, e);
        }
        this.setAddObjectList(identityHashtable);
    }

    public Vector getRemoveObjectsForSDK() {
        if (this.sdkRemoveObjects == null) {
            this.sdkRemoveObjects = new Vector();
            Enumeration enumeration = this.getRemoveObjectList().keys();
            while (enumeration.hasMoreElements()) {
                this.sdkRemoveObjects.add(enumeration.nextElement());
            }
        }
        return this.sdkRemoveObjects;
    }

    public void setRemoveObjectsForSDK(Vector vector) {
        this.sdkRemoveObjects = vector;
        IdentityHashtable identityHashtable = new IdentityHashtable();
        for (int i = 0; i < this.sdkRemoveObjects.size(); ++i) {
            Object e = this.sdkRemoveObjects.elementAt(i);
            identityHashtable.put(e, e);
        }
        this.setRemoveObjectList(identityHashtable);
    }

    public Object getLatestCollection() {
        return this.latestCollection;
    }

    public void setLatestCollection(Object object) {
        this.latestCollection = object;
    }

    public Object getOriginalCollection() {
        return this.originalCollection;
    }

    public void setOriginalCollection(Object object) {
        this.originalCollection = object;
    }
}

