/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.remote;

import java.rmi.server.ObjID;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.queryframework.ScrollableCursor;
import oracle.toplink.remote.RemoteSession;

public class RemoteScrollableCursor
extends ScrollableCursor {
    protected ObjID id = new ObjID();
    protected boolean isClosed;

    public RemoteScrollableCursor(ScrollableCursor scrollableCursor) {
        this.isClosed = scrollableCursor.isClosed();
    }

    public boolean absolute(int n) throws DatabaseException {
        this.clearNextAndPrevious();
        return ((RemoteSession)this.getSession()).getRemoteConnection().scrollableCursorAbsolute(this.getID(), n);
    }

    public void afterLast() throws DatabaseException {
        this.clearNextAndPrevious();
        ((RemoteSession)this.getSession()).getRemoteConnection().scrollableCursorAfterLast(this.getID());
    }

    public void beforeFirst() throws DatabaseException {
        this.clearNextAndPrevious();
        ((RemoteSession)this.getSession()).getRemoteConnection().scrollableCursorBeforeFirst(this.getID());
    }

    public void close() throws DatabaseException {
        if (this.isClosed()) {
            return;
        }
        ((RemoteSession)this.getSession()).getRemoteConnection().scrollableCursorClose(this.getID());
        this.isClosed = true;
    }

    public int currentIndex() throws DatabaseException {
        return ((RemoteSession)this.getSession()).getRemoteConnection().scrollableCursorCurrentIndex(this.getID());
    }

    public boolean first() throws DatabaseException {
        this.clearNextAndPrevious();
        return ((RemoteSession)this.getSession()).getRemoteConnection().scrollableCursorFirst(this.getID());
    }

    protected int getCursorSize() {
        return ((RemoteSession)this.getSession()).getRemoteConnection().scrollableCursorSize(this.getID());
    }

    public ObjID getID() {
        return this.id;
    }

    public boolean isAfterLast() throws DatabaseException {
        return ((RemoteSession)this.getSession()).getRemoteConnection().scrollableCursorIsAfterLast(this.getID());
    }

    public boolean isBeforeFirst() throws DatabaseException {
        return ((RemoteSession)this.getSession()).getRemoteConnection().scrollableCursorIsBeforeFirst(this.getID());
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public boolean isFirst() throws DatabaseException {
        return ((RemoteSession)this.getSession()).getRemoteConnection().scrollableCursorIsFirst(this.getID());
    }

    public boolean isLast() throws DatabaseException {
        return ((RemoteSession)this.getSession()).getRemoteConnection().scrollableCursorIsLast(this.getID());
    }

    public boolean last() throws DatabaseException {
        this.clearNextAndPrevious();
        return ((RemoteSession)this.getSession()).getRemoteConnection().scrollableCursorLast(this.getID());
    }

    public boolean relative(int n) throws DatabaseException {
        this.clearNextAndPrevious();
        return ((RemoteSession)this.getSession()).getRemoteConnection().scrollableCursorRelative(this.getID(), n);
    }

    protected Object retrieveNextObject() throws DatabaseException, QueryException {
        return ((RemoteSession)this.getSession()).getRemoteConnection().scrollableCursorNextObject(this.getID(), this.getPolicy().getQuery(), (RemoteSession)this.getSession());
    }

    protected Object retrievePreviousObject() throws DatabaseException {
        return ((RemoteSession)this.getSession()).getRemoteConnection().scrollableCursorPreviousObject(this.getID(), this.getPolicy().getQuery(), (RemoteSession)this.getSession());
    }
}

