/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.queryframework;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.expressions.ExpressionBuilder;
import oracle.toplink.internal.databaseaccess.DatasourceCall;
import oracle.toplink.internal.expressions.ObjectExpression;
import oracle.toplink.internal.expressions.SQLDeleteStatement;
import oracle.toplink.internal.expressions.SQLInsertStatement;
import oracle.toplink.internal.expressions.SQLSelectStatement;
import oracle.toplink.internal.expressions.SQLUpdateAllStatement;
import oracle.toplink.internal.expressions.SQLUpdateStatement;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.DatabaseTable;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.helper.IdentityHashtable;
import oracle.toplink.internal.helper.InvalidObject;
import oracle.toplink.internal.helper.NonSynchronizedVector;
import oracle.toplink.internal.queryframework.DatabaseQueryMechanism;
import oracle.toplink.internal.queryframework.StatementQueryMechanism;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.DescriptorQueryManager;
import oracle.toplink.publicinterface.InheritancePolicy;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.InMemoryQueryIndirectionPolicy;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.queryframework.ReadAllQuery;
import oracle.toplink.queryframework.ReadObjectQuery;
import oracle.toplink.queryframework.ReportQuery;
import oracle.toplink.queryframework.UpdateAllQuery;

public class ExpressionQueryMechanism
extends StatementQueryMechanism {
    protected Expression selectionCriteria;

    public ExpressionQueryMechanism(DatabaseQuery databaseQuery) {
        super(databaseQuery);
    }

    public ExpressionQueryMechanism(DatabaseQuery databaseQuery, Expression expression) {
        super(databaseQuery);
        this.selectionCriteria = expression;
    }

    protected Vector aliasFields(ObjectExpression objectExpression, Vector vector) {
        Vector<DatabaseField> vector2 = new Vector<DatabaseField>(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)((DatabaseField)enumeration.nextElement()).clone();
            databaseField.setTable(objectExpression.aliasForTable(databaseField.getTable()));
            vector2.addElement(databaseField);
        }
        return vector2;
    }

    public Vector aliasPresetFields(SQLSelectStatement sQLSelectStatement) {
        Vector vector = sQLSelectStatement.getFields();
        Expression expression = sQLSelectStatement.getWhereClause();
        if (expression == null) {
            return vector;
        }
        ExpressionBuilder expressionBuilder = expression.getBuilder();
        return this.aliasFields(expressionBuilder, vector);
    }

    public Expression buildBaseSelectionCriteria(boolean bl, Dictionary dictionary) {
        DescriptorQueryManager descriptorQueryManager;
        Expression expression = this.getSelectionCriteria();
        if (expression == null && this.getQuery().isObjectLevelReadQuery()) {
            expression = ((ObjectLevelReadQuery)this.getQuery()).getExpressionBuilder();
        }
        if (!bl && expression != null) {
            expression = expression.copiedVersionFrom(dictionary);
        }
        if (!((descriptorQueryManager = this.getDescriptor().getQueryManager()).getAdditionalJoinExpression() == null || this.getDescriptor().hasInheritance() && this.getDescriptor().getInheritancePolicy().hasView())) {
            Expression expression2 = descriptorQueryManager.getAdditionalJoinExpression();
            expression = expression == null ? (Expression)expression2.clone() : expression.and(expression2);
        }
        return expression;
    }

    public SQLSelectStatement buildBaseSelectStatement(boolean bl, Dictionary dictionary) {
        SQLSelectStatement sQLSelectStatement = new SQLSelectStatement();
        sQLSelectStatement.setLockingClause(((ObjectLevelReadQuery)this.getQuery()).getLockingClause());
        sQLSelectStatement.setDistinctState(((ObjectLevelReadQuery)this.getQuery()).getDistinctState());
        sQLSelectStatement.setTables((Vector)this.getDescriptor().getTables().clone());
        sQLSelectStatement.setWhereClause(this.buildBaseSelectionCriteria(bl, dictionary));
        if (this.getQuery().isReadAllQuery() && ((ReadAllQuery)this.getQuery()).hasOrderByExpressions()) {
            sQLSelectStatement.setOrderByExpressions(((ReadAllQuery)this.getQuery()).getOrderByExpressions());
        }
        if (this.getQuery().isReadAllQuery() && ((ReadAllQuery)this.getQuery()).hasHierarchicalExpressions()) {
            ReadAllQuery readAllQuery = (ReadAllQuery)this.getQuery();
            sQLSelectStatement.setHierarchicalQueryExpressions(readAllQuery.getStartWithExpression(), readAllQuery.getConnectByExpression(), readAllQuery.getOrderSiblingsByExpressions());
        }
        sQLSelectStatement.setHintString(this.getQuery().getHintString());
        sQLSelectStatement.setTranslationRow(this.getTranslationRow());
        return sQLSelectStatement;
    }

    protected SQLSelectStatement buildConcreteSelectStatement() {
        IdentityHashtable identityHashtable = new IdentityHashtable();
        SQLSelectStatement sQLSelectStatement = this.buildBaseSelectStatement(false, identityHashtable);
        if (this.getDescriptor().hasInheritance() && this.getDescriptor().getInheritancePolicy().shouldReadSubclasses()) {
            Expression expression = this.getDescriptor().getInheritancePolicy().getOnlyInstancesExpression();
            if (expression != null && sQLSelectStatement.getWhereClause() != null) {
                sQLSelectStatement.setWhereClause(sQLSelectStatement.getWhereClause().and(expression));
            } else if (expression != null) {
                sQLSelectStatement.setWhereClause((Expression)expression.clone());
            }
        }
        sQLSelectStatement.setFields(this.getSelectionFields(sQLSelectStatement, false));
        sQLSelectStatement.normalize(this.getSession(), this.getDescriptor(), identityHashtable);
        ((ObjectLevelReadQuery)this.getQuery()).computeJoiningMappingIndexes(false);
        return sQLSelectStatement;
    }

    protected SQLDeleteStatement buildDeleteAllStatement() {
        SQLDeleteStatement sQLDeleteStatement = new SQLDeleteStatement();
        sQLDeleteStatement.setWhereClause(this.getSelectionCriteria());
        sQLDeleteStatement.setTable(this.getDescriptor().getDefaultTable());
        sQLDeleteStatement.setTranslationRow(this.getTranslationRow());
        sQLDeleteStatement.setHintString(this.getQuery().getHintString());
        return sQLDeleteStatement;
    }

    protected SQLDeleteStatement buildDeleteStatement(DatabaseTable databaseTable) {
        SQLDeleteStatement sQLDeleteStatement = new SQLDeleteStatement();
        Expression expression = this.getDescriptor().getObjectBuilder().buildDeleteExpression(databaseTable, this.getTranslationRow());
        sQLDeleteStatement.setWhereClause(expression);
        sQLDeleteStatement.setTable(databaseTable);
        sQLDeleteStatement.setTranslationRow(this.getTranslationRow());
        sQLDeleteStatement.setHintString(this.getQuery().getHintString());
        return sQLDeleteStatement;
    }

    protected SQLInsertStatement buildInsertStatement(DatabaseTable databaseTable) {
        SQLInsertStatement sQLInsertStatement = new SQLInsertStatement();
        sQLInsertStatement.setTable(databaseTable);
        sQLInsertStatement.setModifyRow(this.getModifyRow());
        if (this.getDescriptor().hasReturningPolicy()) {
            sQLInsertStatement.setReturnFields(this.getDescriptor().getReturningPolicy().getFieldsToGenerateInsert(databaseTable));
        }
        sQLInsertStatement.setHintString(this.getQuery().getHintString());
        return sQLInsertStatement;
    }

    protected SQLSelectStatement buildNormalSelectStatement() {
        IdentityHashtable identityHashtable = new IdentityHashtable();
        SQLSelectStatement sQLSelectStatement = this.buildBaseSelectStatement(false, identityHashtable);
        if (this.getDescriptor().hasInheritance()) {
            this.getDescriptor().getInheritancePolicy().appendWithAllSubclassesExpression(sQLSelectStatement);
        }
        sQLSelectStatement.setFields(this.getSelectionFields(sQLSelectStatement, true));
        sQLSelectStatement.normalize(this.getSession(), this.getDescriptor(), identityHashtable);
        ((ObjectLevelReadQuery)this.getQuery()).computeJoiningMappingIndexes(true);
        return sQLSelectStatement;
    }

    protected SQLSelectStatement buildReportQuerySelectStatement(boolean bl) {
        IdentityHashtable identityHashtable = bl ? null : new IdentityHashtable();
        SQLSelectStatement sQLSelectStatement = this.buildBaseSelectStatement(bl, identityHashtable);
        sQLSelectStatement.setGroupByExpressions(((ReportQuery)this.getQuery()).getGroupByExpressions());
        if (this.getDescriptor().hasInheritance()) {
            this.getDescriptor().getInheritancePolicy().appendWithAllSubclassesExpression(sQLSelectStatement);
        }
        Vector vector = ((ReportQuery)this.getQuery()).getItemExpressions();
        sQLSelectStatement.setFields(vector);
        if (!bl) {
            sQLSelectStatement.normalize(this.getSession(), this.getDescriptor(), identityHashtable);
        }
        return sQLSelectStatement;
    }

    protected SQLSelectStatement buildSelectStatementForDoesExist(DatabaseField databaseField) {
        SQLSelectStatement sQLSelectStatement = new SQLSelectStatement();
        sQLSelectStatement.addField(databaseField);
        sQLSelectStatement.setWhereClause(((Expression)this.getDescriptor().getObjectBuilder().getPrimaryKeyExpression().clone()).and(this.getDescriptor().getQueryManager().getAdditionalJoinExpression()));
        sQLSelectStatement.setTranslationRow(this.getTranslationRow());
        sQLSelectStatement.normalize(this.getSession(), this.getQuery().getDescriptor());
        sQLSelectStatement.setHintString(this.getQuery().getHintString());
        return sQLSelectStatement;
    }

    protected SQLUpdateStatement buildUpdateStatement(DatabaseTable databaseTable) {
        SQLUpdateStatement sQLUpdateStatement = new SQLUpdateStatement();
        sQLUpdateStatement.setModifyRow(this.getModifyRow());
        if (this.getDescriptor().hasReturningPolicy()) {
            sQLUpdateStatement.setReturnFields(this.getDescriptor().getReturningPolicy().getFieldsToGenerateUpdate(databaseTable));
        }
        sQLUpdateStatement.setTable(databaseTable);
        sQLUpdateStatement.setWhereClause(this.getDescriptor().getObjectBuilder().buildUpdateExpression(databaseTable, this.getTranslationRow(), this.getModifyRow()));
        sQLUpdateStatement.setHintString(this.getQuery().getHintString());
        return sQLUpdateStatement;
    }

    public Object checkCacheForObject(DatabaseRow databaseRow, Session session) {
        Expression expression;
        Vector vector;
        Object object;
        InMemoryQueryIndirectionPolicy inMemoryQueryIndirectionPolicy;
        boolean bl;
        ReadObjectQuery readObjectQuery;
        block31: {
            readObjectQuery = this.getReadObjectQuery();
            bl = (readObjectQuery.shouldConformResultsInUnitOfWork() || this.getDescriptor().shouldAlwaysConformResultsInUnitOfWork()) && session.isUnitOfWork();
            inMemoryQueryIndirectionPolicy = readObjectQuery.getInMemoryQueryIndirectionPolicy();
            if (bl && !inMemoryQueryIndirectionPolicy.shouldTriggerIndirection()) {
                inMemoryQueryIndirectionPolicy = new InMemoryQueryIndirectionPolicy();
                inMemoryQueryIndirectionPolicy.ignoreIndirectionExceptionReturnNotConformed();
            }
            object = null;
            vector = null;
            expression = this.getSelectionCriteria();
            if (readObjectQuery.getSelectionKey() != null || readObjectQuery.getSelectionObject() != null) {
                if (readObjectQuery.getSelectionKey() == null && readObjectQuery.getSelectionObject() != null) {
                    readObjectQuery.setSelectionKey(this.getDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(readObjectQuery.getSelectionObject(), session));
                }
                if (readObjectQuery.getSelectionKey() != null) {
                    vector = readObjectQuery.getSelectionKey();
                    object = this.getDescriptor().shouldAcquireCascadedLocks() ? session.getIdentityMapAccessorInstance().getFromIdentityMapWithDeferredLock(vector, readObjectQuery.getReferenceClass(), false, this.getDescriptor()) : session.getIdentityMapAccessorInstance().getFromIdentityMap(vector, readObjectQuery.getReferenceClass(), false, this.getDescriptor());
                }
            } else if (expression == null) {
                if (readObjectQuery.shouldConformResultsInUnitOfWork() || this.getDescriptor().shouldAlwaysConformResultsInUnitOfWork() || readObjectQuery.shouldCheckCacheOnly() || readObjectQuery.shouldCheckCacheThenDatabase()) {
                    object = session.getIdentityMapAccessorInstance().getIdentityMapManager().getFromIdentityMap(null, readObjectQuery.getReferenceClass(), databaseRow, inMemoryQueryIndirectionPolicy, bl, false, this.getDescriptor());
                }
            } else {
                vector = this.getDescriptor().getObjectBuilder().extractPrimaryKeyFromExpression(true, expression, databaseRow, session);
                if (vector != null || readObjectQuery.shouldCheckCacheByExactPrimaryKey()) {
                    if (vector != null) {
                        object = this.getDescriptor().shouldAcquireCascadedLocks() ? session.getIdentityMapAccessorInstance().getFromIdentityMapWithDeferredLock(vector, readObjectQuery.getReferenceClass(), false, this.getDescriptor()) : session.getIdentityMapAccessorInstance().getFromIdentityMap(vector, readObjectQuery.getReferenceClass(), false, this.getDescriptor());
                    }
                } else {
                    boolean bl2;
                    Vector vector2 = this.getDescriptor().getObjectBuilder().extractPrimaryKeyFromExpression(false, expression, databaseRow, session);
                    if (vector2 != null && (object = this.getDescriptor().shouldAcquireCascadedLocks() ? session.getIdentityMapAccessorInstance().getFromIdentityMapWithDeferredLock(vector2, readObjectQuery.getReferenceClass(), false, this.getDescriptor()) : session.getIdentityMapAccessorInstance().getFromIdentityMap(vector2, readObjectQuery.getReferenceClass(), false, this.getDescriptor())) != null) {
                        try {
                            expression.getBuilder().setSession(session.getRootSession(null));
                            expression.getBuilder().setQueryClass(this.getDescriptor().getJavaClass());
                            if (!expression.doesConform(object, session, databaseRow, inMemoryQueryIndirectionPolicy)) {
                                object = null;
                            }
                        }
                        catch (QueryException queryException) {
                            if (readObjectQuery.shouldCheckCacheOnly()) {
                                throw queryException;
                            }
                            object = null;
                        }
                    }
                    boolean bl3 = bl2 = (readObjectQuery.shouldConformResultsInUnitOfWork() || this.getDescriptor().shouldAlwaysConformResultsInUnitOfWork()) && !session.isUnitOfWork();
                    if (object == null && (bl || !readObjectQuery.shouldCheckCacheByPrimaryKey() && !bl2)) {
                        if (expression != null) {
                            expression.getBuilder().setSession(session.getRootSession(null));
                            expression.getBuilder().setQueryClass(this.getDescriptor().getJavaClass());
                        }
                        try {
                            object = session.getIdentityMapAccessorInstance().getIdentityMapManager().getFromIdentityMap(expression, readObjectQuery.getReferenceClass(), databaseRow, inMemoryQueryIndirectionPolicy, bl, false, this.getDescriptor());
                        }
                        catch (QueryException queryException) {
                            if (!readObjectQuery.shouldCheckCacheOnly()) break block31;
                            throw queryException;
                        }
                    }
                }
            }
        }
        if (bl) {
            if (expression != null) {
                expression.getBuilder().setSession(session.getRootSession(null));
                expression.getBuilder().setQueryClass(this.getDescriptor().getJavaClass());
            }
            if (object == null) {
                try {
                    if (vector != null) {
                        if (!((UnitOfWork)session).shouldNewObjectsBeCached()) {
                            object = ((UnitOfWork)session).getObjectFromNewObjects(readObjectQuery.getReferenceClass(), vector);
                        }
                    } else {
                        object = ((UnitOfWork)session).getObjectFromNewObjects(expression, readObjectQuery.getReferenceClass(), databaseRow, inMemoryQueryIndirectionPolicy);
                    }
                }
                catch (QueryException queryException) {
                    // empty catch block
                }
            }
            if (object != null && ((UnitOfWork)session).isObjectDeleted(object)) {
                if (vector != null) {
                    return InvalidObject.instance;
                }
                object = null;
            }
        }
        if (this.getDescriptor().hasFetchGroupManager() && this.getDescriptor().getFetchGroupManager().isPartialObject(object) && !this.getDescriptor().getFetchGroupManager().isObjectValidForFetchGroup(object, this.getReadObjectQuery().getFetchGroup())) {
            object = null;
        }
        return object;
    }

    public DatabaseQueryMechanism clone(DatabaseQuery databaseQuery) {
        DatabaseQueryMechanism databaseQueryMechanism = (DatabaseQueryMechanism)this.clone();
        databaseQueryMechanism.setQuery(databaseQuery);
        return databaseQueryMechanism;
    }

    public ExpressionBuilder getExpressionBuilder() {
        if (this.getSelectionCriteria() != null) {
            return this.getSelectionCriteria().getBuilder();
        }
        return null;
    }

    public Expression getSelectionCriteria() {
        return this.selectionCriteria;
    }

    public Vector getSelectionFields(SQLSelectStatement sQLSelectStatement, boolean bl) {
        Vector vector;
        ObjectLevelReadQuery objectLevelReadQuery = (ObjectLevelReadQuery)this.getQuery();
        if (objectLevelReadQuery.hasPartialAttributeExpressions()) {
            return objectLevelReadQuery.getPartialAttributeSelectionFields();
        }
        if (objectLevelReadQuery.hasFetchGroup()) {
            return objectLevelReadQuery.getFetchGroupSelectionFields();
        }
        ExpressionBuilder expressionBuilder = sQLSelectStatement.getExpressionBuilder();
        if (bl) {
            vector = (Vector)this.getDescriptor().getAllFields().clone();
        } else {
            vector = NonSynchronizedVector.newInstance();
            ((Vector)vector).addElement(expressionBuilder);
        }
        if (objectLevelReadQuery.hasJoinedAttributes()) {
            Helper.addAllToVector(vector, objectLevelReadQuery.getJoinedAttributeExpressions());
            Helper.addAllToVector(vector, objectLevelReadQuery.getJoinedMappingExpressions());
        }
        if (objectLevelReadQuery.hasAdditionalFields()) {
            Helper.addAllToVector(vector, objectLevelReadQuery.getAdditionalFields());
        }
        return vector;
    }

    public boolean isExpressionQueryMechanism() {
        return true;
    }

    public boolean isStatementQueryMechanism() {
        return false;
    }

    public void prepare() throws QueryException {
    }

    public void prepareCursorSelectAllRows() {
        if (this.getQuery().isReportQuery()) {
            SQLSelectStatement sQLSelectStatement = this.buildReportQuerySelectStatement(false);
            this.setSQLStatement(sQLSelectStatement);
        } else if (this.getDescriptor().hasInheritance() && this.getDescriptor().getInheritancePolicy().requiresMultipleTableSubclassRead() && this.getDescriptor().getInheritancePolicy().hasView()) {
            InheritancePolicy inheritancePolicy = this.getDescriptor().getInheritancePolicy();
            SQLSelectStatement sQLSelectStatement = inheritancePolicy.buildViewSelectStatement((ObjectLevelReadQuery)this.getQuery());
            this.setSQLStatement(sQLSelectStatement);
        } else {
            this.setSQLStatement(this.buildNormalSelectStatement());
        }
        super.prepareCursorSelectAllRows();
    }

    public void prepareDeleteAll() {
        this.setSQLStatement(this.buildDeleteAllStatement());
        super.prepareDeleteAll();
    }

    public void prepareDeleteObject() {
        if (this.getDescriptor().usesFieldLocking() && this.getTranslationRow() == null) {
            return;
        }
        Enumeration enumeration = this.getDescriptor().getMultipleTableInsertOrder().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseTable databaseTable = (DatabaseTable)enumeration.nextElement();
            SQLDeleteStatement sQLDeleteStatement = this.buildDeleteStatement(databaseTable);
            if (this.getDescriptor().getTables().size() > 1) {
                this.getSQLStatements().addElement(sQLDeleteStatement);
                continue;
            }
            this.setSQLStatement(sQLDeleteStatement);
        }
        super.prepareDeleteObject();
    }

    public void prepareDoesExist(DatabaseField databaseField) {
        this.setSQLStatement(this.buildSelectStatementForDoesExist(databaseField));
        super.prepareDoesExist(databaseField);
    }

    public void prepareInsertObject() {
        if (this.getModifyRow() == null) {
            return;
        }
        Enumeration enumeration = this.getDescriptor().getMultipleTableInsertOrder().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseTable databaseTable = (DatabaseTable)enumeration.nextElement();
            SQLInsertStatement sQLInsertStatement = this.buildInsertStatement(databaseTable);
            if (this.getDescriptor().getTables().size() > 1) {
                this.getSQLStatements().addElement(sQLInsertStatement);
                continue;
            }
            this.setSQLStatement(sQLInsertStatement);
        }
        super.prepareInsertObject();
    }

    public void prepareReportQuerySelectAllRows() {
        SQLSelectStatement sQLSelectStatement = this.buildReportQuerySelectStatement(false);
        this.setSQLStatement(sQLSelectStatement);
        this.setSelectionCriteria(null);
        this.setCallFromStatement();
        this.setSQLStatement(null);
        this.getCall().returnManyRows();
        this.prepareCall();
    }

    public void prepareReportQuerySubSelect() {
        this.setSQLStatement(this.buildReportQuerySelectStatement(true));
        this.setSelectionCriteria(null);
    }

    public void prepareSelectAllRows() {
        if (this.getDescriptor().hasInheritance() && this.getDescriptor().getInheritancePolicy().requiresMultipleTableSubclassRead()) {
            if (this.getDescriptor().getInheritancePolicy().hasView()) {
                this.setSQLStatement(this.getDescriptor().getInheritancePolicy().buildViewSelectStatement((ObjectLevelReadQuery)this.getQuery()));
                super.prepareSelectAllRows();
            } else if (!this.getDescriptor().getInheritancePolicy().hasClassExtractor()) {
                this.setSQLStatement(this.getDescriptor().getInheritancePolicy().buildClassIndicatorSelectStatement((ObjectLevelReadQuery)this.getQuery()));
                super.prepareSelectAllRows();
            }
        } else {
            this.setSQLStatement(this.buildNormalSelectStatement());
            super.prepareSelectAllRows();
        }
    }

    public void prepareSelectOneRow() {
        if (this.getDescriptor().hasInheritance() && this.getDescriptor().getInheritancePolicy().requiresMultipleTableSubclassRead()) {
            if (this.getDescriptor().getInheritancePolicy().hasView()) {
                this.setSQLStatement(this.getDescriptor().getInheritancePolicy().buildViewSelectStatement((ObjectLevelReadQuery)this.getQuery()));
                super.prepareSelectOneRow();
            } else if (!this.getDescriptor().getInheritancePolicy().hasClassExtractor()) {
                this.setSQLStatement(this.getDescriptor().getInheritancePolicy().buildClassIndicatorSelectStatement((ObjectLevelReadQuery)this.getQuery()));
                super.prepareSelectOneRow();
            }
        } else {
            this.setSQLStatement(this.buildNormalSelectStatement());
            super.prepareSelectOneRow();
        }
    }

    public void prepareUpdateObject() {
        if (this.getModifyRow() == null) {
            return;
        }
        Vector vector = this.getDescriptor().getQueryManager().getCachedUpdateCalls(this.getModifyRow().getFields());
        if (vector != null) {
            if (vector.size() == 1) {
                this.setCall((DatasourceCall)vector.get(0));
            } else {
                this.setCalls(vector);
            }
            return;
        }
        int n = this.getDescriptor().getTables().size();
        for (int i = 0; i < n; ++i) {
            DatabaseTable databaseTable = (DatabaseTable)this.getDescriptor().getTables().get(i);
            SQLUpdateStatement sQLUpdateStatement = this.buildUpdateStatement(databaseTable);
            if (n > 1) {
                this.getSQLStatements().addElement(sQLUpdateStatement);
                continue;
            }
            this.setSQLStatement(sQLUpdateStatement);
        }
        super.prepareUpdateObject();
        if (this.hasMultipleCalls()) {
            vector = this.getCalls();
        } else {
            vector = NonSynchronizedVector.newInstance(1);
            vector.add(this.getCall());
        }
        this.getDescriptor().getQueryManager().putCachedUpdateCalls(this.getModifyRow().getFields(), vector);
    }

    public void prepareUpdateAll() {
        Expression expression = this.getSelectionCriteria();
        if (expression != null) {
            expression.getBuilder().setSession(this.getSession());
            expression.getBuilder().setQueryClass(this.getQuery().getReferenceClass());
        }
        SQLUpdateAllStatement sQLUpdateAllStatement = new SQLUpdateAllStatement();
        sQLUpdateAllStatement.setWhereClause(expression);
        sQLUpdateAllStatement.setUpdateClauses(((UpdateAllQuery)this.getQuery()).getUpdateClauses());
        sQLUpdateAllStatement.setTranslationRow(this.getTranslationRow());
        sQLUpdateAllStatement.setHintString(this.getQuery().getHintString());
        sQLUpdateAllStatement.setTable(this.getDescriptor().getDefaultTable());
        this.setSQLStatement(sQLUpdateAllStatement);
        super.prepareUpdateAll();
    }

    public Vector selectAllReportQueryRows() throws DatabaseException {
        return this.selectAllRowsFromTable();
    }

    public Vector selectAllRows() throws DatabaseException {
        if (this.getDescriptor().hasInheritance() && this.getDescriptor().getInheritancePolicy().requiresMultipleTableSubclassRead() && !this.getDescriptor().getInheritancePolicy().hasView()) {
            return this.getDescriptor().getInheritancePolicy().selectAllRowUsingMultipleTableSubclassRead((ReadAllQuery)this.getQuery());
        }
        return this.selectAllRowsFromTable();
    }

    public Vector selectAllRowsFromConcreteTable() throws DatabaseException {
        this.setSQLStatement(this.buildConcreteSelectStatement());
        super.prepareSelectAllRows();
        return super.selectAllRows();
    }

    public Vector selectAllRowsFromTable() throws DatabaseException {
        return super.selectAllRows();
    }

    public DatabaseRow selectOneRow() throws DatabaseException {
        if (this.getDescriptor().hasInheritance() && this.getDescriptor().getInheritancePolicy().requiresMultipleTableSubclassRead() && !this.getDescriptor().getInheritancePolicy().hasView()) {
            return this.getDescriptor().getInheritancePolicy().selectOneRowUsingMultipleTableSubclassRead((ReadObjectQuery)this.getQuery());
        }
        return this.selectOneRowFromTable();
    }

    public DatabaseRow selectOneRowFromConcreteTable() throws DatabaseException {
        this.setSQLStatement(this.buildConcreteSelectStatement());
        super.prepareSelectOneRow();
        return super.selectOneRow();
    }

    public DatabaseRow selectOneRowFromTable() throws DatabaseException {
        return super.selectOneRow();
    }

    public void setSelectionCriteria(Expression expression) {
        this.selectionCriteria = expression;
    }
}

