/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.queryframework;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.queryframework.InterfaceContainerPolicy;
import oracle.toplink.mappings.converters.Converter;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;

public class DirectMapContainerPolicy
extends InterfaceContainerPolicy {
    protected DatabaseField keyField;
    protected DatabaseField valueField;
    protected Converter keyConverter;
    protected Converter valueConverter;

    public DirectMapContainerPolicy() {
    }

    public DirectMapContainerPolicy(Class clazz) {
        super(clazz);
    }

    public boolean addInto(Object object, Object object2, Object object3, Session session) {
        try {
            ((Map)object3).put(object, object2);
        }
        catch (ClassCastException classCastException) {
            throw QueryException.cannotAddElement(object, object3, classCastException);
        }
        return true;
    }

    public boolean addInto(Object object, Object object2, Session session) {
        throw ValidationException.operationNotSupported("addInto(Object element, Object container, Session session)");
    }

    public Object buildContainerFromVector(Vector vector, Session session) {
        Map map = (Map)this.containerInstance(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            DatabaseRow databaseRow = (DatabaseRow)enumeration.nextElement();
            Object object = databaseRow.get(this.keyField);
            Object object2 = databaseRow.get(this.valueField);
            if (this.getKeyConverter() != null) {
                object = this.getKeyConverter().convertDataValueToObjectValue(object, session);
            }
            if (this.getValueConverter() != null) {
                object2 = this.getValueConverter().convertDataValueToObjectValue(object2, session);
            }
            if (object == null) continue;
            map.put(object, object2);
        }
        return map;
    }

    public void clear(Object object) {
        try {
            ((Map)object).clear();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw QueryException.methodNotValid(object, "clear()");
        }
    }

    public boolean compareContainers(Object object, Object object2) {
        if (this.sizeFor(object) != this.sizeFor(object2)) {
            return false;
        }
        Object object3 = this.iteratorFor(object);
        while (this.hasNext(object3)) {
            Object object4 = this.next(object3);
            if (((Map)object).get(object4).equals(((Map)object2).get(object4))) continue;
            return false;
        }
        return true;
    }

    public boolean compareKeys(Object object, Session session) {
        Object object2 = null;
        object2 = ((UnitOfWork)session).isClassReadOnly(object.getClass()) ? ((UnitOfWork)session).getOriginalVersionOfObject(object) : ((UnitOfWork)session).getBackupClone(object);
        return this.keyFrom(object2, session).equals(this.keyFrom(object, session));
    }

    protected boolean contains(Object object, Object object2) {
        return ((Map)object2).containsValue(object);
    }

    public Class getInterfaceType() {
        return ClassConstants.Map_Class;
    }

    public boolean isDirectMapPolicy() {
        return true;
    }

    public Object iteratorFor(Object object) {
        if (((Map)object).keySet() == null) {
            return null;
        }
        return ((Map)object).keySet().iterator();
    }

    public Object iteratorForValue(Object object) {
        if (((Map)object).values() == null) {
            return null;
        }
        return ((Map)object).values().iterator();
    }

    public boolean removeFrom(Object object, Object object2, Object object3, Session session) {
        try {
            Object var5_5 = null;
            var5_5 = object != null ? ((Map)object3).remove(object) : ((Map)object3).remove(this.keyFrom(object2, session));
            return var5_5 != null;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw QueryException.methodNotValid(object3, "remove(Object element)");
        }
    }

    public boolean removeFromWithIdentity(Object object, Object object2, Session session) {
        boolean bl = false;
        Vector vector = new Vector(1);
        try {
            Iterator iterator = ((Map)object2).keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                if (((Map)object2).get(k) != object) continue;
                vector.addElement(k);
                bl = true;
            }
            if (bl) {
                for (int i = 0; i < vector.size(); ++i) {
                    ((Map)object2).remove(vector.elementAt(i));
                }
            }
            return bl;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw QueryException.methodNotValid(object2, "remove(Object element)");
        }
    }

    public void setKeyField(DatabaseField databaseField) {
        this.keyField = databaseField;
    }

    public void setValueField(DatabaseField databaseField) {
        this.valueField = databaseField;
    }

    public int sizeFor(Object object) {
        return ((Map)object).size();
    }

    public void validateElementAndRehashIfRequired(Object object, Object object2, Session session, Object object3) {
        Object object4;
        if (session.isUnitOfWork() && !this.keyFrom(object4 = ((UnitOfWork)session).getBackupClone(object), session).equals(this.keyFrom(object, session))) {
            this.removeFrom(object4, object2, session);
            this.addInto(object3, object2, session);
        }
    }

    public boolean isValidContainer(Object object) {
        return object instanceof Map;
    }

    public Object valueFromKey(Object object, Object object2) {
        return ((Map)object2).get(object);
    }

    public Converter getKeyConverter() {
        return this.keyConverter;
    }

    public void setKeyConverter(Converter converter) {
        this.keyConverter = converter;
    }

    public void setValueConverter(Converter converter) {
        this.valueConverter = converter;
    }

    public Converter getValueConverter() {
        return this.valueConverter;
    }
}

