/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.queryframework;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.internal.databaseaccess.DatabaseCall;
import oracle.toplink.internal.databaseaccess.DatasourceCall;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.helper.NonSynchronizedVector;
import oracle.toplink.internal.queryframework.DatabaseQueryMechanism;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.WriteObjectQuery;

public class DatasourceCallQueryMechanism
extends DatabaseQueryMechanism {
    protected DatasourceCall call;
    protected Vector calls;

    public DatasourceCallQueryMechanism(DatabaseQuery databaseQuery) {
        super(databaseQuery);
    }

    public DatasourceCallQueryMechanism(DatabaseQuery databaseQuery, DatasourceCall datasourceCall) {
        super(databaseQuery);
        this.call = datasourceCall;
        datasourceCall.setQuery(databaseQuery);
    }

    public void addCall(DatasourceCall datasourceCall) {
        this.getCalls().addElement(datasourceCall);
        datasourceCall.setQuery(this.getQuery());
    }

    public DatabaseCall cursorSelectAllRows() throws DatabaseException {
        try {
            return (DatabaseCall)this.executeCall();
        }
        catch (ClassCastException classCastException) {
            throw QueryException.mustUseCursorStreamPolicy();
        }
    }

    public void deleteAll() throws DatabaseException {
        this.executeNoSelectCall();
    }

    public Integer deleteObject() throws DatabaseException {
        if (this.hasMultipleCalls()) {
            Integer n = null;
            for (int i = this.getCalls().size() - 1; i >= 0; --i) {
                DatasourceCall datasourceCall = (DatasourceCall)this.getCalls().elementAt(i);
                Integer n2 = (Integer)this.executeCall(datasourceCall);
                if (i != this.getCalls().size() - 1 && n2 > 0) continue;
                n = n2;
            }
            return n;
        }
        return (Integer)this.executeCall();
    }

    protected Object executeCall() throws DatabaseException {
        return this.executeCall(this.getCall());
    }

    protected Object executeCall(DatasourceCall datasourceCall) throws DatabaseException {
        Session session = this.getQuery().getExecutionSession();
        DatasourceCall datasourceCall2 = (DatasourceCall)datasourceCall.clone();
        datasourceCall2.setQuery(this.getQuery());
        datasourceCall2.translate(this.getTranslationRow(), this.getModifyRow(), session);
        return session.executeCall(datasourceCall2, this.getTranslationRow(), this.getQuery());
    }

    public Integer executeNoSelect() throws DatabaseException {
        return this.executeNoSelectCall();
    }

    public Integer executeNoSelectCall() throws DatabaseException {
        if (this.hasMultipleCalls()) {
            Integer n = null;
            for (int i = 0; i < this.getCalls().size(); ++i) {
                DatasourceCall datasourceCall = (DatasourceCall)this.getCalls().elementAt(i);
                Integer n2 = (Integer)this.executeCall(datasourceCall);
                if (i != 0 && n2 > 0) continue;
                n = n2;
            }
            return n;
        }
        return (Integer)this.executeCall();
    }

    public Vector executeSelect() throws DatabaseException {
        return this.executeSelectCall();
    }

    public Vector executeSelectCall() throws DatabaseException {
        if (this.hasMultipleCalls()) {
            Vector vector = new Vector();
            Enumeration enumeration = this.getCalls().elements();
            while (enumeration.hasMoreElements()) {
                DatasourceCall datasourceCall = (DatasourceCall)enumeration.nextElement();
                Helper.addAllToVector(vector, (Vector)this.executeCall(datasourceCall));
            }
            return vector;
        }
        return (Vector)this.executeCall();
    }

    public DatasourceCall getCall() {
        return this.call;
    }

    public Vector getCalls() {
        if (this.calls == null) {
            this.calls = NonSynchronizedVector.newInstance(3);
        }
        return this.calls;
    }

    public boolean hasMultipleCalls() {
        return this.calls != null && !this.calls.isEmpty();
    }

    public void insertObject() throws DatabaseException {
        Class clazz = this.getQuery().getReferenceClass();
        boolean bl = this.getDescriptor().usesSequenceNumbers();
        boolean bl2 = false;
        if (bl) {
            bl2 = this.getSession().getSequencing().shouldAcquireValueAfterInsert(clazz);
        }
        Collection collection = null;
        if (this.getDescriptor().hasReturningPolicy()) {
            collection = this.getDescriptor().getReturningPolicy().getFieldsToMergeInsert();
        }
        if (bl && !bl2) {
            this.updateObjectAndRowWithSequenceNumber();
        }
        if (this.hasMultipleCalls()) {
            for (int i = 0; i < this.getCalls().size(); ++i) {
                DatasourceCall datasourceCall = (DatasourceCall)this.getCalls().elementAt(i);
                this.executeCall(datasourceCall);
                if (collection != null) {
                    this.updateObjectAndRowWithReturnRow(collection, i == 0);
                }
                if (i != 0 || !bl || !bl2) continue;
                this.updateObjectAndRowWithSequenceNumber();
            }
        } else {
            this.executeCall();
            if (collection != null) {
                this.updateObjectAndRowWithReturnRow(collection, true);
            }
            if (bl && bl2) {
                this.updateObjectAndRowWithSequenceNumber();
            }
        }
        Session session = this.getQuery().getExecutionSession();
        session.getAccessor().flushSelectCalls(session);
    }

    public boolean isCallQueryMechanism() {
        return true;
    }

    public void prepare() {
        if (!this.hasMultipleCalls() && this.getCall() == null) {
            throw QueryException.sqlStatementNotSetProperly(this.getQuery());
        }
    }

    public void prepareCall() throws QueryException {
        DatabaseQuery databaseQuery = this.getQuery();
        Session session = databaseQuery.getExecutionSession();
        if (this.hasMultipleCalls()) {
            Enumeration enumeration = this.getCalls().elements();
            while (enumeration.hasMoreElements()) {
                DatasourceCall datasourceCall = (DatasourceCall)enumeration.nextElement();
                datasourceCall.prepare(session);
            }
        } else if (this.getCall() != null) {
            this.getCall().prepare(session);
        }
    }

    public void prepareCursorSelectAllRows() throws QueryException {
        this.getCall().returnCursor();
        this.prepareCall();
    }

    public void prepareDeleteAll() {
        if (this.hasMultipleCalls()) {
            Enumeration enumeration = this.getCalls().elements();
            while (enumeration.hasMoreElements()) {
                DatasourceCall datasourceCall = (DatasourceCall)enumeration.nextElement();
                datasourceCall.returnNothing();
            }
        } else {
            this.getCall().returnNothing();
        }
        this.prepareCall();
    }

    public void prepareDeleteObject() {
        if (this.hasMultipleCalls()) {
            Enumeration enumeration = this.getCalls().elements();
            while (enumeration.hasMoreElements()) {
                DatasourceCall datasourceCall = (DatasourceCall)enumeration.nextElement();
                datasourceCall.returnNothing();
            }
        } else {
            this.getCall().returnNothing();
        }
        this.prepareCall();
    }

    public void prepareDoesExist(DatabaseField databaseField) {
        if (this.hasMultipleCalls()) {
            Enumeration enumeration = this.getCalls().elements();
            while (enumeration.hasMoreElements()) {
                ((DatasourceCall)enumeration.nextElement()).returnOneRow();
            }
        } else {
            this.getCall().returnOneRow();
        }
        this.prepareCall();
    }

    public void prepareExecuteNoSelect() {
        if (this.hasMultipleCalls()) {
            Enumeration enumeration = this.getCalls().elements();
            while (enumeration.hasMoreElements()) {
                ((DatasourceCall)enumeration.nextElement()).returnNothing();
            }
        } else {
            this.getCall().returnNothing();
        }
        this.prepareCall();
    }

    public void prepareExecuteSelect() {
        if (this.hasMultipleCalls()) {
            Enumeration enumeration = this.getCalls().elements();
            while (enumeration.hasMoreElements()) {
                DatasourceCall datasourceCall = (DatasourceCall)enumeration.nextElement();
                datasourceCall.returnManyRows();
            }
        } else {
            this.getCall().returnManyRows();
        }
        this.prepareCall();
    }

    public void prepareInsertObject() {
        if (this.hasMultipleCalls()) {
            Enumeration enumeration = this.getCalls().elements();
            while (enumeration.hasMoreElements()) {
                ((DatasourceCall)enumeration.nextElement()).returnNothing();
            }
        } else {
            this.getCall().returnNothing();
        }
        this.prepareCall();
    }

    public void prepareReportQuerySelectAllRows() {
        this.prepareExecuteSelect();
    }

    public void prepareReportQuerySubSelect() {
        this.prepareCall();
    }

    public void prepareSelectAllRows() {
        if (this.hasMultipleCalls()) {
            Enumeration enumeration = this.getCalls().elements();
            while (enumeration.hasMoreElements()) {
                DatasourceCall datasourceCall = (DatasourceCall)enumeration.nextElement();
                datasourceCall.returnManyRows();
            }
        } else {
            this.getCall().returnManyRows();
        }
        this.prepareCall();
    }

    public void prepareSelectOneRow() {
        if (this.hasMultipleCalls()) {
            Enumeration enumeration = this.getCalls().elements();
            while (enumeration.hasMoreElements()) {
                DatasourceCall datasourceCall = (DatasourceCall)enumeration.nextElement();
                datasourceCall.returnOneRow();
            }
        } else {
            this.getCall().returnOneRow();
        }
        this.prepareCall();
    }

    public void prepareUpdateObject() {
        if (this.hasMultipleCalls()) {
            Enumeration enumeration = this.getCalls().elements();
            while (enumeration.hasMoreElements()) {
                DatasourceCall datasourceCall = (DatasourceCall)enumeration.nextElement();
                datasourceCall.returnNothing();
            }
        } else if (this.getCall() != null) {
            this.getCall().returnNothing();
        }
        this.prepareCall();
    }

    public void prepareUpdateAll() {
        if (this.getCall() != null) {
            this.getCall().returnNothing();
        }
        this.prepareCall();
    }

    public Vector selectAllReportQueryRows() throws DatabaseException {
        return this.executeSelect();
    }

    public Vector selectAllRows() throws DatabaseException {
        return this.executeSelectCall();
    }

    public DatabaseRow selectOneRow() throws DatabaseException {
        if (this.hasMultipleCalls()) {
            Enumeration enumeration = this.getCalls().elements();
            while (enumeration.hasMoreElements()) {
                DatasourceCall datasourceCall = (DatasourceCall)enumeration.nextElement();
                DatabaseRow databaseRow = (DatabaseRow)this.executeCall(datasourceCall);
                if (databaseRow == null) continue;
                return databaseRow;
            }
            return null;
        }
        return (DatabaseRow)this.executeCall();
    }

    public DatabaseRow selectRowForDoesExist(DatabaseField databaseField) throws DatabaseException {
        if (this.hasMultipleCalls()) {
            Enumeration enumeration = this.getCalls().elements();
            while (enumeration.hasMoreElements()) {
                DatasourceCall datasourceCall = (DatasourceCall)enumeration.nextElement();
                DatabaseRow databaseRow = (DatabaseRow)this.executeCall(datasourceCall);
                if (databaseRow == null) continue;
                return databaseRow;
            }
            return null;
        }
        return (DatabaseRow)this.executeCall();
    }

    public void setCall(DatasourceCall datasourceCall) {
        this.call = datasourceCall;
        if (datasourceCall != null) {
            datasourceCall.setQuery(this.getQuery());
        }
    }

    protected void setCalls(Vector vector) {
        this.calls = vector;
    }

    public Integer updateObject() throws DatabaseException {
        Collection collection = null;
        if (this.getDescriptor().hasReturningPolicy()) {
            collection = this.getDescriptor().getReturningPolicy().getFieldsToMergeUpdate();
        }
        Integer n = null;
        if (this.hasMultipleCalls()) {
            for (int i = 0; i < this.getCalls().size(); ++i) {
                DatasourceCall datasourceCall = (DatasourceCall)this.getCalls().elementAt(i);
                Integer n2 = (Integer)this.executeCall(datasourceCall);
                if (i == 0 || n2 <= 0) {
                    n = n2;
                }
                if (collection == null) continue;
                this.updateObjectAndRowWithReturnRow(collection, false);
            }
        } else {
            n = (Integer)this.executeCall();
            if (collection != null) {
                this.updateObjectAndRowWithReturnRow(collection, false);
            }
        }
        Session session = this.getQuery().getExecutionSession();
        session.getAccessor().flushSelectCalls(session);
        return n;
    }

    public Integer updateAll() throws DatabaseException {
        return this.executeNoSelectCall();
    }

    protected void updateForeignKeyFieldAfterInsert(WriteObjectQuery writeObjectQuery) {
        writeObjectQuery.setModifyRow(this.getDescriptor().getObjectBuilder().buildRow(writeObjectQuery.getObject(), this.getSession()));
        Session session = this.getQuery().getExecutionSession();
        Vector vector = ((DatasourceCallQueryMechanism)this.getDescriptor().getQueryManager().getUpdateQuery().getQueryMechanism()).getCalls();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            DatasourceCall datasourceCall = (DatasourceCall)((DatasourceCall)enumeration.nextElement()).clone();
            datasourceCall.setQuery(writeObjectQuery);
            session.executeCall(datasourceCall, this.getTranslationRow(), writeObjectQuery);
        }
    }
}

