/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.queryframework;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.descriptors.DescriptorEvent;
import oracle.toplink.descriptors.VersionLockingPolicy;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.OptimisticLockException;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.internal.databaseaccess.DatabaseCall;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.identitymaps.CacheKey;
import oracle.toplink.internal.sessions.AggregateChangeRecord;
import oracle.toplink.internal.sessions.CommitManager;
import oracle.toplink.internal.sessions.ObjectChangeSet;
import oracle.toplink.internal.sessions.TransformationMappingChangeRecord;
import oracle.toplink.internal.sessions.UnitOfWorkChangeSet;
import oracle.toplink.mappings.AggregateObjectMapping;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.mappings.foundation.AbstractTransformationMapping;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.DescriptorEventManager;
import oracle.toplink.publicinterface.DescriptorQueryManager;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.DoesExistQuery;
import oracle.toplink.queryframework.ModifyQuery;
import oracle.toplink.queryframework.ReadAllQuery;
import oracle.toplink.queryframework.ReadObjectQuery;
import oracle.toplink.queryframework.WriteObjectQuery;
import oracle.toplink.sessions.DatabaseRecord;
import oracle.toplink.tools.profiler.QueryMonitor;

public abstract class DatabaseQueryMechanism
implements Cloneable,
Serializable {
    protected DatabaseQuery query;

    public DatabaseQueryMechanism() {
    }

    public DatabaseQueryMechanism(DatabaseQuery databaseQuery) {
        this.query = databaseQuery;
    }

    protected void addWriteLockFieldForInsert() {
        if (this.getDescriptor().usesOptimisticLocking()) {
            this.getDescriptor().getOptimisticLockingPolicy().setupWriteFieldsForInsert(this.getWriteObjectQuery());
        }
    }

    public void buildSelectionCriteria(Session session) {
    }

    public Object checkCacheForObject(DatabaseRow databaseRow, Session session) {
        if (databaseRow == null || databaseRow.isEmpty()) {
            return null;
        }
        List list = this.getDescriptor().getPrimaryKeyFields();
        Vector<Object> vector = new Vector<Object>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            Object object = databaseRow.get((DatabaseField)list.get(i));
            if (object == null) {
                return null;
            }
            vector.add(object);
        }
        return session.getIdentityMapAccessorInstance().getFromIdentityMapWithDeferredLock(vector, this.getReadObjectQuery().getReferenceClass(), false, this.getDescriptor());
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public DatabaseQueryMechanism clone(DatabaseQuery databaseQuery) {
        DatabaseQueryMechanism databaseQueryMechanism = (DatabaseQueryMechanism)this.clone();
        databaseQueryMechanism.setQuery(databaseQuery);
        return databaseQueryMechanism;
    }

    public abstract DatabaseCall cursorSelectAllRows() throws DatabaseException;

    public boolean isEJBQLCallQueryMechanism() {
        return false;
    }

    public Object buildObjectsFromRows(Vector vector) throws DatabaseException {
        Object object = ((ReadAllQuery)this.getQuery()).getContainerPolicy().containerInstance(vector.size());
        return this.getDescriptor().getObjectBuilder().buildObjectsInto((ReadAllQuery)this.getQuery(), vector, object);
    }

    public abstract void deleteAll() throws DatabaseException;

    public abstract Integer deleteObject() throws DatabaseException;

    public abstract Integer executeNoSelect() throws DatabaseException;

    public abstract Vector executeSelect() throws DatabaseException;

    public Object executeWrite() throws DatabaseException, OptimisticLockException {
        WriteObjectQuery writeObjectQuery = this.getWriteObjectQuery();
        Object object = writeObjectQuery.getObject();
        CommitManager commitManager = this.getSession().getCommitManager();
        if (commitManager.isCommitCompleted(object) || commitManager.isCommitInPostModify(object)) {
            return object;
        }
        if (commitManager.isCommitInPreModify(object)) {
            this.shallowInsertObjectForWrite(object, writeObjectQuery, commitManager);
            return object;
        }
        try {
            this.getSession().beginTransaction();
            if (writeObjectQuery.getObjectChangeSet() == null && this.getDescriptor().getEventManager().hasAnyEventListeners()) {
                this.getDescriptor().getEventManager().executeEvent(new DescriptorEvent(0, writeObjectQuery));
            }
            writeObjectQuery.executeCommit();
            if (this.getDescriptor().getEventManager().hasAnyEventListeners()) {
                this.getDescriptor().getEventManager().executeEvent(new DescriptorEvent(1, writeObjectQuery));
            }
            this.getSession().commitTransaction();
            commitManager.markCommitCompleted(object);
            return object;
        }
        catch (RuntimeException runtimeException) {
            this.getSession().rollbackTransaction();
            commitManager.markCommitCompleted(object);
            throw runtimeException;
        }
    }

    public Object executeWriteWithChangeSet() throws DatabaseException, OptimisticLockException {
        WriteObjectQuery writeObjectQuery = this.getWriteObjectQuery();
        ObjectChangeSet objectChangeSet = writeObjectQuery.getObjectChangeSet();
        Descriptor descriptor = this.getDescriptor();
        Session session = this.getSession();
        CommitManager commitManager = session.getCommitManager();
        Object object = writeObjectQuery.getObject();
        if (!objectChangeSet.hasChanges() && !objectChangeSet.hasForcedChanges()) {
            commitManager.markCommitCompleted(object);
            return object;
        }
        if (commitManager.isCommitCompleted(object) || commitManager.isCommitInPostModify(object)) {
            return object;
        }
        try {
            writeObjectQuery.executeCommitWithChangeSet();
            if (descriptor.getEventManager().hasAnyEventListeners()) {
                descriptor.getEventManager().executeEvent(new DescriptorEvent(1, writeObjectQuery));
            }
            commitManager.markCommitCompleted(object);
            return object;
        }
        catch (RuntimeException runtimeException) {
            commitManager.markCommitCompleted(object);
            throw runtimeException;
        }
    }

    protected Descriptor getDescriptor() {
        return this.getQuery().getDescriptor();
    }

    public DatabaseRow getModifyRow() {
        if (this.getQuery().isModifyQuery()) {
            return ((ModifyQuery)this.getQuery()).getModifyRow();
        }
        return null;
    }

    public DatabaseQuery getQuery() {
        return this.query;
    }

    protected ReadObjectQuery getReadObjectQuery() {
        return (ReadObjectQuery)this.getQuery();
    }

    public Expression getSelectionCriteria() {
        return null;
    }

    protected Session getSession() {
        return this.getQuery().getSession();
    }

    protected DatabaseRow getTranslationRow() {
        return this.getQuery().getTranslationRow();
    }

    protected WriteObjectQuery getWriteObjectQuery() {
        return (WriteObjectQuery)this.getQuery();
    }

    public abstract void insertObject() throws DatabaseException;

    public void insertObject(boolean bl) {
        this.insertObject();
    }

    public void insertObjectForWrite() {
        WriteObjectQuery writeObjectQuery = this.getWriteObjectQuery();
        Descriptor descriptor = this.getDescriptor();
        DescriptorQueryManager descriptorQueryManager = descriptor.getQueryManager();
        if (!writeObjectQuery.isUserDefined() && descriptorQueryManager.hasInsertQuery() && this.isExpressionQueryMechanism()) {
            this.performUserDefinedInsert();
            return;
        }
        Object object = writeObjectQuery.getObject();
        Session session = this.getSession();
        ObjectChangeSet objectChangeSet = writeObjectQuery.getObjectChangeSet();
        CommitManager commitManager = session.getCommitManager();
        DescriptorEventManager descriptorEventManager = descriptor.getEventManager();
        commitManager.markPreModifyCommitInProgress(object);
        if (objectChangeSet == null && descriptorEventManager.hasAnyEventListeners()) {
            descriptorEventManager.executeEvent(new DescriptorEvent(4, writeObjectQuery));
        }
        if (writeObjectQuery.shouldCascadeParts()) {
            descriptorQueryManager.preInsert(writeObjectQuery);
        }
        if (commitManager.isShallowCommitted(object)) {
            this.updateForeignKeyFieldAfterInsert();
        } else {
            DatabaseRow databaseRow = writeObjectQuery.getModifyRow();
            if (databaseRow == null) {
                if (writeObjectQuery.shouldCascadeParts()) {
                    writeObjectQuery.setModifyRow(descriptor.getObjectBuilder().buildRow(object, session));
                } else {
                    writeObjectQuery.setModifyRow(descriptor.getObjectBuilder().buildRowForShallowInsert(object, session));
                }
            } else if (writeObjectQuery.shouldCascadeParts()) {
                writeObjectQuery.setModifyRow(descriptor.getObjectBuilder().buildRow(databaseRow, object, session));
            } else {
                writeObjectQuery.setModifyRow(descriptor.getObjectBuilder().buildRowForShallowInsert(databaseRow, object, session));
            }
            databaseRow = this.getModifyRow();
            writeObjectQuery.setTranslationRow(databaseRow);
            if (!descriptor.isAggregateCollectionDescriptor()) {
                writeObjectQuery.setPrimaryKey(descriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, session));
            }
            this.addWriteLockFieldForInsert();
            int n = databaseRow.size();
            if (descriptorEventManager.hasAnyEventListeners()) {
                DescriptorEvent descriptorEvent = new DescriptorEvent(12, writeObjectQuery);
                descriptorEvent.setRow(databaseRow);
                descriptorEventManager.executeEvent(descriptorEvent);
            }
            if (QueryMonitor.shouldMonitor()) {
                QueryMonitor.incrementInsert(writeObjectQuery);
            }
            this.insertObject(n != databaseRow.size());
            this.registerObjectInIdentityMap();
            if (objectChangeSet != null) {
                ((UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet()).putNewObjectInChangesList(objectChangeSet, session);
            }
        }
        commitManager.markPostModifyCommitInProgress(object);
        if (writeObjectQuery.shouldCascadeParts()) {
            descriptorQueryManager.postInsert(writeObjectQuery);
        }
        if (descriptor.getHistoryPolicy() != null && descriptor.getHistoryPolicy().shouldHandleWrites()) {
            descriptor.getHistoryPolicy().postInsert(writeObjectQuery);
        }
        if (descriptor.hasCMPPolicy()) {
            descriptor.getCMPPolicy().postInsert(object, session);
        }
        if (descriptorEventManager.hasAnyEventListeners()) {
            descriptorEventManager.executeEvent(new DescriptorEvent(5, writeObjectQuery));
        }
    }

    public boolean isCallQueryMechanism() {
        return false;
    }

    public boolean isExpressionQueryMechanism() {
        return false;
    }

    public boolean isQueryByExampleMechanism() {
        return false;
    }

    public boolean isStatementQueryMechanism() {
        return false;
    }

    protected void performUserDefinedInsert() {
        this.performUserDefinedWrite(this.getDescriptor().getQueryManager().getInsertQuery());
    }

    protected void performUserDefinedUpdate() {
        this.performUserDefinedWrite(this.getDescriptor().getQueryManager().getUpdateQuery());
    }

    protected void performUserDefinedWrite(WriteObjectQuery writeObjectQuery) {
        writeObjectQuery.checkPrepare(this.getSession(), this.getTranslationRow());
        Object object = this.getWriteObjectQuery().getObject();
        WriteObjectQuery writeObjectQuery2 = (WriteObjectQuery)writeObjectQuery.clone();
        writeObjectQuery2.setIsExecutionClone(true);
        writeObjectQuery2.setObject(object);
        writeObjectQuery2.setObjectChangeSet(this.getWriteObjectQuery().getObjectChangeSet());
        writeObjectQuery2.setCascadePolicy(this.getQuery().getCascadePolicy());
        writeObjectQuery2.setShouldMaintainCache(this.getQuery().shouldMaintainCache());
        writeObjectQuery2.setTranslationRow(this.getTranslationRow());
        writeObjectQuery2.setModifyRow(this.getModifyRow());
        writeObjectQuery2.setPrimaryKey(this.getWriteObjectQuery().getPrimaryKey());
        writeObjectQuery2.setSession(this.getSession());
        if (writeObjectQuery2.getObjectChangeSet() != null) {
            writeObjectQuery2.executeCommitWithChangeSet();
        } else {
            writeObjectQuery2.executeCommit();
        }
    }

    public void prepare() throws QueryException {
    }

    public abstract void prepareCursorSelectAllRows() throws QueryException;

    public abstract void prepareDeleteAll() throws QueryException;

    public abstract void prepareDeleteObject() throws QueryException;

    public abstract void prepareDoesExist(DatabaseField var1) throws QueryException;

    public abstract void prepareExecuteNoSelect() throws QueryException;

    public abstract void prepareExecuteSelect() throws QueryException;

    public abstract void prepareInsertObject() throws QueryException;

    public abstract void prepareReportQuerySelectAllRows() throws QueryException;

    public abstract void prepareReportQuerySubSelect() throws QueryException;

    public abstract void prepareSelectAllRows() throws QueryException;

    public abstract void prepareSelectOneRow() throws QueryException;

    public abstract void prepareUpdateObject() throws QueryException;

    public abstract void prepareUpdateAll() throws QueryException;

    protected void registerObjectInIdentityMap() {
        WriteObjectQuery writeObjectQuery = this.getWriteObjectQuery();
        Object object = writeObjectQuery.getObject();
        if (writeObjectQuery.shouldMaintainCache()) {
            if (this.getDescriptor().usesOptimisticLocking()) {
                Object object2 = this.getDescriptor().getOptimisticLockingPolicy().getValueToPutInCache(writeObjectQuery.getModifyRow(), this.getSession());
                this.getSession().getIdentityMapAccessorInstance().putInIdentityMap(object, writeObjectQuery.getPrimaryKey(), object2, System.currentTimeMillis(), this.getDescriptor());
            } else {
                this.getSession().getIdentityMapAccessorInstance().putInIdentityMap(object, writeObjectQuery.getPrimaryKey(), null, System.currentTimeMillis(), this.getDescriptor());
            }
        }
    }

    public abstract Vector selectAllReportQueryRows() throws DatabaseException;

    public abstract Vector selectAllRows() throws DatabaseException;

    public abstract DatabaseRow selectOneRow() throws DatabaseException;

    public abstract DatabaseRow selectRowForDoesExist(DatabaseField var1) throws DatabaseException;

    public void setQuery(DatabaseQuery databaseQuery) {
        this.query = databaseQuery;
    }

    protected void shallowInsertObjectForWrite(Object object, WriteObjectQuery writeObjectQuery, CommitManager commitManager) throws DatabaseException, OptimisticLockException {
        boolean bl;
        if (this.getSession().isUnitOfWork()) {
            UnitOfWork unitOfWork = (UnitOfWork)this.getSession();
            boolean bl2 = bl = !unitOfWork.isCloneNewObject(object);
            if (bl) {
                bl = unitOfWork.isObjectRegistered(object);
            }
        } else {
            DoesExistQuery doesExistQuery = (DoesExistQuery)this.getDescriptor().getQueryManager().getDoesExistQuery().clone();
            doesExistQuery.setObject(object);
            doesExistQuery.setPrimaryKey(writeObjectQuery.getPrimaryKey());
            doesExistQuery.setDescriptor(this.getDescriptor());
            doesExistQuery.setTranslationRow(this.getTranslationRow());
            bl = (Boolean)this.getSession().executeQuery(doesExistQuery);
        }
        if (!bl) {
            writeObjectQuery.dontCascadeParts();
            this.insertObjectForWrite();
            commitManager.markShallowCommit(object);
        }
    }

    protected void updateForeignKeyFieldAfterInsert() {
        WriteObjectQuery writeObjectQuery = this.getWriteObjectQuery();
        Object object = writeObjectQuery.getObject();
        writeObjectQuery.setPrimaryKey(this.getDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(object, this.getSession()));
        writeObjectQuery.setTranslationRow(this.getDescriptor().getObjectBuilder().buildRowForTranslation(object, this.getSession()));
        this.updateForeignKeyFieldAfterInsert(writeObjectQuery);
    }

    public abstract Integer updateAll() throws DatabaseException;

    public abstract Integer updateObject() throws DatabaseException;

    protected abstract void updateForeignKeyFieldAfterInsert(WriteObjectQuery var1);

    protected void updateObjectAndRowWithReturnRow(Collection collection, boolean bl) {
        Serializable serializable;
        Cloneable cloneable;
        WriteObjectQuery writeObjectQuery = this.getWriteObjectQuery();
        DatabaseRow databaseRow = (DatabaseRow)writeObjectQuery.getProperties().get("output");
        if (databaseRow == null || databaseRow.isEmpty()) {
            return;
        }
        DatabaseRecord databaseRecord = new DatabaseRecord();
        Object object = collection.iterator();
        while (object.hasNext()) {
            cloneable = (DatabaseField)object.next();
            if (!databaseRow.containsKey((DatabaseField)cloneable)) continue;
            databaseRecord.put((DatabaseField)cloneable, databaseRow.get((DatabaseField)cloneable));
        }
        if (((DatabaseRow)databaseRecord).isEmpty()) {
            return;
        }
        object = writeObjectQuery.getObject();
        this.getDescriptor().getObjectBuilder().assignReturnRow(object, this.getSession(), databaseRecord);
        cloneable = null;
        if (bl) {
            serializable = new DatabaseRecord();
            List list = this.getDescriptor().getPrimaryKeyFields();
            for (int i = 0; i < list.size(); ++i) {
                DatabaseField databaseField = (DatabaseField)list.get(i);
                if (!databaseRecord.containsKey(databaseField)) continue;
                ((DatabaseRow)serializable).put(databaseField, databaseRecord.get(databaseField));
            }
            if (!((DatabaseRow)serializable).isEmpty()) {
                cloneable = this.getDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(object, this.getSession());
                writeObjectQuery.setPrimaryKey((Vector)cloneable);
                this.getModifyRow().putAll((Map)((Object)serializable));
                this.getDescriptor().getObjectBuilder().addPrimaryKeyForNonDefaultTable(this.getModifyRow());
            }
        }
        if (this.getSession().isUnitOfWork()) {
            serializable = writeObjectQuery.getObjectChangeSet();
            if (serializable == null && ((UnitOfWork)this.getSession()).getUnitOfWorkChangeSet() != null) {
                serializable = (ObjectChangeSet)((UnitOfWork)this.getSession()).getUnitOfWorkChangeSet().getObjectChangeSetForClone(object);
            }
            if (serializable != null) {
                this.updateChangeSet(this.getDescriptor(), (ObjectChangeSet)serializable, databaseRecord, object);
                if (cloneable != null) {
                    ((ObjectChangeSet)serializable).setCacheKey(new CacheKey((Vector)cloneable));
                }
            }
        }
    }

    public void updateChangeSet(Descriptor descriptor, ObjectChangeSet objectChangeSet, DatabaseRow databaseRow, Object object) {
        HashSet hashSet = new HashSet(databaseRow.size());
        for (int i = 0; i < databaseRow.size(); ++i) {
            DatabaseField databaseField = (DatabaseField)databaseRow.getFields().elementAt(i);
            Object e = databaseRow.getValues().elementAt(i);
            this.updateChangeSet(descriptor, objectChangeSet, databaseField, object, hashSet);
        }
    }

    protected void updateChangeSet(Descriptor descriptor, ObjectChangeSet objectChangeSet, DatabaseField databaseField, Object object) {
        this.updateChangeSet(descriptor, objectChangeSet, databaseField, object, null);
    }

    protected void updateChangeSet(Descriptor descriptor, ObjectChangeSet objectChangeSet, DatabaseField databaseField, Object object, Collection collection) {
        DatabaseMapping databaseMapping;
        Vector vector = descriptor.getObjectBuilder().getReadOnlyMappingsForField(databaseField);
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                databaseMapping = (DatabaseMapping)vector.elementAt(i);
                this.updateChangeSet(databaseMapping, objectChangeSet, databaseField, object, collection);
            }
        }
        if ((databaseMapping = descriptor.getObjectBuilder().getMappingForField(databaseField)) != null) {
            this.updateChangeSet(databaseMapping, objectChangeSet, databaseField, object, collection);
        }
    }

    protected void updateChangeSet(DatabaseMapping databaseMapping, ObjectChangeSet objectChangeSet, DatabaseField databaseField, Object object, Collection collection) {
        if (collection != null && collection.contains(databaseMapping)) {
            return;
        }
        if (databaseMapping.isAggregateObjectMapping()) {
            Object object2 = databaseMapping.getAttributeValueFromObject(object);
            AggregateChangeRecord aggregateChangeRecord = (AggregateChangeRecord)objectChangeSet.getChangesForAttributeNamed(databaseMapping.getAttributeName());
            if (object2 != null) {
                if (aggregateChangeRecord == null) {
                    aggregateChangeRecord = new AggregateChangeRecord(objectChangeSet);
                    aggregateChangeRecord.setAttribute(databaseMapping.getAttributeName());
                    aggregateChangeRecord.setMapping(databaseMapping);
                    objectChangeSet.addChange(aggregateChangeRecord);
                }
                ObjectChangeSet objectChangeSet2 = (ObjectChangeSet)aggregateChangeRecord.getChangedObject();
                Descriptor descriptor = ((AggregateObjectMapping)databaseMapping).getReferenceDescriptor();
                if (objectChangeSet2 == null) {
                    objectChangeSet2 = descriptor.getObjectBuilder().createObjectChangeSet(object2, (UnitOfWorkChangeSet)((UnitOfWork)this.getSession()).getUnitOfWorkChangeSet(), this.getSession());
                    aggregateChangeRecord.setChangedObject(objectChangeSet2);
                }
                this.updateChangeSet(descriptor, objectChangeSet2, databaseField, object2, collection);
            } else if (aggregateChangeRecord != null) {
                aggregateChangeRecord.setChangedObject(null);
            }
        } else if (databaseMapping.isTransformationMapping()) {
            TransformationMappingChangeRecord transformationMappingChangeRecord = (TransformationMappingChangeRecord)objectChangeSet.getChangesForAttributeNamed(databaseMapping.getAttributeName());
            if (transformationMappingChangeRecord == null) {
                transformationMappingChangeRecord = new TransformationMappingChangeRecord(objectChangeSet);
                transformationMappingChangeRecord.setAttribute(databaseMapping.getAttributeName());
                transformationMappingChangeRecord.setMapping(databaseMapping);
                objectChangeSet.addChange(transformationMappingChangeRecord);
            }
            DatabaseRecord databaseRecord = new DatabaseRecord(databaseMapping.getFields().size());
            for (int i = 0; i < databaseMapping.getFields().size(); ++i) {
                DatabaseField databaseField2 = (DatabaseField)databaseMapping.getFields().elementAt(i);
                Object object3 = ((AbstractTransformationMapping)databaseMapping).valueFromObject(object, databaseField2, this.getSession());
                databaseRecord.add(databaseField2, object3);
            }
            transformationMappingChangeRecord.setRow(databaseRecord);
            if (collection != null) {
                collection.add(databaseMapping);
            }
        } else if (databaseMapping.isDirectToFieldMapping()) {
            Object object4 = databaseMapping.getAttributeValueFromObject(object);
            objectChangeSet.updateChangeRecordForAttribute(databaseMapping, object4);
        } else {
            this.getSession().log(1, "query", "field_for_unsupported_mapping_returned", databaseField, this.getDescriptor());
        }
    }

    protected void updateObjectAndRowWithSequenceNumber() throws DatabaseException {
        WriteObjectQuery writeObjectQuery = this.getWriteObjectQuery();
        Object object = writeObjectQuery.getObject();
        Object object2 = this.getDescriptor().getObjectBuilder().assignSequenceNumber(object, this.getSession());
        if (object2 == null) {
            return;
        }
        Vector vector = this.getDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(object, this.getSession());
        writeObjectQuery.setPrimaryKey(vector);
        DatabaseField databaseField = this.getDescriptor().getSequenceNumberField();
        this.getModifyRow().put(databaseField, object2);
        this.getDescriptor().getObjectBuilder().addPrimaryKeyForNonDefaultTable(this.getModifyRow());
        if (this.getSession().isUnitOfWork()) {
            ObjectChangeSet objectChangeSet = writeObjectQuery.getObjectChangeSet();
            if (objectChangeSet == null && ((UnitOfWork)this.getSession()).getUnitOfWorkChangeSet() != null) {
                objectChangeSet = (ObjectChangeSet)((UnitOfWork)this.getSession()).getUnitOfWorkChangeSet().getObjectChangeSetForClone(object);
            }
            if (objectChangeSet != null) {
                this.updateChangeSet(this.getDescriptor(), objectChangeSet, databaseField, object);
                objectChangeSet.setCacheKey(new CacheKey(vector));
            }
        }
    }

    public void updateObjectForWrite() {
        WriteObjectQuery writeObjectQuery = this.getWriteObjectQuery();
        Object object = writeObjectQuery.getObject();
        DescriptorQueryManager descriptorQueryManager = this.getDescriptor().getQueryManager();
        if (!writeObjectQuery.isUserDefined() && descriptorQueryManager.hasUpdateQuery() && this.isExpressionQueryMechanism()) {
            this.performUserDefinedUpdate();
            return;
        }
        this.getSession().getCommitManager().markPreModifyCommitInProgress(object);
        if (writeObjectQuery.getObjectChangeSet() == null && this.getDescriptor().getEventManager().hasAnyEventListeners()) {
            this.getDescriptor().getEventManager().executeEvent(new DescriptorEvent(6, writeObjectQuery));
        }
        if (writeObjectQuery.shouldCascadeParts()) {
            descriptorQueryManager.preUpdate(writeObjectQuery);
        }
        if ((writeObjectQuery.isUserDefined() || writeObjectQuery.isCallQuery()) && !this.getSession().isUnitOfWork()) {
            writeObjectQuery.setModifyRow(this.getDescriptor().getObjectBuilder().buildRow(object, this.getSession()));
        } else {
            writeObjectQuery.setModifyRow(this.getDescriptor().getObjectBuilder().buildRowForUpdate(writeObjectQuery));
        }
        Boolean bl = null;
        if (this.getSession().isUnitOfWork()) {
            bl = (Boolean)((UnitOfWork)this.getSession()).getOptimisticReadLockObjects().get(writeObjectQuery.getObject());
        }
        if (!this.getModifyRow().isEmpty() || bl != null || this.getDescriptor().getCMPPolicy() != null && this.getDescriptor().getCMPPolicy().getForceUpdate()) {
            int n;
            Serializable serializable;
            if ((writeObjectQuery.isUserDefined() || writeObjectQuery.isCallQuery()) && this.getSession().isUnitOfWork()) {
                writeObjectQuery.setModifyRow(this.getDescriptor().getObjectBuilder().buildRow(object, this.getSession()));
            }
            if (this.getDescriptor().usesOptimisticLocking()) {
                serializable = this.getDescriptor().getOptimisticLockingPolicy();
                serializable.addLockValuesToTranslationRow(writeObjectQuery);
                if (!this.getModifyRow().isEmpty() || bl.booleanValue() && serializable instanceof VersionLockingPolicy) {
                    serializable.updateRowAndObjectForUpdate(writeObjectQuery, object);
                } else if (!bl.booleanValue() && serializable instanceof VersionLockingPolicy) {
                    ((VersionLockingPolicy)serializable).writeLockValueIntoRow(writeObjectQuery, object);
                }
            }
            if (this.getDescriptor().getEventManager().hasAnyEventListeners()) {
                serializable = new DescriptorEvent(13, writeObjectQuery);
                ((oracle.toplink.publicinterface.DescriptorEvent)serializable).setRow(this.getModifyRow());
                this.getDescriptor().getEventManager().executeEvent((DescriptorEvent)serializable);
            }
            if (QueryMonitor.shouldMonitor()) {
                QueryMonitor.incrementUpdate(this.getWriteObjectQuery());
            }
            if ((n = this.updateObject().intValue()) < 1) {
                this.getSession().getEventManager().noRowsModified(writeObjectQuery, object);
            }
            if (this.getDescriptor().usesOptimisticLocking()) {
                this.getDescriptor().getOptimisticLockingPolicy().validateUpdate(n, object, writeObjectQuery);
            }
        }
        this.getSession().getCommitManager().markPostModifyCommitInProgress(object);
        if (writeObjectQuery.shouldCascadeParts()) {
            descriptorQueryManager.postUpdate(writeObjectQuery);
        }
        if (this.getDescriptor().getHistoryPolicy() != null && this.getDescriptor().getHistoryPolicy().shouldHandleWrites()) {
            this.getDescriptor().getHistoryPolicy().postUpdate(writeObjectQuery);
        }
        if (this.getDescriptor().getEventManager().hasAnyEventListeners()) {
            this.getDescriptor().getEventManager().executeEvent(new DescriptorEvent(7, writeObjectQuery));
        }
    }

    public void updateObjectForWriteWithChangeSet() {
        Serializable serializable;
        WriteObjectQuery writeObjectQuery = this.getWriteObjectQuery();
        ObjectChangeSet objectChangeSet = writeObjectQuery.getObjectChangeSet();
        Object object = writeObjectQuery.getObject();
        Descriptor descriptor = this.getDescriptor();
        Session session = this.getSession();
        DescriptorQueryManager descriptorQueryManager = descriptor.getQueryManager();
        DescriptorEventManager descriptorEventManager = descriptor.getEventManager();
        CommitManager commitManager = session.getCommitManager();
        if (!writeObjectQuery.isUserDefined() && descriptorQueryManager.hasUpdateQuery() && this.isExpressionQueryMechanism()) {
            commitManager.markPreModifyCommitInProgress(object);
            this.performUserDefinedUpdate();
            return;
        }
        commitManager.markPreModifyCommitInProgress(object);
        if (objectChangeSet.hasChanges() && descriptorEventManager.hasAnyEventListeners()) {
            serializable = new DescriptorEvent(17, writeObjectQuery);
            descriptorEventManager.executeEvent((DescriptorEvent)serializable);
        }
        if (writeObjectQuery.shouldCascadeParts()) {
            descriptorQueryManager.preUpdate(writeObjectQuery);
        }
        writeObjectQuery.setModifyRow(descriptor.getObjectBuilder().buildRowForUpdateWithChangeSet(writeObjectQuery));
        serializable = objectChangeSet.shouldModifyVersionField();
        if (!this.getModifyRow().isEmpty() || serializable != null || objectChangeSet.hasCmpPolicyForcedUpdate()) {
            int n;
            Serializable serializable2;
            if (writeObjectQuery.isUserDefined() || writeObjectQuery.isCallQuery()) {
                writeObjectQuery.setModifyRow(descriptor.getObjectBuilder().buildRow(object, session));
            }
            if (descriptor.usesOptimisticLocking()) {
                serializable2 = descriptor.getOptimisticLockingPolicy();
                serializable2.addLockValuesToTranslationRow(writeObjectQuery);
                if (!this.getModifyRow().isEmpty() || ((Boolean)serializable).booleanValue() && serializable2 instanceof VersionLockingPolicy) {
                    serializable2.updateRowAndObjectForUpdate(writeObjectQuery, object);
                } else if (!((Boolean)serializable).booleanValue() && serializable2 instanceof VersionLockingPolicy) {
                    ((VersionLockingPolicy)serializable2).writeLockValueIntoRow(writeObjectQuery, object);
                }
            }
            if (descriptorEventManager.hasAnyEventListeners()) {
                serializable2 = new DescriptorEvent(13, writeObjectQuery);
                ((oracle.toplink.publicinterface.DescriptorEvent)serializable2).setRow(this.getModifyRow());
                descriptorEventManager.executeEvent((DescriptorEvent)serializable2);
            }
            if (QueryMonitor.shouldMonitor()) {
                QueryMonitor.incrementUpdate(this.getWriteObjectQuery());
            }
            if ((n = this.updateObject().intValue()) < 1) {
                session.getEventManager().noRowsModified(writeObjectQuery, object);
            }
            if (descriptor.usesOptimisticLocking()) {
                descriptor.getOptimisticLockingPolicy().validateUpdate(n, object, writeObjectQuery);
            }
        }
        commitManager.markPostModifyCommitInProgress(object);
        if (writeObjectQuery.shouldCascadeParts()) {
            descriptorQueryManager.postUpdate(writeObjectQuery);
        }
        if (descriptor.getHistoryPolicy() != null && descriptor.getHistoryPolicy().shouldHandleWrites()) {
            descriptor.getHistoryPolicy().postUpdate(writeObjectQuery);
        }
        if (descriptorEventManager.hasAnyEventListeners()) {
            descriptorEventManager.executeEvent(new DescriptorEvent(7, writeObjectQuery));
        }
    }
}

