/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.indirection;

import java.io.Serializable;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.indirection.ValueHolderInterface;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.indirection.UnitOfWorkValueHolder;
import oracle.toplink.internal.localization.ToStringLocalization;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;

public abstract class DatabaseValueHolder
implements ValueHolderInterface,
Cloneable,
Serializable {
    protected Object value;
    protected boolean isInstantiated;
    protected transient Session session;
    protected DatabaseRow row;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public DatabaseRow getRow() {
        return this.row;
    }

    public Session getSession() {
        return this.session;
    }

    public synchronized Object getValue() {
        if (!this.isInstantiated()) {
            this.privilegedSetValue(this.instantiate());
            this.setInstantiated();
            this.resetFields();
        }
        return this.value;
    }

    protected abstract Object instantiate() throws DatabaseException;

    public abstract Object instantiateForUnitOfWorkValueHolder(UnitOfWorkValueHolder var1);

    public boolean isEasilyInstantiated() {
        return this.isInstantiated();
    }

    public boolean isInstantiated() {
        return this.isInstantiated;
    }

    public abstract boolean isPessimisticLockingValueHolder();

    protected boolean isTransactionalValueHolder() {
        return this.session != null && this.session.isUnitOfWork();
    }

    public boolean isSerializedRemoteUnitOfWorkValueHolder() {
        return false;
    }

    public void privilegedSetValue(Object object) {
        this.value = object;
    }

    public void releaseWrappedValueHolder() {
        Session session = this.getSession();
        if (session != null && session.isUnitOfWork()) {
            this.setSession(session.getRootSession(null));
        }
    }

    protected void resetFields() {
        this.setRow(null);
        this.setSession(null);
    }

    public void setInstantiated() {
        this.isInstantiated = true;
    }

    public void setRow(DatabaseRow databaseRow) {
        this.row = databaseRow;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public void setUninstantiated() {
        this.isInstantiated = false;
    }

    public void setValue(Object object) {
        this.value = object;
        this.setInstantiated();
    }

    public String toString() {
        if (this.isInstantiated()) {
            return "{" + this.getValue() + "}";
        }
        return "{" + Helper.getShortClassName(this.getClass()) + ": " + ToStringLocalization.buildMessage("not_instantiated", null) + "}";
    }
}

