/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.indirection;

import oracle.toplink.exceptions.TopLinkException;
import oracle.toplink.internal.indirection.QueryBasedValueHolder;
import oracle.toplink.mappings.ForeignReferenceMapping;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ReadQuery;

public class BatchValueHolder
extends QueryBasedValueHolder {
    protected transient ForeignReferenceMapping mapping;
    protected transient DatabaseRow argumentRow;

    public BatchValueHolder(ReadQuery readQuery, DatabaseRow databaseRow, ForeignReferenceMapping foreignReferenceMapping, DatabaseQuery databaseQuery) {
        super(readQuery, databaseRow, databaseQuery.getSession());
        this.mapping = foreignReferenceMapping;
        this.argumentRow = databaseQuery.getTranslationRow();
    }

    protected DatabaseRow getArgumentRow() {
        return this.argumentRow;
    }

    protected ForeignReferenceMapping getMapping() {
        return this.mapping;
    }

    protected Object instantiate(Session session) throws TopLinkException {
        return this.getMapping().extractResultFromBatchQuery(this.getQuery(), this.getRow(), session, this.getArgumentRow());
    }

    public boolean isEasilyInstantiated() {
        return this.isInstantiated() || this.getQuery().getProperty("batched objects") != null;
    }

    protected void resetFields() {
        super.resetFields();
        this.setArgumentRow(null);
        this.setMapping(null);
    }

    protected void setArgumentRow(DatabaseRow databaseRow) {
        this.argumentRow = databaseRow;
    }

    protected void setMapping(ForeignReferenceMapping foreignReferenceMapping) {
        this.mapping = foreignReferenceMapping;
    }
}

