/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.indirection;

import java.rmi.server.ObjID;
import java.util.Vector;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.exceptions.IntegrityChecker;
import oracle.toplink.indirection.ValueHolder;
import oracle.toplink.indirection.ValueHolderInterface;
import oracle.toplink.internal.descriptors.DescriptorIterator;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.IdentityHashtable;
import oracle.toplink.internal.indirection.BatchValueHolder;
import oracle.toplink.internal.indirection.DatabaseValueHolder;
import oracle.toplink.internal.indirection.IndirectionPolicy;
import oracle.toplink.internal.indirection.QueryBasedValueHolder;
import oracle.toplink.internal.indirection.TransformerBasedValueHolder;
import oracle.toplink.internal.indirection.UnitOfWorkValueHolder;
import oracle.toplink.internal.remote.RemoteSessionController;
import oracle.toplink.internal.remote.RemoteUnitOfWork;
import oracle.toplink.internal.remote.RemoteValueHolder;
import oracle.toplink.internal.sessions.MergeManager;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.queryframework.ReadObjectQuery;
import oracle.toplink.queryframework.ReadQuery;
import oracle.toplink.remote.RemoteSession;

public class BasicIndirectionPolicy
extends IndirectionPolicy {
    public Object backupCloneAttribute(Object object, Object object2, Object object3, UnitOfWork unitOfWork) {
        ValueHolderInterface valueHolderInterface = (ValueHolderInterface)object;
        ValueHolder valueHolder = new ValueHolder();
        if (!(valueHolderInterface instanceof UnitOfWorkValueHolder) || valueHolderInterface.isInstantiated()) {
            valueHolder.setValue(super.backupCloneAttribute(valueHolderInterface.getValue(), object2, object3, unitOfWork));
        } else {
            ((UnitOfWorkValueHolder)valueHolderInterface).setBackupValueHolder(valueHolder);
        }
        return valueHolder;
    }

    public Object cloneAttribute(Object object, Object object2, Object object3, UnitOfWork unitOfWork, boolean bl) {
        Cloneable cloneable;
        ValueHolderInterface valueHolderInterface = (ValueHolderInterface)object;
        if (!bl && unitOfWork.isOriginalNewObject(object2)) {
            if (valueHolderInterface instanceof DatabaseValueHolder && !((DatabaseValueHolder)valueHolderInterface).isInstantiated() && ((DatabaseValueHolder)valueHolderInterface).getSession() == null && !((DatabaseValueHolder)valueHolderInterface).isSerializedRemoteUnitOfWorkValueHolder()) {
                throw DescriptorException.attemptToRegisterDeadIndirection(object2, this.getMapping());
            }
            if (this.getMapping().getRelationshipPartner() == null) {
                cloneable = new ValueHolder();
                cloneable.setValue(this.getMapping().buildCloneForPartObject(valueHolderInterface.getValue(), object2, object3, unitOfWork, false));
            } else {
                DatabaseRow databaseRow = null;
                if (valueHolderInterface instanceof DatabaseValueHolder) {
                    databaseRow = ((DatabaseValueHolder)valueHolderInterface).getRow();
                }
                cloneable = this.getMapping().createUnitOfWorkValueHolder(valueHolderInterface, object2, object3, databaseRow, unitOfWork, bl);
                Object object4 = this.getMapping().buildCloneForPartObject(valueHolderInterface.getValue(), object2, object3, unitOfWork, false);
                ((UnitOfWorkValueHolder)cloneable).privilegedSetValue(object4);
                ((UnitOfWorkValueHolder)cloneable).setInstantiated();
            }
        } else {
            DatabaseRow databaseRow = null;
            if (valueHolderInterface instanceof DatabaseValueHolder) {
                databaseRow = ((DatabaseValueHolder)valueHolderInterface).getRow();
            }
            cloneable = this.getMapping().createUnitOfWorkValueHolder(valueHolderInterface, object2, object3, databaseRow, unitOfWork, bl);
        }
        return cloneable;
    }

    public Vector extractPrimaryKeyForReferenceObject(Object object, Session session) {
        if (this.objectIsInstantiated(object)) {
            return super.extractPrimaryKeyForReferenceObject(((ValueHolderInterface)object).getValue(), session);
        }
        return this.getOneToOneMapping().extractPrimaryKeysForReferenceObjectFromRow(this.extractReferenceRow(object));
    }

    public DatabaseRow extractReferenceRow(Object object) {
        if (this.objectIsInstantiated(object)) {
            return null;
        }
        return ((DatabaseValueHolder)object).getRow();
    }

    public void fixObjectReferences(Object object, IdentityHashtable identityHashtable, IdentityHashtable identityHashtable2, ObjectLevelReadQuery objectLevelReadQuery, RemoteSession remoteSession) {
        Object object2 = this.getMapping().getAttributeValueFromObject(object);
        if (object2 instanceof RemoteValueHolder) {
            RemoteValueHolder remoteValueHolder = (RemoteValueHolder)this.getMapping().getAttributeValueFromObject(object);
            remoteValueHolder.setSession(remoteSession);
            remoteValueHolder.setMapping(this.getMapping());
            if (!objectLevelReadQuery.shouldMaintainCache() && (!objectLevelReadQuery.shouldCascadeParts() || objectLevelReadQuery.shouldCascadePrivateParts() && !this.getMapping().isPrivateOwned())) {
                remoteValueHolder.setQuery(null);
            } else {
                remoteValueHolder.setQuery(objectLevelReadQuery);
            }
            remoteValueHolder.setUninstantiated();
        } else {
            this.getMapping().fixRealObjectReferences(object, identityHashtable, identityHashtable2, objectLevelReadQuery, remoteSession);
        }
    }

    public Object getOriginalIndirectionObject(Object object, Session session) {
        if (object instanceof UnitOfWorkValueHolder) {
            ValueHolderInterface valueHolderInterface = ((UnitOfWorkValueHolder)object).getWrappedValueHolder();
            if (valueHolderInterface == null && session.isRemoteUnitOfWork()) {
                RemoteSessionController remoteSessionController = ((RemoteUnitOfWork)session).getParentSessionController();
                ObjID objID = ((UnitOfWorkValueHolder)object).getWrappedValueHolderRemoteID();
                if (objID == null) {
                    Object object2 = ((UnitOfWorkValueHolder)object).getSourceObject();
                    DatabaseRow databaseRow = this.getMapping().getDescriptor().getObjectBuilder().buildRow(object2, session);
                    ReadObjectQuery readObjectQuery = new ReadObjectQuery();
                    readObjectQuery.setSession(((RemoteUnitOfWork)session).getParent());
                    valueHolderInterface = (ValueHolderInterface)this.getMapping().valueFromRow(databaseRow, readObjectQuery);
                } else {
                    valueHolderInterface = (ValueHolderInterface)remoteSessionController.getRemoteValueHolders().get(objID);
                }
            }
            if (valueHolderInterface != null && valueHolderInterface instanceof DatabaseValueHolder) {
                ((DatabaseValueHolder)valueHolderInterface).releaseWrappedValueHolder();
            }
            return valueHolderInterface;
        }
        return object;
    }

    public Object getRealAttributeValueFromObject(Object object) {
        if (ClassConstants.ValueHolderInterface_Class.isAssignableFrom(object.getClass())) {
            return ((ValueHolderInterface)object).getValue();
        }
        return object;
    }

    public Object getValueFromRemoteValueHolder(RemoteValueHolder remoteValueHolder) {
        return remoteValueHolder.getValue();
    }

    public void iterateOnAttributeValue(DescriptorIterator descriptorIterator, Object object) {
        descriptorIterator.iterateValueHolderForMapping((ValueHolderInterface)object, this.getMapping());
    }

    public void mergeRemoteValueHolder(Object object, Object object2, MergeManager mergeManager) {
        RemoteValueHolder remoteValueHolder = (RemoteValueHolder)this.getMapping().getAttributeValueFromObject(object2);
        this.mergeClientIntoServerValueHolder(remoteValueHolder, mergeManager);
        this.getMapping().setAttributeValueInObject(object, remoteValueHolder);
    }

    public Object nullValueFromRow() {
        return new ValueHolder();
    }

    public boolean objectIsInstantiated(Object object) {
        return ((ValueHolderInterface)object).isInstantiated();
    }

    public void setRealAttributeValueInObject(Object object, Object object2) {
        ValueHolderInterface valueHolderInterface = (ValueHolderInterface)this.getMapping().getAttributeValueFromObject(object);
        if (valueHolderInterface == null) {
            valueHolderInterface = new ValueHolder(object2);
        } else {
            valueHolderInterface.setValue(object2);
        }
        super.setRealAttributeValueInObject(object, valueHolderInterface);
    }

    protected boolean typeIsValid(Class clazz) {
        return clazz == ClassConstants.ValueHolderInterface_Class;
    }

    public Object validateAttributeOfInstantiatedObject(Object object) {
        if (object == null) {
            return new ValueHolder();
        }
        if (!(object instanceof ValueHolderInterface)) {
            throw DescriptorException.valueHolderInstantiationMismatch(object, this.getMapping());
        }
        return object;
    }

    public void validateDeclaredAttributeType(Class clazz, IntegrityChecker integrityChecker) throws DescriptorException {
        super.validateDeclaredAttributeType(clazz, integrityChecker);
        if (!this.typeIsValid(clazz)) {
            integrityChecker.handleError(DescriptorException.attributeAndMappingWithIndirectionMismatch(this.getMapping()));
        }
    }

    public void validateGetMethodReturnType(Class clazz, IntegrityChecker integrityChecker) throws DescriptorException {
        super.validateGetMethodReturnType(clazz, integrityChecker);
        if (!this.typeIsValid(clazz)) {
            integrityChecker.handleError(DescriptorException.returnAndMappingWithIndirectionMismatch(this.getMapping()));
        }
    }

    public void validateSetMethodParameterType(Class clazz, IntegrityChecker integrityChecker) throws DescriptorException {
        super.validateSetMethodParameterType(clazz, integrityChecker);
        if (!this.typeIsValid(clazz)) {
            integrityChecker.handleError(DescriptorException.parameterAndMappingWithIndirectionMismatch(this.getMapping()));
        }
    }

    public Object valueFromBatchQuery(ReadQuery readQuery, DatabaseRow databaseRow, ObjectLevelReadQuery objectLevelReadQuery) {
        return new BatchValueHolder(readQuery, databaseRow, this.getForeignReferenceMapping(), objectLevelReadQuery);
    }

    public Object valueFromMethod(Object object, DatabaseRow databaseRow, Session session) {
        return new TransformerBasedValueHolder(this.getTransformationMapping().getAttributeTransformer(), object, databaseRow, session);
    }

    public Object valueFromQuery(ReadQuery readQuery, DatabaseRow databaseRow, Session session) {
        return new QueryBasedValueHolder(readQuery, databaseRow, session);
    }

    public Object valueFromRow(Object object) {
        return new ValueHolder(object);
    }
}

