/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.identitymaps;

import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.exceptions.TopLinkException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.internal.descriptors.ObjectBuilder;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.ConcurrencyManager;
import oracle.toplink.internal.helper.DeferredLockManager;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.helper.JavaPlatform;
import oracle.toplink.internal.helper.WriteLockManager;
import oracle.toplink.internal.identitymaps.CacheIdentityMap;
import oracle.toplink.internal.identitymaps.CacheKey;
import oracle.toplink.internal.identitymaps.IdentityMap;
import oracle.toplink.internal.identitymaps.UnitOfWorkIdentityMap;
import oracle.toplink.internal.localization.LoggingLocalization;
import oracle.toplink.internal.localization.TraceLocalization;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.InMemoryQueryIndirectionPolicy;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.queryframework.ReadQuery;
import oracle.toplink.sessions.Record;

public class IdentityMapManager
implements Serializable,
Cloneable {
    protected Hashtable identityMaps;
    protected Map queryResults;
    protected Session session;
    protected transient ConcurrencyManager cacheMutex;
    protected IdentityMap lastAccessedIdentityMap = null;
    protected Class lastAccessedIdentityMapClass = null;
    protected transient WriteLockManager writeLockManager;
    protected Boolean isCacheAccessPreCheckRequired;

    public IdentityMapManager(Session session) {
        this.session = session;
        this.cacheMutex = new ConcurrencyManager();
        this.identityMaps = new Hashtable();
        if (!session.isUnitOfWork()) {
            this.queryResults = JavaPlatform.getQueryCacheMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheKey acquireDeferredLock(Vector vector, Class clazz, Descriptor descriptor) {
        CacheKey cacheKey = null;
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                cacheKey = this.getIdentityMap(descriptor).acquireDeferredLock(vector);
            }
            finally {
                this.releaseReadLock();
            }
            this.getSession().endOperationProfile("cache");
        } else {
            cacheKey = this.getIdentityMap(descriptor).acquireDeferredLock(vector);
        }
        return cacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheKey acquireLock(Vector vector, Class clazz, boolean bl, Descriptor descriptor) {
        CacheKey cacheKey = null;
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                cacheKey = this.getIdentityMap(descriptor).acquireLock(vector, bl);
            }
            finally {
                this.releaseReadLock();
            }
            this.getSession().endOperationProfile("cache");
        } else {
            cacheKey = this.getIdentityMap(descriptor).acquireLock(vector, bl);
        }
        return cacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheKey acquireLockNoWait(Vector vector, Class clazz, boolean bl, Descriptor descriptor) {
        CacheKey cacheKey = null;
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                cacheKey = this.getIdentityMap(descriptor).acquireLockNoWait(vector, bl);
            }
            finally {
                this.releaseReadLock();
            }
            this.getSession().endOperationProfile("cache");
        } else {
            cacheKey = this.getIdentityMap(descriptor).acquireLockNoWait(vector, bl);
        }
        return cacheKey;
    }

    protected boolean isCacheAccessPreCheckRequired() {
        if (this.isCacheAccessPreCheckRequired == null) {
            this.isCacheAccessPreCheckRequired = this.getSession().getProfiler() != null || this.getSession().getDatasourceLogin().shouldSynchronizedReadOnWrite() ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.isCacheAccessPreCheckRequired;
    }

    public void clearCacheAccessPreCheck() {
        this.isCacheAccessPreCheckRequired = null;
    }

    public void acquireReadLock() {
        this.getSession().startOperationProfile("cache");
        if (this.getSession().getDatasourceLogin().shouldSynchronizedReadOnWrite()) {
            this.getCacheMutex().acquireReadLock();
        }
        this.getSession().endOperationProfile("cache");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheKey acquireReadLockOnCacheKey(Vector vector, Class clazz, Descriptor descriptor) {
        CacheKey cacheKey = null;
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                cacheKey = this.getIdentityMap(descriptor).acquireReadLockOnCacheKey(vector);
            }
            finally {
                this.releaseReadLock();
            }
            this.getSession().endOperationProfile("cache");
        } else {
            cacheKey = this.getIdentityMap(descriptor).acquireReadLockOnCacheKey(vector);
        }
        return cacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheKey acquireReadLockOnCacheKeyNoWait(Vector vector, Class clazz, Descriptor descriptor) {
        CacheKey cacheKey = null;
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                cacheKey = this.getIdentityMap(descriptor).acquireReadLockOnCacheKeyNoWait(vector);
            }
            finally {
                this.releaseReadLock();
            }
            this.getSession().endOperationProfile("cache");
        } else {
            cacheKey = this.getIdentityMap(descriptor).acquireReadLockOnCacheKeyNoWait(vector);
        }
        return cacheKey;
    }

    public boolean acquireWriteLock() {
        if (this.getSession().getDatasourceLogin().shouldSynchronizedReadOnWrite() || this.getSession().getDatasourceLogin().shouldSynchronizeWrites()) {
            this.getCacheMutex().acquire();
            return true;
        }
        return false;
    }

    public IdentityMap buildNewIdentityMap(Descriptor descriptor) throws ValidationException, DescriptorException {
        if (this.getSession().isUnitOfWork()) {
            return new UnitOfWorkIdentityMap(32);
        }
        try {
            if (this.getSession().isRemoteSession()) {
                Constructor constructor = PrivilegedAccessController.getConstructorFor(descriptor.getRemoteIdentityMapClass(), new Class[]{ClassConstants.PINT}, false);
                return (IdentityMap)PrivilegedAccessController.invokeConstructor(constructor, new Object[]{new Integer(descriptor.getRemoteIdentityMapSize())});
            }
            Constructor constructor = PrivilegedAccessController.getConstructorFor(descriptor.getIdentityMapClass(), new Class[]{ClassConstants.PINT}, false);
            return (IdentityMap)PrivilegedAccessController.invokeConstructor(constructor, new Object[]{new Integer(descriptor.getIdentityMapSize())});
        }
        catch (Exception exception) {
            throw DescriptorException.invalidIdentityMap(descriptor, exception);
        }
    }

    public void clearLastAccessedIdentityMap() {
        this.lastAccessedIdentityMap = null;
        this.lastAccessedIdentityMapClass = null;
    }

    public Object clone() {
        IdentityMapManager identityMapManager = null;
        try {
            identityMapManager = (IdentityMapManager)super.clone();
            identityMapManager.setIdentityMaps(new Hashtable());
            Enumeration enumeration = this.getIdentityMaps().keys();
            while (enumeration.hasMoreElements()) {
                Class clazz = (Class)enumeration.nextElement();
                identityMapManager.getIdentityMaps().put(clazz, ((IdentityMap)this.getIdentityMaps().get(clazz)).clone());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return identityMapManager;
    }

    public void clearQueryCache() {
        this.queryResults = JavaPlatform.getQueryCacheMap();
    }

    public void clearQueryCache(ReadQuery readQuery) {
        if (readQuery != null) {
            this.queryResults.remove(readQuery);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Vector vector, Class clazz, Descriptor descriptor) {
        boolean bl;
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.elementAt(i) != null) continue;
            return false;
        }
        IdentityMap identityMap = this.getIdentityMap(descriptor);
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                bl = identityMap.containsKey(vector);
            }
            finally {
                this.releaseReadLock();
                this.getSession().endOperationProfile("cache");
            }
        } else {
            bl = identityMap.containsKey(vector);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Vector getAllFromIdentityMap(Expression expression, Class clazz, Record record, InMemoryQueryIndirectionPolicy inMemoryQueryIndirectionPolicy, boolean bl) {
        Descriptor descriptor = this.getSession().getDescriptor(clazz);
        this.getSession().startOperationProfile("cache");
        Vector<Object> vector = null;
        try {
            Expression expression2 = expression;
            if (expression != null && expression2.getBuilder().getSession() == null) {
                expression2 = (Expression)expression.clone();
                expression2.getBuilder().setSession(this.getSession());
                expression2.getBuilder().setQueryClass(clazz);
            }
            vector = new Vector<Object>();
            IdentityMap identityMap = this.getIdentityMap(descriptor);
            long l = System.currentTimeMillis();
            Enumeration enumeration = identityMap.keys();
            while (enumeration.hasMoreElements()) {
                Object object;
                CacheKey cacheKey = (CacheKey)enumeration.nextElement();
                if (cacheKey.getObject() == null || !bl && this.getSession().getDescriptor(clazz).getCacheInvalidationPolicy().isInvalidated(cacheKey, l) || (object = cacheKey.getObject()) == null || object.getClass() != clazz && !clazz.isInstance(object)) continue;
                if (expression2 == null) {
                    vector.addElement(object);
                    this.getSession().incrementProfile("CacheHits");
                    continue;
                }
                try {
                    if (!expression2.doesConform(object, this.getSession(), (DatabaseRow)record, inMemoryQueryIndirectionPolicy)) continue;
                    vector.addElement(object);
                    this.getSession().incrementProfile("CacheHits");
                }
                catch (QueryException queryException) {
                    if (queryException.getErrorCode() != 6092) throw queryException;
                    if (inMemoryQueryIndirectionPolicy.shouldIgnoreIndirectionExceptionReturnConformed()) {
                        vector.addElement(object);
                        this.getSession().incrementProfile("CacheHits");
                        continue;
                    }
                    if (!inMemoryQueryIndirectionPolicy.shouldThrowIndirectionException()) continue;
                    throw queryException;
                    return vector;
                }
            }
        }
        finally {
            this.getSession().endOperationProfile("cache");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheKey getCacheKeyForObject(Vector vector, Class clazz, Descriptor descriptor) {
        IdentityMap identityMap = this.getIdentityMap(descriptor);
        CacheKey cacheKey = null;
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                cacheKey = identityMap.getCacheKey(vector);
            }
            finally {
                this.releaseReadLock();
                this.getSession().endOperationProfile("cache");
            }
        } else {
            cacheKey = identityMap.getCacheKey(vector);
        }
        return cacheKey;
    }

    public ConcurrencyManager getCacheMutex() {
        return this.cacheMutex;
    }

    public Vector getClassesRegistered() {
        Enumeration enumeration = this.getIdentityMaps().keys();
        Vector<String> vector = new Vector<String>(this.getIdentityMaps().size());
        while (enumeration.hasMoreElements()) {
            vector.add(((Class)enumeration.nextElement()).getName());
        }
        return vector;
    }

    public Object getFromIdentityMap(Object object) {
        Descriptor descriptor = this.getSession().getDescriptor(object);
        Vector vector = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, this.getSession());
        return this.getFromIdentityMap(vector, object.getClass(), descriptor);
    }

    public Object getFromIdentityMap(Vector vector, Class clazz, Descriptor descriptor) {
        return this.getFromIdentityMap(vector, clazz, true, descriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getFromIdentityMap(Vector vector, Class clazz, boolean bl, Descriptor descriptor) {
        CacheKey cacheKey;
        if (vector == null) {
            return null;
        }
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            if (vector.get(i) != null) continue;
            return null;
        }
        IdentityMap identityMap = this.getIdentityMap(descriptor);
        Object object = null;
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                cacheKey = identityMap.getCacheKey(vector);
            }
            finally {
                this.releaseReadLock();
            }
        } else {
            cacheKey = identityMap.getCacheKey(vector);
        }
        if (cacheKey != null && (bl || !this.getSession().getDescriptor(clazz).getCacheInvalidationPolicy().isInvalidated(cacheKey, System.currentTimeMillis()))) {
            try {
                cacheKey.acquireReadLock();
                object = cacheKey.getObject();
            }
            finally {
                cacheKey.releaseReadLock();
            }
            object = this.checkForInheritance(object, clazz);
        }
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().endOperationProfile("cache");
            if (object == null) {
                this.getSession().incrementProfile("CacheMisses");
            } else {
                this.getSession().incrementProfile("CacheHits");
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getFromIdentityMap(Expression expression, Class clazz, Record record, InMemoryQueryIndirectionPolicy inMemoryQueryIndirectionPolicy, boolean bl, boolean bl2, Descriptor descriptor) {
        UnitOfWork unitOfWork = bl ? (UnitOfWork)this.getSession() : null;
        this.getSession().startOperationProfile("cache");
        try {
            Expression expression2 = expression;
            if (expression != null && expression2.getBuilder().getSession() == null) {
                expression2 = (Expression)expression.clone();
                expression2.getBuilder().setSession(this.getSession());
                expression2.getBuilder().setQueryClass(clazz);
            }
            IdentityMap identityMap = this.getIdentityMap(descriptor);
            long l = System.currentTimeMillis();
            Enumeration enumeration = identityMap.keys();
            while (enumeration.hasMoreElements()) {
                Object object;
                CacheKey cacheKey = (CacheKey)enumeration.nextElement();
                if (!bl2 && descriptor.getCacheInvalidationPolicy().isInvalidated(cacheKey, l) || (object = cacheKey.getObject()) == null || object.getClass() != clazz && !clazz.isInstance(object)) continue;
                if (!(expression2 != null || bl && unitOfWork.isObjectDeleted(object))) {
                    this.getSession().incrementProfile("CacheHits");
                    Object object2 = object;
                    this.getSession().endOperationProfile("cache");
                    return object2;
                }
                if (!expression2.doesConform(object, this.getSession(), (DatabaseRow)record, inMemoryQueryIndirectionPolicy) || bl && unitOfWork.isObjectDeleted(object)) continue;
                this.getSession().incrementProfile("CacheHits");
                Object object3 = object;
                this.getSession().endOperationProfile("cache");
                return object3;
            }
            return null;
        }
        finally {
            this.getSession().endOperationProfile("cache");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getFromIdentityMapWithDeferredLock(Vector vector, Class clazz, boolean bl, Descriptor descriptor) {
        CacheKey cacheKey;
        if (vector == null) {
            this.getSession().incrementProfile("CacheMisses");
            return null;
        }
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.elementAt(i) != null) continue;
            this.getSession().incrementProfile("CacheMisses");
            return null;
        }
        IdentityMap identityMap = this.getIdentityMap(descriptor);
        Object object = null;
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                cacheKey = identityMap.getCacheKey(vector);
            }
            finally {
                this.releaseReadLock();
            }
        } else {
            cacheKey = identityMap.getCacheKey(vector);
        }
        if (cacheKey != null && (bl || !descriptor.getCacheInvalidationPolicy().isInvalidated(cacheKey, System.currentTimeMillis()))) {
            cacheKey.acquireDeferredLock();
            object = cacheKey.getObject();
            cacheKey.releaseDeferredLock();
        }
        object = this.checkForInheritance(object, clazz);
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().endOperationProfile("cache");
            if (object == null) {
                this.getSession().incrementProfile("CacheMisses");
            } else {
                this.getSession().incrementProfile("CacheHits");
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdentityMap getIdentityMap(Descriptor descriptor) {
        IdentityMap identityMap;
        if (descriptor.hasInheritance()) {
            descriptor = descriptor.getInheritancePolicy().getRootParentDescriptor();
        }
        Class clazz = descriptor.getJavaClass();
        IdentityMapManager identityMapManager = this;
        synchronized (identityMapManager) {
            IdentityMap identityMap2 = this.lastAccessedIdentityMap;
            if (identityMap2 != null && this.lastAccessedIdentityMapClass == clazz) {
                return identityMap2;
            }
            identityMap = (IdentityMap)this.getIdentityMaps().get(clazz);
            if (identityMap == null) {
                identityMap = this.buildNewIdentityMap(descriptor);
                this.getIdentityMaps().put(clazz, identityMap);
            }
            this.lastAccessedIdentityMap = identityMap;
            this.lastAccessedIdentityMapClass = clazz;
        }
        return identityMap;
    }

    protected Hashtable getIdentityMaps() {
        return this.identityMaps;
    }

    public Enumeration getIdentityMapClasses() {
        return this.identityMaps.keys();
    }

    public Object getQueryResult(ReadQuery readQuery, Vector vector, boolean bl) {
        CacheKey cacheKey;
        if (readQuery.getQueryResultsCachePolicy() == null) {
            return null;
        }
        IdentityMap identityMap = (IdentityMap)this.queryResults.get(readQuery);
        if (identityMap == null) {
            return null;
        }
        Vector vector2 = vector;
        if (vector2 == null) {
            vector2 = new Vector();
        }
        if ((cacheKey = identityMap.getCacheKey(vector2)) == null || bl && readQuery.getQueryResultsCachePolicy().getCacheInvalidationPolicy().isInvalidated(cacheKey, System.currentTimeMillis())) {
            return null;
        }
        return cacheKey.getObject();
    }

    protected Session getSession() {
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getWrapper(Vector vector, Class clazz) {
        Object object;
        Descriptor descriptor = this.getSession().getDescriptor(clazz);
        IdentityMap identityMap = this.getIdentityMap(descriptor);
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                object = identityMap.getWrapper(vector);
            }
            finally {
                this.releaseReadLock();
            }
            this.getSession().endOperationProfile("cache");
        } else {
            object = identityMap.getWrapper(vector);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WriteLockManager getWriteLockManager() {
        IdentityMapManager identityMapManager = this;
        synchronized (identityMapManager) {
            if (this.writeLockManager == null) {
                this.writeLockManager = new WriteLockManager();
            }
        }
        return this.writeLockManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getWriteLockValue(Vector vector, Class clazz, Descriptor descriptor) {
        Object object;
        IdentityMap identityMap = this.getIdentityMap(descriptor);
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                object = identityMap.getWriteLockValue(vector);
            }
            finally {
                this.releaseReadLock();
            }
            this.getSession().endOperationProfile("cache");
        } else {
            object = identityMap.getWriteLockValue(vector);
        }
        return object;
    }

    public void initializeIdentityMap(Class clazz) throws TopLinkException {
        Descriptor descriptor = this.getSession().getDescriptor(clazz);
        if (descriptor == null) {
            throw ValidationException.missingDescriptor(String.valueOf(clazz));
        }
        if (descriptor.isChildDescriptor()) {
            throw ValidationException.childDescriptorsDoNotHaveIdentityMap();
        }
        Class clazz2 = descriptor.getJavaClass();
        if (clazz2 == this.lastAccessedIdentityMapClass) {
            this.clearLastAccessedIdentityMap();
        }
        IdentityMap identityMap = this.buildNewIdentityMap(descriptor);
        this.getIdentityMaps().put(clazz2, identityMap);
    }

    public void initializeIdentityMaps() {
        this.clearLastAccessedIdentityMap();
        this.setIdentityMaps(new Hashtable());
        this.clearQueryCache();
    }

    public void printIdentityMap(Class clazz) {
        Object object;
        Object object2;
        String string = Helper.cr();
        Descriptor descriptor = this.getSession().getDescriptor(clazz);
        int n = 0;
        StringWriter stringWriter = new StringWriter();
        if (descriptor.isAggregateDescriptor()) {
            return;
        }
        IdentityMap identityMap = this.getIdentityMap(descriptor);
        stringWriter.write(LoggingLocalization.buildMessage("identitymap_for", new Object[]{string, Helper.getShortClassName(identityMap.getClass()), Helper.getShortClassName(clazz)}));
        if (descriptor.hasInheritance() && descriptor.getInheritancePolicy().isRootParentDescriptor()) {
            stringWriter.write(LoggingLocalization.buildMessage("includes"));
            object2 = descriptor.getInheritancePolicy().getChildDescriptors();
            if (object2 != null && ((Vector)object2).size() != 0) {
                object = ((Vector)object2).elements();
                stringWriter.write(Helper.getShortClassName(((Descriptor)object.nextElement()).getJavaClass()));
                while (object.hasMoreElements()) {
                    stringWriter.write(", " + Helper.getShortClassName(((Descriptor)object.nextElement()).getJavaClass()));
                }
            }
            stringWriter.write(")");
        }
        object2 = identityMap.keys();
        while (object2.hasMoreElements()) {
            object = (CacheKey)object2.nextElement();
            Object object3 = ((CacheKey)object).getObject();
            if (!clazz.isInstance(object3)) continue;
            ++n;
            if (object3 == null) {
                stringWriter.write(LoggingLocalization.buildMessage("key_object_null", new Object[]{string, ((CacheKey)object).getKey(), "\t"}));
                continue;
            }
            stringWriter.write(LoggingLocalization.buildMessage("key_identity_hash_code_object", new Object[]{string, ((CacheKey)object).getKey(), "\t", String.valueOf(System.identityHashCode(object3)), object3}));
        }
        stringWriter.write(LoggingLocalization.buildMessage("elements", new Object[]{string, String.valueOf(n)}));
        this.getSession().log(7, "cache", stringWriter.toString(), null, null, false);
    }

    public void printIdentityMaps() {
        Iterator iterator = this.getSession().getDescriptors().keySet().iterator();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            Descriptor descriptor = this.getSession().getDescriptor(clazz);
            if (descriptor.hasInheritance()) {
                if (!descriptor.getInheritancePolicy().isRootParentDescriptor()) continue;
                this.printIdentityMap(clazz);
                continue;
            }
            this.printIdentityMap(clazz);
        }
    }

    public void printLocks() {
        Object object;
        StringWriter stringWriter = new StringWriter();
        HashMap hashMap = new HashMap();
        stringWriter.write(TraceLocalization.buildMessage("lock_writer_header", null) + Helper.cr());
        Iterator iterator = this.session.getIdentityMapAccessorInstance().getIdentityMapManager().getIdentityMaps().values().iterator();
        while (iterator.hasNext()) {
            object = (IdentityMap)iterator.next();
            ((IdentityMap)object).collectLocks(hashMap);
        }
        object = new Object[1];
        Iterator iterator2 = hashMap.keySet().iterator();
        while (iterator2.hasNext()) {
            Object object2;
            Thread thread = (Thread)iterator2.next();
            object[0] = thread.getName();
            stringWriter.write(TraceLocalization.buildMessage("active_thread", (Object[])object) + Helper.cr());
            Object object3 = ((HashSet)hashMap.get(thread)).iterator();
            while (object3.hasNext()) {
                object2 = (CacheKey)object3.next();
                object[0] = ((CacheKey)object2).getObject();
                stringWriter.write(TraceLocalization.buildMessage("locked_object", (Object[])object) + Helper.cr());
                object[0] = new Integer(((CacheKey)object2).getMutex().getDepth());
                stringWriter.write(TraceLocalization.buildMessage("depth", (Object[])object) + Helper.cr());
            }
            object3 = ConcurrencyManager.getDeferredLockManager(thread);
            if (object3 == null) continue;
            object2 = ((DeferredLockManager)object3).getDeferredLocks().iterator();
            while (object2.hasNext()) {
                ConcurrencyManager concurrencyManager = (ConcurrencyManager)object2.next();
                object[0] = concurrencyManager.getOwnerCacheKey().getObject();
                stringWriter.write(TraceLocalization.buildMessage("deferred_locks", (Object[])object) + Helper.cr());
            }
        }
        stringWriter.write(Helper.cr() + TraceLocalization.buildMessage("lock_writer_footer", null) + Helper.cr());
        this.getSession().log(1, "cache", stringWriter.toString(), null, null, false);
    }

    public void printLocks(Class clazz) {
        Descriptor descriptor = this.getSession().getDescriptor(clazz);
        StringWriter stringWriter = new StringWriter();
        HashMap hashMap = new HashMap();
        stringWriter.write(TraceLocalization.buildMessage("lock_writer_header", null) + Helper.cr());
        IdentityMap identityMap = this.getIdentityMap(descriptor);
        identityMap.collectLocks(hashMap);
        Object[] objectArray = new Object[1];
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            Thread thread = (Thread)iterator.next();
            objectArray[0] = thread.getName();
            stringWriter.write(TraceLocalization.buildMessage("active_thread", objectArray) + Helper.cr());
            Object object2 = ((HashSet)hashMap.get(thread)).iterator();
            while (object2.hasNext()) {
                object = (CacheKey)object2.next();
                objectArray[0] = ((CacheKey)object).getObject();
                stringWriter.write(TraceLocalization.buildMessage("locked_object", objectArray) + Helper.cr());
                objectArray[0] = new Integer(((CacheKey)object).getMutex().getDepth());
                stringWriter.write(TraceLocalization.buildMessage("depth", objectArray) + Helper.cr());
            }
            object2 = ConcurrencyManager.getDeferredLockManager(thread);
            if (object2 == null) continue;
            object = ((DeferredLockManager)object2).getDeferredLocks().iterator();
            while (object.hasNext()) {
                ConcurrencyManager concurrencyManager = (ConcurrencyManager)object.next();
                objectArray[0] = concurrencyManager.getOwnerCacheKey().getObject();
                stringWriter.write(TraceLocalization.buildMessage("deferred_locks", objectArray) + Helper.cr());
            }
        }
        stringWriter.write(Helper.cr() + TraceLocalization.buildMessage("lock_writer_footer", null) + Helper.cr());
        this.getSession().log(1, "cache", stringWriter.toString(), null, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheKey putInIdentityMap(Object object, Vector vector, Object object2, long l, Descriptor descriptor) {
        CacheKey cacheKey;
        ObjectBuilder objectBuilder = descriptor.getObjectBuilder();
        Object object3 = objectBuilder.unwrapObject(object, this.getSession());
        IdentityMap identityMap = this.getIdentityMap(descriptor);
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                cacheKey = identityMap.put(vector, object3, object2, l);
            }
            finally {
                this.releaseReadLock();
            }
            this.getSession().endOperationProfile("cache");
        } else {
            cacheKey = identityMap.put(vector, object3, object2, l);
        }
        return cacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putQueryResult(ReadQuery readQuery, Vector vector, Object object) {
        Vector vector2;
        IdentityMap identityMap = (IdentityMap)this.queryResults.get(readQuery);
        if (identityMap == null) {
            vector2 = this.queryResults;
            synchronized (vector2) {
                identityMap = (IdentityMap)this.queryResults.get(readQuery);
                if (identityMap == null) {
                    identityMap = new CacheIdentityMap(readQuery.getQueryResultsCachePolicy().getMaximumCachedResults());
                    this.queryResults.put(readQuery, identityMap);
                }
            }
        }
        if ((vector2 = vector) == null) {
            vector2 = new Vector();
        }
        long l = 0L;
        if (readQuery.isObjectLevelReadQuery()) {
            l = ((ObjectLevelReadQuery)readQuery).getExecutionTime();
        }
        if (l == 0L) {
            l = System.currentTimeMillis();
        }
        identityMap.put(vector2, object, null, l);
    }

    protected void releaseReadLock() {
        if (this.getSession().getDatasourceLogin().shouldSynchronizedReadOnWrite()) {
            this.getCacheMutex().releaseReadLock();
        }
    }

    public void releaseWriteLock() {
        if (this.getSession().getDatasourceLogin().shouldSynchronizedReadOnWrite() || this.getSession().getDatasourceLogin().shouldSynchronizeWrites()) {
            this.getCacheMutex().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeFromIdentityMap(Vector vector, Class clazz, Descriptor descriptor) {
        Object object;
        IdentityMap identityMap = this.getIdentityMap(descriptor);
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                object = identityMap.remove(vector);
            }
            finally {
                this.releaseReadLock();
            }
            this.getSession().endOperationProfile("cache");
        } else {
            object = identityMap.remove(vector);
        }
        return object;
    }

    protected void setCacheMutex(ConcurrencyManager concurrencyManager) {
        this.cacheMutex = concurrencyManager;
    }

    public void setIdentityMaps(Hashtable hashtable) {
        this.clearLastAccessedIdentityMap();
        this.identityMaps = hashtable;
    }

    protected void setSession(Session session) {
        this.session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWrapper(Vector vector, Class clazz, Object object) {
        Descriptor descriptor = this.getSession().getDescriptor(clazz);
        IdentityMap identityMap = this.getIdentityMap(descriptor);
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                identityMap.setWrapper(vector, object);
            }
            finally {
                this.releaseReadLock();
            }
            this.getSession().endOperationProfile("cache");
        } else {
            identityMap.setWrapper(vector, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWriteLockValue(Vector vector, Class clazz, Object object) {
        Descriptor descriptor = this.getSession().getDescriptor(clazz);
        IdentityMap identityMap = this.getIdentityMap(descriptor);
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                identityMap.setWriteLockValue(vector, object);
            }
            finally {
                this.releaseReadLock();
            }
            this.getSession().endOperationProfile("cache");
        } else {
            identityMap.setWriteLockValue(vector, object);
        }
    }

    protected Object checkForInheritance(Object object, Class clazz) {
        if (object != null && object.getClass() != clazz && !clazz.isInstance(object)) {
            Descriptor descriptor = this.getSession().getDescriptor(clazz);
            if (descriptor.hasInheritance() && descriptor.getInheritancePolicy().getUseDescriptorsToValidateInheritedObjects()) {
                if (descriptor.getInheritancePolicy().getSubclassDescriptor(object.getClass()) == null) {
                    return null;
                }
                return object;
            }
            return null;
        }
        return object;
    }
}

