/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.identitymaps;

import java.util.Vector;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.identitymaps.CacheKey;
import oracle.toplink.internal.identitymaps.FullIdentityMap;
import oracle.toplink.internal.identitymaps.LinkedCacheKey;

public class CacheIdentityMap
extends FullIdentityMap {
    protected LinkedCacheKey first = new LinkedCacheKey(new Vector(2), null, null, 0L);
    protected LinkedCacheKey last = new LinkedCacheKey(new Vector(2), null, null, 0L);

    public CacheIdentityMap(int n) {
        super(n);
        this.first.setNext(this.last);
        this.last.setPrevious(this.first);
    }

    public CacheKey createCacheKey(Vector vector, Object object, Object object2, long l) {
        return new LinkedCacheKey(vector, object, object2, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureFixedSize() {
        LinkedCacheKey linkedCacheKey = this.first;
        synchronized (linkedCacheKey) {
            while (this.getMaxSize() > 0 && this.getSize() > this.getMaxSize()) {
                this.remove(this.last.getPrevious());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheKey getCacheKey(Vector vector) {
        LinkedCacheKey linkedCacheKey = (LinkedCacheKey)super.getCacheKey(vector);
        if (linkedCacheKey != null) {
            LinkedCacheKey linkedCacheKey2 = this.first;
            synchronized (linkedCacheKey2) {
                this.removeLink(linkedCacheKey);
                this.insertLink(linkedCacheKey);
            }
        }
        return linkedCacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LinkedCacheKey insertLink(LinkedCacheKey linkedCacheKey) {
        if (linkedCacheKey == null) {
            return linkedCacheKey;
        }
        LinkedCacheKey linkedCacheKey2 = this.first;
        synchronized (linkedCacheKey2) {
            this.first.getNext().setPrevious(linkedCacheKey);
            linkedCacheKey.setNext(this.first.getNext());
            linkedCacheKey.setPrevious(this.first);
            this.first.setNext(linkedCacheKey);
        }
        return linkedCacheKey;
    }

    protected void put(CacheKey cacheKey) {
        super.put(cacheKey);
        this.insertLink((LinkedCacheKey)cacheKey);
        this.ensureFixedSize();
    }

    public Object remove(CacheKey cacheKey) {
        super.remove(cacheKey);
        if (cacheKey == null) {
            CacheKey cacheKey2;
            Class<?> clazz = null;
            if (!this.getCacheKeys().isEmpty() && (cacheKey2 = (CacheKey)this.getCacheKeys().keys().nextElement()) != null && cacheKey2.getObject() != null) {
                clazz = cacheKey2.getObject().getClass();
            }
            throw ValidationException.nullCacheKeyFoundOnRemoval(this, clazz);
        }
        return this.removeLink((LinkedCacheKey)cacheKey).getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LinkedCacheKey removeLink(LinkedCacheKey linkedCacheKey) {
        if (linkedCacheKey == null) {
            return linkedCacheKey;
        }
        LinkedCacheKey linkedCacheKey2 = this.first;
        synchronized (linkedCacheKey2) {
            if (linkedCacheKey.getPrevious() == null || linkedCacheKey.getNext() == null) {
                return linkedCacheKey;
            }
            linkedCacheKey.getPrevious().setNext(linkedCacheKey.getNext());
            linkedCacheKey.getNext().setPrevious(linkedCacheKey.getPrevious());
            linkedCacheKey.setNext(null);
            linkedCacheKey.setPrevious(null);
        }
        return linkedCacheKey;
    }

    public synchronized void updateMaxSize(int n) {
        this.setMaxSize(n);
        this.ensureFixedSize();
    }
}

