/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.expressions;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.expressions.ExpressionBuilder;
import oracle.toplink.history.AsOfClause;
import oracle.toplink.internal.databaseaccess.DB2MainframePlatform;
import oracle.toplink.internal.databaseaccess.DatabaseCall;
import oracle.toplink.internal.expressions.CompoundExpression;
import oracle.toplink.internal.expressions.DataExpression;
import oracle.toplink.internal.expressions.ExpressionIterator;
import oracle.toplink.internal.expressions.ExpressionNormalizer;
import oracle.toplink.internal.expressions.ExpressionSQLPrinter;
import oracle.toplink.internal.expressions.ForUpdateClause;
import oracle.toplink.internal.expressions.FunctionExpression;
import oracle.toplink.internal.expressions.ObjectExpression;
import oracle.toplink.internal.expressions.QueryKeyExpression;
import oracle.toplink.internal.expressions.RelationExpression;
import oracle.toplink.internal.expressions.SQLStatement;
import oracle.toplink.internal.expressions.TableAliasLookup;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.DatabaseTable;
import oracle.toplink.internal.helper.IdentityHashtable;
import oracle.toplink.internal.helper.NonSynchronizedVector;
import oracle.toplink.internal.history.DecoratedDatabaseTable;
import oracle.toplink.internal.history.UniversalAsOfClause;
import oracle.toplink.mappings.AggregateCollectionMapping;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.mappings.DirectCollectionMapping;
import oracle.toplink.mappings.ManyToManyMapping;
import oracle.toplink.mappings.OneToManyMapping;
import oracle.toplink.mappings.OneToOneMapping;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.SQLCall;

public class SQLSelectStatement
extends SQLStatement {
    protected Vector fields = NonSynchronizedVector.newInstance(2);
    protected Vector tables = NonSynchronizedVector.newInstance(4);
    protected short distinctState = 0;
    protected Vector orderByExpressions;
    protected Vector groupByExpressions;
    protected ForUpdateClause forUpdateClause;
    protected boolean isAggregateSelect = false;
    protected Vector outerJoinedExpressions;
    protected Vector outerJoinedMappingCriteria;
    protected Vector outerJoinedAdditionalJoinCriteria;
    protected Expression startWithExpression;
    protected Expression connectByExpression;
    protected Vector orderSiblingsByExpressions;
    protected boolean requiresAliases = false;
    protected Hashtable tableAliases;
    protected DatabaseTable lastTable;
    protected DatabaseTable currentAlias;
    protected int currentAliasNumber = 0;
    protected SQLSelectStatement parentStatement;

    public void addField(DatabaseField databaseField) {
        this.getFields().addElement(databaseField);
    }

    public void addField(Expression expression) {
        if (expression instanceof FunctionExpression && ((FunctionExpression)expression).getOperator().isAggregateOperator()) {
            this.setIsAggregateSelect(true);
        }
        this.getFields().addElement(expression);
    }

    protected void addOrderByExpressionToSelectForDistinct() {
        Enumeration enumeration = this.getOrderByExpressions().elements();
        while (enumeration.hasMoreElements()) {
            Expression expression = (Expression)enumeration.nextElement();
            Expression expression2 = null;
            expression2 = expression.isFunctionExpression() && expression.getOperator().isOrderOperator() ? ((FunctionExpression)expression).getBaseExpression() : expression;
            if (!expression2.selectIfOrderedBy() || this.fieldsContainField(this.getFields(), expression2)) continue;
            this.addField(expression2);
        }
    }

    public void addTable(DatabaseTable databaseTable) {
        if (!this.getTables().contains(databaseTable)) {
            this.getTables().addElement(databaseTable);
        }
    }

    public void appendFromClauseForInformixOuterJoin(ExpressionSQLPrinter expressionSQLPrinter, Vector vector) throws IOException {
        Writer writer = expressionSQLPrinter.getWriter();
        Session session = expressionSQLPrinter.getSession();
        boolean bl = true;
        for (int i = 0; i < this.getOuterJoinExpressions().size(); ++i) {
            DatabaseTable databaseTable;
            Object object;
            QueryKeyExpression queryKeyExpression = (QueryKeyExpression)this.getOuterJoinExpressions().elementAt(i);
            CompoundExpression compoundExpression = (CompoundExpression)this.getOuterJoinedMappingCriteria().elementAt(i);
            DatabaseTable databaseTable2 = null;
            databaseTable2 = queryKeyExpression.getMapping().isDirectCollectionMapping() ? ((DirectCollectionMapping)queryKeyExpression.getMapping()).getReferenceTable() : (DatabaseTable)queryKeyExpression.getMapping().getReferenceDescriptor().getTables().firstElement();
            DatabaseTable databaseTable3 = (DatabaseTable)((ObjectExpression)queryKeyExpression.getBaseExpression()).getDescriptor().getTables().firstElement();
            DatabaseTable databaseTable4 = queryKeyExpression.getBaseExpression().aliasForTable(databaseTable3);
            DatabaseTable databaseTable5 = queryKeyExpression.aliasForTable(databaseTable2);
            if (vector.contains(databaseTable4) || vector.contains(databaseTable5)) continue;
            if (!bl) {
                writer.write(", ");
            }
            bl = false;
            writer.write(databaseTable3.getQualifiedName());
            vector.addElement(databaseTable4);
            writer.write(" ");
            writer.write(databaseTable4.getQualifiedName());
            if (queryKeyExpression.getMapping().isManyToManyMapping()) {
                object = ((ManyToManyMapping)queryKeyExpression.getMapping()).getRelationTable();
                databaseTable = compoundExpression.aliasForTable((DatabaseTable)object);
                writer.write(", OUTER ");
                writer.write(((DatabaseTable)object).getQualifiedName());
                writer.write(" ");
                vector.addElement(databaseTable);
                writer.write(databaseTable.getQualifiedName());
                continue;
            }
            if (queryKeyExpression.getMapping().isDirectCollectionMapping()) {
                object = ((DirectCollectionMapping)queryKeyExpression.getMapping()).getReferenceTable();
                databaseTable = compoundExpression.aliasForTable((DatabaseTable)object);
                writer.write(", OUTER ");
                writer.write(((DatabaseTable)object).getQualifiedName());
                writer.write(" ");
                vector.addElement(databaseTable);
                writer.write(databaseTable.getQualifiedName());
                continue;
            }
            object = queryKeyExpression.getMapping().getReferenceDescriptor().getTables().elements();
            while (object.hasMoreElements()) {
                databaseTable = (DatabaseTable)object.nextElement();
                QueryKeyExpression queryKeyExpression2 = queryKeyExpression;
                DatabaseTable databaseTable6 = queryKeyExpression.aliasForTable(databaseTable);
                writer.write(", OUTER ");
                writer.write(databaseTable.getQualifiedName());
                writer.write(" ");
                vector.addElement(databaseTable6);
                writer.write(databaseTable6.getQualifiedName());
            }
        }
    }

    public void appendFromClauseForOuterJoin(ExpressionSQLPrinter expressionSQLPrinter, Vector vector) throws IOException {
        Writer writer = expressionSQLPrinter.getWriter();
        Session session = expressionSQLPrinter.getSession();
        boolean bl = true;
        boolean bl2 = false;
        for (int i = 0; i < this.getOuterJoinExpressions().size(); ++i) {
            Object object;
            Expression expression;
            DatabaseTable databaseTable;
            Object object2;
            QueryKeyExpression queryKeyExpression = (QueryKeyExpression)this.getOuterJoinExpressions().elementAt(i);
            DatabaseTable databaseTable2 = null;
            databaseTable2 = queryKeyExpression.getMapping().isDirectCollectionMapping() ? ((DirectCollectionMapping)queryKeyExpression.getMapping()).getReferenceTable() : (DatabaseTable)queryKeyExpression.getMapping().getReferenceDescriptor().getTables().firstElement();
            DatabaseTable databaseTable3 = (DatabaseTable)((ObjectExpression)queryKeyExpression.getBaseExpression()).getDescriptor().getTables().firstElement();
            DatabaseTable databaseTable4 = queryKeyExpression.getBaseExpression().aliasForTable(databaseTable3);
            DatabaseTable databaseTable5 = queryKeyExpression.aliasForTable(databaseTable2);
            if (vector.contains(databaseTable5)) continue;
            if (!vector.contains(databaseTable4)) {
                if (bl2 && session.getPlatform().shouldUseJDBCOuterJoinSyntax()) {
                    writer.write("}");
                }
                if (!bl) {
                    writer.write(",");
                }
                if (session.getPlatform().shouldUseJDBCOuterJoinSyntax()) {
                    writer.write("{'oj ");
                }
                bl2 = true;
                bl = false;
                writer.write(databaseTable3.getQualifiedName());
                vector.addElement(databaseTable4);
                writer.write(" ");
                writer.write(databaseTable4.getQualifiedName());
            }
            if (queryKeyExpression.getMapping().isDirectCollectionMapping()) {
                object2 = (Expression)this.getOuterJoinedMappingCriteria().elementAt(i);
                databaseTable = ((Expression)object2).aliasForTable(databaseTable2);
                writer.write(" LEFT OUTER JOIN ");
                writer.write(databaseTable2.getQualifiedName());
                writer.write(" ");
                vector.addElement(databaseTable);
                writer.write(databaseTable.getQualifiedName());
                writer.write(" ON ");
                if (session.getPlatform() instanceof DB2MainframePlatform) {
                    ((RelationExpression)object2).printSQLNoParens(expressionSQLPrinter);
                    continue;
                }
                ((Expression)object2).printSQL(expressionSQLPrinter);
                continue;
            }
            if (queryKeyExpression.getMapping().isManyToManyMapping()) {
                object2 = ((ManyToManyMapping)queryKeyExpression.getMapping()).getRelationTable();
                databaseTable = ((Expression)this.getOuterJoinedMappingCriteria().elementAt(i)).aliasForTable((DatabaseTable)object2);
                writer.write(" LEFT OUTER JOIN (");
                writer.write(((DatabaseTable)object2).getQualifiedName());
                writer.write(" ");
                vector.addElement(databaseTable);
                writer.write(databaseTable.getQualifiedName());
                expression = null;
                object = queryKeyExpression.getMapping().getReferenceDescriptor().getTables().elements();
                while (object.hasMoreElements()) {
                    DatabaseTable databaseTable6 = (DatabaseTable)object.nextElement();
                    Expression expression2 = null;
                    expression2 = databaseTable2 == databaseTable6 ? (Expression)this.getOuterJoinedMappingCriteria().elementAt(i) : (Expression)this.getOuterJoinedAdditionalJoinCriteria().elementAt(i);
                    DatabaseTable databaseTable7 = queryKeyExpression.aliasForTable(databaseTable6);
                    writer.write(" LEFT OUTER JOIN ");
                    writer.write(databaseTable6.getQualifiedName());
                    writer.write(" ");
                    vector.addElement(databaseTable7);
                    writer.write(databaseTable7.getQualifiedName());
                    writer.write(" ON ");
                    if (expression2.isCompoundExpression()) {
                        ((CompoundExpression)expression2).getSecondChild().printSQL(expressionSQLPrinter);
                        expression = ((CompoundExpression)expression2).getFirstChild();
                        continue;
                    }
                    expression2.printSQL(expressionSQLPrinter);
                }
                writer.write(") ON ");
                expression.printSQL(expressionSQLPrinter);
                continue;
            }
            object2 = queryKeyExpression.getMapping().getReferenceDescriptor().getTables().elements();
            while (object2.hasMoreElements()) {
                databaseTable = (DatabaseTable)object2.nextElement();
                expression = null;
                expression = databaseTable2 == databaseTable ? (Expression)this.getOuterJoinedMappingCriteria().elementAt(i) : (Expression)this.getOuterJoinedAdditionalJoinCriteria().elementAt(i);
                object = queryKeyExpression.aliasForTable(databaseTable);
                writer.write(" LEFT OUTER JOIN ");
                writer.write(databaseTable.getQualifiedName());
                writer.write(" ");
                vector.addElement(object);
                writer.write(((DatabaseTable)object).getQualifiedName());
                writer.write(" ON ");
                if (session.getPlatform() instanceof DB2MainframePlatform) {
                    ((RelationExpression)expression).printSQLNoParens(expressionSQLPrinter);
                    continue;
                }
                expression.printSQL(expressionSQLPrinter);
            }
        }
        if (bl2 && session.getPlatform().shouldUseJDBCOuterJoinSyntax()) {
            writer.write("}");
        }
    }

    public void appendFromClauseToWriter(ExpressionSQLPrinter expressionSQLPrinter) throws IOException {
        Writer writer = expressionSQLPrinter.getWriter();
        Session session = expressionSQLPrinter.getSession();
        writer.write(" FROM ");
        boolean bl = true;
        Vector vector = new Vector(1);
        if (this.hasOuterJoinExpressions()) {
            if (session.getPlatform().isInformixOuterJoin()) {
                this.appendFromClauseForInformixOuterJoin(expressionSQLPrinter, vector);
            } else if (!session.getPlatform().shouldPrintOuterJoinInWhereClause()) {
                this.appendFromClauseForOuterJoin(expressionSQLPrinter, vector);
            }
            bl = false;
        }
        if (this.getTableAliases().isEmpty()) {
            throw QueryException.invalidBuilderInQuery(null);
        }
        Enumeration enumeration = this.getTableAliases().keys();
        while (enumeration.hasMoreElements()) {
            DatabaseTable databaseTable = (DatabaseTable)enumeration.nextElement();
            if (vector.contains(databaseTable)) continue;
            DatabaseTable databaseTable2 = (DatabaseTable)this.getTableAliases().get(databaseTable);
            if (this.requiresAliases()) {
                if (!bl) {
                    writer.write(", ");
                }
                bl = false;
                writer.write(databaseTable2.getQualifiedName());
                writer.write(" ");
                if (databaseTable.isDecorated()) {
                    ((DecoratedDatabaseTable)databaseTable).getAsOfClause().printSQL(expressionSQLPrinter);
                    writer.write(" ");
                }
                writer.write(databaseTable.getQualifiedName());
                continue;
            }
            writer.write(databaseTable2.getQualifiedName());
            if (!databaseTable.isDecorated()) continue;
            writer.write(" ");
            ((DecoratedDatabaseTable)databaseTable).getAsOfClause().printSQL(expressionSQLPrinter);
        }
    }

    public void appendGroupByClauseToWriter(ExpressionSQLPrinter expressionSQLPrinter) throws IOException {
        if (this.getGroupByExpressions().isEmpty()) {
            return;
        }
        expressionSQLPrinter.getWriter().write(" GROUP BY ");
        Enumeration enumeration = this.getGroupByExpressions().elements();
        while (enumeration.hasMoreElements()) {
            Expression expression = (Expression)enumeration.nextElement();
            expression.printSQL(expressionSQLPrinter);
            if (!enumeration.hasMoreElements()) continue;
            expressionSQLPrinter.getWriter().write(", ");
        }
    }

    public void appendHierarchicalQueryClauseToWriter(ExpressionSQLPrinter expressionSQLPrinter) throws IOException {
        Cloneable cloneable;
        Object object;
        Expression expression = this.getStartWithExpression();
        Expression expression2 = this.getConnectByExpression();
        Vector vector = this.getOrderSiblingsByExpressions();
        if (expression != null) {
            expressionSQLPrinter.getWriter().write(" START WITH ");
            expression.printSQL(expressionSQLPrinter);
        }
        if (expression2 != null) {
            Cloneable cloneable2;
            if (!expression2.isQueryKeyExpression()) {
                throw QueryException.illFormedExpression(expression2);
            }
            expressionSQLPrinter.getWriter().write(" CONNECT BY ");
            object = ((QueryKeyExpression)expression2).getMapping();
            cloneable = ((DatabaseMapping)object).getDescriptor();
            Map map = null;
            if (((DatabaseMapping)object).isOneToManyMapping()) {
                cloneable2 = (OneToManyMapping)object;
                map = ((OneToManyMapping)cloneable2).getTargetForeignKeyToSourceKeys();
            } else if (((DatabaseMapping)object).isOneToOneMapping()) {
                cloneable2 = (OneToOneMapping)object;
                map = ((OneToOneMapping)cloneable2).getSourceToTargetKeyFields();
            } else if (((DatabaseMapping)object).isAggregateCollectionMapping()) {
                cloneable2 = (AggregateCollectionMapping)object;
                map = ((AggregateCollectionMapping)cloneable2).getTargetForeignKeyToSourceKeys();
            } else {
                throw QueryException.invalidQueryKeyInExpression(expression2);
            }
            cloneable2 = ((Descriptor)cloneable).getDefaultTable();
            String string = "";
            string = this.requiresAliases() ? this.getBuilder().aliasForTable((DatabaseTable)cloneable2).getName() : ((DatabaseTable)cloneable2).getName();
            if (map != null && !map.isEmpty()) {
                Iterator iterator = map.keySet().iterator();
                if (map.size() > 1) {
                    expressionSQLPrinter.getWriter().write("((");
                }
                DatabaseField databaseField = (DatabaseField)iterator.next();
                DatabaseField databaseField2 = (DatabaseField)map.get(databaseField);
                if (((DatabaseMapping)object).isOneToOneMapping()) {
                    expressionSQLPrinter.getWriter().write("PRIOR " + string + "." + databaseField.getName());
                    expressionSQLPrinter.getWriter().write(" = " + string + "." + databaseField2.getName());
                } else {
                    expressionSQLPrinter.getWriter().write(string + "." + databaseField.getName());
                    expressionSQLPrinter.getWriter().write(" = PRIOR " + string + "." + databaseField2.getName());
                }
                while (iterator.hasNext()) {
                    expressionSQLPrinter.getWriter().write(") AND (");
                    databaseField = (DatabaseField)iterator.next();
                    databaseField2 = (DatabaseField)map.get(databaseField);
                    if (((DatabaseMapping)object).isOneToOneMapping()) {
                        expressionSQLPrinter.getWriter().write("PRIOR " + string + "." + databaseField.getName());
                        expressionSQLPrinter.getWriter().write(" = " + string + "." + databaseField2.getName());
                        continue;
                    }
                    expressionSQLPrinter.getWriter().write(string + "." + databaseField.getName());
                    expressionSQLPrinter.getWriter().write(" = PRIOR " + string + "." + databaseField2.getName());
                }
                if (map.size() > 1) {
                    expressionSQLPrinter.getWriter().write("))");
                }
            }
        }
        if (vector != null) {
            expressionSQLPrinter.getWriter().write(" ORDER SIBLINGS BY ");
            object = vector.elements();
            while (object.hasMoreElements()) {
                cloneable = (Expression)object.nextElement();
                ((Expression)cloneable).printSQL(expressionSQLPrinter);
                if (!object.hasMoreElements()) continue;
                expressionSQLPrinter.getWriter().write(", ");
            }
        }
    }

    public void appendOrderClauseToWriter(ExpressionSQLPrinter expressionSQLPrinter) throws IOException {
        if (!this.hasOrderByExpressions()) {
            return;
        }
        expressionSQLPrinter.getWriter().write(" ORDER BY ");
        Enumeration enumeration = this.getOrderByExpressions().elements();
        while (enumeration.hasMoreElements()) {
            Expression expression = (Expression)enumeration.nextElement();
            expression.printSQL(expressionSQLPrinter);
            if (!enumeration.hasMoreElements()) continue;
            expressionSQLPrinter.getWriter().write(", ");
        }
    }

    public void assignAliases(Vector vector) {
        this.currentAliasNumber = this.getCurrentAliasNumber();
        ExpressionIterator expressionIterator = new ExpressionIterator(){

            public void iterate(Expression expression) {
                SQLSelectStatement.this.currentAliasNumber = expression.assignTableAliasesStartingAt(SQLSelectStatement.this.currentAliasNumber);
            }
        };
        if (vector.isEmpty()) {
            if (this.getBuilder() != null && this.requiresAliases()) {
                this.getBuilder().assignTableAliasesStartingAt(this.currentAliasNumber);
            }
        } else {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Expression expression = (Expression)enumeration.nextElement();
                expressionIterator.iterateOn(expression);
            }
        }
        this.setCurrentAliasNumber(this.currentAliasNumber);
    }

    public DatabaseCall buildCall(Session session) {
        SQLCall sQLCall = new SQLCall();
        sQLCall.returnManyRows();
        CharArrayWriter charArrayWriter = new CharArrayWriter(200);
        ExpressionSQLPrinter expressionSQLPrinter = new ExpressionSQLPrinter(session, this.getTranslationRow(), sQLCall, this.requiresAliases());
        expressionSQLPrinter.setWriter(charArrayWriter);
        sQLCall.setFields(this.printSQL(expressionSQLPrinter));
        sQLCall.setSQLString(((Object)charArrayWriter).toString());
        return sQLCall;
    }

    public void computeDistinct() {
        ExpressionIterator expressionIterator = new ExpressionIterator(){

            public void iterate(Expression expression) {
                if (expression.isQueryKeyExpression() && ((QueryKeyExpression)expression).shouldQueryToManyRelationship() && !SQLSelectStatement.this.isDistinctComputed()) {
                    SQLSelectStatement.this.useDistinct();
                }
            }
        };
        if (this.getWhereClause() != null) {
            expressionIterator.iterateOn(this.getWhereClause());
        }
    }

    public boolean isSubSelect() {
        return this.getParentStatement() != null;
    }

    public void computeTables() {
        ExpressionIterator expressionIterator = new ExpressionIterator(){

            public void iterate(Expression expression) {
                TableAliasLookup tableAliasLookup = expression.getTableAliases();
                if (tableAliasLookup != null && !tableAliasLookup.haveBeenAddedToStatement()) {
                    tableAliasLookup.addToHashtable((Hashtable)this.getResult());
                    tableAliasLookup.setHaveBeenAddedToStatement(true);
                }
            }
        };
        expressionIterator.setResult(new Hashtable(5));
        if (this.getWhereClause() != null) {
            expressionIterator.iterateOn(this.getWhereClause());
        } else if (this.hasOuterJoinExpressions()) {
            expressionIterator.iterateOn((Expression)this.getOuterJoinedMappingCriteria().firstElement());
        }
        expressionIterator.iterateOn(this.getBuilder());
        Hashtable hashtable = (Hashtable)expressionIterator.getResult();
        this.setTableAliases(hashtable);
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            this.addTable((DatabaseTable)enumeration.nextElement());
        }
    }

    public void computeTablesFromTables() {
        Hashtable<DecoratedDatabaseTable, DatabaseTable> hashtable = new Hashtable<DecoratedDatabaseTable, DatabaseTable>();
        AsOfClause asOfClause = null;
        if (this.getBuilder().hasAsOfClause() && !this.getBuilder().getSession().getProject().hasGenericHistorySupport()) {
            asOfClause = this.getBuilder().getAsOfClause();
        }
        for (int i = 0; i < this.getTables().size(); ++i) {
            DatabaseTable databaseTable = (DatabaseTable)this.getTables().elementAt(i);
            DecoratedDatabaseTable decoratedDatabaseTable = new DecoratedDatabaseTable("t" + i, asOfClause);
            hashtable.put(decoratedDatabaseTable, databaseTable);
        }
        this.setTableAliases(hashtable);
    }

    public void dontUseDistinct() {
        this.setDistinctState((short)2);
    }

    protected boolean fieldsContainField(Vector vector, Expression expression) {
        if (!(expression instanceof DataExpression)) {
            return false;
        }
        DatabaseField databaseField = ((DataExpression)expression).getField();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Cloneable cloneable;
            Cloneable cloneable2;
            Object e = enumeration.nextElement();
            if (e instanceof DatabaseField) {
                cloneable2 = (DatabaseField)e;
                cloneable = (DataExpression)expression;
                if (!((DatabaseField)cloneable2).equals(databaseField) || ((DataExpression)cloneable).getBaseExpression() != this.getBuilder()) continue;
                return true;
            }
            cloneable2 = (Expression)e;
            cloneable = databaseField.getTable();
            if (!((Expression)cloneable2).getFields().contains(databaseField) || !expression.aliasForTable((DatabaseTable)cloneable).equals(((Expression)cloneable2).aliasForTable((DatabaseTable)cloneable))) continue;
            return true;
        }
        return false;
    }

    public int getCurrentAliasNumber() {
        if (this.getParentStatement() != null) {
            return this.getParentStatement().getCurrentAliasNumber();
        }
        return this.currentAliasNumber;
    }

    public Vector getFields() {
        return this.fields;
    }

    protected ForUpdateClause getForUpdateClause() {
        return this.forUpdateClause;
    }

    public Vector getGroupByExpressions() {
        if (this.groupByExpressions == null) {
            this.groupByExpressions = NonSynchronizedVector.newInstance(3);
        }
        return this.groupByExpressions;
    }

    public Expression getStartWithExpression() {
        return this.startWithExpression;
    }

    public Expression getConnectByExpression() {
        return this.connectByExpression;
    }

    public Vector getOrderSiblingsByExpressions() {
        return this.orderSiblingsByExpressions;
    }

    public Vector getOrderByExpressions() {
        if (this.orderByExpressions == null) {
            this.orderByExpressions = NonSynchronizedVector.newInstance(3);
        }
        return this.orderByExpressions;
    }

    public Vector getOuterJoinedAdditionalJoinCriteria() {
        if (this.outerJoinedAdditionalJoinCriteria == null) {
            this.outerJoinedAdditionalJoinCriteria = NonSynchronizedVector.newInstance(3);
        }
        return this.outerJoinedAdditionalJoinCriteria;
    }

    public Vector getOuterJoinedMappingCriteria() {
        if (this.outerJoinedMappingCriteria == null) {
            this.outerJoinedMappingCriteria = NonSynchronizedVector.newInstance(3);
        }
        return this.outerJoinedMappingCriteria;
    }

    public Vector getOuterJoinExpressions() {
        if (this.outerJoinedExpressions == null) {
            this.outerJoinedExpressions = NonSynchronizedVector.newInstance(3);
        }
        return this.outerJoinedExpressions;
    }

    public SQLSelectStatement getParentStatement() {
        return this.parentStatement;
    }

    public Hashtable getTableAliases() {
        return this.tableAliases;
    }

    public Vector getTables() {
        return this.tables;
    }

    protected boolean hasAliasForTable(DatabaseTable databaseTable) {
        if (this.tableAliases != null) {
            return this.getTableAliases().containsKey(databaseTable);
        }
        return false;
    }

    public boolean hasGroupByExpressions() {
        return this.groupByExpressions != null && !this.groupByExpressions.isEmpty();
    }

    public boolean hasStartWithExpression() {
        return this.startWithExpression != null;
    }

    public boolean hasConnectByExpression() {
        return this.connectByExpression != null;
    }

    public boolean hasOrderSiblingsByExpressions() {
        return this.orderSiblingsByExpressions != null;
    }

    public boolean hasHierarchicalQueryExpressions() {
        return this.startWithExpression != null || this.connectByExpression != null || this.orderSiblingsByExpressions != null;
    }

    public boolean hasOrderByExpressions() {
        return this.orderByExpressions != null && !this.orderByExpressions.isEmpty();
    }

    public boolean hasOuterJoinedAdditionalJoinCriteria() {
        return this.outerJoinedAdditionalJoinCriteria != null && !this.outerJoinedAdditionalJoinCriteria.isEmpty();
    }

    public boolean hasOuterJoinExpressions() {
        return this.outerJoinedExpressions != null && !this.outerJoinedExpressions.isEmpty();
    }

    public boolean isAggregateSelect() {
        return this.isAggregateSelect;
    }

    public boolean isDistinctComputed() {
        return this.distinctState != 0;
    }

    public final void normalize(Session session, Descriptor descriptor) {
        this.normalize(session, descriptor, new IdentityHashtable());
    }

    public void normalize(Session session, Descriptor descriptor, Dictionary dictionary) {
        Expression expression;
        if (this.getBuilder() == null) {
            if (this.getWhereClause() == null) {
                this.setBuilder(new ExpressionBuilder());
            } else {
                this.setBuilder(this.getWhereClause().getBuilder());
            }
        }
        ExpressionBuilder expressionBuilder = this.getBuilder();
        if (session.getAsOfClause() != null && !this.isSubSelect()) {
            this.getWhereClause().asOf(session.getAsOfClause());
        } else if (expressionBuilder.hasAsOfClause() && expressionBuilder.getAsOfClause().isUniversal()) {
            this.getWhereClause().asOf(((UniversalAsOfClause)expressionBuilder.getAsOfClause()).getAsOfClause());
        }
        if (this.getWhereClause() == expressionBuilder) {
            this.setWhereClause(null);
        }
        expressionBuilder.setSession(session);
        if (!expressionBuilder.doesNotRepresentAnObjectInTheQuery() && descriptor != null && expressionBuilder.getQueryClass() == null) {
            expressionBuilder.setQueryClass(descriptor.getJavaClass());
        }
        Vector<Expression> vector = new Vector<Expression>();
        this.rebuildAndAddExpressions(this.getFields(), vector, expressionBuilder, dictionary);
        if (this.hasGroupByExpressions()) {
            this.rebuildAndAddExpressions(this.getGroupByExpressions(), vector, expressionBuilder, dictionary);
        }
        if (this.hasOrderByExpressions()) {
            this.rebuildAndAddExpressions(this.getOrderByExpressions(), vector, expressionBuilder, dictionary);
        }
        if (this.hasOuterJoinExpressions()) {
            this.rebuildAndAddExpressions(this.getOuterJoinedMappingCriteria(), vector, expressionBuilder, dictionary);
            this.rebuildAndAddExpressions(this.getOuterJoinedAdditionalJoinCriteria(), vector, expressionBuilder, dictionary);
        }
        if (this.hasStartWithExpression()) {
            this.startWithExpression = this.getStartWithExpression().rebuildOn(expressionBuilder);
            vector.addElement(this.startWithExpression);
        }
        if (this.hasConnectByExpression()) {
            this.connectByExpression = this.getConnectByExpression().rebuildOn(expressionBuilder);
        }
        if (this.hasOrderSiblingsByExpressions()) {
            this.rebuildAndAddExpressions(this.getOrderSiblingsByExpressions(), vector, expressionBuilder, dictionary);
        }
        Expression expression2 = this.getWhereClause();
        ExpressionNormalizer expressionNormalizer = new ExpressionNormalizer(this);
        expressionNormalizer.setSession(session);
        Expression expression3 = null;
        if (expression2 != null) {
            expression3 = expression2.normalize(expressionNormalizer);
        }
        if (descriptor != null) {
            expressionBuilder.normalize(expressionNormalizer);
        }
        for (int i = 0; i < vector.size(); ++i) {
            expression = (Expression)vector.elementAt(i);
            expression.normalize(expressionNormalizer);
        }
        if (expression3 == null) {
            this.setNormalizedWhereClause(expressionNormalizer.getAdditionalExpression());
        } else {
            this.setNormalizedWhereClause(expression3.and(expressionNormalizer.getAdditionalExpression()));
        }
        if (this.getWhereClause() != null) {
            vector.addElement(this.getWhereClause());
        }
        if (descriptor != null) {
            vector.addElement(expressionBuilder);
        }
        if (this.hasOuterJoinExpressions()) {
            Iterator iterator = this.getOuterJoinedMappingCriteria().iterator();
            while (iterator.hasNext()) {
                expression = (Expression)iterator.next();
                if (expression == null) continue;
                vector.add(expression);
            }
            iterator = this.getOuterJoinedAdditionalJoinCriteria().iterator();
            while (iterator.hasNext()) {
                expression = (Expression)iterator.next();
                if (expression == null) continue;
                vector.add(expression);
            }
        }
        this.assignAliases(vector);
        if (descriptor == null) {
            this.computeTablesFromTables();
        } else {
            this.computeTables();
        }
        if (expressionNormalizer.encounteredSubSelectExpressions()) {
            expressionNormalizer.normalizeSubSelects(dictionary);
        }
        Class clazz = null;
        if (descriptor != null) {
            clazz = descriptor.getJavaClass();
        }
        if (session.getPlatform(clazz).isInformix() || this.shouldDistinctBeUsed() && this.hasOrderByExpressions()) {
            this.addOrderByExpressionToSelectForDistinct();
        }
    }

    public void normalizeForView(Session session, Descriptor descriptor, Dictionary dictionary) {
        ExpressionBuilder expressionBuilder;
        this.setRequiresAliases(true);
        if (this.getWhereClause() != null) {
            expressionBuilder = this.getWhereClause().getBuilder();
        } else {
            expressionBuilder = new ExpressionBuilder();
            this.setBuilder(expressionBuilder);
        }
        expressionBuilder.setViewTable((DatabaseTable)this.getTables().firstElement());
        this.normalize(session, descriptor, dictionary);
    }

    public Vector printSQL(ExpressionSQLPrinter expressionSQLPrinter) {
        try {
            Vector vector = null;
            expressionSQLPrinter.setRequiresDistinct(this.shouldDistinctBeUsed());
            expressionSQLPrinter.printString("SELECT ");
            if (this.getHintString() != null) {
                expressionSQLPrinter.printString(this.getHintString());
                expressionSQLPrinter.printString(" ");
            }
            if (this.shouldDistinctBeUsed()) {
                expressionSQLPrinter.printString("DISTINCT ");
            }
            vector = this.writeFieldsIn(expressionSQLPrinter);
            this.appendFromClauseToWriter(expressionSQLPrinter);
            if (this.getWhereClause() != null) {
                expressionSQLPrinter.printString(" WHERE ");
                expressionSQLPrinter.printExpression(this.getWhereClause());
            }
            if (this.hasHierarchicalQueryExpressions()) {
                this.appendHierarchicalQueryClauseToWriter(expressionSQLPrinter);
            }
            if (this.hasGroupByExpressions()) {
                this.appendGroupByClauseToWriter(expressionSQLPrinter);
            }
            if (this.hasOrderByExpressions()) {
                this.appendOrderClauseToWriter(expressionSQLPrinter);
            }
            if (this.getForUpdateClause() != null) {
                this.getForUpdateClause().printSQL(expressionSQLPrinter, this);
            }
            return vector;
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    public void rebuildAndAddExpressions(Vector vector, Vector vector2, ExpressionBuilder expressionBuilder, Dictionary dictionary) {
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (!(e instanceof Expression)) continue;
            Expression expression = (Expression)e;
            ExpressionBuilder expressionBuilder2 = expression.getBuilder();
            if (expressionBuilder2 != expressionBuilder) {
                expression = dictionary.get(expressionBuilder2) != null ? expression.copiedVersionFrom(dictionary) : expression.rebuildOn(expressionBuilder);
                vector.setElementAt(expression, i);
            }
            vector2.addElement(expression);
        }
    }

    public void removeField(DatabaseField databaseField) {
        this.getFields().removeElement(databaseField);
    }

    public void removeTable(DatabaseTable databaseTable) {
        this.getTables().removeElement(databaseTable);
    }

    public boolean requiresAliases() {
        if (this.requiresAliases || this.hasOuterJoinExpressions()) {
            return true;
        }
        if (this.tableAliases != null) {
            return this.getTableAliases().size() > 1;
        }
        return false;
    }

    public void resetDistinct() {
        this.setDistinctState((short)0);
    }

    public void setCurrentAliasNumber(int n) {
        if (this.getParentStatement() != null) {
            this.getParentStatement().setCurrentAliasNumber(n);
        } else {
            this.currentAliasNumber = n;
        }
    }

    public void setNormalizedWhereClause(Expression expression) {
        this.whereClause = expression;
    }

    public void setDistinctState(short s) {
        this.distinctState = s;
    }

    public void setFields(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof FunctionExpression) || !((FunctionExpression)e).getOperator().isAggregateOperator()) continue;
            this.setIsAggregateSelect(true);
            break;
        }
        this.fields = vector;
    }

    public void setGroupByExpressions(Vector vector) {
        this.groupByExpressions = vector;
    }

    public void setHierarchicalQueryExpressions(Expression expression, Expression expression2, Vector vector) {
        this.startWithExpression = expression;
        this.connectByExpression = expression2;
        this.orderSiblingsByExpressions = vector;
    }

    public void setIsAggregateSelect(boolean bl) {
        this.isAggregateSelect = bl;
    }

    protected void setForUpdateClause(ForUpdateClause forUpdateClause) {
        this.forUpdateClause = forUpdateClause;
    }

    public void setLockingClause(ForUpdateClause forUpdateClause) {
        this.forUpdateClause = forUpdateClause;
    }

    public void setOrderByExpressions(Vector vector) {
        this.orderByExpressions = vector;
    }

    public void setOuterJoinedAdditionalJoinCriteria(Vector vector) {
        this.outerJoinedAdditionalJoinCriteria = vector;
    }

    public void setOuterJoinedMappingCriteria(Vector vector) {
        this.outerJoinedMappingCriteria = vector;
    }

    public void setOuterJoinExpressions(Vector vector) {
        this.outerJoinedExpressions = vector;
    }

    public void setParentStatement(SQLSelectStatement sQLSelectStatement) {
        this.parentStatement = sQLSelectStatement;
    }

    public void setRequiresAliases(boolean bl) {
        this.requiresAliases = bl;
    }

    protected void setTableAliases(Hashtable hashtable) {
        this.tableAliases = hashtable;
    }

    public void setTables(Vector vector) {
        this.tables = vector;
    }

    public boolean shouldDistinctBeUsed() {
        return this.distinctState == 1;
    }

    public void useDistinct() {
        this.setDistinctState((short)1);
    }

    protected void writeField(ExpressionSQLPrinter expressionSQLPrinter, DatabaseField databaseField) {
        if (expressionSQLPrinter.isFirstElementPrinted()) {
            expressionSQLPrinter.printString(", ");
        } else {
            expressionSQLPrinter.setIsFirstElementPrinted(true);
        }
        if (expressionSQLPrinter.shouldPrintQualifiedNames()) {
            if (databaseField.getTable() != this.lastTable) {
                this.lastTable = databaseField.getTable();
                this.currentAlias = this.getBuilder().aliasForTable(this.lastTable);
                if (this.currentAlias == null) {
                    this.currentAlias = this.lastTable;
                }
            }
            expressionSQLPrinter.printString(this.currentAlias.getQualifiedName());
            expressionSQLPrinter.printString(".");
            expressionSQLPrinter.printString(databaseField.getName());
        } else {
            expressionSQLPrinter.printString(databaseField.getName());
        }
    }

    protected void writeFieldsFromExpression(ExpressionSQLPrinter expressionSQLPrinter, Expression expression, Vector vector) {
        expression.writeFields(expressionSQLPrinter, vector, this);
    }

    protected Vector writeFieldsIn(ExpressionSQLPrinter expressionSQLPrinter) {
        this.lastTable = null;
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
        Enumeration enumeration = this.getFields().elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e == null) continue;
            if (e instanceof Expression) {
                this.writeFieldsFromExpression(expressionSQLPrinter, (Expression)e, nonSynchronizedVector);
                continue;
            }
            this.writeField(expressionSQLPrinter, (DatabaseField)e);
            ((Vector)nonSynchronizedVector).addElement(e);
        }
        return nonSynchronizedVector;
    }
}

