/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Dictionary;
import oracle.toplink.expressions.Expression;
import oracle.toplink.expressions.ExpressionBuilder;
import oracle.toplink.internal.expressions.ExpressionSQLPrinter;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.InMemoryQueryIndirectionPolicy;

public class LiteralExpression
extends Expression {
    protected String value;
    protected Expression localBase;

    public LiteralExpression() {
    }

    public LiteralExpression(String string, Expression expression) {
        this.value = string;
        this.localBase = expression;
    }

    public String descriptionOfNodeType() {
        return "Literal";
    }

    public ExpressionBuilder getBuilder() {
        return this.getLocalBase().getBuilder();
    }

    protected Expression getLocalBase() {
        return this.localBase;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isLiteralExpression() {
        return true;
    }

    protected void postCopyIn(Dictionary dictionary) {
        super.postCopyIn(dictionary);
        this.localBase = this.localBase.copiedVersionFrom(dictionary);
    }

    public void printSQL(ExpressionSQLPrinter expressionSQLPrinter) {
        expressionSQLPrinter.printString(this.value);
    }

    public void printSQLWithoutConversion(ExpressionSQLPrinter expressionSQLPrinter) {
        this.printSQL(expressionSQLPrinter);
    }

    public Expression rebuildOn(Expression expression) {
        LiteralExpression literalExpression = (LiteralExpression)this.clone();
        ((Expression)literalExpression).setLocalBase(this.getLocalBase().rebuildOn(expression));
        return literalExpression;
    }

    public void setLocalBase(Expression expression) {
        this.localBase = expression;
    }

    public Expression twistedForBaseAndContext(Expression expression, Expression expression2) {
        return (Expression)this.clone();
    }

    public Object valueFromObject(Object object, Session session, DatabaseRow databaseRow, InMemoryQueryIndirectionPolicy inMemoryQueryIndirectionPolicy, boolean bl) {
        return this.getLocalBase().getFieldValue(this.getValue());
    }

    public void writeDescriptionOn(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write(this.getValue().toString());
    }
}

