/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.ejb.cmp3.base;

import java.util.Vector;
import oracle.toplink.expressions.Expression;
import oracle.toplink.internal.ejb.cmp3.base.CMP3Policy;
import oracle.toplink.internal.ejb.cmp3.base.RepeatableWriteUnitOfWork;
import oracle.toplink.internal.ejb.cmp3.transaction.base.TransactionWrapperImpl;
import oracle.toplink.internal.helper.IdentityHashtable;
import oracle.toplink.internal.localization.ExceptionLocalization;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ReadAllQuery;
import oracle.toplink.queryframework.ReadObjectQuery;
import oracle.toplink.threetier.ServerSession;
import oracle.toplink.tools.sessionmanagement.SessionManager;

public abstract class EntityManagerImpl {
    protected TransactionWrapperImpl transaction = null;
    protected boolean isOpen = true;
    protected ServerSession serverSession;

    protected abstract void setJTATransactionWrapper();

    protected abstract void setEntityTransactionWrapper();

    public EntityManagerImpl(String string) {
        this.serverSession = (ServerSession)SessionManager.getManager().getSession(string);
        this.detectTransactionWrapper();
    }

    public EntityManagerImpl(ServerSession serverSession) {
        this.serverSession = serverSession;
        this.detectTransactionWrapper();
    }

    public void persist(Object object) {
        this.verifyOpen();
        this.getActiveUnitOfWork().registerNewObjectForPersist(object, new IdentityHashtable());
    }

    protected Object mergeInternal(Object object) {
        this.verifyOpen();
        return this.getActiveUnitOfWork().mergeCloneWithReferences(object, 4);
    }

    public void remove(Object object) {
        this.verifyOpen();
        this.getActiveUnitOfWork().performRemove(object, new IdentityHashtable());
    }

    public Object find(String string, Object object) {
        this.verifyOpen();
        oracle.toplink.sessions.Session session = this.getActiveSession();
        Descriptor descriptor = session.getDescriptorForAlias(string);
        if (descriptor == null || descriptor.isAggregateDescriptor() || descriptor.isAggregateCollectionDescriptor()) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("unknown_entitybean_name", new Object[]{string}));
        }
        return EntityManagerImpl.findInternal(descriptor, session, object);
    }

    protected Object findInternal(Class clazz, Object object) {
        this.verifyOpen();
        oracle.toplink.sessions.Session session = this.getActiveSession();
        Descriptor descriptor = session.getDescriptor(clazz);
        if (descriptor == null || descriptor.isAggregateDescriptor() || descriptor.isAggregateCollectionDescriptor()) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("unknown_bean_class", new Object[]{clazz}));
        }
        return EntityManagerImpl.findInternal(descriptor, session, object);
    }

    protected static Object findInternal(Descriptor descriptor, oracle.toplink.sessions.Session session, Object object) {
        Vector vector = object instanceof Vector ? (Vector)object : ((CMP3Policy)descriptor.getCMPPolicy()).createPkVectorFromKey(object, (Session)session);
        ReadObjectQuery readObjectQuery = new ReadObjectQuery(descriptor.getJavaClass());
        readObjectQuery.setSelectionKey(vector);
        readObjectQuery.conformResultsInUnitOfWork();
        return session.executeQuery(readObjectQuery);
    }

    public void flush() {
        this.verifyOpen();
        this.getActiveUnitOfWork().writeChanges();
    }

    protected void detectTransactionWrapper() {
        if (this.serverSession.hasExternalTransactionController()) {
            this.setJTATransactionWrapper();
        } else {
            this.setEntityTransactionWrapper();
        }
    }

    public void refresh(Object object) {
        this.verifyOpen();
        RepeatableWriteUnitOfWork repeatableWriteUnitOfWork = this.getActiveUnitOfWork();
        Descriptor descriptor = (Descriptor)repeatableWriteUnitOfWork.getDescriptors().get(object.getClass());
        if (descriptor == null || descriptor.isAggregateDescriptor() || descriptor.isAggregateCollectionDescriptor()) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("not_an_entity", new Object[]{object}));
        }
        ReadObjectQuery readObjectQuery = new ReadObjectQuery();
        readObjectQuery.setSelectionObject(object);
        readObjectQuery.refreshIdentityMapResult();
        readObjectQuery.cascadeByMapping();
        readObjectQuery.setLockMode((short)0);
        repeatableWriteUnitOfWork.executeQuery(readObjectQuery);
    }

    public boolean contains(Object object) {
        this.verifyOpen();
        RepeatableWriteUnitOfWork repeatableWriteUnitOfWork = this.getActiveUnitOfWork();
        Descriptor descriptor = (Descriptor)repeatableWriteUnitOfWork.getDescriptors().get(object.getClass());
        if (descriptor == null || descriptor.isAggregateDescriptor() || descriptor.isAggregateCollectionDescriptor()) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("not_an_entity", new Object[]{object}));
        }
        return ((UnitOfWork)repeatableWriteUnitOfWork).isObjectRegistered(object);
    }

    public oracle.toplink.sessions.Session getActiveSession() {
        Object object = this.checkForTransaction(false);
        if (object == null) {
            return this.serverSession.acquireClientSession().acquireNonSynchronizedUnitOfWork();
        }
        return this.getActiveUnitOfWork(object);
    }

    public oracle.toplink.sessions.UnitOfWork getUnitOfWork() {
        return this.getActiveUnitOfWork(this.checkForTransaction(false));
    }

    public oracle.toplink.sessions.Session getSession() {
        if (this.checkForTransaction(false) == null) {
            return this.serverSession.acquireNonSynchronizedUnitOfWork();
        }
        return null;
    }

    public ServerSession getServerSession() {
        return this.serverSession;
    }

    protected DatabaseQuery createNativeQueryInternal(String string, Class clazz) {
        this.verifyOpen();
        ReadAllQuery readAllQuery = new ReadAllQuery(clazz);
        readAllQuery.setSQLString(string);
        return readAllQuery;
    }

    protected DatabaseQuery createQueryInternal(Expression expression, Class clazz) {
        ReadAllQuery readAllQuery = new ReadAllQuery(clazz);
        readAllQuery.setSelectionCriteria(expression);
        return readAllQuery;
    }

    public void close() {
        if (!this.transaction.shouldClose()) {
            throw new IllegalStateException("Attempting to close an EntityManager with a transaction state other than NO_TRANSACTION, COMMITTED, or ROLLEDBACK.");
        }
        this.isOpen = false;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void verifyOpen() {
        if (!this.isOpen) {
            throw new IllegalStateException("Attempting to execute an operation on a closed EntityManager.");
        }
    }

    protected RepeatableWriteUnitOfWork getActiveUnitOfWork() {
        Object object = this.checkForTransaction(true);
        return this.getActiveUnitOfWork(object);
    }

    protected RepeatableWriteUnitOfWork getActiveUnitOfWork(Object object) {
        return this.transaction.getActiveUnitOfWork(object);
    }

    protected Object checkForTransaction(boolean bl) {
        return this.transaction.checkForTransaction(bl);
    }
}

