/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.ejb.cmp.finders;

import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import oracle.toplink.exceptions.TopLinkException;
import oracle.toplink.internal.ejb.cmp.EJBExceptionFactory;
import oracle.toplink.internal.ejb.cmp.finders.Finder;
import oracle.toplink.internal.ejb.cmp.finders.FinderManager;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ReadObjectQuery;

public class FindByPrimaryKey
extends Finder {
    public static final String FIND_BY_PRIMARY_KEY = "findByPrimaryKey";

    public FindByPrimaryKey(DatabaseQuery databaseQuery, FinderManager finderManager) {
        super(databaseQuery, finderManager);
    }

    public Object executeFindByPk(boolean bl, Object object, boolean bl2) throws ObjectNotFoundException, FinderException {
        if (object == null) {
            EJBException eJBException = EJBExceptionFactory.findWithNullPK(this.getBeanName());
            this.getSession().logThrowable(6, "ejb", eJBException);
            throw eJBException;
        }
        try {
            return this.internalExecute(bl, object, null, bl2);
        }
        catch (Error error) {
            this.getSession().log(6, "ejb", "an_error_occured_executing_findByPrimaryKey", object);
            this.getSession().logThrowable(6, "ejb", error);
            throw error;
        }
        catch (TopLinkException topLinkException) {
            this.getSession().logThrowable(6, "ejb", topLinkException);
            throw (FinderException)new FinderException().initCause((Throwable)topLinkException);
        }
        catch (RuntimeException runtimeException) {
            EJBException eJBException = EJBExceptionFactory.errorDuringFind(FIND_BY_PRIMARY_KEY, this.getBeanName(), runtimeException);
            this.getSession().logThrowable(6, "ejb", eJBException);
            throw eJBException;
        }
    }

    public Object execute(boolean bl, Object object, boolean bl2) throws ObjectNotFoundException, FinderException {
        throw new UnsupportedOperationException("Developer error - Can only be called for regular Finder");
    }

    protected void prepareArgs() {
        this.args = this.getFinderManager().getEJBFactory().createPkVectorFromKey(this.getInputParams());
    }

    protected boolean checkEarlyReturn() {
        if (!this.getSession().isUnitOfWork()) {
            return false;
        }
        UnitOfWork unitOfWork = (UnitOfWork)this.getSession();
        Object object = unitOfWork.getIdentityMapAccessorInstance().getIdentityMapManager().getFromIdentityMap(this.getArgs(), this.getFinderManager().getDescriptor().getJavaClass(), this.getFinderManager().getDescriptor());
        if (object == null) {
            return false;
        }
        if (unitOfWork.isPessimisticLocked(object)) {
            if (unitOfWork.getDeletedObjects().get(object) == null) {
                this.result = object;
            }
            return true;
        }
        if (this.hasLockQuery()) {
            if (unitOfWork.isObjectNew(object)) {
                this.result = object;
                return true;
            }
        } else if (this.isSystemLookupQuery()) {
            if (unitOfWork.getDeletedObjects().get(object) == null) {
                this.result = object;
            }
            return true;
        }
        return false;
    }

    protected boolean isSystemLookupQuery() {
        return false;
    }

    protected boolean shouldCloneQuery() {
        return true;
    }

    protected void prepareQuery(boolean bl) {
        super.prepareQuery(bl);
        ((ReadObjectQuery)this.getQuery()).setSelectionKey(this.getArgs());
    }

    protected void executeQuery() {
        this.result = this.getSession().executeQuery(this.getQuery());
    }
}

