/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.ejb.cmp.api.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.toplink.ejb.DeploymentException;
import oracle.toplink.internal.ejb.cmp.CmpHelper;
import oracle.toplink.internal.ejb.cmp.api.CmpField;
import oracle.toplink.internal.ejb.cmp.api.CmrField;
import oracle.toplink.internal.ejb.cmp.api.EntityDescriptor;
import oracle.toplink.internal.ejb.cmp.api.FinderDescriptor;
import oracle.toplink.internal.ejb.cmp.api.RelationshipDescriptor;
import oracle.toplink.internal.ejb.cmp.api.RelationshipRoleDescriptor;
import oracle.toplink.internal.ejb.cmp.api.impl.CmpFieldImpl;
import oracle.toplink.internal.ejb.cmp.api.impl.CmrFieldImpl;
import oracle.toplink.internal.ejb.cmp.api.impl.EntityDescriptorImpl;
import oracle.toplink.internal.ejb.cmp.api.impl.FinderDescriptorImpl;
import oracle.toplink.internal.ejb.cmp.api.impl.RelationshipDescriptorImpl;
import oracle.toplink.internal.ejb.cmp.api.impl.RelationshipRoleDescriptorImpl;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.ConversionManager;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.logging.AbstractSessionLog;

public abstract class DescriptorBuilder {
    protected Map oldDescriptors;
    protected ConversionManager conversionManager;
    protected Map tlEntityDescriptors = new HashMap();
    public boolean shouldUseRemoteRelationships = false;

    protected DescriptorBuilder() {
    }

    protected DescriptorBuilder(ConversionManager conversionManager) {
        this.conversionManager = conversionManager;
    }

    protected DescriptorBuilder(ConversionManager conversionManager, boolean bl) {
        this.conversionManager = conversionManager;
        this.shouldUseRemoteRelationships = bl;
    }

    public void setConversionManager(ConversionManager conversionManager) {
        this.conversionManager = conversionManager;
    }

    protected abstract String getBeanName(Object var1);

    protected abstract EntityDescriptor buildShallowDescriptor(String var1);

    protected abstract void buildDescriptorPostCodeGen(Object var1);

    protected abstract String getPrimaryKeyFieldName(Object var1);

    protected abstract Collection getCmpFieldNames(Object var1);

    protected abstract Collection getOldFinders(Object var1);

    protected abstract FinderDescriptor buildFinderDescriptor(Object var1, EntityDescriptor var2);

    protected abstract Collection buildRelationships(Object var1);

    public Map getEntityDescriptors() {
        return this.tlEntityDescriptors;
    }

    public EntityDescriptor getEntityDescriptor(String string) {
        return (EntityDescriptor)this.getEntityDescriptors().get(string);
    }

    protected void buildEntityDescriptors() {
        Iterator iterator = this.getOldDescriptors().values().iterator();
        while (iterator.hasNext()) {
            this.buildDescriptor(iterator.next());
        }
    }

    protected void buildEntityDescriptorsPostCodeGen() {
        Iterator iterator = this.getOldDescriptors().values().iterator();
        while (iterator.hasNext()) {
            this.buildDescriptorPostCodeGen(iterator.next());
        }
    }

    protected EntityDescriptor privateGetEntityDescriptor(String string) {
        EntityDescriptor entityDescriptor = (EntityDescriptor)this.getEntityDescriptors().get(string);
        if (entityDescriptor == null) {
            entityDescriptor = this.buildShallowDescriptor(string);
            this.getEntityDescriptors().put(string, entityDescriptor);
        }
        return entityDescriptor;
    }

    protected void buildDescriptor(Object object) {
        EntityDescriptorImpl entityDescriptorImpl = (EntityDescriptorImpl)this.privateGetEntityDescriptor(this.getBeanName(object));
        entityDescriptorImpl.descriptors = this.getEntityDescriptors();
        entityDescriptorImpl.builder = this;
        entityDescriptorImpl.pkField = this.buildPrimaryKeyField(object, entityDescriptorImpl);
        entityDescriptorImpl.cmpFields = this.buildCmpFields(object, entityDescriptorImpl);
        entityDescriptorImpl.finders = this.buildFinders(object, entityDescriptorImpl);
        entityDescriptorImpl.relationships = this.buildRelationships(object);
    }

    private CmpField buildPrimaryKeyField(Object object, EntityDescriptor entityDescriptor) {
        String string = this.getPrimaryKeyFieldName(object);
        if (string == null) {
            return null;
        }
        return this.buildCmpField(string, entityDescriptor);
    }

    private Map buildCmpFields(Object object, EntityDescriptor entityDescriptor) {
        Collection collection = this.getCmpFieldNames(object);
        HashMap<String, CmpField> hashMap = new HashMap<String, CmpField>(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                hashMap.put(string, this.buildCmpField(string, entityDescriptor));
            }
            catch (DeploymentException deploymentException) {
                if (deploymentException.getErrorCode() == 14031 || deploymentException.getErrorCode() == 14032) {
                    AbstractSessionLog.getLog().logThrowable(6, deploymentException);
                    continue;
                }
                throw deploymentException;
            }
        }
        return hashMap;
    }

    protected CmpField buildCmpField(String string, EntityDescriptor entityDescriptor) {
        return DescriptorBuilder.buildCmpField(string, CmpHelper.getCmpFieldType(string, entityDescriptor), entityDescriptor);
    }

    public static CmpField buildCmpField(String string, Class clazz, EntityDescriptor entityDescriptor) {
        return new CmpFieldImpl(string, clazz, entityDescriptor);
    }

    public CmrField buildCmrField(String string, Class clazz, EntityDescriptor entityDescriptor, RelationshipRoleDescriptor relationshipRoleDescriptor, boolean bl) {
        CmrFieldImpl cmrFieldImpl = new CmrFieldImpl(string, clazz, entityDescriptor, relationshipRoleDescriptor, bl);
        ((EntityDescriptorImpl)entityDescriptor).cmrFields.put(string, cmrFieldImpl);
        return cmrFieldImpl;
    }

    protected RelationshipDescriptor buildRelationshipDescriptor(String string, String string2, boolean bl, boolean bl2, String string3, String string4, boolean bl3, boolean bl4) {
        Class clazz = null;
        Class clazz2 = null;
        boolean bl5 = false;
        boolean bl6 = false;
        EntityDescriptor entityDescriptor = this.privateGetEntityDescriptor(string);
        EntityDescriptor entityDescriptor2 = this.privateGetEntityDescriptor(string3);
        if (string2 == null) {
            bl5 = true;
            clazz = this.getSyntheticFieldType(entityDescriptor2, bl3);
            string2 = this.getSyntheticFieldName(string3, string4);
        } else {
            clazz = CmpHelper.getCmpFieldType(string2, entityDescriptor);
        }
        if (string4 == null) {
            bl6 = true;
            clazz2 = this.getSyntheticFieldType(entityDescriptor, bl);
            string4 = this.getSyntheticFieldName(string, string2);
        } else {
            clazz2 = CmpHelper.getCmpFieldType(string4, entityDescriptor2);
        }
        RelationshipRoleDescriptor relationshipRoleDescriptor = this.buildRelationshipRoleDescriptor(entityDescriptor, string2, clazz, bl, bl2, bl5);
        RelationshipRoleDescriptor relationshipRoleDescriptor2 = this.buildRelationshipRoleDescriptor(entityDescriptor2, string4, clazz2, bl3, bl4, bl6);
        ((RelationshipRoleDescriptorImpl)relationshipRoleDescriptor2).partnerRole = relationshipRoleDescriptor;
        ((RelationshipRoleDescriptorImpl)relationshipRoleDescriptor).partnerRole = relationshipRoleDescriptor2;
        return new RelationshipDescriptorImpl(relationshipRoleDescriptor, relationshipRoleDescriptor2);
    }

    protected Class getSyntheticFieldType(EntityDescriptor entityDescriptor, boolean bl) {
        if (bl) {
            return ClassConstants.Collection_Class;
        }
        if (entityDescriptor.getLocalInterfaceClass() != null && !this.shouldUseRemoteRelationships) {
            return entityDescriptor.getLocalInterfaceClass();
        }
        return entityDescriptor.getRemoteInterfaceClass();
    }

    protected String getSyntheticFieldName(String string, String string2) {
        return string + "_" + string2;
    }

    protected RelationshipRoleDescriptor buildRelationshipRoleDescriptor(EntityDescriptor entityDescriptor, String string, Class clazz, boolean bl, boolean bl2, boolean bl3) {
        RelationshipRoleDescriptorImpl relationshipRoleDescriptorImpl = new RelationshipRoleDescriptorImpl();
        relationshipRoleDescriptorImpl.cmrField = this.buildCmrField(string, clazz, entityDescriptor, relationshipRoleDescriptorImpl, bl3);
        relationshipRoleDescriptorImpl.isMany = bl;
        relationshipRoleDescriptorImpl.isCascadeDelete = bl2;
        return relationshipRoleDescriptorImpl;
    }

    protected Collection buildFinders(Object object, EntityDescriptor entityDescriptor) {
        ArrayList arrayList = this.getOldFinders(object);
        if (arrayList == null) {
            arrayList = new ArrayList(1);
        }
        ArrayList<FinderDescriptor> arrayList2 = new ArrayList<FinderDescriptor>(arrayList.size() + 1);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            try {
                FinderDescriptor finderDescriptor = this.buildFinderDescriptor(iterator.next(), entityDescriptor);
                if (finderDescriptor.getMethodName().equals("findByPrimaryKey")) continue;
                arrayList2.add(finderDescriptor);
            }
            catch (DeploymentException deploymentException) {
                if (deploymentException.getErrorCode() == 14029 || deploymentException.getErrorCode() == 14030) {
                    AbstractSessionLog.getLog().logThrowable(6, deploymentException);
                    continue;
                }
                throw deploymentException;
            }
        }
        arrayList2.add(this.buildFindByPkDescriptor(entityDescriptor));
        return arrayList2;
    }

    private FinderDescriptor buildFindByPkDescriptor(EntityDescriptor entityDescriptor) {
        ArrayList<Class> arrayList = new ArrayList<Class>(1);
        arrayList.add(entityDescriptor.getPrimaryKeyClass());
        return DescriptorBuilder.buildFinderDescriptor("findByPrimaryKey", arrayList, entityDescriptor.getPrimaryKeyClass());
    }

    protected Class getFinderReturnType(EntityDescriptor entityDescriptor, FinderDescriptor finderDescriptor) {
        Class[] classArray;
        Class clazz;
        block9: {
            clazz = null;
            classArray = finderDescriptor.getMethodParams().toArray(new Class[finderDescriptor.getMethodParams().size()]);
            if (finderDescriptor.isEjbSelect()) {
                try {
                    clazz = this.getMethodReturnType(finderDescriptor.getMethodName(), classArray, entityDescriptor.getBeanClass());
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw DeploymentException.missingEjbSelectDefinition(finderDescriptor.getMethodName() + finderDescriptor.getMethodParams(), entityDescriptor.getBeanName());
                }
            }
            try {
                if (entityDescriptor.getHomeInterfaceClass() != null) {
                    clazz = this.getMethodReturnType(finderDescriptor.getMethodName(), classArray, entityDescriptor.getHomeInterfaceClass());
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (entityDescriptor.getLocalHomeInterfaceClass() != null) break block9;
                throw DeploymentException.missingFinderDefinition(finderDescriptor.getMethodName() + finderDescriptor.getMethodParams(), entityDescriptor.getBeanName());
            }
        }
        if (clazz == null) {
            try {
                clazz = this.getMethodReturnType(finderDescriptor.getMethodName(), classArray, entityDescriptor.getLocalHomeInterfaceClass());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw DeploymentException.missingFinderDefinition(finderDescriptor.getMethodName() + finderDescriptor.getMethodParams(), entityDescriptor.getBeanName());
            }
        }
        return clazz;
    }

    public Class getMethodReturnType(String string, Class[] classArray, Class clazz) throws NoSuchMethodException {
        return PrivilegedAccessController.getMethodReturnType(PrivilegedAccessController.getMethod(clazz, string, classArray, false));
    }

    protected Map getOldDescriptors() {
        return this.oldDescriptors;
    }

    public static FinderDescriptor buildFinderDescriptor(String string, List list, Class clazz) {
        FinderDescriptorImpl finderDescriptorImpl = new FinderDescriptorImpl();
        finderDescriptorImpl.methodName = string;
        finderDescriptorImpl.params = list;
        finderDescriptorImpl.returnType = clazz;
        return finderDescriptorImpl;
    }
}

