/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.ejb.cmp;

import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Vector;
import javax.ejb.EntityBean;
import oracle.toplink.descriptors.CMPPolicy;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.exceptions.OptimisticLockException;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.internal.descriptors.ObjectBuilder;
import oracle.toplink.internal.helper.IdentityHashtable;
import oracle.toplink.internal.identitymaps.CacheKey;
import oracle.toplink.internal.sessions.ObjectChangeSet;
import oracle.toplink.internal.sessions.UnitOfWorkChangeSet;
import oracle.toplink.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.DeleteObjectQuery;

public class NonDeferredUnitOfWork
extends UnitOfWorkImpl {
    protected LinkedList trackedObjects;
    protected IdentityHashtable nonTrackedObjects;
    protected IdentityHashtable deferredObjects;
    protected IdentityHashtable deferredDeletes;
    protected UnitOfWorkChangeSet cumulativeUOWChangeSet = new UnitOfWorkChangeSet();

    public NonDeferredUnitOfWork(Session session) {
        super(session);
        this.registerWithTransactionIfRequired();
    }

    public Object cloneAndRegisterObject(Object object, CacheKey cacheKey, CacheKey cacheKey2, Descriptor descriptor) {
        if (this.getTrackedObjects().isEmpty()) {
            this.incrementCallStackDepth();
        }
        Object object2 = super.cloneAndRegisterObject(object, cacheKey, cacheKey2, descriptor);
        this.markObjectForUpdate(object2, descriptor);
        return object2;
    }

    public void commit() {
        Enumeration enumeration = this.getDeferredDeletes().keys();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            this.getDeletedObjects().put(e, e);
        }
        this.getDeferredDeletes().clear();
        super.commit();
    }

    public void commitRootUnitOfWork() throws DatabaseException, OptimisticLockException {
        if (this.usesOldCommit()) {
            this.commitToDatabaseOldCommit(true);
        } else {
            this.commitToDatabaseWithChangeSet(false);
            this.cumulativeUOWChangeSet.mergeUnitOfWorkChangeSet((UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet(), this, true);
            this.setUnitOfWorkChangeSet(this.cumulativeUOWChangeSet);
        }
        this.commitTransactionAfterWriteChanges();
        this.mergeChangesIntoParent();
    }

    public IdentityHashtable collectAndPrepareObjectsForCommit() {
        Object e;
        IdentityHashtable identityHashtable = new IdentityHashtable(1 + this.getDeferredObjects().size());
        IdentityHashtable identityHashtable2 = new IdentityHashtable();
        IdentityHashtable identityHashtable3 = new IdentityHashtable();
        IdentityHashtable identityHashtable4 = new IdentityHashtable();
        Enumeration enumeration = this.getDeferredObjects().keys();
        while (enumeration.hasMoreElements()) {
            e = enumeration.nextElement();
            this.discoverUnregisteredNewObjects(e, identityHashtable3, identityHashtable4, identityHashtable2);
            if (this.isCloneNewObject(e)) {
                this.assignSequenceNumber(e);
            }
            identityHashtable.put(e, e);
        }
        enumeration = identityHashtable3.keys();
        while (enumeration.hasMoreElements()) {
            e = enumeration.nextElement();
            this.assignSequenceNumber(e);
            identityHashtable.put(e, e);
        }
        return identityHashtable;
    }

    protected IdentityHashtable getDeferredDeletes() {
        if (this.deferredDeletes == null) {
            this.deferredDeletes = new IdentityHashtable();
        }
        return this.deferredDeletes;
    }

    protected IdentityHashtable getDeferredObjects() {
        if (this.deferredObjects == null) {
            this.deferredObjects = new IdentityHashtable();
        }
        return this.deferredObjects;
    }

    protected IdentityHashtable getNonTrackedObjects() {
        if (this.nonTrackedObjects == null) {
            this.nonTrackedObjects = new IdentityHashtable();
        }
        return this.nonTrackedObjects;
    }

    protected LinkedList getTrackedObjects() {
        if (this.trackedObjects == null) {
            this.trackedObjects = new LinkedList();
        }
        return this.trackedObjects;
    }

    public void incrementCallStackDepth() {
        this.getTrackedObjects().addFirst(new IdentityHashtable());
    }

    public void issueSQLbeforeCompletion() {
        Enumeration enumeration = this.getDeferredDeletes().elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            this.getDeletedObjects().put(e, e);
        }
        this.getDeferredDeletes().clear();
        super.issueSQLbeforeCompletion(false);
        if (this.getUnitOfWorkChangeSet() != null) {
            this.cumulativeUOWChangeSet.mergeUnitOfWorkChangeSet((UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet(), this, true);
            this.setUnitOfWorkChangeSet(this.cumulativeUOWChangeSet);
        }
        this.commitTransactionAfterWriteChanges();
    }

    public void markObjectForUpdate(Object object, Descriptor descriptor) {
        CMPPolicy cMPPolicy;
        if (this.getTrackedObjects().isEmpty()) {
            this.incrementCallStackDepth();
        }
        if (descriptor == null) {
            descriptor = this.getDescriptor(object);
        }
        if ((cMPPolicy = descriptor.getCMPPolicy()) != null) {
            if (cMPPolicy.getDeferModificationsUntilCommit() == 2) {
                this.getDeferredObjects().put(object, object);
            } else if (cMPPolicy.getDeferModificationsUntilCommit() == 1) {
                if (!this.isObjectNew(object)) {
                    this.getDeferredObjects().put(object, object);
                } else if (object instanceof EntityBean) {
                    ((IdentityHashtable)this.getTrackedObjects().getFirst()).put(object, object);
                } else {
                    this.getNonTrackedObjects().put(object, object);
                }
            } else if (object instanceof EntityBean) {
                ((IdentityHashtable)this.getTrackedObjects().getFirst()).put(object, object);
            } else {
                this.getNonTrackedObjects().put(object, object);
            }
        } else {
            this.getDeferredObjects().put(object, object);
        }
    }

    public Object processDeleteObjectQuery(DeleteObjectQuery deleteObjectQuery) {
        if (deleteObjectQuery.getObject() == null) {
            throw QueryException.objectToModifyNotSpecified(deleteObjectQuery);
        }
        Descriptor descriptor = this.getDescriptor(deleteObjectQuery.getObject());
        ObjectBuilder objectBuilder = descriptor.getObjectBuilder();
        Object object = objectBuilder.unwrapObject(deleteObjectQuery.getObject(), this);
        if (this.isClassReadOnly(object.getClass())) {
            throw QueryException.cannotDeleteReadOnlyObject(object);
        }
        if (this.isCloneNewObject(object)) {
            this.unregisterObject(object);
            return object;
        }
        Vector vector = objectBuilder.extractPrimaryKeyFromObject(object, this);
        Object object2 = this.getFromIdentityMap(vector, object.getClass());
        if (object2 == null) {
            object2 = object;
        }
        object2 = objectBuilder.unwrapObject(object2, this);
        deleteObjectQuery.setObject(object2);
        if (!this.getCommitManager().isActive()) {
            if (descriptor.getCMPPolicy() != null && descriptor.getCMPPolicy().getDeferModificationsUntilCommit() != 2) {
                this.getDeletedObjects().put(object2, vector);
            } else {
                this.getDeferredDeletes().put(object2, object2);
            }
            return object2;
        }
        return null;
    }

    public synchronized Object registerObject(Object object) {
        Descriptor descriptor;
        if (object == null) {
            return null;
        }
        if (this.getTrackedObjects().isEmpty()) {
            this.incrementCallStackDepth();
        }
        if ((descriptor = this.getDescriptor(object)) == null) {
            throw DescriptorException.missingDescriptor(object.getClass().toString());
        }
        ObjectBuilder objectBuilder = descriptor.getObjectBuilder();
        Object object2 = objectBuilder.unwrapObject(object, this);
        boolean bl = object2 != object;
        Object object3 = this.registerObject(object2, descriptor);
        this.markObjectForUpdate(object3, descriptor);
        if (bl) {
            return objectBuilder.wrapObject(object3, this);
        }
        return object3;
    }

    public synchronized Object registerExistingObject(Object object) {
        Descriptor descriptor;
        if (object == null) {
            return null;
        }
        if (this.getTrackedObjects().isEmpty()) {
            this.incrementCallStackDepth();
        }
        if ((descriptor = this.getDescriptor(object)) == null) {
            throw DescriptorException.missingDescriptor(object.getClass().toString());
        }
        ObjectBuilder objectBuilder = descriptor.getObjectBuilder();
        Object object2 = objectBuilder.unwrapObject(object, this);
        Object object3 = this.registerExistingObject(object2, descriptor);
        this.markObjectForUpdate(object3, descriptor);
        if (object2 != object) {
            return objectBuilder.wrapObject(object3, this);
        }
        return object3;
    }

    public synchronized Object registerNewObject(Object object) {
        Descriptor descriptor;
        if (object == null) {
            return null;
        }
        if (this.getTrackedObjects().isEmpty()) {
            this.incrementCallStackDepth();
        }
        if ((descriptor = this.getDescriptor(object)) == null) {
            throw DescriptorException.missingDescriptor(object.getClass().toString());
        }
        ObjectBuilder objectBuilder = descriptor.getObjectBuilder();
        Object object2 = objectBuilder.unwrapObject(object, this);
        boolean bl = object2 != object;
        Object object3 = this.registerNewObject(object2, descriptor);
        this.markObjectForUpdate(object3, descriptor);
        if (bl) {
            return objectBuilder.wrapObject(object3, this);
        }
        return object3;
    }

    public void updateChangeTrackersIfRequired(Object object, ObjectChangeSet objectChangeSet, UnitOfWork unitOfWork, Descriptor descriptor) {
        descriptor.getObjectChangePolicy().updateWithChanges(object, objectChangeSet, unitOfWork, descriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeChanges() {
        try {
            Object object;
            Object e;
            this.mergeBmpAndWsEntities();
            IdentityHashtable identityHashtable = new IdentityHashtable();
            IdentityHashtable identityHashtable2 = (IdentityHashtable)this.getTrackedObjects().getFirst();
            IdentityHashtable identityHashtable3 = new IdentityHashtable(2);
            IdentityHashtable identityHashtable4 = new IdentityHashtable(2);
            IdentityHashtable identityHashtable5 = new IdentityHashtable(2);
            IdentityHashtable identityHashtable6 = new IdentityHashtable(2);
            Enumeration enumeration = identityHashtable2.keys();
            while (enumeration.hasMoreElements()) {
                e = enumeration.nextElement();
                identityHashtable.put(e, e);
                this.discoverUnregisteredNewObjects(e, identityHashtable4, identityHashtable5, identityHashtable3);
                if (!this.isCloneNewObject(e)) continue;
                this.assignSequenceNumber(e);
                identityHashtable6.put(e, e);
            }
            enumeration = this.getNonTrackedObjects().keys();
            while (enumeration.hasMoreElements()) {
                e = enumeration.nextElement();
                identityHashtable.put(e, e);
                this.discoverUnregisteredNewObjects(e, identityHashtable4, identityHashtable5, identityHashtable3);
                if (!this.isCloneNewObject(e)) continue;
                this.assignSequenceNumber(e);
                identityHashtable6.put(e, e);
            }
            enumeration = identityHashtable4.keys();
            while (enumeration.hasMoreElements()) {
                e = enumeration.nextElement();
                object = this.getDescriptor(e);
                this.registerNewObject(e);
                if (((Descriptor)object).getCMPPolicy() == null || ((Descriptor)object).getCMPPolicy().getDeferModificationsUntilCommit() == 2) continue;
                this.assignSequenceNumber(e);
                identityHashtable.put(e, e);
                identityHashtable6.put(e, e);
            }
            if (this.getUnitOfWorkChangeSet() == null) {
                this.setUnitOfWorkChangeSet(new UnitOfWorkChangeSet());
            }
            this.calculateChanges(identityHashtable, (UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet());
            try {
                this.commitToDatabaseWithPreBuiltChangeSet((UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet(), false);
                this.writesCompleted();
            }
            catch (RuntimeException runtimeException) {
                this.setLifecycle(3);
                throw runtimeException;
            }
            ((UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet()).addDeletedObjects(this.getDeletedObjects(), this);
            ((UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet()).addDeletedObjects(this.getObjectsDeletedDuringCommit(), this);
            this.getDeletedObjects().clear();
            this.cumulativeUOWChangeSet.mergeUnitOfWorkChangeSet((UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet(), this, true);
            this.setUnitOfWorkChangeSet(new UnitOfWorkChangeSet());
            enumeration = identityHashtable6.elements();
            while (enumeration.hasMoreElements()) {
                e = enumeration.nextElement();
                object = this.getNewObjectsCloneToOriginal().remove(e);
                if (object == null) continue;
                this.getNewObjectsOriginalToClone().remove(object);
                this.getCloneToOriginals().put(e, object);
            }
        }
        finally {
            this.getTrackedObjects().removeFirst();
        }
    }
}

