/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.ejb.cmp;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import oracle.toplink.ejb.DeploymentException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.ejb.cmp.CmpHelper;
import oracle.toplink.internal.ejb.cmp.api.CmpField;
import oracle.toplink.internal.ejb.cmp.api.CmrField;
import oracle.toplink.internal.ejb.cmp.api.EntityDescriptor;
import oracle.toplink.internal.ejb.cmp.api.FinderDescriptor;
import oracle.toplink.internal.ejb.cmp.api.impl.CmpFieldImpl;
import oracle.toplink.internal.ejb.cmp.api.impl.DescriptorBuilder;
import oracle.toplink.internal.ejb.cmp.api.impl.EntityDescriptorImpl;
import oracle.toplink.internal.ejb.cmp.api.impl.RelationshipDescriptorImpl;
import oracle.toplink.internal.ejb.cmp.finders.FinderManager;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.logging.AbstractSessionLog;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.sessions.Project;

public class EntityDescriptorValidator {
    public static final String DESCRIPTOR_VALIDATED = "entityDescriptorValidatedFlag";
    private Project project;
    private Map entityDescriptors;
    private boolean shouldUseRemoteRelationships = false;

    public void configureAndValidateDescriptors(boolean bl, Project project, Map map) {
        this.project = project;
        this.entityDescriptors = map;
        this.shouldUseRemoteRelationships = bl;
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            this.configureAndValidateDescriptor((EntityDescriptor)iterator.next());
        }
    }

    private EntityDescriptor configureAndValidateDescriptor(EntityDescriptor entityDescriptor) {
        if (entityDescriptor == null) {
            return null;
        }
        if (entityDescriptor.getProperties().containsKey(DESCRIPTOR_VALIDATED)) {
            return entityDescriptor;
        }
        entityDescriptor.getProperties().put(DESCRIPTOR_VALIDATED, DESCRIPTOR_VALIDATED);
        Descriptor descriptor = this.getTopLinkDescriptorFor(entityDescriptor);
        if (descriptor.isChildDescriptor()) {
            EntityDescriptor entityDescriptor2 = this.configureAndValidateDescriptor(this.getDescriptorFor(descriptor.getInheritancePolicy().getParentClass()));
            this.copyInheritedValues(entityDescriptor, entityDescriptor2);
        }
        this.configureRemoteRelationships(entityDescriptor);
        this.configureAndValidateCmpFields(entityDescriptor, new HashMap(entityDescriptor.getCmpFields()));
        this.configureAndValidateCmpFields(entityDescriptor, new HashMap(entityDescriptor.getCmrFields()));
        if (entityDescriptor.isEJB20()) {
            this.collectExtraCmpFieldsAndEjbSelects(entityDescriptor);
        }
        this.collectExtraFinders(entityDescriptor);
        return entityDescriptor;
    }

    private Descriptor getTopLinkDescriptorFor(EntityDescriptor entityDescriptor) {
        Descriptor descriptor = this.project.getDescriptor(entityDescriptor.getBeanClass());
        if (descriptor == null) {
            throw ValidationException.missingDescriptor(entityDescriptor.getBeanClass().toString());
        }
        ((EntityDescriptorImpl)entityDescriptor).setDescriptor(descriptor);
        return descriptor;
    }

    private void copyInheritedValues(EntityDescriptor entityDescriptor, EntityDescriptor entityDescriptor2) {
        Cloneable cloneable;
        Cloneable cloneable2;
        if (entityDescriptor2 == null) {
            return;
        }
        HashMap<String, CmpFieldImpl> hashMap = new HashMap<String, CmpFieldImpl>(entityDescriptor2.getCmpFields().size() + entityDescriptor.getCmpFields().size());
        Iterator<Object> iterator = entityDescriptor2.getCmpFields().values().iterator();
        while (iterator.hasNext()) {
            cloneable2 = ((CmpFieldImpl)iterator.next()).buildCloneFor(entityDescriptor);
            ((CmpFieldImpl)cloneable2).descriptor = entityDescriptor;
            hashMap.put(((CmpFieldImpl)cloneable2).getName(), (CmpFieldImpl)cloneable2);
        }
        hashMap.putAll(entityDescriptor.getCmpFields());
        ((EntityDescriptorImpl)entityDescriptor).setCmpFields(hashMap);
        cloneable2 = new HashMap(entityDescriptor2.getCmrFields().size() + entityDescriptor.getCmrFields().size());
        HashSet<RelationshipDescriptorImpl> hashSet = new HashSet<RelationshipDescriptorImpl>(entityDescriptor2.getRelationshipDescriptors().size() + entityDescriptor.getRelationshipDescriptors().size());
        iterator = entityDescriptor2.getRelationshipDescriptors().iterator();
        while (iterator.hasNext()) {
            cloneable = ((RelationshipDescriptorImpl)iterator.next()).buildCloneFor(entityDescriptor);
            hashSet.add((RelationshipDescriptorImpl)cloneable);
            cloneable2.put(((RelationshipDescriptorImpl)cloneable).getSourceRole().getCmrField().getName(), ((RelationshipDescriptorImpl)cloneable).getSourceRole().getCmrField());
        }
        hashSet.addAll(entityDescriptor.getRelationshipDescriptors());
        ((EntityDescriptorImpl)entityDescriptor).setRelationShipDescriptors(hashSet);
        cloneable2.putAll(entityDescriptor.getCmrFields());
        ((EntityDescriptorImpl)entityDescriptor).setCmrFields((Map)((Object)cloneable2));
        cloneable = new HashSet(entityDescriptor2.getFinderDescriptors().size() + entityDescriptor.getFinderDescriptors().size());
        cloneable.addAll(entityDescriptor2.getFinderDescriptors());
        cloneable.addAll(entityDescriptor.getFinderDescriptors());
        ((EntityDescriptorImpl)entityDescriptor).setFinderDescriptors((Collection)((Object)cloneable));
    }

    private void configureRemoteRelationships(EntityDescriptor entityDescriptor) {
        boolean bl = true;
        if (entityDescriptor.isEJB20()) {
            if (this.shouldUseRemoteRelationships) {
                if (entityDescriptor.getRemoteInterfaceClass() == null) {
                    throw DeploymentException.cantUseRemoteRelationships(entityDescriptor.getBeanName());
                }
                bl = false;
            } else if (entityDescriptor.getLocalInterfaceClass() == null) {
                bl = false;
            }
        } else {
            bl = false;
        }
        ((EntityDescriptorImpl)entityDescriptor).usesLocalRelationships = bl;
    }

    private void configureAndValidateCmpFields(EntityDescriptor entityDescriptor, Map map) {
        Descriptor descriptor = entityDescriptor.getDescriptor();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            CmpField cmpField = (CmpField)iterator.next();
            String string = cmpField.getName();
            if (entityDescriptor.getCmpFields().containsKey(string) && entityDescriptor.getCmrFields().containsKey(string)) {
                entityDescriptor.getCmpFields().remove(string);
                AbstractSessionLog.getLog().log(6, "cmp_and_cmr_field", entityDescriptor.getBeanName(), string);
            }
            if (cmpField.getMapping() != null) continue;
            DatabaseMapping databaseMapping = this.getMappingForAttributeName(descriptor.getJavaClass(), string);
            if (databaseMapping != null) {
                ((CmpFieldImpl)cmpField).setMapping(databaseMapping);
                continue;
            }
            if (cmpField instanceof CmrField && ((CmrField)cmpField).isSynthetic()) continue;
            AbstractSessionLog.getLog().logThrowable(6, DeploymentException.noSuchMapping(descriptor.getJavaClass(), string));
        }
    }

    private void collectExtraCmpFieldsAndEjbSelects(EntityDescriptor entityDescriptor) {
        Method[] methodArray = entityDescriptor.getBeanClass().getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (!Modifier.isAbstract(method.getModifiers())) continue;
            String string = method.getName();
            if (string.startsWith("get")) {
                String string2 = CmpHelper.getCmpNameFromGetter(string);
                if (entityDescriptor.getCmpFields().containsKey(string2) || entityDescriptor.getCmrFields().containsKey(string2)) continue;
                AbstractSessionLog.getLog().log(6, "extra_cmp_field", entityDescriptor.getBeanName(), string2);
                CmpFieldImpl cmpFieldImpl = (CmpFieldImpl)DescriptorBuilder.buildCmpField(string2, PrivilegedAccessController.getMethodReturnType(method), entityDescriptor);
                cmpFieldImpl.setMapping(this.getMappingForAttributeName(entityDescriptor.getBeanClass(), cmpFieldImpl.getName()));
                entityDescriptor.getCmpFields().put(string2, cmpFieldImpl);
                continue;
            }
            if (!string.startsWith("ejbSelect")) continue;
            this.collectExtraFinder(entityDescriptor, method, "extra_ejb_select");
        }
    }

    private void collectExtraFinders(EntityDescriptor entityDescriptor) {
        Method method;
        int n;
        Method[] methodArray;
        if (entityDescriptor.getHomeInterfaceClass() != null) {
            methodArray = entityDescriptor.getHomeInterfaceClass().getMethods();
            for (n = 0; n < methodArray.length; ++n) {
                method = methodArray[n];
                if (!method.getName().startsWith("find") || method.getName().equals("findByPrimaryKey")) continue;
                this.collectExtraFinder(entityDescriptor, method, "extra_finder");
            }
        }
        if (entityDescriptor.getLocalHomeInterfaceClass() != null) {
            methodArray = entityDescriptor.getLocalHomeInterfaceClass().getMethods();
            for (n = 0; n < methodArray.length; ++n) {
                method = methodArray[n];
                if (!method.getName().startsWith("find") || method.getName().equals("findByPrimaryKey")) continue;
                this.collectExtraFinder(entityDescriptor, method, "extra_finder");
            }
        }
    }

    private void collectExtraFinder(EntityDescriptor entityDescriptor, Method method, String string) {
        String string2 = method.getName();
        FinderDescriptor finderDescriptor = DescriptorBuilder.buildFinderDescriptor(string2, Arrays.asList(PrivilegedAccessController.getMethodParameterTypes(method)), PrivilegedAccessController.getMethodReturnType(method));
        if (!entityDescriptor.getFinderDescriptors().contains(finderDescriptor)) {
            if (entityDescriptor.isEJB20() && !FinderManager.isMagicFinder(method, entityDescriptor)) {
                AbstractSessionLog.getLog().log(6, string, entityDescriptor.getBeanName(), string2, finderDescriptor.getMethodParams());
            }
            entityDescriptor.getFinderDescriptors().add(finderDescriptor);
        }
    }

    private EntityDescriptor getDescriptorFor(Class clazz) {
        Iterator iterator = this.entityDescriptors.values().iterator();
        while (iterator.hasNext()) {
            EntityDescriptor entityDescriptor = (EntityDescriptor)iterator.next();
            if (entityDescriptor.getBeanClass() != clazz) continue;
            return entityDescriptor;
        }
        return null;
    }

    private DatabaseMapping getMappingForAttributeName(Class clazz, String string) {
        Descriptor descriptor = (Descriptor)this.project.getDescriptors().get(clazz);
        DatabaseMapping databaseMapping = descriptor.getMappingForAttributeName(string);
        if (databaseMapping == null && descriptor.isChildDescriptor()) {
            databaseMapping = this.getMappingForAttributeName(descriptor.getInheritancePolicy().getParentClass(), string);
        }
        return databaseMapping;
    }
}

