/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.databaseaccess;

import java.sql.Connection;
import java.util.Vector;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.internal.databaseaccess.Accessor;
import oracle.toplink.internal.databaseaccess.DatasourcePlatform;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.Call;
import oracle.toplink.sessions.Login;

public abstract class DatasourceAccessor
implements Accessor {
    protected Object datasourceConnection;
    protected Login login;
    protected int callCount = 0;
    protected boolean isInTransaction = false;
    protected boolean isConnected = false;
    protected DatasourcePlatform platform;

    public Object clone() {
        try {
            DatasourceAccessor datasourceAccessor = (DatasourceAccessor)super.clone();
            return datasourceAccessor;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("clone not supported");
        }
    }

    public void afterJTSTransaction() {
        if (this.usesExternalTransactionController()) {
            this.setIsInTransaction(false);
            if (this.getDatasourceConnection() != null && this.usesExternalConnectionPooling()) {
                this.closeConnection();
                this.setDatasourceConnection(null);
            }
        }
    }

    protected void setIsInTransaction(boolean bl) {
        this.isInTransaction = bl;
    }

    public boolean isInTransaction() {
        return this.isInTransaction;
    }

    public boolean usesExternalConnectionPooling() {
        if (this.getLogin() == null) {
            throw DatabaseException.databaseAccessorNotConnected();
        }
        return this.getLogin().shouldUseExternalConnectionPooling();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginTransaction(Session session) throws DatabaseException {
        if (this.usesExternalTransactionController()) {
            this.setIsInTransaction(true);
            return;
        }
        session.log(2, "transaction", "begin_transaction", (Object[])null, this);
        try {
            session.startOperationProfile("transactions");
            this.incrementCallCount(session);
            this.basicBeginTransaction(session);
            this.setIsInTransaction(true);
        }
        finally {
            this.decrementCallCount();
            session.endOperationProfile("transactions");
        }
    }

    protected abstract void basicBeginTransaction(Session var1);

    protected abstract void basicCommitTransaction(Session var1);

    protected abstract void basicRollbackTransaction(Session var1);

    public synchronized void decrementCallCount() {
        this.setCallCount(this.getCallCount() - 1);
        if (this.usesExternalConnectionPooling() && !this.isInTransaction() && this.getCallCount() == 0) {
            try {
                this.closeConnection();
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
        }
    }

    public synchronized void incrementCallCount(Session session) {
        this.setCallCount(this.getCallCount() + 1);
        if (this.getCallCount() == 1) {
            if (this.getLogin() == null) {
                throw DatabaseException.databaseAccessorNotConnected();
            }
            if (this.getDatasourceConnection() != null) {
                if (!this.isConnected()) {
                    if (this.isInTransaction()) {
                        throw DatabaseException.databaseAccessorNotConnected();
                    }
                    this.reconnect(session);
                }
            } else if (this.usesExternalConnectionPooling()) {
                this.reconnect(session);
            } else {
                throw DatabaseException.databaseAccessorNotConnected();
            }
        }
    }

    protected void connect(Login login) throws DatabaseException {
        this.setDatasourceConnection(login.connectToDatasource(this));
        this.setIsConnected(true);
    }

    protected void setIsConnected(boolean bl) {
        this.isConnected = bl;
    }

    protected void setCallCount(int n) {
        this.callCount = n;
    }

    public int getCallCount() {
        return this.callCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitTransaction(Session session) throws DatabaseException {
        if (this.usesExternalTransactionController()) {
            if (session.getExternalTransactionController() == null) {
                this.setIsInTransaction(false);
                if (this.getDatasourceConnection() != null && this.usesExternalConnectionPooling()) {
                    this.closeConnection();
                    this.setDatasourceConnection(null);
                }
            }
            return;
        }
        session.log(2, "transaction", "commit_transaction", (Object[])null, this);
        try {
            session.startOperationProfile("transactions");
            this.incrementCallCount(session);
            this.basicCommitTransaction(session);
            session.afterTransaction(true, false);
            this.setIsInTransaction(false);
        }
        finally {
            this.decrementCallCount();
            session.endOperationProfile("transactions");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(Login login, Session session) throws DatabaseException {
        session.startOperationProfile("connect");
        session.incrementProfile("ConnectCalls");
        try {
            if (session.shouldLog(4, "connection")) {
                session.log(4, "connection", "connecting", new Object[]{login}, this);
            }
            this.setLogin(login);
            this.setDatasourcePlatform((DatasourcePlatform)session.getDatasourceLogin().getDatasourcePlatform());
            try {
                this.connect(login);
                this.setIsInTransaction(false);
            }
            catch (RuntimeException runtimeException) {
                session.handleSevere(runtimeException);
            }
            session.getEventManager().postConnect(this);
            this.incrementCallCount(session);
            try {
                this.buildConnectLog(session);
            }
            finally {
                this.decrementCallCount();
            }
        }
        finally {
            session.endOperationProfile("connect");
        }
    }

    protected abstract void closeDatasourceConnection();

    protected abstract Object basicExecuteCall(Call var1, DatabaseRow var2, Session var3);

    protected abstract void buildConnectLog(Session var1);

    public Login getLogin() {
        return this.login;
    }

    protected void setLogin(Login login) {
        this.login = login;
    }

    public void disconnect(Session session) throws DatabaseException {
        session.log(4, "connection", "disconnect", (Object[])null, this);
        if (this.getDatasourceConnection() == null) {
            return;
        }
        session.incrementProfile("DisconnectCalls");
        session.startOperationProfile("connect");
        this.closeDatasourceConnection();
        this.setDatasourceConnection(null);
        this.setIsInTransaction(false);
        session.endOperationProfile("connect");
    }

    public void closeConnection() {
        try {
            if (this.getDatasourceConnection() != null) {
                if (this.isDatasourceConnected()) {
                    this.closeDatasourceConnection();
                }
                this.setDatasourceConnection(null);
            }
        }
        catch (DatabaseException databaseException) {
            this.setDatasourceConnection(null);
        }
    }

    public Object executeCall(Call call, DatabaseRow databaseRow, Session session) throws DatabaseException {
        if (this.getLogin() == null) {
            throw DatabaseException.databaseAccessorNotConnected();
        }
        if (session.shouldLog(3, "sql")) {
            session.log(3, "sql", call.getLogString(this), null, this, false);
        }
        Object object = this.basicExecuteCall(call, databaseRow, session);
        return object;
    }

    public void reestablishConnection(Session session) throws DatabaseException {
        if (session.shouldLog(4, "connection")) {
            Object[] objectArray = new Object[]{this.getLogin()};
            session.log(4, "connection", "reconnecting", objectArray, this);
        }
        this.reconnect(session);
        this.setIsInTransaction(false);
        session.getEventManager().postConnect(this);
    }

    protected void reconnect(Session session) throws DatabaseException {
        session.log(1, "connection", "reconnecting_to_external_connection_pool");
        session.startOperationProfile("connect");
        this.connect(this.getLogin());
        session.endOperationProfile("connect");
    }

    public DatasourcePlatform getDatasourcePlatform() {
        return this.platform;
    }

    public void setDatasourcePlatform(DatasourcePlatform datasourcePlatform) {
        this.platform = datasourcePlatform;
    }

    public Object getDatasourceConnection() {
        return this.datasourceConnection;
    }

    public Connection getConnection() {
        return (Connection)this.getDatasourceConnection();
    }

    public Vector getColumnInfo(String string, String string2, String string3, String string4, Session session) throws DatabaseException {
        return new Vector();
    }

    public Vector getTableInfo(String string, String string2, String string3, String[] stringArray, Session session) throws DatabaseException {
        return new Vector();
    }

    protected void setDatasourceConnection(Object object) {
        this.datasourceConnection = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackTransaction(Session session) throws DatabaseException {
        if (this.usesExternalTransactionController()) {
            if (session.getExternalTransactionController() == null) {
                this.setIsInTransaction(false);
                if (this.getDatasourceConnection() != null && this.usesExternalConnectionPooling()) {
                    this.closeConnection();
                    this.setDatasourceConnection(null);
                }
            }
            return;
        }
        session.log(2, "transaction", "rollback_transaction", (Object[])null, this);
        try {
            session.startOperationProfile("transactions");
            this.incrementCallCount(session);
            this.basicRollbackTransaction(session);
            Object var3_2 = null;
            session.afterTransaction(false, false);
            this.setIsInTransaction(false);
            this.decrementCallCount();
            session.endOperationProfile("transactions");
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            session.afterTransaction(false, false);
            this.setIsInTransaction(false);
            this.decrementCallCount();
            session.endOperationProfile("transactions");
            throw throwable;
        }
    }

    public boolean usesExternalTransactionController() {
        if (this.getLogin() == null) {
            throw DatabaseException.databaseAccessorNotConnected();
        }
        return this.getLogin().shouldUseExternalTransactionController();
    }

    public boolean isConnected() {
        if (this.getDatasourceConnection() == null && this.getLogin() == null) {
            return false;
        }
        if (this.usesExternalConnectionPooling()) {
            return true;
        }
        if (this.getDatasourceConnection() == null) {
            return false;
        }
        return this.isDatasourceConnected();
    }

    protected abstract boolean isDatasourceConnected();

    public void flushSelectCalls(Session session) {
    }

    public void writesCompleted(Session session) {
    }
}

