/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.databaseaccess;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.databaseaccess.Accessor;
import oracle.toplink.internal.databaseaccess.DatabaseAccessor;
import oracle.toplink.internal.databaseaccess.DatabasePlatform;
import oracle.toplink.internal.databaseaccess.DatasourceCall;
import oracle.toplink.internal.databaseaccess.InOutputParameterForCallableStatement;
import oracle.toplink.internal.databaseaccess.OutputParameterForCallableStatement;
import oracle.toplink.internal.expressions.ParameterExpression;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.queryframework.CallQueryMechanism;
import oracle.toplink.internal.queryframework.DatabaseQueryMechanism;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.sessions.DatabaseRecord;

public abstract class DatabaseCall
extends DatasourceCall {
    protected transient Statement statement;
    protected transient ResultSet result;
    protected int usesBinding = 0;
    protected int shouldCacheStatement = 0;
    protected transient Vector fields;
    protected boolean isFieldMatchingRequired = false;
    protected boolean hasOptimisticLock;
    protected boolean isResultSetScrollable;
    protected int resultSetFetchSize;
    protected int resultSetType;
    protected int resultSetConcurrency;
    protected int queryTimeout;
    protected int maxRows;
    protected int firstResult;
    private transient DatabaseRow contexts = null;
    protected boolean isCursorOutputProcedure;
    protected int returnsResultSet;
    protected boolean shouldBuildOutputRow;
    protected boolean isCallableStatementRequired;
    protected String sqlString;

    public DatabaseCall() {
        this.returnType = 3;
        this.queryTimeout = 0;
        this.maxRows = 0;
        this.resultSetFetchSize = 0;
        this.isCursorOutputProcedure = false;
        this.shouldBuildOutputRow = false;
        this.returnsResultSet = 0;
    }

    public void appendIn(Object object) {
        this.getParameters().add(object);
        this.getParameterTypes().add(IN);
    }

    public void appendInOut(DatabaseField databaseField) {
        Object[] objectArray = new Object[]{databaseField, databaseField};
        this.getParameters().add(objectArray);
        this.getParameterTypes().add(INOUT);
    }

    public void appendInOut(Object object, DatabaseField databaseField) {
        Object[] objectArray = new Object[]{object, databaseField};
        this.getParameters().add(objectArray);
        this.getParameterTypes().add(INOUT);
    }

    public void appendOut(DatabaseField databaseField) {
        this.getParameters().add(databaseField);
        this.getParameterTypes().add(OUT);
    }

    public void appendOutCursor(DatabaseField databaseField) {
        this.getParameters().add(databaseField);
        this.getParameterTypes().add(OUT_CURSOR);
    }

    public void appendParameter(Writer writer, Object object, Session session) {
        if (this.usesBinding == 1) {
            this.bindParameter(writer, object);
        } else {
            session.getPlatform().appendParameter(this, writer, object);
        }
    }

    public void bindParameter(Writer writer, Object object) {
        if (object instanceof Vector) {
            throw QueryException.inCannotBeParameterized(this.getQuery());
        }
        try {
            writer.write("?");
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        this.getParameters().addElement(object);
    }

    public DatabaseQueryMechanism buildNewQueryMechanism(DatabaseQuery databaseQuery) {
        return new CallQueryMechanism(databaseQuery, this);
    }

    public DatabaseRow buildOutputRow(CallableStatement callableStatement) throws SQLException {
        DatabaseRecord databaseRecord = new DatabaseRecord();
        for (int i = 0; i < this.parameters.size(); ++i) {
            OutputParameterForCallableStatement outputParameterForCallableStatement;
            Object e = this.parameters.elementAt(i);
            if (!(e instanceof OutputParameterForCallableStatement) || (outputParameterForCallableStatement = (OutputParameterForCallableStatement)e).isCursor()) continue;
            Object object = callableStatement.getObject(i + 1);
            DatabaseField databaseField = outputParameterForCallableStatement.getOutputField();
            databaseRecord.put(databaseField, object);
        }
        return databaseRecord;
    }

    public DatabaseQueryMechanism buildQueryMechanism(DatabaseQuery databaseQuery, DatabaseQueryMechanism databaseQueryMechanism) {
        if (databaseQueryMechanism.isCallQueryMechanism() && databaseQueryMechanism instanceof CallQueryMechanism) {
            CallQueryMechanism callQueryMechanism = (CallQueryMechanism)databaseQueryMechanism;
            if (!callQueryMechanism.hasMultipleCalls()) {
                callQueryMechanism.addCall(callQueryMechanism.getCall());
                callQueryMechanism.setCall(null);
            }
            callQueryMechanism.addCall(this);
            return databaseQueryMechanism;
        }
        return this.buildNewQueryMechanism(databaseQuery);
    }

    protected Object createInOutParameter(Object object, Object object2, Session session) {
        if (object2 instanceof OutputParameterForCallableStatement) {
            return new InOutputParameterForCallableStatement(object, (OutputParameterForCallableStatement)object2);
        }
        if (object2 instanceof DatabaseField) {
            return new InOutputParameterForCallableStatement(object, (DatabaseField)object2, session.getPlatform());
        }
        return null;
    }

    public String getCallString() {
        return this.getSQLString();
    }

    public Vector getFields() {
        return this.fields;
    }

    protected DatabaseField getFieldWithTypeFromDescriptor(DatabaseField databaseField) {
        if (this.getQuery().getDescriptor() != null) {
            return this.getQuery().getDescriptor().getTypedField(databaseField);
        }
        return null;
    }

    public int getCursorOutIndex() {
        for (int i = 0; i < this.getParameters().size(); ++i) {
            Object e = this.getParameters().elementAt(i);
            if (!(e instanceof OutputParameterForCallableStatement) || !((OutputParameterForCallableStatement)e).isCursor()) continue;
            return i + 1;
        }
        return -1;
    }

    public int getFirstResult() {
        return this.firstResult;
    }

    public String getLogString(Accessor accessor) {
        if (this.hasParameters()) {
            StringWriter stringWriter = new StringWriter();
            stringWriter.write(this.getSQLString());
            stringWriter.write(Helper.cr());
            if (this.hasParameters()) {
                Session session = null;
                if (this.getQuery() != null) {
                    session = this.getQuery().getSession();
                }
                DatabaseCall.appendLogParameters(this.getParameters(), accessor, stringWriter, session);
            }
            return stringWriter.toString();
        }
        return this.getSQLString();
    }

    public static void appendLogParameters(Collection collection, Accessor accessor, StringWriter stringWriter, Session session) {
        stringWriter.write("\tbind => [");
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object instanceof DatabaseField) {
                stringWriter.write("null");
            } else {
                if (session != null) {
                    object = session.getPlatform().convertToDatabaseType(object);
                }
                stringWriter.write(String.valueOf(object));
            }
            if (iterator.hasNext()) {
                stringWriter.write(", ");
                continue;
            }
            stringWriter.write("]");
        }
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public Vector getOutputRowFields() {
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < this.getParameters().size(); ++i) {
            Integer n = (Integer)this.getParameterTypes().elementAt(i);
            Object e = this.getParameters().elementAt(i);
            if (n == OUT) {
                vector.add(e);
                continue;
            }
            if (n != INOUT) continue;
            vector.add(((Object[])e)[1]);
        }
        return vector;
    }

    public String getQueryString() {
        return this.getSQLString();
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public ResultSet getResult() {
        return this.result;
    }

    public boolean getReturnsResultSet() {
        if (this.returnsResultSet == 0) {
            return !this.shouldBuildOutputRow();
        }
        return this.returnsResultSet == 1;
    }

    public int getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    public int getResultSetFetchSize() {
        return this.resultSetFetchSize;
    }

    public int getResultSetType() {
        return this.resultSetType;
    }

    public String getSQLString() {
        return this.sqlString;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public boolean hasOptimisticLock() {
        return this.hasOptimisticLock;
    }

    protected boolean isCallableStatementRequired() {
        return this.isCallableStatementRequired;
    }

    protected boolean isDynamicCall(Session session) {
        return DatabaseAccessor.shouldUseDynamicStatements && !this.usesBinding(session) && !this.isResultSetScrollable() && !this.hasParameters();
    }

    public boolean isCursorOutputProcedure() {
        return this.isCursorOutputProcedure;
    }

    public boolean isCursorReturned() {
        return this.getReturnType() == 4;
    }

    public boolean isFieldMatchingRequired() {
        return this.isFieldMatchingRequired;
    }

    public boolean isFinished() {
        return !this.isCursorReturned();
    }

    public boolean isNonCursorOutputProcedure() {
        return !this.isCursorOutputProcedure() && this.shouldBuildOutputRow();
    }

    public boolean isResultSetScrollable() {
        return this.isResultSetScrollable;
    }

    public void matchFieldOrder(ResultSet resultSet, DatabaseAccessor databaseAccessor, Session session) {
        if (this.getFields() != null && !this.isFieldMatchingRequired()) {
            return;
        }
        this.setFields(databaseAccessor.buildSortedFields(this.getFields(), resultSet, session));
    }

    public void prepare(Session session) {
        if (this.isPrepared()) {
            return;
        }
        this.prepareInternal(session);
        this.setIsPrepared(true);
    }

    protected void prepareInternal(Session session) {
        int n;
        if (this.isCursorOutputProcedure()) {
            n = -1;
            boolean bl = false;
            for (int i = 0; i < this.parameters.size(); ++i) {
                Integer n2 = (Integer)this.parameterTypes.elementAt(i);
                if (n2 == DatasourceCall.OUT_CURSOR) {
                    if (bl) {
                        throw ValidationException.multipleCursorsNotSupported(this.toString());
                    }
                    bl = true;
                    continue;
                }
                if (n2 == DatasourceCall.OUT) {
                    if (n != -1) continue;
                    n = i;
                    continue;
                }
                if (n2 != null) continue;
                throw ValidationException.wrongUsageOfSetCustomArgumentTypeMethod(this.toString());
            }
            if (!bl && n >= 0) {
                this.parameterTypes.setElementAt(DatasourceCall.OUT_CURSOR, n);
            }
        }
        for (n = 0; n < this.getParameters().size(); ++n) {
            Object object;
            boolean bl;
            Object object2;
            Object e = this.getParameters().elementAt(n);
            Integer n3 = (Integer)this.getParameterTypes().elementAt(n);
            if (n3 == MODIFY) {
                DatabaseField databaseField = (DatabaseField)e;
                if (databaseField.getType() != null && !session.getPlatform().shouldUseCustomModifyForCall(databaseField)) continue;
                this.getParameterTypes().setElementAt(CUSTOM_MODIFY, n);
                continue;
            }
            if (n3 == INOUT) {
                this.setShouldBuildOutputRow(true);
                this.setIsCallableStatementRequired(true);
                DatabaseField databaseField = (DatabaseField)((Object[])e)[1];
                if (databaseField.getType() == null && (object2 = this.getFieldWithTypeFromDescriptor(databaseField)) != null) {
                    databaseField = (DatabaseField)((DatabaseField)object2).clone();
                }
                if (databaseField.getType() == null) continue;
                ((Object[])e)[1] = object2 = new OutputParameterForCallableStatement(databaseField, session.getPlatform());
                continue;
            }
            if (n3 != OUT && n3 != OUT_CURSOR) continue;
            boolean bl2 = bl = n3 == OUT_CURSOR;
            if (!bl) {
                this.setShouldBuildOutputRow(true);
            }
            this.setIsCallableStatementRequired(true);
            object2 = (DatabaseField)e;
            if (((DatabaseField)object2).getType() == null && (object = this.getFieldWithTypeFromDescriptor((DatabaseField)object2)) != null) {
                object2 = (DatabaseField)((DatabaseField)object).clone();
            }
            object = new OutputParameterForCallableStatement((DatabaseField)object2, session.getPlatform(), bl);
            this.getParameters().setElementAt(object, n);
            this.getParameterTypes().setElementAt(LITERAL, n);
        }
        if (this.returnsResultSet == 0) {
            this.setReturnsResultSet(!this.isCallableStatementRequired());
        }
    }

    public Statement prepareStatement(DatabaseAccessor databaseAccessor, DatabaseRow databaseRow, Session session) throws SQLException {
        Statement statement = databaseAccessor.prepareStatement(this, session);
        if (this.getQueryTimeout() > 0) {
            statement.setQueryTimeout(this.getQueryTimeout());
        }
        if (this.getMaxRows() > 0) {
            statement.setMaxRows(this.getMaxRows());
        }
        if (this.getResultSetFetchSize() > 0) {
            statement.setFetchSize(this.getResultSetFetchSize());
        }
        if (!this.hasParameters()) {
            return statement;
        }
        for (int i = 0; i < this.getParameters().size(); ++i) {
            session.getPlatform().setParameterValueInDatabaseCall(this.getParameters(), (PreparedStatement)statement, i, session);
        }
        return statement;
    }

    public void setFields(Vector vector) {
        this.fields = vector;
    }

    public void setFirstResult(int n) {
        this.firstResult = n;
    }

    public void setHasOptimisticLock(boolean bl) {
        this.hasOptimisticLock = bl;
    }

    protected void setIsCallableStatementRequired(boolean bl) {
        this.isCallableStatementRequired = bl;
    }

    public void setIsCursorOutputProcedure(boolean bl) {
        this.isCursorOutputProcedure = bl;
    }

    public void setIsFieldMatchingRequired(boolean bl) {
        this.isFieldMatchingRequired = bl;
    }

    public void setIsResultSetScrollable(boolean bl) {
        this.isResultSetScrollable = bl;
    }

    public void setMaxRows(int n) {
        this.maxRows = n;
    }

    public void setQueryString(String string) {
        this.setSQLStringInternal(string);
    }

    public void setQueryTimeout(int n) {
        this.queryTimeout = n;
    }

    public void setResult(ResultSet resultSet) {
        this.result = resultSet;
    }

    public void setResultSetConcurrency(int n) {
        this.resultSetConcurrency = n;
    }

    protected void setSQLStringInternal(String string) {
        this.sqlString = string;
    }

    public void setResultSetFetchSize(int n) {
        this.resultSetFetchSize = n;
    }

    public void setResultSetType(int n) {
        this.resultSetType = n;
    }

    public void setReturnsResultSet(boolean bl) {
        this.returnsResultSet = bl ? 1 : -1;
    }

    protected void setShouldBuildOutputRow(boolean bl) {
        this.shouldBuildOutputRow = bl;
    }

    public void setShouldCacheStatement(boolean bl) {
        this.shouldCacheStatement = bl ? 1 : -1;
    }

    public void setStatement(Statement statement) {
        this.statement = statement;
    }

    public void setUsesBinding(boolean bl) {
        this.usesBinding = bl ? 1 : -1;
    }

    protected boolean shouldBuildOutputRow() {
        return this.shouldBuildOutputRow;
    }

    public boolean shouldCacheStatement(Session session) {
        return this.shouldCacheStatement(session.getPlatform());
    }

    public boolean shouldCacheStatement(DatabasePlatform databasePlatform) {
        if (this.isResultSetScrollable()) {
            return false;
        }
        if (this.shouldCacheStatement == 0) {
            return databasePlatform.shouldCacheAllStatements();
        }
        return this.shouldCacheStatement == 1;
    }

    public String toString() {
        String string = Helper.getShortClassName(this.getClass());
        if (this.getSQLString() == null) {
            return string;
        }
        return string + "(" + this.getSQLString() + ")";
    }

    public void translate(DatabaseRow databaseRow, DatabaseRow databaseRow2, Session session) {
        if (!this.isPrepared()) {
            throw ValidationException.cannotTranslateUnpreparedCall(this.toString());
        }
        if (this.usesBinding(session)) {
            Vector<Object> vector = new Vector<Object>();
            Vector vector2 = this.getParameters();
            Vector vector3 = this.getParameterTypes();
            int n = vector2.size();
            for (int i = 0; i < n; ++i) {
                Object object;
                Object object2;
                Object e = vector2.elementAt(i);
                Object e2 = vector3.elementAt(i);
                if (e2 == MODIFY) {
                    object2 = (DatabaseField)e;
                    object = databaseRow2.get((DatabaseField)object2);
                    if (object == null) {
                        object = databaseRow2.getField((DatabaseField)object2);
                    }
                    vector.addElement(object);
                    continue;
                }
                if (e2 == CUSTOM_MODIFY) {
                    object2 = (DatabaseField)e;
                    object = databaseRow2.get((DatabaseField)object2);
                    object = session.getPlatform().getCustomModifyValueForCall(this, object, (DatabaseField)object2, true);
                    if (object == null) {
                        object = databaseRow2.getField((DatabaseField)object2);
                    }
                    vector.addElement(object);
                    continue;
                }
                if (e2 == TRANSLATION) {
                    object2 = null;
                    object = null;
                    if (e instanceof ParameterExpression) {
                        object2 = ((ParameterExpression)e).getValue(databaseRow, session);
                    } else {
                        object = (DatabaseField)e;
                        object2 = databaseRow.get((DatabaseField)object);
                        if (object2 == null) {
                            object2 = databaseRow2.get((DatabaseField)object);
                        }
                    }
                    if (object2 instanceof Vector) {
                        throw QueryException.inCannotBeParameterized(this.getQuery());
                    }
                    if (object2 == null && object != null) {
                        object2 = databaseRow.getField((DatabaseField)object);
                    }
                    vector.addElement(object2);
                    continue;
                }
                if (e2 == LITERAL) {
                    vector.addElement(e);
                    continue;
                }
                if (e2 == IN) {
                    object2 = this.getValueForInParameter(e, databaseRow, databaseRow2, session, true);
                    vector.addElement(object2);
                    continue;
                }
                if (e2 != INOUT) continue;
                object2 = this.getValueForInOutParameter(e, databaseRow, databaseRow2, session);
                vector.addElement(object2);
            }
            this.setParameters(vector);
            return;
        }
        this.translateQueryString(databaseRow, databaseRow2, session);
    }

    public boolean usesBinding(Session session) {
        return this.usesBinding(session.getPlatform());
    }

    public boolean usesBinding(DatabasePlatform databasePlatform) {
        if (this.usesBinding == 0) {
            return databasePlatform.shouldBindAllParameters();
        }
        return this.usesBinding == 1;
    }

    public boolean isLOBLocatorNeeded() {
        return this.contexts != null;
    }

    public void addContext(DatabaseField databaseField, Object object) {
        if (this.contexts == null) {
            this.contexts = new DatabaseRecord(2);
        }
        this.contexts.add(databaseField, object);
    }

    public DatabaseRow getContexts() {
        return this.contexts;
    }

    public void setContexts(DatabaseRow databaseRow) {
        this.contexts = databaseRow;
    }

    public void useUnnamedCursorOutputAsResultSet() {
        this.setIsCursorOutputProcedure(true);
    }
}

