/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.indirection;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import oracle.toplink.descriptors.changetracking.CollectionChangeEvent;
import oracle.toplink.descriptors.changetracking.CollectionChangeTracker;
import oracle.toplink.indirection.IndirectCollection;
import oracle.toplink.indirection.ValueHolder;
import oracle.toplink.indirection.ValueHolderInterface;
import oracle.toplink.internal.descriptors.changetracking.AttributeChangeListener;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.indirection.UnitOfWorkQueryValueHolder;

public class IndirectList
extends Vector
implements CollectionChangeTracker,
IndirectCollection {
    protected Vector delegate;
    protected ValueHolderInterface valueHolder;
    private transient PropertyChangeListener changeListener;
    private transient String attributeName;
    private transient List addedElements;
    private transient List removedElements;
    protected int initialCapacity = 10;

    public IndirectList() {
        this(10);
    }

    public IndirectList(int n) {
        this(n, 0);
    }

    public IndirectList(int n, int n2) {
        super(0);
        this.initialize(n, n2);
    }

    public IndirectList(Collection collection) {
        super(0);
        this.initialize(collection);
    }

    public void add(int n, Object object) {
        this.getDelegate().add(n, object);
        this.raiseAddChangeEvent(object);
    }

    protected void raiseAddChangeEvent(Object object) {
        if (this.hasTopLinkPropertyChangeListener()) {
            this.getTopLinkPropertyChangeListener().propertyChange(new CollectionChangeEvent(this, this.getTopLinkAttributeName(), this, object, CollectionChangeEvent.ADD));
        }
        if (this.hasBeenRegistered()) {
            ((UnitOfWorkQueryValueHolder)this.getValueHolder()).updateForeignReferenceSet(object, null);
        }
    }

    protected void raiseRemoveChangeEvent(Object object) {
        if (this.hasTopLinkPropertyChangeListener()) {
            this.getTopLinkPropertyChangeListener().propertyChange(new CollectionChangeEvent(this, this.getTopLinkAttributeName(), this, object, CollectionChangeEvent.REMOVE));
        }
        if (this.hasBeenRegistered()) {
            ((UnitOfWorkQueryValueHolder)this.getValueHolder()).updateForeignReferenceRemove(object);
        }
    }

    public synchronized boolean add(Object object) {
        boolean bl = true;
        if (this.shouldAvoidInstantiation()) {
            if (this.getRemovedElements().contains(object)) {
                this.getRemovedElements().remove(object);
            } else {
                if (this.getAddedElements().contains(object)) {
                    return false;
                }
                this.getAddedElements().add(object);
            }
        } else {
            bl = this.getDelegate().add(object);
        }
        this.raiseAddChangeEvent(object);
        return bl;
    }

    public synchronized boolean addAll(int n, Collection collection) {
        Iterator iterator = collection.iterator();
        if (this.hasBeenRegistered() || this.hasTopLinkPropertyChangeListener()) {
            while (iterator.hasNext()) {
                this.add(n, iterator.next());
                ++n;
            }
            return true;
        }
        return this.getDelegate().addAll(n, collection);
    }

    public synchronized boolean addAll(Collection collection) {
        if (this.hasBeenRegistered() || this.hasTopLinkPropertyChangeListener()) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.add(iterator.next());
            }
            return true;
        }
        return this.getDelegate().addAll(collection);
    }

    public synchronized void addElement(Object object) {
        this.add(object);
    }

    protected Vector buildDelegate() {
        int n;
        Vector vector = (Vector)this.getValueHolder().getValue();
        while (vector instanceof IndirectList) {
            vector = ((IndirectList)vector).getDelegate();
        }
        if (this.hasAddedElements()) {
            for (n = 0; n < this.getAddedElements().size(); ++n) {
                vector.add(((List)this.getAddedElements()).get(n));
            }
            this.addedElements = null;
        }
        if (this.hasRemovedElements()) {
            for (n = 0; n < this.getRemovedElements().size(); ++n) {
                vector.remove(((List)this.getRemovedElements()).get(n));
            }
            this.removedElements = null;
        }
        return vector;
    }

    public int capacity() {
        return this.getDelegate().capacity();
    }

    public void clear() {
        if (this.hasBeenRegistered() || this.hasTopLinkPropertyChangeListener()) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                iterator.remove();
                this.raiseRemoveChangeEvent(e);
            }
        } else {
            this.getDelegate().clear();
        }
    }

    public synchronized Object clone() {
        IndirectList indirectList = (IndirectList)super.clone();
        indirectList.delegate = (Vector)this.getDelegate().clone();
        indirectList.attributeName = null;
        indirectList.changeListener = null;
        return indirectList;
    }

    public boolean contains(Object object) {
        if (this.hasAddedElements() && this.getAddedElements().contains(object)) {
            return true;
        }
        if (this.hasRemovedElements() && this.getRemovedElements().contains(object)) {
            return false;
        }
        return this.getDelegate().contains(object);
    }

    public synchronized boolean containsAll(Collection collection) {
        return this.getDelegate().containsAll(collection);
    }

    public synchronized void copyInto(Object[] objectArray) {
        this.getDelegate().copyInto(objectArray);
    }

    public synchronized Object elementAt(int n) {
        return this.getDelegate().elementAt(n);
    }

    public Enumeration elements() {
        return this.getDelegate().elements();
    }

    public synchronized void ensureCapacity(int n) {
        this.getDelegate().ensureCapacity(n);
    }

    public synchronized boolean equals(Object object) {
        return this.getDelegate().equals(object);
    }

    public synchronized Object firstElement() {
        return this.getDelegate().firstElement();
    }

    public synchronized Object get(int n) {
        return this.getDelegate().get(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector getDelegate() {
        if (this.delegate == null) {
            IndirectList indirectList = this;
            synchronized (indirectList) {
                if (this.delegate == null) {
                    this.delegate = this.buildDelegate();
                }
            }
        }
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueHolderInterface getValueHolder() {
        if (this.valueHolder == null) {
            IndirectList indirectList = this;
            synchronized (indirectList) {
                if (this.valueHolder == null) {
                    this.valueHolder = new ValueHolder(new Vector(this.initialCapacity, this.capacityIncrement));
                }
            }
        }
        return this.valueHolder;
    }

    public boolean hasBeenRegistered() {
        return this.getValueHolder() instanceof UnitOfWorkQueryValueHolder;
    }

    public synchronized int hashCode() {
        return this.getDelegate().hashCode();
    }

    public int indexOf(Object object) {
        return this.getDelegate().indexOf(object);
    }

    public synchronized int indexOf(Object object, int n) {
        return this.getDelegate().indexOf(object, n);
    }

    protected void initialize(int n, int n2) {
        this.initialCapacity = n;
        this.capacityIncrement = n2;
        this.delegate = null;
        this.valueHolder = null;
    }

    protected void initialize(Collection collection) {
        this.delegate = null;
        Vector vector = new Vector(collection);
        this.valueHolder = new ValueHolder(vector);
    }

    public synchronized void insertElementAt(Object object, int n) {
        this.getDelegate().insertElementAt(object, n);
        this.raiseAddChangeEvent(object);
    }

    public boolean isEmpty() {
        return this.getDelegate().isEmpty();
    }

    public boolean isInstantiated() {
        return this.getValueHolder().isInstantiated();
    }

    public Iterator iterator() {
        return new Iterator(){
            Iterator delegateIterator;
            Object currentObject;
            {
                this.delegateIterator = IndirectList.this.getDelegate().iterator();
            }

            public boolean hasNext() {
                return this.delegateIterator.hasNext();
            }

            public Object next() {
                this.currentObject = this.delegateIterator.next();
                return this.currentObject;
            }

            public void remove() {
                this.delegateIterator.remove();
                IndirectList.this.raiseRemoveChangeEvent(this.currentObject);
            }
        };
    }

    public synchronized Object lastElement() {
        return this.getDelegate().lastElement();
    }

    public int lastIndexOf(Object object) {
        return this.getDelegate().lastIndexOf(object);
    }

    public synchronized int lastIndexOf(Object object, int n) {
        return this.getDelegate().lastIndexOf(object, n);
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(final int n) {
        return new ListIterator(){
            ListIterator delegateIterator;
            Object currentObject;
            {
                this.delegateIterator = IndirectList.this.getDelegate().listIterator(n);
            }

            public boolean hasNext() {
                return this.delegateIterator.hasNext();
            }

            public boolean hasPrevious() {
                return this.delegateIterator.hasPrevious();
            }

            public int previousIndex() {
                return this.delegateIterator.previousIndex();
            }

            public int nextIndex() {
                return this.delegateIterator.nextIndex();
            }

            public Object next() {
                this.currentObject = this.delegateIterator.next();
                return this.currentObject;
            }

            public Object previous() {
                this.currentObject = this.delegateIterator.previous();
                return this.currentObject;
            }

            public void remove() {
                this.delegateIterator.remove();
                IndirectList.this.raiseRemoveChangeEvent(this.currentObject);
            }

            public void set(Object object) {
                this.delegateIterator.set(object);
                IndirectList.this.raiseRemoveChangeEvent(this.currentObject);
                IndirectList.this.raiseAddChangeEvent(object);
            }

            public void add(Object object) {
                this.delegateIterator.add(object);
                IndirectList.this.raiseAddChangeEvent(object);
            }
        };
    }

    public synchronized Object remove(int n) {
        Object e = this.getDelegate().remove(n);
        this.raiseRemoveChangeEvent(e);
        return e;
    }

    public boolean remove(Object object) {
        if (this.shouldAvoidInstantiation()) {
            if (this.getAddedElements().contains(object)) {
                this.getAddedElements().remove(object);
            } else {
                if (this.getRemovedElements().contains(object)) {
                    return false;
                }
                this.getRemovedElements().add(object);
            }
            this.raiseRemoveChangeEvent(object);
            return true;
        }
        if (this.getDelegate().remove(object)) {
            this.raiseRemoveChangeEvent(object);
            return true;
        }
        return false;
    }

    public synchronized boolean removeAll(Collection collection) {
        if (this.hasBeenRegistered() || this.hasTopLinkPropertyChangeListener()) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
            return true;
        }
        return this.getDelegate().removeAll(collection);
    }

    public synchronized void removeAllElements() {
        if (this.hasBeenRegistered() || this.hasTopLinkPropertyChangeListener()) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                iterator.remove();
                this.raiseRemoveChangeEvent(e);
            }
            return;
        }
        this.getDelegate().removeAllElements();
    }

    public synchronized boolean removeElement(Object object) {
        return this.remove(object);
    }

    public synchronized void removeElementAt(int n) {
        this.remove(n);
    }

    public synchronized boolean retainAll(Collection collection) {
        if (this.hasBeenRegistered() || this.hasTopLinkPropertyChangeListener()) {
            Iterator iterator = this.getDelegate().iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (collection.contains(e)) continue;
                iterator.remove();
                this.raiseRemoveChangeEvent(e);
            }
            return true;
        }
        return this.getDelegate().retainAll(collection);
    }

    public synchronized Object set(int n, Object object) {
        Object object2 = this.getDelegate().set(n, object);
        this.raiseRemoveChangeEvent(object2);
        this.raiseAddChangeEvent(object);
        return object2;
    }

    public synchronized void setElementAt(Object object, int n) {
        this.set(n, object);
    }

    public synchronized void setSize(int n) {
        if ((this.hasBeenRegistered() || this.hasTopLinkPropertyChangeListener()) && n > this.size()) {
            for (int i = this.size(); i > n; --i) {
                this.remove(i - 1);
            }
        }
        this.getDelegate().setSize(n);
    }

    public void setValueHolder(ValueHolderInterface valueHolderInterface) {
        this.delegate = null;
        this.valueHolder = valueHolderInterface;
    }

    public int size() {
        return this.getDelegate().size();
    }

    public List subList(int n, int n2) {
        return this.getDelegate().subList(n, n2);
    }

    public synchronized Object[] toArray() {
        return this.getDelegate().toArray();
    }

    public synchronized Object[] toArray(Object[] objectArray) {
        return this.getDelegate().toArray(objectArray);
    }

    public String toString() {
        if (this.isInstantiated()) {
            return "{" + this.getDelegate().toString() + "}";
        }
        return "{" + Helper.getShortClassName(this.getClass()) + ": not instantiated}";
    }

    public synchronized void trimToSize() {
        this.getDelegate().trimToSize();
    }

    public PropertyChangeListener getTopLinkPropertyChangeListener() {
        return this.changeListener;
    }

    public boolean hasTopLinkPropertyChangeListener() {
        return this.changeListener != null;
    }

    public void setTopLinkPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeListener = propertyChangeListener;
    }

    public String getTopLinkAttributeName() {
        return this.attributeName;
    }

    public void setTopLinkAttributeName(String string) {
        this.attributeName = string;
    }

    public Collection getRemovedElements() {
        if (this.removedElements == null) {
            this.removedElements = new ArrayList();
        }
        return this.removedElements;
    }

    public Collection getAddedElements() {
        if (this.addedElements == null) {
            this.addedElements = new ArrayList();
        }
        return this.addedElements;
    }

    public boolean hasAddedElements() {
        return this.addedElements != null && !this.addedElements.isEmpty();
    }

    public boolean hasRemovedElements() {
        return this.removedElements != null && !this.removedElements.isEmpty();
    }

    public boolean hasDeferredChanges() {
        return this.hasRemovedElements() || this.hasAddedElements();
    }

    protected boolean shouldAvoidInstantiation() {
        return !this.isInstantiated() && this.getTopLinkPropertyChangeListener() instanceof AttributeChangeListener;
    }
}

