/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.expressions.ExpressionBuilder;
import oracle.toplink.expressions.ExpressionOperator;
import oracle.toplink.history.AsOfClause;
import oracle.toplink.internal.expressions.ConstantExpression;
import oracle.toplink.internal.expressions.ExpressionIterator;
import oracle.toplink.internal.expressions.ExpressionJavaPrinter;
import oracle.toplink.internal.expressions.ExpressionNormalizer;
import oracle.toplink.internal.expressions.ExpressionSQLPrinter;
import oracle.toplink.internal.expressions.FunctionExpression;
import oracle.toplink.internal.expressions.LiteralExpression;
import oracle.toplink.internal.expressions.ParameterExpression;
import oracle.toplink.internal.expressions.QueryKeyExpression;
import oracle.toplink.internal.expressions.SQLSelectStatement;
import oracle.toplink.internal.expressions.SubSelectExpression;
import oracle.toplink.internal.expressions.TableAliasLookup;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.DatabaseTable;
import oracle.toplink.internal.helper.IdentityHashtable;
import oracle.toplink.internal.helper.NonSynchronizedVector;
import oracle.toplink.internal.localization.ToStringLocalization;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.InMemoryQueryIndirectionPolicy;
import oracle.toplink.queryframework.ReportQuery;

public abstract class Expression
implements Serializable,
Cloneable {
    static final long serialVersionUID = -5979150600092006081L;
    protected transient DatabaseTable lastTable;
    protected transient DatabaseTable currentAlias;
    protected boolean selectIfOrderedBy = true;
    static /* synthetic */ Class class$oracle$toplink$internal$expressions$FunctionExpression;

    public Expression addDate(String string, int n) {
        return this.addDate(string, new Integer(n));
    }

    public Expression addDate(String string, Object object) {
        ExpressionOperator expressionOperator = this.getOperator(90);
        FunctionExpression functionExpression = new FunctionExpression();
        functionExpression.setBaseExpression(this);
        functionExpression.addChild(this);
        functionExpression.addChild(Expression.fromLiteral(string, this));
        functionExpression.addChild(Expression.from(object, this));
        functionExpression.setOperator(expressionOperator);
        return functionExpression;
    }

    public Expression addMonths(int n) {
        return this.addMonths(new Integer(n));
    }

    public Expression addMonths(Object object) {
        ExpressionOperator expressionOperator = this.getOperator(47);
        return expressionOperator.expressionFor(this, object);
    }

    public DatabaseTable aliasForTable(DatabaseTable databaseTable) {
        return null;
    }

    public Expression allOf(String string, Expression expression) {
        ReportQuery reportQuery = new ReportQuery();
        reportQuery.setShouldRetrieveFirstPrimaryKey(true);
        ExpressionBuilder expressionBuilder = expression.getBuilder();
        expression = expressionBuilder.equal(this.anyOf(string)).and(expression.not());
        reportQuery.setSelectionCriteria(expression);
        return this.notExists(reportQuery);
    }

    public Expression and(Expression expression) {
        if (expression == null) {
            return this;
        }
        ExpressionBuilder expressionBuilder = this.getBuilder();
        Expression expression2 = expression;
        if (expression.getBuilder() != expressionBuilder && (expressionBuilder == this || expression.getBuilder().getQueryClass() == null)) {
            expression2 = expression.rebuildOn(expressionBuilder);
        }
        if (expressionBuilder == this) {
            return expression2;
        }
        ExpressionOperator expressionOperator = this.getOperator(1);
        return expressionOperator.expressionFor(this, expression2);
    }

    public Expression anyOf(String string) {
        QueryKeyExpression queryKeyExpression = (QueryKeyExpression)this.get(string);
        queryKeyExpression.doQueryToManyRelationship();
        return queryKeyExpression;
    }

    public Expression anyOfAllowingNone(String string) {
        QueryKeyExpression queryKeyExpression = (QueryKeyExpression)this.getAllowingNull(string);
        queryKeyExpression.doQueryToManyRelationship();
        return queryKeyExpression;
    }

    public Expression appendSQL(String string) {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setType(5);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(1);
        ((Vector)nonSynchronizedVector).addElement(string);
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return expressionOperator.expressionFor(this);
    }

    public Expression ascending() {
        return this.getFunction(26);
    }

    public Expression asciiValue() {
        ExpressionOperator expressionOperator = this.getOperator(45);
        return expressionOperator.expressionFor(this);
    }

    public Expression asOf(AsOfClause asOfClause) {
        return this;
    }

    protected void assignAlias(String string, DatabaseTable databaseTable) {
    }

    public int assignTableAliasesStartingAt(int n) {
        if (this.hasBeenAliased()) {
            return n;
        }
        int n2 = n;
        Vector vector = this.getOwnedTables();
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.assignAlias("t" + n2, (DatabaseTable)enumeration.nextElement());
                ++n2;
            }
        }
        return n2;
    }

    public Expression average() {
        return this.getFunction(21);
    }

    public Expression between(byte by, byte by2) {
        return this.between(new Byte(by), new Byte(by2));
    }

    public Expression between(char c, char c2) {
        return this.between(new Character(c), new Character(c2));
    }

    public Expression between(double d, double d2) {
        return this.between(new Double(d), new Double(d2));
    }

    public Expression between(float f, float f2) {
        return this.between(new Float(f), new Float(f2));
    }

    public Expression between(int n, int n2) {
        return this.between(new Integer(n), new Integer(n2));
    }

    public Expression between(long l, long l2) {
        return this.between(new Long(l), new Long(l2));
    }

    public Expression between(Object object, Object object2) {
        ExpressionOperator expressionOperator = this.getOperator(15);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
        ((Vector)nonSynchronizedVector).addElement(object);
        ((Vector)nonSynchronizedVector).addElement(object2);
        return expressionOperator.expressionForArguments(this, nonSynchronizedVector);
    }

    public Expression between(Expression expression, Expression expression2) {
        return this.between((Object)expression, (Object)expression2);
    }

    public Expression between(short s, short s2) {
        return this.between(new Short(s), new Short(s2));
    }

    public Expression caseStatement(Hashtable hashtable, String string) {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setSelector(117);
        expressionOperator.setNodeClass(class$oracle$toplink$internal$expressions$FunctionExpression == null ? (class$oracle$toplink$internal$expressions$FunctionExpression = Expression.class$("oracle.toplink.internal.expressions.FunctionExpression")) : class$oracle$toplink$internal$expressions$FunctionExpression);
        expressionOperator.setType(5);
        expressionOperator.bePrefix();
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(hashtable.size() + 1);
        ((Vector)nonSynchronizedVector).addElement("CASE ");
        FunctionExpression functionExpression = new FunctionExpression();
        functionExpression.setBaseExpression(this);
        functionExpression.addChild(this);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            functionExpression.addChild(Expression.from(k, this));
            functionExpression.addChild(Expression.from(hashtable.get(k), this));
            ((Vector)nonSynchronizedVector).addElement(" WHEN ");
            ((Vector)nonSynchronizedVector).addElement(" THEN ");
        }
        ((Vector)nonSynchronizedVector).addElement(" ELSE ");
        functionExpression.addChild(Expression.from(string, this));
        ((Vector)nonSynchronizedVector).addElement(" END");
        expressionOperator.printsAs(nonSynchronizedVector);
        functionExpression.setOperator(expressionOperator);
        return functionExpression;
    }

    public Object clone() {
        IdentityHashtable identityHashtable = new IdentityHashtable();
        return this.copiedVersionFrom(identityHashtable);
    }

    public Expression cloneUsing(Expression expression) {
        IdentityHashtable identityHashtable = new IdentityHashtable();
        ((Dictionary)identityHashtable).put(identityHashtable, expression);
        return this.copiedVersionFrom(identityHashtable);
    }

    public Expression concat(Object object) {
        ExpressionOperator expressionOperator = this.getOperator(31);
        return expressionOperator.expressionFor(this, object);
    }

    public Expression containsAllKeyWords(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        Expression expression = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (expression == null) {
                expression = this.containsSubstringIgnoringCase(string2);
                continue;
            }
            expression = expression.and(this.containsSubstringIgnoringCase(string2));
        }
        if (expression == null) {
            return this.like("%");
        }
        return expression;
    }

    public Expression containsAnyKeyWords(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        Expression expression = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (expression == null) {
                expression = this.containsSubstringIgnoringCase(string2);
                continue;
            }
            expression = expression.or(this.containsSubstringIgnoringCase(string2));
        }
        if (expression == null) {
            return this.like("%");
        }
        return expression;
    }

    public Expression containsSubstring(String string) {
        return this.like("%" + string + "%");
    }

    public Expression containsSubstring(Expression expression) {
        return this.like(this.value("%").concat(expression).concat("%"));
    }

    public Expression containsSubstringIgnoringCase(String string) {
        return this.toUpperCase().containsSubstring(string.toUpperCase());
    }

    public Expression containsSubstringIgnoringCase(Expression expression) {
        return this.toUpperCase().containsSubstring(expression.toUpperCase());
    }

    protected void convertNodeToUseOuterJoin() {
    }

    public Expression convertToUseOuterJoin() {
        ExpressionIterator expressionIterator = new ExpressionIterator(){

            public void iterate(Expression expression) {
                expression.convertNodeToUseOuterJoin();
            }
        };
        expressionIterator.iterateOn(this);
        return this;
    }

    public Expression copiedVersionFrom(Dictionary dictionary) {
        Expression expression = (Expression)dictionary.get(this);
        if (expression == null) {
            return this.registerIn(dictionary);
        }
        return expression;
    }

    public Expression count() {
        return this.getFunction(19);
    }

    public Expression create(Expression expression, Object object, ExpressionOperator expressionOperator) {
        return this;
    }

    public Expression create(Expression expression, Vector vector, ExpressionOperator expressionOperator) {
        return this;
    }

    public Expression currentDate() {
        return this.getFunction(54);
    }

    public Expression dateDifference(String string, Date date) {
        ExpressionOperator expressionOperator = this.getOperator(94);
        FunctionExpression functionExpression = new FunctionExpression();
        functionExpression.setBaseExpression(this);
        functionExpression.addChild(Expression.fromLiteral(string, this));
        functionExpression.addChild(Expression.from(date, this));
        functionExpression.addChild(this);
        functionExpression.setOperator(expressionOperator);
        return functionExpression;
    }

    public Expression dateDifference(String string, Expression expression) {
        ExpressionOperator expressionOperator = this.getOperator(94);
        FunctionExpression functionExpression = new FunctionExpression();
        functionExpression.setBaseExpression(this);
        functionExpression.addChild(Expression.fromLiteral(string, this));
        functionExpression.addChild(expression);
        functionExpression.addChild(this);
        functionExpression.setOperator(expressionOperator);
        return functionExpression;
    }

    public Expression dateName(String string) {
        ExpressionOperator expressionOperator = this.getOperator(92);
        FunctionExpression functionExpression = new FunctionExpression();
        functionExpression.setBaseExpression(this);
        functionExpression.addChild(Expression.fromLiteral(string, this));
        functionExpression.addChild(this);
        functionExpression.setOperator(expressionOperator);
        return functionExpression;
    }

    public Expression datePart(String string) {
        ExpressionOperator expressionOperator = this.getOperator(93);
        FunctionExpression functionExpression = new FunctionExpression();
        functionExpression.setBaseExpression(this);
        functionExpression.addChild(Expression.fromLiteral(string, this));
        functionExpression.addChild(this);
        functionExpression.setOperator(expressionOperator);
        return functionExpression;
    }

    public Expression dateToString() {
        ExpressionOperator expressionOperator = this.getOperator(48);
        return expressionOperator.expressionFor(this);
    }

    public Expression decode(Hashtable hashtable, String string) {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setSelector(105);
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        expressionOperator.setType(5);
        expressionOperator.bePrefix();
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(hashtable.size() + 1);
        ((Vector)nonSynchronizedVector).addElement("DECODE(");
        for (int i = 0; i < hashtable.size() * 2 + 1; ++i) {
            ((Vector)nonSynchronizedVector).addElement(", ");
        }
        ((Vector)nonSynchronizedVector).addElement(")");
        expressionOperator.printsAs(nonSynchronizedVector);
        FunctionExpression functionExpression = new FunctionExpression();
        functionExpression.setBaseExpression(this);
        functionExpression.addChild(this);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            functionExpression.addChild(Expression.from(k, this));
            functionExpression.addChild(Expression.from(hashtable.get(k), this));
        }
        functionExpression.addChild(Expression.from(string, this));
        functionExpression.setOperator(expressionOperator);
        return functionExpression;
    }

    public Expression descending() {
        return this.getFunction(27);
    }

    public String descriptionOfNodeType() {
        return "Expression";
    }

    public Expression difference(String string) {
        ExpressionOperator expressionOperator = this.getOperator(98);
        return expressionOperator.expressionFor(this, string);
    }

    public Expression distinct() {
        return this.getFunction(87);
    }

    public boolean doesConform(Object object, Session session, DatabaseRow databaseRow, InMemoryQueryIndirectionPolicy inMemoryQueryIndirectionPolicy) throws QueryException {
        return this.doesConform(object, session, databaseRow, inMemoryQueryIndirectionPolicy, false);
    }

    public boolean doesConform(Object object, Session session, DatabaseRow databaseRow, InMemoryQueryIndirectionPolicy inMemoryQueryIndirectionPolicy, boolean bl) throws QueryException {
        throw QueryException.cannotConformExpression();
    }

    public Expression equal(byte by) {
        return this.equal(new Byte(by));
    }

    public Expression equal(char c) {
        return this.equal(new Character(c));
    }

    public Expression equal(double d) {
        return this.equal(new Double(d));
    }

    public Expression equal(float f) {
        return this.equal(new Float(f));
    }

    public Expression equal(int n) {
        return this.equal(new Integer(n));
    }

    public Expression equal(long l) {
        return this.equal(new Long(l));
    }

    public Expression equal(Object object) {
        ExpressionOperator expressionOperator = this.getOperator(4);
        return expressionOperator.expressionFor(this, object);
    }

    public Expression equal(Expression expression) {
        ExpressionOperator expressionOperator = this.getOperator(4);
        return expressionOperator.expressionFor(this, expression);
    }

    public Expression equal(short s) {
        return this.equal(new Short(s));
    }

    public Expression equal(boolean bl) {
        return this.equal(new Boolean(bl));
    }

    public Expression equalOuterJoin(Object object) {
        ExpressionOperator expressionOperator = this.getOperator(6);
        return expressionOperator.expressionFor(this, object);
    }

    public Expression equalOuterJoin(Expression expression) {
        ExpressionOperator expressionOperator = this.getOperator(6);
        return expressionOperator.expressionFor(this, expression);
    }

    public Expression equalsIgnoreCase(String string) {
        return this.toUpperCase().equal(string.toUpperCase());
    }

    public Expression equalsIgnoreCase(Expression expression) {
        return this.toUpperCase().equal(expression.toUpperCase());
    }

    public Expression exists(ReportQuery reportQuery) {
        ExpressionOperator expressionOperator = this.getOperator(86);
        return expressionOperator.expressionFor(this.subQuery(reportQuery));
    }

    public boolean extractPrimaryKeyValues(boolean bl, Descriptor descriptor, DatabaseRow databaseRow, DatabaseRow databaseRow2) {
        return false;
    }

    public static Expression from(Object object, Expression expression) {
        if (object instanceof Expression) {
            Expression expression2 = (Expression)object;
            if (expression2.isValueExpression()) {
                expression2.setLocalBase(expression);
            } else {
                expression.setLocalBase(expression2);
            }
            return expression2;
        }
        if (object instanceof ReportQuery) {
            Expression expression3 = expression.subQuery((ReportQuery)object);
            expression3.setLocalBase(expression);
            expression.setLocalBase(expression3);
            return expression3;
        }
        return Expression.fromConstant(object, expression);
    }

    public static Expression fromConstant(Object object, Expression expression) {
        return new ConstantExpression(object, expression);
    }

    public static Expression fromLiteral(String string, Expression expression) {
        return new LiteralExpression(string, expression);
    }

    public Expression get(String string) {
        return this.get(string, null);
    }

    public Expression get(String string, Vector vector) {
        return null;
    }

    public Expression getAllowingNull(String string) {
        return this.getAllowingNull(string, null);
    }

    public Expression getAllowingNull(String string, Vector vector) {
        return this.get(string, vector);
    }

    public AsOfClause getAsOfClause() {
        return null;
    }

    public AsOfClause getAsOfClauseRecursively() {
        return null;
    }

    public abstract ExpressionBuilder getBuilder();

    public DatabaseField getClonedField() {
        return null;
    }

    public Expression getField(String string) {
        throw QueryException.illegalUseOfGetField(string);
    }

    public Expression getField(DatabaseField databaseField) {
        throw QueryException.illegalUseOfGetField(databaseField);
    }

    public Vector getFields() {
        return NonSynchronizedVector.newInstance(1);
    }

    public Object getFieldValue(Object object) {
        return object;
    }

    public Expression getFunction(int n) {
        ExpressionOperator expressionOperator = this.getOperator(n);
        return expressionOperator.expressionFor(this);
    }

    public Expression getFunction(int n, Vector vector) {
        ExpressionOperator expressionOperator = this.getOperator(n);
        return expressionOperator.expressionForArguments(this, vector);
    }

    public Expression getFunction(String string) {
        ExpressionOperator expressionOperator = ExpressionOperator.simpleFunction(0, string);
        return expressionOperator.expressionFor(this);
    }

    public Expression getFunction(String string, Object object) {
        ExpressionOperator expressionOperator = ExpressionOperator.simpleTwoArgumentFunction(0, string);
        return expressionOperator.expressionFor(this, object);
    }

    public Expression getFunctionWithArguments(String string, Vector vector) {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setType(5);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(vector.size());
        ((Vector)nonSynchronizedVector).addElement(string + "(");
        for (int i = 0; i < vector.size(); ++i) {
            ((Vector)nonSynchronizedVector).addElement(", ");
        }
        ((Vector)nonSynchronizedVector).addElement(")");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return expressionOperator.expressionForArguments(this, vector);
    }

    public String getName() {
        return "";
    }

    public ExpressionOperator getOperator() {
        return null;
    }

    public ExpressionOperator getOperator(int n) {
        ExpressionOperator expressionOperator = ExpressionOperator.getOperator(new Integer(n));
        if (expressionOperator != null) {
            return expressionOperator;
        }
        expressionOperator = new ExpressionOperator();
        expressionOperator.setSelector(n);
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return expressionOperator;
    }

    public Vector getOwnedTables() {
        return null;
    }

    public Expression getParameter(String string) {
        return new ParameterExpression(string, this);
    }

    public Expression getParameter(DatabaseField databaseField) {
        return new ParameterExpression(databaseField, this);
    }

    public Session getSession() {
        return this.getBuilder().getSession();
    }

    public Expression getTable(String string) {
        DatabaseTable databaseTable = new DatabaseTable(string);
        return this.getTable(databaseTable);
    }

    public Expression getTable(DatabaseTable databaseTable) {
        throw QueryException.illegalUseOfGetTable(databaseTable);
    }

    public TableAliasLookup getTableAliases() {
        return null;
    }

    public Expression greaterThan(byte by) {
        return this.greaterThan(new Byte(by));
    }

    public Expression greaterThan(char c) {
        return this.greaterThan(new Character(c));
    }

    public Expression greaterThan(double d) {
        return this.greaterThan(new Double(d));
    }

    public Expression greaterThan(float f) {
        return this.greaterThan(new Float(f));
    }

    public Expression greaterThan(int n) {
        return this.greaterThan(new Integer(n));
    }

    public Expression greaterThan(long l) {
        return this.greaterThan(new Long(l));
    }

    public Expression greaterThan(Object object) {
        ExpressionOperator expressionOperator = this.getOperator(9);
        return expressionOperator.expressionFor(this, object);
    }

    public Expression greaterThan(Expression expression) {
        ExpressionOperator expressionOperator = this.getOperator(9);
        return expressionOperator.expressionFor(this, expression);
    }

    public Expression greaterThan(short s) {
        return this.greaterThan(new Short(s));
    }

    public Expression greaterThan(boolean bl) {
        return this.greaterThan(new Boolean(bl));
    }

    public Expression greaterThanEqual(byte by) {
        return this.greaterThanEqual(new Byte(by));
    }

    public Expression greaterThanEqual(char c) {
        return this.greaterThanEqual(new Character(c));
    }

    public Expression greaterThanEqual(double d) {
        return this.greaterThanEqual(new Double(d));
    }

    public Expression greaterThanEqual(float f) {
        return this.greaterThanEqual(new Float(f));
    }

    public Expression greaterThanEqual(int n) {
        return this.greaterThanEqual(new Integer(n));
    }

    public Expression greaterThanEqual(long l) {
        return this.greaterThanEqual(new Long(l));
    }

    public Expression greaterThanEqual(Object object) {
        ExpressionOperator expressionOperator = this.getOperator(10);
        return expressionOperator.expressionFor(this, object);
    }

    public Expression greaterThanEqual(Expression expression) {
        ExpressionOperator expressionOperator = this.getOperator(10);
        return expressionOperator.expressionFor(this, expression);
    }

    public Expression greaterThanEqual(short s) {
        return this.greaterThanEqual(new Short(s));
    }

    public Expression greaterThanEqual(boolean bl) {
        return this.greaterThanEqual(new Boolean(bl));
    }

    public boolean hasAsOfClause() {
        return false;
    }

    public boolean hasBeenAliased() {
        return false;
    }

    public Expression hexToRaw() {
        ExpressionOperator expressionOperator = this.getOperator(32);
        return expressionOperator.expressionFor(this);
    }

    public Expression ifNull(Object object) {
        ExpressionOperator expressionOperator = this.getOperator(104);
        return expressionOperator.expressionFor(this, object);
    }

    public Expression in(byte[] byArray) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
        for (int i = 0; i < byArray.length; ++i) {
            ((Vector)nonSynchronizedVector).addElement(new Byte(byArray[i]));
        }
        return this.in(nonSynchronizedVector);
    }

    public Expression in(char[] cArray) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
        for (int i = 0; i < cArray.length; ++i) {
            ((Vector)nonSynchronizedVector).addElement(new Character(cArray[i]));
        }
        return this.in(nonSynchronizedVector);
    }

    public Expression in(double[] dArray) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
        for (int i = 0; i < dArray.length; ++i) {
            ((Vector)nonSynchronizedVector).addElement(new Double(dArray[i]));
        }
        return this.in(nonSynchronizedVector);
    }

    public Expression in(float[] fArray) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
        for (int i = 0; i < fArray.length; ++i) {
            ((Vector)nonSynchronizedVector).addElement(new Float(fArray[i]));
        }
        return this.in(nonSynchronizedVector);
    }

    public Expression in(int[] nArray) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
        for (int i = 0; i < nArray.length; ++i) {
            ((Vector)nonSynchronizedVector).addElement(new Integer(nArray[i]));
        }
        return this.in(nonSynchronizedVector);
    }

    public Expression in(long[] lArray) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
        for (int i = 0; i < lArray.length; ++i) {
            ((Vector)nonSynchronizedVector).addElement(new Long(lArray[i]));
        }
        return this.in(nonSynchronizedVector);
    }

    public Expression in(Object[] objectArray) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
        for (int i = 0; i < objectArray.length; ++i) {
            ((Vector)nonSynchronizedVector).addElement(objectArray[i]);
        }
        return this.in(nonSynchronizedVector);
    }

    public Expression in(short[] sArray) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
        for (int i = 0; i < sArray.length; ++i) {
            ((Vector)nonSynchronizedVector).addElement(new Short(sArray[i]));
        }
        return this.in(nonSynchronizedVector);
    }

    public Expression in(boolean[] blArray) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
        for (int i = 0; i < blArray.length; ++i) {
            ((Vector)nonSynchronizedVector).addElement(new Boolean(blArray[i]));
        }
        return this.in(nonSynchronizedVector);
    }

    public Expression in(Vector vector) {
        return this.in(new ConstantExpression(vector, this));
    }

    public Expression in(Expression expression) {
        ExpressionOperator expressionOperator = this.getOperator(13);
        return expressionOperator.expressionFor(this, expression);
    }

    public Expression in(ReportQuery reportQuery) {
        return this.in(this.subQuery(reportQuery));
    }

    public Expression indexOf(Object object) {
        ExpressionOperator expressionOperator = this.getOperator(34);
        return expressionOperator.expressionFor(this, object);
    }

    public boolean isCompoundExpression() {
        return false;
    }

    public boolean isConstantExpression() {
        return false;
    }

    public boolean isDataExpression() {
        return false;
    }

    public Expression isEmpty(String string) {
        return this.size(string).equal(0);
    }

    public boolean isExpressionBuilder() {
        return false;
    }

    public boolean isFieldExpression() {
        return false;
    }

    public boolean isFunctionExpression() {
        return false;
    }

    public boolean isLiteralExpression() {
        return false;
    }

    public boolean isLogicalExpression() {
        return false;
    }

    public Expression isNull() {
        ExpressionOperator expressionOperator = this.getOperator(17);
        return expressionOperator.expressionFor(this);
    }

    public boolean isObjectExpression() {
        return false;
    }

    public boolean isParameterExpression() {
        return false;
    }

    public boolean isQueryKeyExpression() {
        return false;
    }

    public boolean isRelationExpression() {
        return false;
    }

    public boolean isTableExpression() {
        return false;
    }

    public boolean isValueExpression() {
        return false;
    }

    public void iterateOn(ExpressionIterator expressionIterator) {
        expressionIterator.iterate(this);
    }

    public Expression lastDay() {
        ExpressionOperator expressionOperator = this.getOperator(49);
        return expressionOperator.expressionFor(this);
    }

    public Expression leftPad(int n, Object object) {
        return this.leftPad(new Integer(n), object);
    }

    public Expression leftPad(Object object, Object object2) {
        ExpressionOperator expressionOperator = this.getOperator(36);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(2);
        ((Vector)nonSynchronizedVector).addElement(object);
        ((Vector)nonSynchronizedVector).addElement(object2);
        return expressionOperator.expressionForArguments(this, nonSynchronizedVector);
    }

    public Expression leftTrim() {
        ExpressionOperator expressionOperator = this.getOperator(37);
        return expressionOperator.expressionFor(this);
    }

    public Expression length() {
        ExpressionOperator expressionOperator = this.getOperator(46);
        return expressionOperator.expressionFor(this);
    }

    public Expression lessThan(byte by) {
        return this.lessThan(new Byte(by));
    }

    public Expression lessThan(char c) {
        return this.lessThan(new Character(c));
    }

    public Expression lessThan(double d) {
        return this.lessThan(new Double(d));
    }

    public Expression lessThan(float f) {
        return this.lessThan(new Float(f));
    }

    public Expression lessThan(int n) {
        return this.lessThan(new Integer(n));
    }

    public Expression lessThan(long l) {
        return this.lessThan(new Long(l));
    }

    public Expression lessThan(Object object) {
        ExpressionOperator expressionOperator = this.getOperator(7);
        return expressionOperator.expressionFor(this, object);
    }

    public Expression lessThan(Expression expression) {
        ExpressionOperator expressionOperator = this.getOperator(7);
        return expressionOperator.expressionFor(this, expression);
    }

    public Expression lessThan(short s) {
        return this.lessThan(new Short(s));
    }

    public Expression lessThan(boolean bl) {
        return this.lessThan(new Boolean(bl));
    }

    public Expression lessThanEqual(byte by) {
        return this.lessThanEqual(new Byte(by));
    }

    public Expression lessThanEqual(char c) {
        return this.lessThanEqual(new Character(c));
    }

    public Expression lessThanEqual(double d) {
        return this.lessThanEqual(new Double(d));
    }

    public Expression lessThanEqual(float f) {
        return this.lessThanEqual(new Float(f));
    }

    public Expression lessThanEqual(int n) {
        return this.lessThanEqual(new Integer(n));
    }

    public Expression lessThanEqual(long l) {
        return this.lessThanEqual(new Long(l));
    }

    public Expression lessThanEqual(Object object) {
        ExpressionOperator expressionOperator = this.getOperator(8);
        return expressionOperator.expressionFor(this, object);
    }

    public Expression lessThanEqual(Expression expression) {
        ExpressionOperator expressionOperator = this.getOperator(8);
        return expressionOperator.expressionFor(this, expression);
    }

    public Expression lessThanEqual(short s) {
        return this.lessThanEqual(new Short(s));
    }

    public Expression lessThanEqual(boolean bl) {
        return this.lessThanEqual(new Boolean(bl));
    }

    public Expression like(String string) {
        return this.like(new ConstantExpression(string, this));
    }

    public Expression like(String string, String string2) {
        ExpressionOperator expressionOperator = this.getOperator(89);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
        ((Vector)nonSynchronizedVector).addElement(string);
        ((Vector)nonSynchronizedVector).addElement(string2);
        return expressionOperator.expressionForArguments(this, nonSynchronizedVector);
    }

    public Expression like(Expression expression) {
        ExpressionOperator expressionOperator = this.getOperator(11);
        return expressionOperator.expressionFor(this, expression);
    }

    public Expression likeIgnoreCase(String string) {
        return this.toUpperCase().like(string.toUpperCase());
    }

    public Expression likeIgnoreCase(Expression expression) {
        return this.toUpperCase().like(expression.toUpperCase());
    }

    public Expression locate(Object object) {
        ExpressionOperator expressionOperator = this.getOperator(112);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(1);
        ((Vector)nonSynchronizedVector).addElement(object);
        return expressionOperator.expressionForArguments(this, nonSynchronizedVector);
    }

    public Expression locate(String string, int n) {
        return this.locate((Object)string, new Integer(n));
    }

    public Expression locate(Object object, Object object2) {
        ExpressionOperator expressionOperator = this.getOperator(113);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(2);
        ((Vector)nonSynchronizedVector).addElement(object);
        ((Vector)nonSynchronizedVector).addElement(object2);
        return expressionOperator.expressionForArguments(this, nonSynchronizedVector);
    }

    public Expression maximum() {
        return this.getFunction(22);
    }

    public Expression minimum() {
        return this.getFunction(23);
    }

    public Expression monthsBetween(Object object) {
        ExpressionOperator expressionOperator = this.getOperator(50);
        return expressionOperator.expressionFor(this, object);
    }

    public Expression newTime(String string, String string2) {
        ExpressionOperator expressionOperator = this.getOperator(103);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
        ((Vector)nonSynchronizedVector).addElement(string);
        ((Vector)nonSynchronizedVector).addElement(string2);
        return expressionOperator.expressionForArguments(this, nonSynchronizedVector);
    }

    public Expression nextDay(Object object) {
        ExpressionOperator expressionOperator = this.getOperator(51);
        return expressionOperator.expressionFor(this, object);
    }

    public Expression noneOf(String string, Expression expression) {
        ReportQuery reportQuery = new ReportQuery();
        reportQuery.setShouldRetrieveFirstPrimaryKey(true);
        ExpressionBuilder expressionBuilder = expression.getBuilder();
        expression = expressionBuilder.equal(this.anyOf(string)).and(expression);
        reportQuery.setSelectionCriteria(expression);
        return this.notExists(reportQuery);
    }

    public Expression normalize(ExpressionNormalizer expressionNormalizer) {
        this.validateNode();
        return this;
    }

    public Expression not() {
        ExpressionOperator expressionOperator = this.getOperator(3);
        return expressionOperator.expressionFor(this);
    }

    public Expression notBetween(byte by, byte by2) {
        return this.notBetween(new Byte(by), new Byte(by2));
    }

    public Expression notBetween(char c, char c2) {
        return this.notBetween(new Character(c), new Character(c2));
    }

    public Expression notBetween(double d, double d2) {
        return this.notBetween(new Double(d), new Double(d2));
    }

    public Expression notBetween(float f, float f2) {
        return this.notBetween(new Float(f), new Float(f2));
    }

    public Expression notBetween(int n, int n2) {
        return this.notBetween(new Integer(n), new Integer(n2));
    }

    public Expression notBetween(long l, long l2) {
        return this.notBetween(new Long(l), new Long(l2));
    }

    public Expression notBetween(Object object, Object object2) {
        return this.between(object, object2).not();
    }

    public Expression notBetween(Expression expression, Expression expression2) {
        return this.between(expression, expression2).not();
    }

    public Expression notBetween(short s, short s2) {
        return this.notBetween(new Short(s), new Short(s2));
    }

    public Expression notEmpty(String string) {
        return this.size(string).greaterThan(0);
    }

    public Expression notEqual(byte by) {
        return this.notEqual(new Byte(by));
    }

    public Expression notEqual(char c) {
        return this.notEqual(new Character(c));
    }

    public Expression notEqual(double d) {
        return this.notEqual(new Double(d));
    }

    public Expression notEqual(float f) {
        return this.notEqual(new Float(f));
    }

    public Expression notEqual(int n) {
        return this.notEqual(new Integer(n));
    }

    public Expression notEqual(long l) {
        return this.notEqual(new Long(l));
    }

    public Expression notEqual(Object object) {
        ExpressionOperator expressionOperator = this.getOperator(5);
        return expressionOperator.expressionFor(this, object);
    }

    public Expression notEqual(Expression expression) {
        ExpressionOperator expressionOperator = this.getOperator(5);
        return expressionOperator.expressionFor(this, expression);
    }

    public Expression notEqual(short s) {
        return this.notEqual(new Short(s));
    }

    public Expression notEqual(boolean bl) {
        return this.notEqual(new Boolean(bl));
    }

    public Expression notExists(ReportQuery reportQuery) {
        ExpressionOperator expressionOperator = this.getOperator(88);
        return expressionOperator.expressionFor(this.subQuery(reportQuery));
    }

    public Expression notIn(byte[] byArray) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
        for (int i = 0; i < byArray.length; ++i) {
            ((Vector)nonSynchronizedVector).addElement(new Byte(byArray[i]));
        }
        return this.notIn(nonSynchronizedVector);
    }

    public Expression notIn(char[] cArray) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
        for (int i = 0; i < cArray.length; ++i) {
            ((Vector)nonSynchronizedVector).addElement(new Character(cArray[i]));
        }
        return this.notIn(nonSynchronizedVector);
    }

    public Expression notIn(double[] dArray) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
        for (int i = 0; i < dArray.length; ++i) {
            ((Vector)nonSynchronizedVector).addElement(new Double(dArray[i]));
        }
        return this.notIn(nonSynchronizedVector);
    }

    public Expression notIn(float[] fArray) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
        for (int i = 0; i < fArray.length; ++i) {
            ((Vector)nonSynchronizedVector).addElement(new Float(fArray[i]));
        }
        return this.notIn(nonSynchronizedVector);
    }

    public Expression notIn(int[] nArray) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
        for (int i = 0; i < nArray.length; ++i) {
            ((Vector)nonSynchronizedVector).addElement(new Integer(nArray[i]));
        }
        return this.notIn(nonSynchronizedVector);
    }

    public Expression notIn(long[] lArray) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
        for (int i = 0; i < lArray.length; ++i) {
            ((Vector)nonSynchronizedVector).addElement(new Long(lArray[i]));
        }
        return this.notIn(nonSynchronizedVector);
    }

    public Expression notIn(Object[] objectArray) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
        for (int i = 0; i < objectArray.length; ++i) {
            ((Vector)nonSynchronizedVector).addElement(objectArray[i]);
        }
        return this.notIn(nonSynchronizedVector);
    }

    public Expression notIn(ReportQuery reportQuery) {
        return this.notIn(this.subQuery(reportQuery));
    }

    public Expression notIn(short[] sArray) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
        for (int i = 0; i < sArray.length; ++i) {
            ((Vector)nonSynchronizedVector).addElement(new Short(sArray[i]));
        }
        return this.notIn(nonSynchronizedVector);
    }

    public Expression notIn(boolean[] blArray) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
        for (int i = 0; i < blArray.length; ++i) {
            ((Vector)nonSynchronizedVector).addElement(new Boolean(blArray[i]));
        }
        return this.notIn(nonSynchronizedVector);
    }

    public Expression notIn(Vector vector) {
        return this.notIn(new ConstantExpression(vector, this));
    }

    public Expression notIn(Expression expression) {
        ExpressionOperator expressionOperator = this.getOperator(14);
        return expressionOperator.expressionFor(this, expression);
    }

    public Expression notLike(String string) {
        return this.notLike(new ConstantExpression(string, this));
    }

    public Expression notLike(Expression expression) {
        ExpressionOperator expressionOperator = this.getOperator(12);
        return expressionOperator.expressionFor(this, expression);
    }

    public Expression notNull() {
        ExpressionOperator expressionOperator = this.getOperator(18);
        return expressionOperator.expressionFor(this);
    }

    public Expression or(Expression expression) {
        if (expression == null) {
            return this;
        }
        ExpressionBuilder expressionBuilder = this.getBuilder();
        Expression expression2 = expression;
        if (expression.getBuilder() != expressionBuilder && expression.getBuilder().getQueryClass() == null) {
            expression2 = expression.rebuildOn(expressionBuilder);
        }
        if (expressionBuilder == this) {
            return expression2;
        }
        ExpressionOperator expressionOperator = this.getOperator(2);
        return expressionOperator.expressionFor(this, expression2);
    }

    public Expression performOperator(ExpressionOperator expressionOperator, Vector vector) {
        return expressionOperator.expressionForArguments(this, vector);
    }

    protected void postCopyIn(Dictionary dictionary) {
    }

    public Expression postfixSQL(String string) {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setType(5);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(1);
        ((Vector)nonSynchronizedVector).addElement(string);
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePostfix();
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return expressionOperator.expressionFor(this);
    }

    public Expression prefixSQL(String string) {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setType(5);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(1);
        ((Vector)nonSynchronizedVector).addElement(string);
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return expressionOperator.expressionFor(this);
    }

    public abstract void printSQL(ExpressionSQLPrinter var1);

    public void printJava(ExpressionJavaPrinter expressionJavaPrinter) {
    }

    public void printSQLWithoutConversion(ExpressionSQLPrinter expressionSQLPrinter) {
        this.printSQL(expressionSQLPrinter);
    }

    public abstract Expression rebuildOn(Expression var1);

    public Expression ref() {
        return this.getFunction(83);
    }

    protected Expression registerIn(Dictionary dictionary) {
        Expression expression = this.shallowClone();
        dictionary.put(this, expression);
        expression.postCopyIn(dictionary);
        return expression;
    }

    public Expression replace(Object object, Object object2) {
        ExpressionOperator expressionOperator = this.getOperator(38);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(2);
        ((Vector)nonSynchronizedVector).addElement(object);
        ((Vector)nonSynchronizedVector).addElement(object2);
        return expressionOperator.expressionForArguments(this, nonSynchronizedVector);
    }

    public Expression replicate(int n) {
        return this.replicate(new Integer(n));
    }

    public Expression replicate(Object object) {
        ExpressionOperator expressionOperator = this.getOperator(100);
        return expressionOperator.expressionFor(this, object);
    }

    protected void resetCache() {
    }

    public Expression reverse() {
        return this.getFunction(99);
    }

    public Expression right(int n) {
        return this.right(new Integer(n));
    }

    public Expression right(Object object) {
        ExpressionOperator expressionOperator = this.getOperator(101);
        return expressionOperator.expressionFor(this, object);
    }

    public Expression rightPad(int n, Object object) {
        return this.rightPad(new Integer(n), object);
    }

    public Expression rightPad(Object object, Object object2) {
        ExpressionOperator expressionOperator = this.getOperator(39);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(2);
        ((Vector)nonSynchronizedVector).addElement(object);
        ((Vector)nonSynchronizedVector).addElement(object2);
        return expressionOperator.expressionForArguments(this, nonSynchronizedVector);
    }

    public Expression rightTrim() {
        ExpressionOperator expressionOperator = this.getOperator(40);
        return expressionOperator.expressionFor(this);
    }

    public Expression rightTrim(Object object) {
        ExpressionOperator expressionOperator = this.getOperator(116);
        return expressionOperator.expressionFor(this, object);
    }

    public Expression roundDate(Object object) {
        ExpressionOperator expressionOperator = this.getOperator(52);
        return expressionOperator.expressionFor(this, object);
    }

    public boolean selectIfOrderedBy() {
        return this.selectIfOrderedBy;
    }

    public void setLocalBase(Expression expression) {
    }

    public void setSelectIfOrderedBy(boolean bl) {
        this.selectIfOrderedBy = bl;
    }

    public Expression shallowClone() {
        Expression expression = null;
        try {
            expression = (Expression)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return expression;
    }

    public Expression size(String string) {
        ReportQuery reportQuery = new ReportQuery();
        reportQuery.addCount();
        reportQuery.setSelectionCriteria(reportQuery.getExpressionBuilder().equal(this.anyOf(string)));
        return this.subQuery(reportQuery);
    }

    public Expression standardDeviation() {
        return this.getFunction(24);
    }

    public Expression subQuery(ReportQuery reportQuery) {
        return new SubSelectExpression(reportQuery, this);
    }

    public Expression substring(int n, int n2) {
        return this.substring(new Integer(n), new Integer(n2));
    }

    public Expression substring(Object object, Object object2) {
        ExpressionOperator expressionOperator = this.getOperator(41);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(2);
        ((Vector)nonSynchronizedVector).addElement(object);
        ((Vector)nonSynchronizedVector).addElement(object2);
        return expressionOperator.expressionForArguments(this, nonSynchronizedVector);
    }

    public Expression sum() {
        return this.getFunction(20);
    }

    public Expression toCharacter() {
        ExpressionOperator expressionOperator = this.getOperator(30);
        return expressionOperator.expressionFor(this);
    }

    public Expression toDate() {
        ExpressionOperator expressionOperator = this.getOperator(53);
        return expressionOperator.expressionFor(this);
    }

    public Expression toChar() {
        ExpressionOperator expressionOperator = this.getOperator(114);
        return expressionOperator.expressionFor(this);
    }

    public Expression toChar(String string) {
        ExpressionOperator expressionOperator = this.getOperator(115);
        return expressionOperator.expressionFor(this, string);
    }

    public Expression toLowerCase() {
        ExpressionOperator expressionOperator = this.getOperator(29);
        return expressionOperator.expressionFor(this);
    }

    public Expression toNumber() {
        ExpressionOperator expressionOperator = this.getOperator(42);
        return expressionOperator.expressionFor(this);
    }

    public String toString() {
        try {
            StringWriter stringWriter = new StringWriter();
            BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
            this.toString(bufferedWriter, 0);
            bufferedWriter.flush();
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            return ToStringLocalization.buildMessage("error_printing_expression", null);
        }
    }

    public void toString(BufferedWriter bufferedWriter, int n) throws IOException {
        bufferedWriter.newLine();
        for (int i = 0; i < n; ++i) {
            bufferedWriter.write("   ");
        }
        bufferedWriter.write(this.descriptionOfNodeType());
        bufferedWriter.write(" ");
        this.writeDescriptionOn(bufferedWriter);
        this.writeSubexpressionsTo(bufferedWriter, n + 1);
    }

    public Expression toUpperCase() {
        ExpressionOperator expressionOperator = this.getOperator(28);
        return expressionOperator.expressionFor(this);
    }

    public Expression toUppercaseCasedWords() {
        ExpressionOperator expressionOperator = this.getOperator(33);
        return expressionOperator.expressionFor(this);
    }

    public Expression translate(Object object, Object object2) {
        ExpressionOperator expressionOperator = this.getOperator(43);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(2);
        ((Vector)nonSynchronizedVector).addElement(object);
        ((Vector)nonSynchronizedVector).addElement(object2);
        return expressionOperator.expressionForArguments(this, nonSynchronizedVector);
    }

    public Expression trim() {
        ExpressionOperator expressionOperator = this.getOperator(44);
        return expressionOperator.expressionFor(this);
    }

    public Expression extract(String string) {
        ExpressionOperator expressionOperator = this.getOperator(106);
        return expressionOperator.expressionFor(this, string);
    }

    public Expression extractValue(String string) {
        ExpressionOperator expressionOperator = this.getOperator(107);
        return expressionOperator.expressionFor(this, string);
    }

    public Expression existsNode(String string) {
        ExpressionOperator expressionOperator = this.getOperator(108);
        return expressionOperator.expressionFor(this, string);
    }

    public Expression isFragment() {
        ExpressionOperator expressionOperator = this.getOperator(111);
        return expressionOperator.expressionFor(this);
    }

    public Expression getStringVal() {
        ExpressionOperator expressionOperator = this.getOperator(109);
        return expressionOperator.expressionFor(this);
    }

    public Expression getNumberVal() {
        ExpressionOperator expressionOperator = this.getOperator(110);
        return expressionOperator.expressionFor(this);
    }

    public Expression truncateDate(String string) {
        ExpressionOperator expressionOperator = this.getOperator(102);
        return expressionOperator.expressionFor(this, string);
    }

    public Expression twist(Expression expression, Expression expression2) {
        if (expression == null) {
            return null;
        }
        return expression.twistedForBaseAndContext(expression2, this);
    }

    public Expression twistedForBaseAndContext(Expression expression, Expression expression2) {
        return this;
    }

    public void validateNode() {
    }

    public Expression value() {
        ExpressionOperator expressionOperator = this.getOperator(85);
        return expressionOperator.expressionFor(this);
    }

    public Expression value(byte by) {
        return this.value(new Byte(by));
    }

    public Expression value(char c) {
        return this.value(new Character(c));
    }

    public Expression value(double d) {
        return this.value(new Double(d));
    }

    public Expression value(float f) {
        return this.value(new Float(f));
    }

    public Expression value(int n) {
        return this.value(new Integer(n));
    }

    public Expression value(long l) {
        return this.value(new Long(l));
    }

    public Expression value(Object object) {
        return new ConstantExpression(object, this);
    }

    public Expression value(short s) {
        return this.value(new Short(s));
    }

    public Expression value(boolean bl) {
        return this.value(new Boolean(bl));
    }

    public Expression literal(String string) {
        return new LiteralExpression(string, this);
    }

    public Object valueFromObject(Object object, Session session, DatabaseRow databaseRow, InMemoryQueryIndirectionPolicy inMemoryQueryIndirectionPolicy, boolean bl) {
        throw QueryException.cannotConformExpression();
    }

    public Object valueFromObject(Object object, Session session, DatabaseRow databaseRow, InMemoryQueryIndirectionPolicy inMemoryQueryIndirectionPolicy) {
        return this.valueFromObject(object, session, databaseRow, inMemoryQueryIndirectionPolicy, false);
    }

    public Expression variance() {
        return this.getFunction(25);
    }

    public void writeDescriptionOn(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write("some expression");
    }

    protected void writeField(ExpressionSQLPrinter expressionSQLPrinter, DatabaseField databaseField, SQLSelectStatement sQLSelectStatement) {
        if (expressionSQLPrinter.isFirstElementPrinted()) {
            expressionSQLPrinter.printString(", ");
        } else {
            expressionSQLPrinter.setIsFirstElementPrinted(true);
        }
        if (sQLSelectStatement.requiresAliases()) {
            if (databaseField.getTable() != this.lastTable) {
                this.lastTable = databaseField.getTable();
                this.currentAlias = this.aliasForTable(this.lastTable);
            }
            expressionSQLPrinter.printString(this.currentAlias.getQualifiedName());
            expressionSQLPrinter.printString(".");
            expressionSQLPrinter.printString(databaseField.getName());
        } else {
            expressionSQLPrinter.printString(databaseField.getName());
        }
    }

    public void writeFields(ExpressionSQLPrinter expressionSQLPrinter, Vector vector, SQLSelectStatement sQLSelectStatement) {
        Enumeration enumeration = this.getFields().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
            vector.addElement(databaseField);
            this.writeField(expressionSQLPrinter, databaseField, sQLSelectStatement);
        }
    }

    public void writeSubexpressionsTo(BufferedWriter bufferedWriter, int n) throws IOException {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

